/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.ui.Control;
import com.mallowigi.idea.utils.MTUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class MTRowPainter
implements Control.Painter {
    public final int getRendererOffset(@NotNull Control control, int depth, boolean leaf) {
        if (control == null) {
            MTRowPainter.$$$reportNull$$$0(0);
        }
        if (depth < 0) {
            return -1;
        }
        if (depth == 0) {
            return 0;
        }
        int controlWidth = control.getWidth();
        int left = MTRowPainter.getLeftIndent(controlWidth / 2);
        int right = MTRowPainter.getRightIndent();
        int offset = MTRowPainter.getLeafIndent();
        if (offset < 0) {
            offset = Math.max(controlWidth + left - controlWidth / 2 + JBUIScale.scale((int)2), left + right);
        }
        return depth > 1 ? (depth - 1) * (left + right) + offset : offset;
    }

    private static int getLeafIndent() {
        return -1;
    }

    private static int getRightIndent() {
        return Math.max(0, UIManager.getInt("Tree.rightChildIndent"));
    }

    private static int getLeftIndent(int min) {
        return Math.max(min, UIManager.getInt("Tree.leftChildIndent"));
    }

    public final int getControlOffset(@NotNull Control control, int depth, boolean leaf) {
        if (control == null) {
            MTRowPainter.$$$reportNull$$$0(1);
        }
        if (depth <= 0 || leaf) {
            return -1;
        }
        int controlWidth = control.getWidth();
        int left = MTRowPainter.getLeftIndent(controlWidth / 2);
        int offset = left - controlWidth / 2;
        return depth > 1 ? (depth - 1) * (left + MTRowPainter.getRightIndent()) + offset : offset;
    }

    public final void paint(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height, @NotNull Control control, int depth, boolean leaf, boolean expanded, boolean selected) {
        Border listFocusedSelectionPainter;
        if (c == null) {
            MTRowPainter.$$$reportNull$$$0(2);
        }
        if (g == null) {
            MTRowPainter.$$$reportNull$$$0(3);
        }
        if (control == null) {
            MTRowPainter.$$$reportNull$$$0(4);
        }
        if (selected && (listFocusedSelectionPainter = MTUI.List.getListFocusedSelectionPainter()) != null) {
            listFocusedSelectionPainter.paintBorder(c, g, x, y, width, height);
        }
        if (depth <= 0) {
            return;
        }
        boolean paintLines = MTRowPainter.shouldPaintLines();
        if (!paintLines && leaf) {
            return;
        }
        int controlWidth = control.getWidth();
        int left = MTRowPainter.getLeftIndent(controlWidth / 2);
        int indent = left + MTRowPainter.getRightIndent();
        int lineX = x + left - controlWidth / 2;
        int controlX = !leaf && depth > 1 ? (depth - 1) * indent + lineX : lineX;
        int d = depth;
        if (paintLines && (depth > 1 || !leaf && expanded)) {
            int offset;
            g.setColor(MTUI.Tree.getSelectionBackground());
            while (--d > 0) {
                MTRowPainter.paintLine(g, lineX, y, controlWidth, height);
                lineX += indent;
            }
            if (!leaf && expanded && (offset = (height - control.getHeight()) / 2) > 0) {
                MTRowPainter.paintLine(g, lineX, y + height - offset, controlWidth, offset);
            }
        }
        if (leaf) {
            return;
        }
        control.paint(c, g, controlX, y, controlWidth, height, expanded, selected);
    }

    private static void paintLine(@NotNull Graphics g, int x, int y, int width, int height) {
        if (g == null) {
            MTRowPainter.$$$reportNull$$$0(5);
        }
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            double dx = (double)x + (double)width / 2.0 - PaintUtil.devPixel((Graphics2D)g2d);
            LinePainter2D.paint((Graphics2D)g2d, (double)dx, (double)y, (double)dx, (double)(y + height), (LinePainter2D.StrokeType)LinePainter2D.StrokeType.CENTERED, (double)1.0, (Object)RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            int newX = x + width / 2;
            g.drawLine(newX, y, x, y + height);
        }
    }

    private static boolean shouldPaintLines() {
        if (UIManager.getBoolean("Tree.paintLines")) {
            return true;
        }
        UISettings settings = UISettings.getInstanceOrNull();
        return settings != null && settings.getShowTreeIndentGuides();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        objectArray2[1] = "com/mallowigi/idea/ui/MTRowPainter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRendererOffset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getControlOffset";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "paintLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

