/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.ui;

import com.intellij.ide.ui.laf.darcula.ui.DarculaRootPaneUI;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.ui.DoubleClickListener;
import com.intellij.util.Consumer;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.utils.MTUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import org.jetbrains.annotations.NonNls;

public final class MTRootPaneUI
extends DarculaRootPaneUI {
    @NonNls
    private static final String WINDOW_DARK_APPEARANCE = "jetbrains.awt.windowDarkAppearance";
    @NonNls
    private static final String TRANSPARENT_TITLE_BAR_APPEARANCE = "jetbrains.awt.transparentTitleBarAppearance";
    @NonNls
    private static final String REGISTRY_VALUE = "ide.mac.transparentTitleBarAppearance";
    private static final int JDK_VER = 11;
    private Runnable disposer = null;

    public static ComponentUI createUI(JComponent component) {
        return MTRootPaneUI.hasCustomDecoration() ? new MTRootPaneUI() : MTRootPaneUI.createWindowsRootPaneUI();
    }

    private static boolean hasCustomDecoration() {
        return SystemInfo.isMac;
    }

    private static ComponentUI createWindowsRootPaneUI() {
        try {
            return (ComponentUI)Class.forName("com.sun.java.swing.plaf.windows.WindowsRootPaneUI").getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            return new BasicRootPaneUI();
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (this.disposer != null) {
            this.disposer.run();
        }
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        boolean themeIsDark = MTConfig.getInstance().getSelectedTheme().isDark();
        boolean darkTitleBar = MTConfig.getInstance().isDarkTitleBar();
        if (SystemInfo.isMac || SystemInfo.isLinux) {
            c.putClientProperty(WINDOW_DARK_APPEARANCE, themeIsDark);
            if (darkTitleBar) {
                if (SystemInfo.isJavaVersionAtLeast((int)11)) {
                    JRootPane rootPane = (JRootPane)c;
                    c.addHierarchyListener(event -> {
                        Window window = UIUtil.getWindow((Component)c);
                        String title = MTRootPaneUI.getWindowTitle(window);
                        if (title != null && !MTRootPaneUI.isDialogWindow(window)) {
                            Registry.get((String)REGISTRY_VALUE).setValue(true);
                            MTRootPaneUI.setCustomTitleBar(window, rootPane, (Consumer<Runnable>)((Consumer)runnable -> {
                                this.disposer = runnable;
                            }));
                        } else {
                            Registry.get((String)REGISTRY_VALUE).setValue(false);
                        }
                    });
                } else {
                    Registry.get((String)REGISTRY_VALUE).setValue(true);
                }
            } else {
                Registry.get((String)REGISTRY_VALUE).setValue(false);
            }
        }
    }

    private static void setCustomTitleBar(final Window window, final JRootPane rootPane, Consumer<Runnable> onDispose) {
        final JBInsets topWindowInset = JBUI.insetsTop((int)24);
        AbstractBorder customDecorationBorder = new AbstractBorder(){

            @Override
            public Insets getBorderInsets(Component c) {
                if (MTRootPaneUI.isInFullScreen(window) || !MTConfig.getInstance().isDarkTitleBar()) {
                    return JBUI.insets((int)0);
                }
                return topWindowInset;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                if (MTRootPaneUI.isInFullScreen(window) || !MTConfig.getInstance().isDarkTitleBar()) {
                    return;
                }
                Graphics2D graphics = (Graphics2D)g.create();
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                try {
                    Rectangle headerRectangle = new Rectangle(0, 0, c.getWidth(), topWindowInset.top);
                    graphics.setColor(UIUtil.getPanelBackground());
                    graphics.fill(headerRectangle);
                    graphics.setFont(UIManager.getFont("Panel.font"));
                    Color color = window.isActive() ? MTUI.Label.getLabelForeground() : MTUI.Label.getLabelDisabledForeground();
                    graphics.setColor(color);
                    int controlButtonsWidth = 70;
                    String windowTitle = MTRootPaneUI.getWindowTitle(window);
                    double widthToFit = 140 + GraphicsUtil.stringWidth((String)windowTitle, (Font)g.getFont()) - c.getWidth();
                    if (widthToFit <= 0.0) {
                        UIUtil.drawCenteredString((Graphics2D)graphics, (Rectangle)headerRectangle, (String)windowTitle);
                    } else {
                        FontMetrics fm = graphics.getFontMetrics();
                        Rectangle2D stringBounds = fm.getStringBounds(windowTitle, graphics);
                        Rectangle bounds = AffineTransform.getTranslateInstance(70.0, (double)fm.getAscent() + ((double)headerRectangle.height - stringBounds.getHeight()) / 2.0).createTransformedShape(stringBounds).getBounds();
                        UIUtil.drawCenteredString((Graphics2D)graphics, (Rectangle)bounds, (String)windowTitle, (boolean)false, (boolean)true);
                    }
                }
                finally {
                    graphics.dispose();
                }
            }
        };
        rootPane.setBorder(customDecorationBorder);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                rootPane.repaint();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                rootPane.repaint();
            }
        };
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                if (!(window instanceof Frame)) {
                    return false;
                }
                Frame frame = (Frame)window;
                int state = frame.getExtendedState();
                if (event.getClickCount() % 2 == 0 && (event.getModifiers() & 0x10) != 0 && frame.isResizable()) {
                    if ((state & 6) == 0) {
                        frame.setExtendedState(state | 6);
                    } else {
                        frame.setExtendedState(state & 0xFFFFFFF9);
                    }
                    return true;
                }
                return false;
            }
        }.installOn((Component)rootPane);
        window.addWindowListener(windowAdapter);
        PropertyChangeListener propertyChangeListener = evt -> rootPane.repaint();
        window.addPropertyChangeListener("title", propertyChangeListener);
        onDispose.consume(() -> {
            window.removeWindowListener(windowAdapter);
            window.removePropertyChangeListener("title", propertyChangeListener);
        });
    }

    private static String getWindowTitle(Window window) {
        return window instanceof JDialog ? ((Dialog)window).getTitle() : (window instanceof JFrame ? ((Frame)window).getTitle() : null);
    }

    private static boolean isDialogWindow(Window window) {
        return window instanceof JDialog ? ((Dialog)window).isModal() : (window instanceof JFrame ? ((Frame)window).isUndecorated() : true);
    }

    private static boolean isInFullScreen(Window window) {
        Component ultimateParent = UIUtil.findUltimateParent((Component)window);
        if (ultimateParent == window && ultimateParent instanceof IdeFrameEx) {
            IdeFrame ultimateParentWindowForEvent = (IdeFrame)ultimateParent;
            return ultimateParentWindowForEvent.isInFullScreen();
        }
        return false;
    }
}

