/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.ui;

import com.intellij.ide.ui.laf.darcula.ui.DarculaRadioButtonUI;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.mallowigi.idea.utils.MTUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public final class MTRadioButtonUI
extends DarculaRadioButtonUI {
    public static ComponentUI createUI(JComponent component) {
        return new MTRadioButtonUI();
    }

    public Icon getDefaultIcon() {
        return EmptyIcon.create((int)20).asUIResource();
    }

    protected void paintIcon(JComponent c, Graphics2D g, Rectangle viewRect, Rectangle iconRect) {
        Insets insets = c.getInsets();
        viewRect.x += insets.left;
        viewRect.y += insets.top;
        viewRect.width -= insets.right + viewRect.x;
        viewRect.height -= insets.bottom + viewRect.y;
        int rad = JBUI.scale((int)5);
        int x = iconRect.x + (rad - (rad % 2 == 1 ? 1 : 0)) / 2;
        int y = iconRect.y + (rad - (rad % 2 == 1 ? 1 : 0)) / 2;
        int w = iconRect.width - rad;
        int h = iconRect.height - rad;
        g.translate(x, y);
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        boolean focus = c.hasFocus();
        boolean selected = ((AbstractButton)c).isSelected();
        if (focus) {
            MTRadioButtonUI.paintOvalRing(g, w, h);
        }
        if (selected) {
            boolean enabled = c.isEnabled();
            g.setColor(MTUI.Radio.getSelectedColor(enabled));
            g.drawOval(JBUI.scale((int)2), JBUI.scale((int)1), w, h);
            int yOff = JBUI.scale((int)1);
            g.fillOval(w / 2 - rad / 2, h / 2 - rad / 2 - yOff, rad + JBUI.scale((int)4), rad + JBUI.scale((int)4));
        } else {
            g.setPaint(MTUI.Radio.getBorderColor());
            g.drawOval(JBUI.scale((int)2), JBUI.scale((int)1) + 1, w - 1, h - 1);
        }
        config.restore();
        g.translate(-x, -y);
    }

    protected Color getFocusColor() {
        return MTUI.Radio.getFocusColor();
    }

    private static void paintOvalRing(Graphics2D g, int w, int h) {
        g.setColor(MTUI.Radio.getFocusColor());
        g.fillOval(-JBUI.scale((int)2), -3, w + 8, h + 8);
    }
}

