/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.ui;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.mallowigi.idea.ui.MTTextBorder;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;

public final class MTPasswordFieldUI
extends BasicPasswordFieldUI
implements Condition {
    private final JPasswordField passwordField;
    private ShowHidePasswordAdapter showHidePasswordAdapter;
    private FocusAdapter myFocusAdapter;
    private boolean echoCharIsSet = true;

    private MTPasswordFieldUI(JPasswordField passwordField) {
        this.passwordField = passwordField;
    }

    public static ComponentUI createUI(JComponent component) {
        return new MTPasswordFieldUI((JPasswordField)component);
    }

    public JPasswordField getPasswordField() {
        return this.passwordField;
    }

    public boolean isEchoCharIsSet() {
        return this.echoCharIsSet;
    }

    @Override
    public void installListeners() {
        MTPasswordFieldUI ui = this;
        this.myFocusAdapter = new RepaintOnFocusAdapter();
        this.passwordField.addFocusListener(this.myFocusAdapter);
        this.showHidePasswordAdapter = new ShowHidePasswordAdapter(ui);
        this.passwordField.addMouseListener(this.showHidePasswordAdapter);
    }

    @Override
    protected void uninstallListeners() {
        this.passwordField.removeFocusListener(this.myFocusAdapter);
        this.passwordField.removeMouseListener(this.showHidePasswordAdapter);
    }

    @Override
    protected void paintBackground(Graphics g) {
        Border border;
        Graphics2D g2d = (Graphics2D)g;
        JTextComponent component = this.getComponent();
        Container parent = component.getParent();
        if (component.isOpaque() && parent != null) {
            g2d.setColor(parent.getBackground());
            g2d.fillRect(0, 0, component.getWidth(), component.getHeight());
        }
        if ((border = component.getBorder()) instanceof MTTextBorder) {
            if (component.isEnabled() && component.isEditable()) {
                g2d.setColor(component.getBackground());
            }
            int width = component.getWidth();
            int height = component.getHeight();
            Insets insets = border.getBorderInsets(component);
            if (component.hasFocus()) {
                GraphicsConfig config = new GraphicsConfig((Graphics)g2d);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                g2d.fillRoundRect(insets.left - JBUI.scale((int)5), insets.top - JBUI.scale((int)2), width - insets.left - insets.right + JBUI.scale((int)10), height - insets.top - insets.bottom + JBUI.scale((int)6), JBUI.scale((int)5), JBUI.scale((int)5));
                Point p = this.getPreviewIconCoordinates();
                Icon searchIcon = this.echoCharIsSet ? IconLoader.findIcon((String)"/icons/mt/eye.svg") : IconLoader.findIcon((String)"/icons/mt/eyeOff.svg");
                searchIcon.paintIcon(null, g2d, p.x, p.y);
                config.restore();
            } else {
                g2d.fillRect(insets.left - JBUI.scale((int)5), insets.top - JBUI.scale((int)2), width - insets.left - insets.right + JBUI.scale((int)12), height - insets.top - insets.bottom + JBUI.scale((int)6));
            }
        } else {
            super.paintBackground(g2d);
        }
    }

    public boolean value(Object t) {
        MouseEvent me;
        if (t instanceof MouseEvent && this.getActionUnder((me = (MouseEvent)t).getPoint()) != null) {
            if (me.getID() == 500) {
                SwingUtilities.invokeLater(() -> this.showHidePasswordAdapter.mouseClicked(me));
            }
            return true;
        }
        return false;
    }

    PasswordActions getActionUnder(@NotNull Point p) {
        int off;
        Point point;
        if (p == null) {
            MTPasswordFieldUI.$$$reportNull$$$0(0);
        }
        if ((point = new Point(p.x - (off = JBUI.scale((int)8)), p.y - off)).distance(this.getPreviewIconCoordinates()) <= (double)off) {
            return PasswordActions.PREVIEW;
        }
        return null;
    }

    void toggleEchoChar() {
        this.echoCharIsSet = !this.echoCharIsSet;
    }

    private Rectangle getDrawingRect() {
        JPasswordField component = this.passwordField;
        JBInsets insets = JBInsets.create((Insets)component.getInsets());
        int x = insets.right - JBUI.scale((int)4) - JBUI.scale((int)32);
        int y = insets.top - JBUI.scale((int)3);
        int w = component.getWidth() - insets.width() + JBUI.scale((int)41);
        int h = component.getBounds().height - insets.height() + JBUI.scale((int)5);
        if (h % 2 == 1) {
            ++h;
        }
        return new Rectangle(x, y, w, h);
    }

    private Point getPreviewIconCoordinates() {
        Rectangle r = this.getDrawingRect();
        return new Point(r.x + r.width - JBUI.scale((int)20), r.y + (r.height - JBUI.scale((int)16)) / 2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/mallowigi/idea/ui/MTPasswordFieldUI", "getActionUnder"));
    }

    private final class RepaintOnFocusAdapter
    extends FocusAdapter {
        private RepaintOnFocusAdapter() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            MTPasswordFieldUI.this.getPasswordField().repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            MTPasswordFieldUI.this.getPasswordField().repaint();
        }
    }

    private final class ShowHidePasswordAdapter
    extends MouseAdapter {
        private static final char SHOW_VALUE = '\u0000';
        private final MTPasswordFieldUI passwordFieldUI;

        ShowHidePasswordAdapter(MTPasswordFieldUI ui) {
            this.passwordFieldUI = ui;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PasswordActions action = this.passwordFieldUI.getActionUnder(e.getPoint());
            if (action != null) {
                if (MTPasswordFieldUI.this.isEchoCharIsSet()) {
                    MTPasswordFieldUI.this.getPasswordField().setEchoChar('\u0000');
                } else {
                    MTPasswordFieldUI.this.getPasswordField().setEchoChar('\u2022');
                }
                MTPasswordFieldUI.this.toggleEchoChar();
            }
            e.consume();
        }
    }

    public static enum PasswordActions {
        PREVIEW;

    }
}

