/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.ui;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.components.OnOffButton;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.mallowigi.idea.utils.MTUI;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public final class MTOnOffButtonUI
extends BasicToggleButtonUI {
    private static final Dimension TOGGLE_SIZE = new JBDimension(18, 18);
    private static final Dimension BUTTON_SIZE = new JBDimension(32, 14);
    private static final Border BUTTON_BORDER = JBUI.Borders.empty((int)1, (int)10);
    private static final int ARC = 16;

    public static ComponentUI createUI(JComponent component) {
        component.setBorder(BUTTON_BORDER);
        return new MTOnOffButtonUI();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = new Dimension(BUTTON_SIZE);
        JBInsets.addTo((Dimension)size, (Insets)BUTTON_BORDER.getBorderInsets(c));
        return size;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        if (!(c instanceof OnOffButton)) {
            return;
        }
        OnOffButton button = (OnOffButton)c;
        Graphics2D g2 = (Graphics2D)g.create();
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
        try {
            Insets insets = c.getInsets();
            Point origin = new Point((c.getWidth() - MTOnOffButtonUI.BUTTON_SIZE.width) / 2 + insets.left, (c.getHeight() - MTOnOffButtonUI.BUTTON_SIZE.height) / 2 + insets.top);
            g2.setColor(button.isSelected() ? MTUI.Switch.getOnSwitchColor() : MTUI.Switch.getOffSwitchColor());
            g2.fillRoundRect(origin.x, origin.y, MTOnOffButtonUI.BUTTON_SIZE.width, MTOnOffButtonUI.BUTTON_SIZE.height, 16, 16);
            g2.setColor(button.isSelected() ? MTUI.Switch.getOnThumbColor() : MTUI.Switch.getOffThumbColor());
            Point location = new Point((button.isSelected() ? JBUI.scale((int)20) : JBUI.scale((int)-2)) + origin.x, JBUI.scale((int)-2) + origin.y);
            g2.fillOval(location.x, location.y, MTOnOffButtonUI.TOGGLE_SIZE.width, MTOnOffButtonUI.TOGGLE_SIZE.height);
            config.restore();
        }
        finally {
            g2.dispose();
        }
    }
}

