/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.ui;

import com.intellij.ide.navigationToolbar.NavBarItem;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.navigationToolbar.ui.CommonNavBarUI;
import com.intellij.ide.ui.UISettings;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.mallowigi.idea.utils.MTUI;
import gnu.trove.THashMap;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.Icon;

public final class MTNavBarUI
extends CommonNavBarUI {
    private static final Map<NavBarItem, Map<ImageType, BufferedImage>> CACHE = new THashMap();

    public void clearItems() {
        super.clearItems();
        CACHE.clear();
    }

    public JBInsets getElementPadding() {
        return JBUI.insets((int)5, (int)5, (int)5, (int)5);
    }

    public void doPaintNavBarItem(Graphics2D g, NavBarItem item, NavBarPanel navbar) {
        boolean nextSelected;
        boolean floating = navbar.isInFloatingMode();
        boolean toolbarVisible = UISettings.getInstance().getShowMainToolbar();
        boolean selected = item.isSelected() && item.isFocused();
        boolean bl = nextSelected = item.isNextSelected() && navbar.isFocused();
        ImageType type = floating ? (selected ? ImageType.ACTIVE_FLOATING : (nextSelected ? ImageType.NEXT_ACTIVE_FLOATING : ImageType.INACTIVE_FLOATING)) : (toolbarVisible ? (selected ? ImageType.ACTIVE : (nextSelected ? ImageType.NEXT_ACTIVE : ImageType.INACTIVE)) : (selected ? ImageType.ACTIVE_NO_TOOLBAR : (nextSelected ? ImageType.NEXT_ACTIVE_NO_TOOLBAR : ImageType.INACTIVE_NO_TOOLBAR)));
        Map cached = CACHE.computeIfAbsent(item, navBarItem -> new EnumMap(ImageType.class));
        BufferedImage image = cached.computeIfAbsent(type, imageType -> MTNavBarUI.drawToBuffer(item, floating, selected, navbar));
        StartupUiUtil.drawImage((Graphics)g, (Image)image, (int)0, (int)0, null);
        int offset = item.isFirstElement() ? MTUI.NavBar.getFirstElementLeftOffset() : 0;
        int textOffset = this.getElementPadding().width() + offset;
        if (item.needPaintIcon()) {
            Icon icon = item.getIcon();
            int iconOffset = this.getElementPadding().left + offset;
            icon.paintIcon((Component)item, g, iconOffset, (item.getHeight() - icon.getIconHeight()) / 2);
            textOffset += icon.getIconWidth();
        }
        item.doPaintText(g, textOffset);
    }

    private static BufferedImage drawToBuffer(NavBarItem item, boolean floating, boolean selected, NavBarPanel navbar) {
        int w = item.getWidth() + 2;
        int h = item.getHeight();
        int decorationOffset = MTUI.NavBar.getDecorationOffset();
        int decorationHOffset = MTUI.NavBar.getDecorationHOffset();
        int offset = w - decorationOffset;
        int arrowXBegin = w - decorationOffset / 2;
        int arrowHeight = h - 2 * decorationHOffset;
        int h2 = h / 2;
        Color highlightColor = MTUI.NavBar.getHighlightColor();
        Color arrowColor = MTUI.NavBar.getArrowColor();
        BufferedImage result = ImageUtil.createImage((int)w, (int)h, (int)2);
        Gray defaultBg = StartupUiUtil.isUnderDarcula() ? Gray._100 : JBColor.WHITE;
        Gray bg = floating ? defaultBg : null;
        Graphics2D g2 = result.createGraphics();
        g2.setStroke(new BasicStroke(1.0f, 0, 1));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Path2D.Double shape = new Path2D.Double();
        shape.moveTo(0.0, 0.0);
        shape.lineTo(offset, 0.0);
        shape.lineTo(w, h2);
        shape.lineTo(offset, h);
        shape.lineTo(0.0, h);
        shape.closePath();
        Path2D.Double endShape = new Path2D.Double();
        endShape.moveTo(offset, 0.0);
        endShape.lineTo(w, 0.0);
        endShape.lineTo(w, h);
        endShape.lineTo(offset, h);
        endShape.lineTo(w, h2);
        endShape.closePath();
        if (bg != null && selected) {
            g2.setPaint(UIUtil.getPanelBackground());
            g2.fill(shape);
            g2.fill(endShape);
        }
        if (selected) {
            Path2D.Double focusShape = new Path2D.Double();
            focusShape.moveTo(0.0, 1.0);
            focusShape.lineTo(offset, 1.0);
            focusShape.lineTo(w - 1, h2);
            focusShape.lineTo(offset, h - 1);
            focusShape.lineTo(0.0, h - 1);
            g2.setColor(highlightColor);
            if (floating && item.isLastElement()) {
                g2.fillRect(0, 0, w, h);
            } else {
                g2.fill(shape);
                g2.draw(focusShape);
            }
        }
        if (item.isNextSelected() && navbar.isFocused()) {
            g2.setColor(highlightColor);
            g2.fill(endShape);
            Path2D.Double endFocusShape = new Path2D.Double();
            endFocusShape.moveTo(w, 1.0);
            endFocusShape.lineTo(offset, 1.0);
            endFocusShape.lineTo(w - 1, h2);
            endFocusShape.lineTo(offset, h - 1);
            endFocusShape.lineTo(w, h - 1);
            g2.setColor(highlightColor);
            g2.draw(endFocusShape);
        }
        g2.translate(arrowXBegin, decorationHOffset);
        int off = decorationOffset / 2 - 1;
        if (!floating || !item.isLastElement()) {
            MTNavBarUI.drawArrow(g2, arrowColor, off, arrowHeight);
        }
        g2.dispose();
        return result;
    }

    private static void drawArrow(Graphics2D g2d, Color arrowColor, int arrowWidth, int arrowHeight) {
        int xEnd = arrowWidth - 1;
        g2d.setColor(arrowColor);
        g2d.drawLine(0, 0, xEnd, arrowHeight / 2);
        g2d.drawLine(xEnd, arrowHeight / 2, 0, arrowHeight);
        g2d.translate(-1, 0);
        g2d.drawLine(2, 0, xEnd, arrowHeight / 2);
        g2d.drawLine(xEnd, arrowHeight / 2, 2, arrowHeight);
    }

    private static enum ImageType {
        INACTIVE,
        NEXT_ACTIVE,
        ACTIVE,
        INACTIVE_FLOATING,
        NEXT_ACTIVE_FLOATING,
        ACTIVE_FLOATING,
        INACTIVE_NO_TOOLBAR,
        NEXT_ACTIVE_NO_TOOLBAR,
        ACTIVE_NO_TOOLBAR;

    }
}

