/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.ui;

import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.util.ui.UIUtil;
import com.mallowigi.idea.MTConfig;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import sun.swing.SwingUtilities2;

public final class MTDarculaButtonUI
extends DarculaButtonUI {
    public static ComponentUI createUI(JComponent component) {
        return new MTDarculaButtonUI();
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        int mnemonicIndex;
        if (UIUtil.isHelpButton((Component)c)) {
            return;
        }
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        g.setColor(this.getButtonTextColor(button));
        FontMetrics metrics = SwingUtilities2.getFontMetrics(c, g);
        String textToPrint = MTConfig.getInstance().isUpperCaseButtons() ? text.toUpperCase(Locale.ENGLISH) : text;
        int textWidth = metrics.stringWidth(textToPrint);
        int x = (c.getWidth() - this.getTextShiftOffset() - textWidth) / 2;
        int y = textRect.y + metrics.getAscent();
        int n = mnemonicIndex = DarculaLaf.isAltPressed() ? button.getDisplayedMnemonicIndex() : -1;
        if (model.isEnabled()) {
            SwingUtilities2.drawStringUnderlineCharAt(c, g, textToPrint, mnemonicIndex, x, y);
        } else {
            this.paintDisabledText(g, text, c, textRect, metrics);
        }
    }

    protected void paintDisabledText(Graphics g, String text, JComponent c, Rectangle textRect, FontMetrics metrics) {
        String textToPrint = MTConfig.getInstance().isUpperCaseButtons() ? text.toUpperCase(Locale.ENGLISH) : text;
        int x = (c.getWidth() - this.getTextShiftOffset() - metrics.stringWidth(textToPrint)) / 2;
        g.setColor(UIManager.getColor("Button.disabledText"));
        SwingUtilities2.drawStringUnderlineCharAt(c, g, textToPrint, -1, x + 1, textRect.y + metrics.getAscent() + 1);
    }
}

