/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.MacUIUtil;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.ui.MTComboBoxUI;
import com.mallowigi.idea.utils.MTUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboPopup;

final class MTComboPopup
extends BasicComboPopup {
    MTComboPopup(MTComboBoxUI mtComboBoxUI, JComboBox combo) {
        super(combo);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        if (this.comboBox instanceof ComboBoxWithWidePopup) {
            Dimension popupSize = this.comboBox.getSize();
            int minPopupWidth = ((ComboBoxWithWidePopup)this.comboBox).getMinimumPopupWidth();
            Insets insets = this.getInsets();
            popupSize.width = Math.max(popupSize.width, minPopupWidth);
            popupSize.setSize(popupSize.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount()));
            this.scroller.setMaximumSize(popupSize);
            this.scroller.setPreferredSize(popupSize);
            this.scroller.setMinimumSize(popupSize);
            this.list.revalidate();
        }
        Point p = this.adjustPopupLocationToFitScreen(x, y);
        if (p.y != y || MTConfig.getInstance().isCompactDropdowns()) {
            super.show(invoker, x, y);
        } else {
            super.show(invoker, x, y - this.comboBox.getHeight());
        }
    }

    private static void doPaint(Graphics2D g, int width, int height) {
        float bw = DarculaUIUtil.BW.get();
        float lw = JBUIScale.scale((float)0.5f);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        float outerArc = bw;
        Path2D.Float outerRect = new Path2D.Float(0);
        ((Path2D)outerRect).moveTo((float)width - outerArc, 0.0);
        ((Path2D)outerRect).quadTo(width, 0.0, width, outerArc);
        ((Path2D)outerRect).lineTo(width, (float)height - outerArc);
        ((Path2D)outerRect).quadTo(width, height, (float)width - outerArc, height);
        ((Path2D)outerRect).lineTo(outerArc, height);
        ((Path2D)outerRect).quadTo(0.0, height, 0.0, (float)height - outerArc);
        ((Path2D)outerRect).lineTo(0.0, outerArc);
        ((Path2D)outerRect).quadTo(0.0, 0.0, outerArc, 0.0);
        outerRect.closePath();
        Path2D.Float innerRect = new Path2D.Float(0);
        ((Path2D)innerRect).moveTo((float)width - outerArc, bw += lw);
        ((Path2D)innerRect).quadTo((float)width - bw, bw, (float)width - bw, outerArc);
        ((Path2D)innerRect).lineTo((float)width - bw, (float)height - outerArc);
        ((Path2D)innerRect).quadTo((float)width - bw, (float)height - bw, (float)width - outerArc, (float)height - bw);
        ((Path2D)innerRect).lineTo(outerArc, (float)height - bw);
        ((Path2D)innerRect).quadTo(bw, (float)height - bw, bw, (float)height - outerArc);
        ((Path2D)innerRect).lineTo(bw, outerArc);
        ((Path2D)innerRect).quadTo(bw, bw, outerArc, bw);
        innerRect.closePath();
        Path2D.Float path = new Path2D.Float(0);
        path.append(outerRect, false);
        path.append(innerRect, false);
        g.fill(path);
    }

    @Override
    protected void paintBorder(Graphics g) {
        float bw = 6.0f;
        boolean isEnabled = this.comboBox != null && this.comboBox.isEnabled();
        Color borderColor = MTUI.TextField.getBorderColor(isEnabled);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        Path2D.Float border = new Path2D.Float(0);
        border.append(new RoundRectangle2D.Float(6.0f, 6.0f, (float)this.getWidth() - 12.0f, (float)this.getHeight() - 12.0f, 0.0f, 0.0f), false);
        g2.setColor(borderColor);
        MTComboPopup.doPaint(g2, this.getWidth(), this.getHeight());
    }

    private Point adjustPopupLocationToFitScreen(int xPosition, int yPosition) {
        Point popupLocation = new Point(xPosition, yPosition);
        GraphicsConfiguration gc = this.getCurrentGraphicsConfiguration(popupLocation);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Rectangle scrBounds = gc != null ? gc.getBounds() : new Rectangle(toolkit.getScreenSize());
        Dimension popupSize = this.getPreferredSize();
        long popupRightX = (long)popupLocation.x + (long)popupSize.width;
        long popupBottomY = (long)popupLocation.y + (long)popupSize.height;
        int scrWidth = scrBounds.width;
        int scrHeight = scrBounds.height;
        int scrRightX = scrBounds.x + scrWidth;
        int scrBottomY = scrBounds.y + scrHeight;
        if (popupRightX > (long)scrRightX) {
            popupLocation.x = scrRightX - popupSize.width;
        }
        if (popupBottomY > (long)scrBottomY) {
            popupLocation.y = scrBottomY - popupSize.height;
        }
        if (popupLocation.x < scrBounds.x) {
            popupLocation.x = scrBounds.x;
        }
        if (popupLocation.y < scrBounds.y) {
            popupLocation.y = scrBounds.y;
        }
        return popupLocation;
    }

    private GraphicsConfiguration getCurrentGraphicsConfiguration(Point popupLocation) {
        GraphicsDevice[] gd;
        GraphicsConfiguration gc = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice aGd : gd = ge.getScreenDevices()) {
            GraphicsConfiguration dgc;
            if (aGd.getType() != 0 || !(dgc = aGd.getDefaultConfiguration()).getBounds().contains(popupLocation)) continue;
            gc = dgc;
            break;
        }
        if (gc == null && this.getInvoker() != null) {
            gc = this.getInvoker().getGraphicsConfiguration();
        }
        return gc;
    }
}

