/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaComboBoxUI;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.OffsetIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.ui.MTComboPopup;
import com.mallowigi.idea.utils.MTUI;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Objects;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NotNull;

public final class MTComboBoxUI
extends DarculaComboBoxUI {
    private Insets myPadding = null;
    private final MTConfig config = MTConfig.getInstance();

    private MTComboBoxUI(JComboBox comboBox) {
        this.comboBox = comboBox;
    }

    public static ComponentUI createUI(JComponent component) {
        return new MTComboBoxUI((JComboBox)component);
    }

    private void paintFocusBorder(Graphics2D g, Shape border) {
        g.setPaint(this.getSelectedBorderColor());
        g.fill(border);
    }

    private boolean isCompact() {
        return this.config.isCompactDropdowns();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.comboBox.setBorder((Border)((Object)this));
        this.myPadding = this.getPadding();
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.comboBox.setBorder(null);
    }

    protected ComboPopup createPopup() {
        return new MTComboPopup(this, this.comboBox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g, JComponent c) {
        Container parent = Objects.requireNonNull(c).getParent();
        if (parent != null) {
            g.setColor(this.getBackgroundColor());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        Graphics2D g2 = (Graphics2D)g.create();
        Rectangle r = new Rectangle(c.getSize());
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            g2.translate(r.x, r.y);
            float bw = DarculaUIUtil.BW.getFloat();
            g2.setColor(this.getBackgroundColor());
            g2.fill(new Rectangle2D.Float(r.x, r.y, r.width, (float)r.height - bw));
        }
        finally {
            g2.dispose();
        }
        if (!this.comboBox.isEditable()) {
            this.checkFocus();
            this.paintCurrentValue(g, this.rectangleForCurrentValue(), this.hasFocus);
        }
    }

    private Color getBackgroundColor() {
        Color coloredItemColor;
        boolean isBackgroundSet;
        Color bg = this.comboBox.getBackground();
        boolean enabled = this.comboBox.isEnabled();
        boolean bl = isBackgroundSet = this.comboBox.isBackgroundSet() && !(bg instanceof UIResource);
        if (this.comboBox.isEditable() && this.editor != null) {
            if (enabled) {
                return this.editor.getBackground();
            }
            if (isBackgroundSet) {
                return bg;
            }
            return MTUI.ComboBox.getDisabledBackground();
        }
        Object value = this.comboBox.getSelectedItem();
        Color color = coloredItemColor = value instanceof ColoredItem ? ((ColoredItem)value).getColor() : null;
        if (coloredItemColor != null) {
            return coloredItemColor;
        }
        if (isBackgroundSet) {
            return bg;
        }
        return enabled ? MTUI.ComboBox.getNonEditableBackground() : MTUI.ComboBox.getDisabledBackground();
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        JComponent component;
        JLabel jLabel;
        Border cellBorder;
        SimpleColoredComponent scc;
        boolean changeOpaque;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        Component cellRendererComponent = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
        cellRendererComponent.setFont(this.comboBox.getFont());
        cellRendererComponent.setBackground(this.getBackgroundColor());
        Rectangle r = new Rectangle(bounds);
        JComponent jc = (JComponent)cellRendererComponent;
        JBEmptyBorder border = this.getCellBorder();
        jc.setBorder((Border)border);
        if (hasFocus && !this.isPopupVisible(this.comboBox)) {
            cellRendererComponent.setForeground(this.listBox.getForeground());
        } else if (this.comboBox.isEnabled()) {
            cellRendererComponent.setForeground(this.comboBox.getForeground());
        } else {
            cellRendererComponent.setForeground(this.comboBox.isEnabled() ? this.comboBox.getForeground() : MTUI.ComboBox.getDisabledForeground());
        }
        boolean bl = changeOpaque = DarculaUIUtil.isTableCellEditor((Component)this.comboBox) && cellRendererComponent.isOpaque();
        if (changeOpaque) {
            ((JComponent)cellRendererComponent).setOpaque(false);
        }
        boolean shouldValidate = false;
        if (cellRendererComponent instanceof JPanel) {
            shouldValidate = true;
        }
        ((JComponent)cellRendererComponent).setBorder((Border)this.getCellBorder());
        Icon icon = null;
        Insets iPad = null;
        if (cellRendererComponent instanceof SimpleColoredComponent) {
            scc = (SimpleColoredComponent)cellRendererComponent;
            iPad = scc.getIpad();
            scc.setIpad((Insets)JBUI.emptyInsets());
            cellBorder = scc.getBorder();
            scc.setBorder((Border)JBUI.Borders.empty());
            icon = scc.getIcon();
            if (!scc.isIconOnTheRight()) {
                scc.setIcon(OffsetIcon.getOriginalIcon((Icon)icon));
            }
        } else if (cellRendererComponent instanceof JLabel) {
            jLabel = (JLabel)cellRendererComponent;
            cellBorder = jLabel.getBorder();
            jLabel.setBorder((Border)JBUI.Borders.empty());
            icon = jLabel.getIcon();
            jLabel.setIcon(OffsetIcon.getOriginalIcon((Icon)icon));
            String text = jLabel.getText();
            int maxWidth = bounds.width - (this.padding == null || StartupUiUtil.isUnderDarcula() ? 0 : this.padding.right);
            if (StringUtil.isNotEmpty((String)text) && jLabel.getPreferredSize().width > maxWidth) {
                int max;
                int max0 = ObjectUtils.binarySearch((int)7, (int)(text.length() - 1), idx -> {
                    jLabel.setText(StringUtil.trimMiddle((String)text, (int)idx));
                    return Comparing.compare((int)jLabel.getPreferredSize().width, (int)maxWidth);
                });
                int n = max = max0 < 0 ? -max0 - 2 : max0;
                if (max > 7 && max < text.length()) {
                    jLabel.setText(StringUtil.trimMiddle((String)text, (int)max));
                }
            }
        } else {
            component = (JComponent)cellRendererComponent;
            cellBorder = component.getBorder();
            component.setBorder((Border)JBUI.Borders.empty());
        }
        this.currentValuePane.paintComponent(g, cellRendererComponent, this.comboBox, r.x, r.y, r.width, r.height, shouldValidate);
        if (changeOpaque) {
            ((JComponent)cellRendererComponent).setOpaque(true);
        }
        if (cellRendererComponent instanceof SimpleColoredComponent) {
            scc = (SimpleColoredComponent)cellRendererComponent;
            scc.setIpad(iPad);
            scc.setIcon(icon);
            scc.setBorder(cellBorder);
        } else if (cellRendererComponent instanceof JLabel) {
            jLabel = (JLabel)cellRendererComponent;
            jLabel.setBorder(cellBorder);
            jLabel.setIcon(icon);
        } else {
            component = (JComponent)cellRendererComponent;
            component.setBorder(cellBorder);
        }
    }

    protected ComboBoxEditor createEditor() {
        return new BasicComboBoxEditor.UIResource(){

            @Override
            protected JTextField createEditorComponent() {
                return new JTextField(){

                    @Override
                    public Color getBackground() {
                        return MTComboBoxUI.this.getComboBackground();
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!(c instanceof JComponent)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            this.checkFocus();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            Rectangle r = new Rectangle(x, y, width, height);
            g2.translate(x, y);
            float bw = DarculaUIUtil.BW.getFloat();
            Object op = this.comboBox.getClientProperty("JComponent.outline");
            if (op != null) {
                DarculaUIUtil.paintOutlineBorder((Graphics2D)g2, (int)width, (int)height, (float)0.0f, (boolean)true, (boolean)this.hasFocus, (DarculaUIUtil.Outline)DarculaUIUtil.Outline.valueOf((String)op.toString()));
            } else {
                Path2D.Float border = new Path2D.Float(0);
                if (c.isEnabled()) {
                    g2.setColor(this.getBorderColor());
                    border.append(new Rectangle2D.Float(r.x, (float)r.height - bw, r.width, bw), false);
                    g2.fill(border);
                } else {
                    g2.setColor(this.getBorderColor());
                    g2.setStroke(new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{1.0f, 2.0f}, 0.0f));
                    g2.draw(new Line2D.Double(r.x, r.height - 1, r.x + r.width, r.height - 1));
                }
                if (this.hasFocus) {
                    this.paintFocusBorder(g2, border);
                }
            }
        }
        finally {
            g2.dispose();
        }
    }

    public Insets getBorderInsets(Component c) {
        return (Insets)ObjectUtils.notNull((Object)this.myPadding, (Object)this.getPadding());
    }

    protected Insets getInsets() {
        return JBUI.insets((int)2).asUIResource();
    }

    @NotNull
    private Insets getPadding() {
        if (this.config.isCompactDropdowns()) {
            JBInsets jBInsets = JBUI.insets((int)2, (int)2);
            if (jBInsets == null) {
                MTComboBoxUI.$$$reportNull$$$0(0);
            }
            return jBInsets;
        }
        JBInsets jBInsets = JBUI.insets((int)7, (int)2);
        if (jBInsets == null) {
            MTComboBoxUI.$$$reportNull$$$0(1);
        }
        return jBInsets;
    }

    @NotNull
    private JBEmptyBorder getCellBorder() {
        JBEmptyBorder jBEmptyBorder = this.isCompact() ? JBUI.Borders.empty((int)2, (int)1) : JBUI.Borders.empty((int)10, (int)4);
        if (jBEmptyBorder == null) {
            MTComboBoxUI.$$$reportNull$$$0(2);
        }
        return jBEmptyBorder;
    }

    private Color getSelectedBorderColor() {
        Color defaultValue = ColorUtil.fromHex((String)this.config.getAccentColor());
        return (Color)ObjectUtils.notNull((Object)MTUI.TextField.getSelectedBorderColor(), (Object)defaultValue);
    }

    Color getComboBackground() {
        if (this.comboBox != null) {
            if (this.comboBox.isEnabled() && this.comboBox.isEditable()) {
                return MTUI.ComboBox.getEnabledBackground();
            }
            if (!this.comboBox.isEnabled()) {
                return MTUI.ComboBox.getDisabledBackground();
            }
        }
        return MTUI.ComboBox.getFallbackBackground();
    }

    private Color getBorderColor() {
        boolean isEnabled = this.comboBox != null && this.comboBox.isEnabled();
        return MTUI.TextField.getBorderColor(isEnabled);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/mallowigi/idea/ui/MTComboBoxUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPadding";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellBorder";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

