/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.ui;

import com.intellij.ide.ui.laf.darcula.ui.DarculaCheckBoxUI;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.UIUtil;
import com.mallowigi.idea.utils.MTIconLookup;
import com.mallowigi.idea.utils.MTUI;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public final class MTCheckBoxUI
extends DarculaCheckBoxUI {
    private static final Icon DEFAULT_ICON = ((EmptyIcon)JBUIScale.scaleIcon((JBScalableIcon)EmptyIcon.create((int)20))).asUIResource();

    public static ComponentUI createUI(JComponent component) {
        return new MTCheckBoxUI();
    }

    private static void paintOvalRing(Graphics2D g, int w, int h) {
        g.setColor(MTUI.ActionButton.getHoverBackground());
        g.fillOval(-3, -3, w + 6, h + 6);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setBackground(MTUI.Panel.getBackground());
        c.setForeground(MTUI.Panel.getForeground());
        if (UIUtil.getParentOfType(CellRendererPane.class, (Component)c) != null) {
            c.setBorder(null);
        }
    }

    protected int textIconGap() {
        return JBUIScale.scale((int)4);
    }

    public Icon getDefaultIcon() {
        return DEFAULT_ICON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawCheckIcon(JComponent c, Graphics2D g, AbstractButton b, Rectangle iconRect, boolean selected, boolean enabled) {
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            String iconName = this.isIndeterminate(b) ? "checkBoxIndeterminate" : "checkBox";
            boolean hasFocus = b.hasFocus();
            Icon icon = MTIconLookup.getIcon("checkboxes/" + iconName, selected || this.isIndeterminate(b), hasFocus, b.isEnabled());
            icon.paintIcon(b, g2, iconRect.x, iconRect.y);
        }
        finally {
            g2.dispose();
        }
    }

    protected void drawText(JComponent c, Graphics2D g, AbstractButton b, FontMetrics fm, Rectangle textRect, String text) {
        if (text != null) {
            View view = (View)c.getClientProperty("html");
            if (view != null) {
                view.paint(g, textRect);
            } else {
                g.setColor(b.isEnabled() ? b.getForeground() : this.getDisabledTextColor());
                SwingUtilities2.drawStringUnderlineCharAt(c, g, text, b.getDisplayedMnemonicIndex(), textRect.x, textRect.y + fm.getAscent());
            }
        }
    }
}

