/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.actionSystem.impl.segmentedActionBar.SegmentedBarActionComponent;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.UIUtilities;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.utils.ColorCycle;
import com.mallowigi.idea.utils.MTUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicButtonListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.swing.SwingUtilities2;

public final class MTButtonUI
extends DarculaButtonUI {
    private static final int HELP_BUTTON_DIAMETER = JBUI.scale((int)22);
    private static final int MINIMUM_BUTTON_WIDTH = JBUI.scale((int)64);
    private static final int HORIZONTAL_PADDING = JBUI.scale((int)20);
    @Nullable
    private static Color primaryButtonBg;
    @Nullable
    private static Color primaryButtonFg;
    @Nullable
    private static Color primaryButtonHover;
    @Nullable
    private static Color buttonHover;
    @Nullable
    private static Color selectedButtonFg;
    @Nullable
    private static Color selectedButtonBg;
    @Nullable
    private static Color buttonFg;
    @Nullable
    private static Color buttonBg;
    private boolean isNotThemed = true;

    public static ComponentUI createUI(JComponent component) {
        return new MTButtonUI();
    }

    public static void resetCache() {
        selectedButtonFg = null;
        selectedButtonBg = null;
        buttonBg = null;
        buttonFg = null;
        primaryButtonFg = null;
        primaryButtonBg = null;
        primaryButtonHover = null;
    }

    @NotNull
    static Color buttonBg() {
        if (buttonBg == null) {
            buttonBg = MTUI.Button.getBackgroundColor();
            if (MTConfig.getInstance().isBorderedButtons()) {
                buttonBg = ColorUtil.withAlpha((Color)buttonBg, (double)0.0);
            }
        }
        Color color = buttonBg;
        if (color == null) {
            MTButtonUI.$$$reportNull$$$0(0);
        }
        return color;
    }

    @NotNull
    static Color buttonFg() {
        if (buttonFg == null) {
            buttonFg = MTUI.Button.getForegroundColor();
            if (MTConfig.getInstance().isBorderedButtons()) {
                buttonFg = MTUI.Panel.getAccentColor();
            }
        }
        Color color = buttonFg;
        if (color == null) {
            MTButtonUI.$$$reportNull$$$0(1);
        }
        return color;
    }

    @NotNull
    static Color primaryButtonBg() {
        if (primaryButtonBg == null) {
            primaryButtonBg = MTUI.Button.getPrimaryBackgroundColor();
            if (MTConfig.getInstance().isBorderedButtons()) {
                primaryButtonBg = ColorUtil.withAlpha((Color)primaryButtonBg, (double)0.0);
            }
        }
        Color color = primaryButtonBg;
        if (color == null) {
            MTButtonUI.$$$reportNull$$$0(2);
        }
        return color;
    }

    private static Color primaryButtonFg() {
        if (primaryButtonFg == null) {
            primaryButtonFg = MTUI.Button.getPrimaryForegroundColor();
            if (MTConfig.getInstance().isBorderedButtons()) {
                primaryButtonFg = MTUI.Panel.getAccentColor();
            }
        }
        return primaryButtonFg;
    }

    @NotNull
    private static Color selectedButtonBg() {
        if (selectedButtonBg == null) {
            selectedButtonBg = MTUI.Button.getSelectedBackgroundColor();
            if (MTConfig.getInstance().isBorderedButtons()) {
                selectedButtonBg = ColorUtil.withAlpha((Color)selectedButtonBg, (double)0.0);
            }
        }
        Color color = selectedButtonBg;
        if (color == null) {
            MTButtonUI.$$$reportNull$$$0(3);
        }
        return color;
    }

    @NotNull
    static Color selectedButtonFg() {
        if (selectedButtonFg == null) {
            selectedButtonFg = MTUI.Button.getSelectedForegroundColor();
            if (MTConfig.getInstance().isBorderedButtons()) {
                selectedButtonFg = MTUI.Panel.getAccentColor();
            }
        }
        Color color = selectedButtonFg;
        if (color == null) {
            MTButtonUI.$$$reportNull$$$0(4);
        }
        return color;
    }

    @NotNull
    static Color primaryButtonHoverColor() {
        if (primaryButtonHover == null) {
            Color color = MTButtonUI.primaryButtonBg();
            primaryButtonHover = new JBColor(ColorUtil.darker((Color)color, (int)2), ColorUtil.brighter((Color)color, (int)2));
            if (MTConfig.getInstance().isBorderedButtons()) {
                primaryButtonHover = ColorUtil.withAlpha((Color)MTUI.Panel.getAccentColor(), (double)0.15);
            }
        }
        Color color = primaryButtonHover;
        if (color == null) {
            MTButtonUI.$$$reportNull$$$0(5);
        }
        return color;
    }

    @NotNull
    static Color buttonHoverColor() {
        if (buttonHover == null) {
            Color color = MTButtonUI.selectedButtonBg();
            buttonHover = new JBColor(ColorUtil.darker((Color)color, (int)2), ColorUtil.brighter((Color)color, (int)2));
            if (MTConfig.getInstance().isBorderedButtons()) {
                buttonHover = ColorUtil.withAlpha((Color)MTUI.Panel.getAccentColor(), (double)0.15);
            }
        }
        Color color = buttonHover;
        if (color == null) {
            MTButtonUI.$$$reportNull$$$0(6);
        }
        return color;
    }

    private static boolean paintHelpIcon(Graphics2D g, JComponent component, int w, int h, Color buttonColor1) {
        g.setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)buttonColor1, (float)0.0f, (float)h, (Color)buttonColor1));
        int off = JBUI.scale((int)22);
        int x = (w - off) / 2;
        int y = (h - off) / 2;
        g.fillOval(x, y, off, off);
        AllIcons.Actions.Help.paintIcon(component, g, x + JBUI.scale((int)3), y + JBUI.scale((int)3));
        AbstractButton button = (AbstractButton)component;
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setContentAreaFilled(false);
        return false;
    }

    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
        this.isNotThemed = true;
        button.setRolloverEnabled(true);
        if (MTConfig.getInstance().isUpperCaseButtons()) {
            button.setFont(button.getFont().deriveFont(1, JBUIScale.scale((float)12.0f)));
        } else {
            button.setFont(button.getFont().deriveFont(1, JBUIScale.scale((float)13.0f)));
        }
    }

    protected int textIconGap() {
        return JBUI.scale((int)24);
    }

    protected boolean paintDecorations(Graphics2D g, JComponent c) {
        if (!((AbstractButton)c).isContentAreaFilled()) {
            return true;
        }
        int w = c.getWidth();
        int h = c.getHeight();
        Color background = c.getBackground();
        if (this.isNotThemed && MTButtonUI.isDefaultButton((JComponent)c)) {
            c.setBackground(MTButtonUI.primaryButtonBg());
            this.isNotThemed = false;
        }
        if (SegmentedBarActionComponent.Companion.isCustomBar((Component)c)) {
            return SegmentedBarActionComponent.Companion.paintButtonDecorations(g, c, (Paint)MTButtonUI.buttonBg());
        }
        Rectangle r = new Rectangle(c.getSize());
        JBInsets.removeFrom((Rectangle)r, (Insets)(MTButtonUI.isSmallVariant(c) ? c.getInsets() : JBUI.insets((int)1)));
        Color overridenColor = (Color)c.getClientProperty("JButton.backgroundColor");
        Color backgroundColor = MTButtonUI.buttonBg();
        Color focusedColor = MTButtonUI.primaryButtonHoverColor();
        if (UIUtil.isHelpButton((Component)c)) {
            return MTButtonUI.paintHelpIcon(g, c, w, h, backgroundColor);
        }
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        boolean xOff = false;
        boolean yOff = false;
        if (c.hasFocus()) {
            g.setPaint(focusedColor);
        } else {
            g.setPaint(background);
        }
        if (overridenColor != null) {
            g.setPaint(overridenColor);
        }
        int rad = JBUI.scale((int)3);
        g.fillRoundRect(0, 0, w, h, rad, rad);
        config.restore();
        return true;
    }

    public static boolean isSmallVariant(Component c) {
        if (!(c instanceof AbstractButton)) {
            return false;
        }
        AbstractButton b = (AbstractButton)c;
        boolean smallVariant = b.getClientProperty("ActionToolbar.smallVariant") == Boolean.TRUE;
        ComboBoxAction a = (ComboBoxAction)b.getClientProperty("styleCombo");
        return smallVariant || a != null && a.isSmallVariant();
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        int mnemonicIndex;
        Color fg;
        if (UIUtil.isHelpButton((Component)c)) {
            return;
        }
        AbstractButton button = (AbstractButton)c;
        ButtonModel model = button.getModel();
        Color overridenColor = (Color)button.getClientProperty("JButton.textColor");
        Color color = fg = MTButtonUI.isDefaultButton((JComponent)c) ? MTButtonUI.primaryButtonFg() : MTButtonUI.buttonFg();
        if (fg instanceof UIResource && button.isSelected()) {
            fg = MTButtonUI.selectedButtonFg();
        } else if (model.isRollover()) {
            fg = MTButtonUI.selectedButtonFg();
        }
        g.setColor(overridenColor != null ? overridenColor : fg);
        FontMetrics metrics = UIUtilities.getFontMetrics((JComponent)c, (Graphics)g);
        String textToPrint = MTConfig.getInstance().isUpperCaseButtons() ? text.toUpperCase(Locale.ENGLISH) : text;
        int textWidth = metrics.stringWidth(textToPrint);
        int x = (c.getWidth() - this.getTextShiftOffset() - textWidth) / 2;
        int y = textRect.y + metrics.getAscent();
        int n = mnemonicIndex = DarculaLaf.isAltPressed() ? button.getDisplayedMnemonicIndex() : -1;
        if (model.isEnabled()) {
            UIUtilities.drawStringUnderlineCharAt((JComponent)c, (Graphics)g, (String)textToPrint, (int)mnemonicIndex, (int)x, (int)y);
        } else {
            this.paintDisabledText(g, text, c, textRect, metrics);
        }
    }

    protected void paintDisabledText(Graphics g, String text, JComponent c, Rectangle textRect, FontMetrics metrics) {
        String textToPrint = MTConfig.getInstance().isUpperCaseButtons() ? text.toUpperCase(Locale.ENGLISH) : text;
        int x = (c.getWidth() - this.getTextShiftOffset() - metrics.stringWidth(textToPrint)) / 2;
        g.setColor(MTUI.Button.getDisabledShadowColor());
        SwingUtilities2.drawStringUnderlineCharAt(c, g, textToPrint, -1, x + 1, textRect.y + metrics.getAscent() + 1);
        g.setColor(MTUI.Button.getDisabledColor());
        SwingUtilities2.drawStringUnderlineCharAt(c, g, textToPrint, -1, x, textRect.y + metrics.getAscent());
    }

    protected Dimension getDarculaButtonSize(JComponent c, Dimension prefSize) {
        Insets insets = c.getInsets();
        if (UIUtil.isHelpButton((Component)c) || MTButtonUI.isSquare((Component)c)) {
            int helpDiam = HELP_BUTTON_DIAMETER;
            return new Dimension(Math.max(prefSize.width, helpDiam + insets.left + insets.right), Math.max(prefSize.height, helpDiam + insets.top + insets.bottom));
        }
        int width = MTButtonUI.isComboAction((Component)c) ? prefSize.width : Math.max((HORIZONTAL_PADDING << 1) + prefSize.width, MINIMUM_BUTTON_WIDTH + insets.left + insets.right);
        int height = Math.max(prefSize.height, this.getMinimumHeight() + insets.top + insets.bottom);
        return new Dimension(width, height);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new ButtonHighlighter(b);
    }

    protected void paintIcon(Graphics g, JComponent c, Rectangle iconRect) {
        Rectangle newIconRect = new Rectangle(iconRect.getBounds());
        super.paintIcon(g, c, newIconRect);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/mallowigi/idea/ui/MTButtonUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buttonBg";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buttonFg";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "primaryButtonBg";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "selectedButtonBg";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "selectedButtonFg";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "primaryButtonHoverColor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buttonHoverColor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static final class ButtonHighlighter
    extends BasicButtonListener {
        private final ColorCycle colorCycle;
        private final AbstractButton button;

        ButtonHighlighter(AbstractButton button) {
            super(button);
            this.button = button;
            this.colorCycle = new ColorCycle(5, 20);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.button instanceof BasicArrowButton) {
                super.mousePressed(e);
                return;
            }
            if (!this.button.isEnabled()) {
                return;
            }
            this.highlightButton(e);
            super.mousePressed(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.button instanceof BasicArrowButton) {
                super.mouseReleased(e);
                return;
            }
            if (!this.button.isEnabled()) {
                return;
            }
            this.removeHighlight(e);
            super.mouseReleased(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this.button instanceof BasicArrowButton) {
                return;
            }
            if (!this.button.isEnabled()) {
                return;
            }
            this.highlightButton(e);
            super.mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.button instanceof BasicArrowButton) {
                return;
            }
            if (!this.button.isEnabled()) {
                return;
            }
            this.removeHighlight(e);
            super.mouseExited(e);
        }

        private void highlightButton(MouseEvent e) {
            this.colorCycle.stop();
            Component component = e.getComponent();
            JButton jButton = (JButton)component;
            this.colorCycle.setComponent((JComponent)component);
            Color hoverColor = jButton.isDefaultButton() ? MTButtonUI.primaryButtonHoverColor() : MTButtonUI.buttonHoverColor();
            Color preHoverColor = jButton.isDefaultButton() ? MTButtonUI.primaryButtonBg() : MTButtonUI.buttonBg();
            Color textColor = MTButtonUI.selectedButtonFg();
            component.setForeground(textColor);
            Color[] colors = new Color[5];
            for (int i = 0; i < 5; ++i) {
                colors[i] = ColorUtil.mix((Color)preHoverColor, (Color)hoverColor, (double)((double)i * 0.2));
            }
            this.colorCycle.start(colors);
        }

        private void removeHighlight(MouseEvent e) {
            this.colorCycle.stop();
            Component component = e.getComponent();
            JButton jButton = (JButton)component;
            this.colorCycle.setComponent((JComponent)component);
            Color notHoverColor = jButton.isDefaultButton() ? MTButtonUI.primaryButtonHoverColor() : MTButtonUI.buttonHoverColor();
            Color preNotHoverColor = jButton.isDefaultButton() ? MTButtonUI.primaryButtonBg() : MTButtonUI.buttonBg();
            Color textColor = MTButtonUI.buttonFg();
            component.setForeground(textColor);
            Color[] colors = new Color[5];
            for (int i = 0; i < 5; ++i) {
                colors[i] = ColorUtil.mix((Color)notHoverColor, (Color)preNotHoverColor, (double)((double)i * 0.2));
            }
            this.colorCycle.start(colors);
        }
    }
}

