/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.ui;

import com.intellij.ui.ColorUtil;
import com.mallowigi.idea.ui.OverlapLayout;
import com.mallowigi.idea.ui.SwingUtils;
import com.mallowigi.idea.utils.MTUI;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public final class DisabledPanel
extends JPanel {
    private static final DisabledEventQueue queue = new DisabledEventQueue();
    private static final Map<Container, List<JComponent>> containers = new HashMap<Container, List<JComponent>>(10);
    private final String text;
    private JComponent glassPane;

    public DisabledPanel(Container container) {
        this(container, null, "");
    }

    public DisabledPanel(Container container, String text) {
        this(container, null, text);
    }

    public DisabledPanel(Container container, Color disabledColor, String text) {
        this.setLayout(new OverlapLayout());
        this.add(container);
        this.text = text;
        this.glassPane = new GlassPane();
        this.glassPane.setLayout((LayoutManager)new MigLayout("hidemode 3,align center top", "[]", "[]para[][]"));
        if (text != null) {
            JTextPane textLabel = new JTextPane();
            textLabel.setText(text);
            textLabel.setFont(new Font("Roboto", textLabel.getFont().getStyle(), textLabel.getFont().getSize() + 3));
            this.glassPane.add((Component)textLabel, "cell 2 0");
        }
        this.add(this.glassPane);
        if (disabledColor != null) {
            this.glassPane.setBackground(disabledColor);
        }
        this.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy());
    }

    public Color getDisabledColor() {
        return this.glassPane.getBackground();
    }

    public void setDisabledColor(Color disabledColor) {
        this.glassPane.setBackground(disabledColor);
    }

    public JComponent getGlassPane() {
        return this.glassPane;
    }

    public void setGlassPane(JComponent glassPane) {
        this.glassPane = glassPane;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.glassPane.setVisible(false);
            this.setFocusCycleRoot(false);
            queue.removePanel(this);
        } else {
            this.glassPane.setVisible(true);
            this.setFocusCycleRoot(true);
            queue.addPanel(this);
        }
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public static void disable(Container container) {
        List<JComponent> components = SwingUtils.getDescendantsOfType(JComponent.class, container, true);
        ArrayList<JComponent> enabledComponents = new ArrayList<JComponent>(10);
        containers.put(container, enabledComponents);
        for (JComponent component : components) {
            if (!component.isEnabled()) continue;
            enabledComponents.add(component);
            component.setEnabled(false);
        }
    }

    public static void enable(Container container) {
        List<JComponent> enabledComponents = containers.get(container);
        if (enabledComponents != null) {
            for (JComponent component : enabledComponents) {
                component.setEnabled(true);
            }
            containers.remove(container);
        }
    }

    static final class DisabledEventQueue
    extends EventQueue
    implements WindowListener {
        private final Map<DisabledPanel, Set<KeyStroke>> panels = new HashMap<DisabledPanel, Set<KeyStroke>>(10);

        DisabledEventQueue() {
        }

        void addPanel(DisabledPanel panel) {
            Set<KeyStroke> keyStrokes = DisabledEventQueue.getKeyStrokes(panel);
            if (keyStrokes.isEmpty()) {
                return;
            }
            this.panels.put(panel, keyStrokes);
            EventQueue current = Toolkit.getDefaultToolkit().getSystemEventQueue();
            if (current != this) {
                current.push(queue);
            }
            Window window = SwingUtilities.windowForComponent(panel);
            window.removeWindowListener(this);
            window.addWindowListener(this);
        }

        private static Set<KeyStroke> getKeyStrokes(DisabledPanel panel) {
            HashSet<KeyStroke> keyStrokes = new HashSet<KeyStroke>(10);
            Container container = (Container)panel.getComponent(1);
            List<JComponent> components = SwingUtils.getDescendantsOfType(JComponent.class, container);
            for (JComponent component : components) {
                InputMap im = component.getInputMap(2);
                if (im == null || im.allKeys() == null) continue;
                for (KeyStroke keyStroke : im.allKeys()) {
                    keyStrokes.add(keyStroke);
                }
            }
            return keyStrokes;
        }

        void removePanel(DisabledPanel panel) {
            if (this.panels.remove(panel) != null && this.panels.isEmpty()) {
                this.pop();
            }
        }

        @Override
        protected void dispatchEvent(AWTEvent event) {
            if (event.getID() == 400 || event.getID() == 401 || event.getID() == 402) {
                KeyEvent keyEvent = (KeyEvent)event;
                KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                for (DisabledPanel panel : this.panels.keySet()) {
                    Window panelWindow = SwingUtilities.windowForComponent(panel);
                    if (panelWindow != keyEvent.getComponent() || !this.searchForKeyBinding(panel, keyStroke)) continue;
                    return;
                }
            }
            super.dispatchEvent(event);
        }

        private boolean searchForKeyBinding(DisabledPanel panel, KeyStroke keyStroke) {
            Set<KeyStroke> keyStrokes = this.panels.get(panel);
            return keyStrokes.contains(keyStroke);
        }

        @Override
        public void windowClosed(WindowEvent e) {
            ArrayList<DisabledPanel> panelsToRemove = new ArrayList<DisabledPanel>(10);
            Window window = e.getWindow();
            for (DisabledPanel panel : this.panels.keySet()) {
                Window panelWindow = SwingUtilities.windowForComponent(panel);
                if (panelWindow != window) continue;
                panelsToRemove.add(panel);
            }
            for (DisabledPanel panel : panelsToRemove) {
                this.removePanel(panel);
            }
            window.removeWindowListener(this);
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }
    }

    static final class GlassPane
    extends JComponent {
        GlassPane() {
            this.setOpaque(false);
            this.setVisible(false);
            Color base = MTUI.Panel.getExcludedBackground();
            Color background = ColorUtil.toAlpha((Color)base, (int)212);
            this.setBackground(background);
            this.addMouseListener(new MouseAdapter(){});
            this.addMouseMotionListener(new MouseMotionAdapter(){});
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
    }
}

