/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.ui;

import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.beans.EventHandler;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class ColorPanelWithOpacity
extends JComponent {
    private static final RelativeFont MONOSPACED_FONT = RelativeFont.SMALL.family("Monospaced");
    @NonNls
    private static final String ON_PRESSED = "onPressed";
    @NonNls
    private static final String MOUSE_PRESSED = "mousePressed";
    @NonNls
    private static final String KEY_CODE = "keyCode";
    @NonNls
    private static final String KEY_PRESSED = "keyPressed";
    @NonNls
    private static final String COLOR_PANEL_CHANGED = "colorPanelChanged";
    @NonNls
    private static final String HEX_STR = " %s ";
    private final Collection<ActionListener> myListeners = new CopyOnWriteArrayList<ActionListener>();
    private final JTextField myTextField = new JBTextField(10);
    private boolean myEditable;
    @Nullable
    private ActionEvent myEvent;
    @Nullable
    private Color myColor;

    public ColorPanelWithOpacity() {
        this.addImpl(this.myTextField, null, 0);
        this.myColor = null;
        this.setEditable();
        this.setMinimumSize((Dimension)JBUI.size((int)10, (int)10));
        this.myTextField.addMouseListener(EventHandler.create(MouseListener.class, this, ON_PRESSED, null, MOUSE_PRESSED));
        this.myTextField.addKeyListener(EventHandler.create(KeyListener.class, this, ON_PRESSED, KEY_CODE, KEY_PRESSED));
        this.myTextField.setEditable(false);
        MONOSPACED_FONT.install((Component)this.myTextField);
        ColorPainter.BACKGROUND.install(this.myTextField, true);
    }

    public void onPressed(int keyCode) {
        if (keyCode == 32) {
            this.onPressed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPressed() {
        Color color;
        if (this.myEditable && this.isEnabled() && (color = ColorChooser.chooseColor((Component)this, (String)UIBundle.message((String)"color.panel.select.color.dialog.description", (Object[])new Object[0]), (Color)this.myColor, (boolean)true)) != null) {
            this.setSelectedColor(color);
            if (!this.myListeners.isEmpty() && this.myEvent == null) {
                try {
                    this.myEvent = new ActionEvent(this, 1001, COLOR_PANEL_CHANGED);
                    for (ActionListener listener : this.myListeners) {
                        listener.actionPerformed(this.myEvent);
                    }
                }
                finally {
                    this.myEvent = null;
                }
            }
        }
    }

    @Override
    public void doLayout() {
        Rectangle bounds = new Rectangle(this.getWidth(), this.getHeight());
        JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
        this.myTextField.setBounds(bounds);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension size = this.myTextField.getPreferredSize();
        JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
        return size;
    }

    @Override
    public String getToolTipText() {
        return this.myTextField.getToolTipText();
    }

    public void removeActionListener(ActionListener actionlistener) {
        this.myListeners.remove(actionlistener);
    }

    public void addActionListener(ActionListener actionlistener) {
        this.myListeners.add(actionlistener);
    }

    @Nullable
    public Color getSelectedColor() {
        return this.myColor;
    }

    public void setSelectedColor(@Nullable Color color) {
        this.myColor = color;
        this.updateSelectedColor();
    }

    private void updateSelectedColor() {
        Color color;
        boolean enabled = this.isEnabled();
        if (enabled && this.myEditable) {
            this.myTextField.setEnabled(true);
            this.myTextField.setToolTipText(UIBundle.message((String)"color.panel.select.color.tooltip.text", (Object[])new Object[0]));
        } else {
            this.myTextField.setEnabled(false);
            this.myTextField.setToolTipText(null);
        }
        Color color2 = color = enabled ? this.myColor : null;
        if (color != null) {
            this.myTextField.setText(String.format(HEX_STR, ColorUtil.toHex((Color)color, (boolean)true).toUpperCase(Locale.ENGLISH)));
        } else {
            this.myTextField.setText(null);
            color = this.getBackground();
        }
        this.myTextField.setBackground(color);
        this.myTextField.setSelectedTextColor(color);
        this.myTextField.setOpaque(false);
        if (color != null) {
            int gray = (int)(0.212656 * (double)color.getRed() + 0.715158 * (double)color.getGreen() + 0.072186 * (double)color.getBlue());
            int delta = gray < 32 ? 96 : (gray < 80 ? 64 : (gray < 128 ? 32 : (gray < 176 ? -32 : (gray < 224 ? -64 : -96))));
            color = new Color(gray += delta, gray, gray);
            this.myTextField.setDisabledTextColor(color);
            this.myTextField.setSelectionColor(color);
            color = new Color(gray += delta, gray, gray);
            this.myTextField.setForeground(color);
        }
    }

    private void setEditable() {
        this.myEditable = true;
        this.updateSelectedColor();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateSelectedColor();
    }

    private static final class ColorPainter
    implements Highlighter.HighlightPainter,
    PropertyChangeListener {
        @NonNls
        private static final String PROPERTY = "highlighter";
        static final ColorPainter BACKGROUND = new ColorPainter();

        private ColorPainter() {
        }

        @Override
        public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
            Color color = c.getBackground();
            if (color != null) {
                g.setColor(color);
                Rectangle rectangle = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
                g.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object source = evt.getSource();
            if (source instanceof JTextComponent && PROPERTY.equals(evt.getPropertyName())) {
                this.install((JTextComponent)source, false);
            }
        }

        private void install(JTextComponent component, boolean listener) {
            try {
                Highlighter highlighter = component.getHighlighter();
                if (highlighter != null) {
                    highlighter.addHighlight(0, 0, this);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (listener) {
                component.addPropertyChangeListener(PROPERTY, this);
            }
        }
    }
}

