/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.themes.themes;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.UIThemeBasedLookAndFeelInfo;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.ui.ColorUtil;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.lafs.MTDarculaLaf;
import com.mallowigi.idea.lafs.MTNativeLaf;
import com.mallowigi.idea.themes.MTAccentMode;
import com.mallowigi.idea.themes.lists.ContrastResources;
import com.mallowigi.idea.themes.themes.MTAbstractTheme;
import com.mallowigi.idea.utils.MTColorUtils;
import com.mallowigi.idea.utils.MTUI;
import com.mallowigi.idea.utils.MTUiUtils;
import java.awt.Color;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;

public class MTNativeTheme
extends MTAbstractTheme {
    @Override
    public final ColorUIResource getBackgroundColorResource() {
        return new ColorUIResource(MTUI.Panel.getBackground());
    }

    @Override
    public final ColorUIResource getForegroundColorResource() {
        return new ColorUIResource(MTUI.Panel.getForeground());
    }

    @Override
    public final ColorUIResource getTextColorResource() {
        return new ColorUIResource(MTUI.Panel.getPrimaryForeground());
    }

    @Override
    public final ColorUIResource getSelectionBackgroundColorResource() {
        return new ColorUIResource(MTUI.Panel.getSelectionBackground());
    }

    @Override
    public final ColorUIResource getSelectionForegroundColorResource() {
        return new ColorUIResource(MTUI.Panel.getSelectionForeground());
    }

    @Override
    public final ColorUIResource getButtonColorResource() {
        return new ColorUIResource(MTUI.Button.getBackgroundColor());
    }

    @Override
    public final ColorUIResource getSecondaryBackgroundColorResource() {
        return new ColorUIResource(MTUI.Panel.getSecondaryBackground());
    }

    @Override
    public final ColorUIResource getDisabledColorResource() {
        return new ColorUIResource(MTUI.Button.getDisabledColor());
    }

    @Override
    public final ColorUIResource getContrastColorResource() {
        return new ColorUIResource(MTUI.Panel.getContrastBackground());
    }

    @Override
    public final ColorUIResource getTableSelectedColorResource() {
        return new ColorUIResource(MTUI.Table.getHighlightOuterColor());
    }

    @Override
    public final ColorUIResource getSecondBorderColorResource() {
        return new ColorUIResource(MTUI.Separator.getSeparatorColor());
    }

    @Override
    public final ColorUIResource getHighlightColorResource() {
        return new ColorUIResource(MTUI.Panel.getHighlightBackground());
    }

    @Override
    public final ColorUIResource getTreeSelectionColorResource() {
        return new ColorUIResource(MTUI.Tree.getSelectionBackground());
    }

    @Override
    public final ColorUIResource getNotificationsColorResource() {
        return new ColorUIResource(MTUI.Notification.getBackgroundColor());
    }

    @Override
    public final ColorUIResource getAccentColorResource() {
        return new ColorUIResource(ColorUtil.brighter((Color)MTUI.Button.getPrimaryBackgroundColor(), (int)2));
    }

    @Override
    public final ColorUIResource getExcludedColorResource() {
        return new ColorUIResource(MTUI.Panel.getExcludedBackground());
    }

    @Override
    public final String getThemeId() {
        return "external";
    }

    @Override
    public final void setLookAndFeel() throws UnsupportedLookAndFeelException {
        UIManager.LookAndFeelInfo currentLookAndFeel = LafManager.getInstance().getCurrentLookAndFeel();
        if (currentLookAndFeel == null) {
            super.setLookAndFeel();
            return;
        }
        if (currentLookAndFeel instanceof UIThemeBasedLookAndFeelInfo) {
            UIManager.setLookAndFeel((LookAndFeel)((Object)new MTNativeLaf(this, currentLookAndFeel)));
        } else if (DarculaLookAndFeelInfo.CLASS_NAME.equals(currentLookAndFeel.getClassName())) {
            UIManager.setLookAndFeel((LookAndFeel)((Object)new MTDarculaLaf(this)));
        }
    }

    @Override
    protected void buildAllResources() {
    }

    @Override
    public void applyContrast(boolean apply) {
        boolean dark = this.isDark();
        for (String resource : ContrastResources.CONTRASTED_RESOURCES) {
            Color color = UIManager.getLookAndFeelDefaults().getColor(resource);
            if (color != null) {
                UIManager.put(resource, apply ? MTColorUtils.contrastifyBackground(dark, new ColorUIResource(color), false) : color);
                continue;
            }
            UIManager.put(resource, apply ? MTUI.Panel.getContrastBackground() : MTUI.Panel.getBackground());
        }
    }

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    protected String getBackgroundImage() {
        return null;
    }

    @Override
    public void applyAccentMode() {
        MTConfig mtConfig = MTConfig.getInstance();
        Color accentColor = ColorUtil.fromHex((String)mtConfig.getAccentColor());
        Color darkerAccentColor = ColorUtil.darker((Color)accentColor, (int)2);
        Color accentColorTransparent = ColorUtil.withAlpha((Color)accentColor, (double)0.5);
        Color secondAccentColor = ColorUtil.fromHex((String)mtConfig.getSecondAccentColor());
        boolean accentMode = mtConfig.isAccentMode();
        MTUiUtils.buildAccentResources(MTAccentMode.ACCENT_EXTRA_RESOURCES, accentColor, accentMode);
        MTUiUtils.buildAccentResources(MTAccentMode.DARKER_ACCENT_RESOURCES, darkerAccentColor, accentMode);
        MTUiUtils.buildAccentResources(MTAccentMode.ACCENT_TRANSPARENT_EXTRA_RESOURCES, accentColorTransparent, accentMode);
        MTUiUtils.buildAccentResources(MTAccentMode.SELECTION_RESOURCES, MTAccentMode.getSelectionColor(), accentMode);
        MTUiUtils.buildAccentResources(MTAccentMode.SECOND_ACCENT_RESOURCES, secondAccentColor, accentMode);
    }
}

