/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.themes.themes;

import com.google.common.collect.Sets;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.IconUtil;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.MTThemeManager;
import com.mallowigi.idea.lafs.MTDarkLaf;
import com.mallowigi.idea.lafs.MTLightLaf;
import com.mallowigi.idea.themes.MTAccentMode;
import com.mallowigi.idea.themes.lists.ContrastResources;
import com.mallowigi.idea.themes.lists.MTThemeResources;
import com.mallowigi.idea.themes.models.MTSerializedTheme;
import com.mallowigi.idea.themes.models.MTThemeable;
import com.mallowigi.idea.utils.MTColorUtils;
import com.mallowigi.idea.utils.MTUI;
import com.mallowigi.idea.utils.MTUiUtils;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class MTAbstractTheme
implements Serializable,
MTThemeable,
MTSerializedTheme {
    private String id = null;
    private String editorColorsScheme = null;
    private boolean dark = false;
    private String name = null;
    private String icon = null;
    private transient boolean isNotHighContrast = false;

    protected MTAbstractTheme() {
        this.init();
    }

    protected void init() {
        this.setId(this.getThemeId()).setIsDark(this.isThemeDark()).setEditorColorScheme(this.getThemeColorScheme()).setIcon(this.getThemeIcon()).setName(this.getThemeName());
    }

    public final String toString() {
        return this.getId();
    }

    @Override
    public final void activate() {
        MTConfig config = MTConfig.getInstance();
        this.isNotHighContrast = !config.isHighContrast();
        try {
            JBColor.setDark((boolean)this.dark);
            IconLoader.setUseDarkIcons((boolean)this.dark);
            this.buildAllResources();
            if (config.isOverrideAccentColor()) {
                config.setAccentColor(ColorUtil.toHex((Color)this.getAccentColorResource()));
                MTThemeManager.applyAccents(true);
            }
            this.installBackgroundImage();
            this.setLookAndFeel();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
    }

    protected void setLookAndFeel() throws UnsupportedLookAndFeelException {
        if (this.dark) {
            UIManager.setLookAndFeel((LookAndFeel)((Object)new MTDarkLaf(this)));
        } else {
            UIManager.setLookAndFeel((LookAndFeel)((Object)new MTLightLaf(this)));
        }
    }

    protected void buildAllResources() {
        MTUiUtils.buildResources(MTThemeResources.getBackgroundResources(), MTColorUtils.contrastifyBackground(this.dark, this.getBackgroundColorResource(), this.isNotHighContrast));
        MTUiUtils.buildResources(MTThemeResources.getForegroundResources(), this.getForegroundColorResource());
        MTUiUtils.buildResources(MTThemeResources.getTextResources(), MTColorUtils.contrastifyForeground(this.dark, this.getTextColorResource(), this.isNotHighContrast));
        MTUiUtils.buildResources(MTThemeResources.getSelectionBackgroundResources(), this.getSelectionBackgroundColorResource());
        MTUiUtils.buildResources(MTThemeResources.getSelectionTransparentBackgroundResources(), ColorUtil.toAlpha((Color)this.getSelectionBackgroundColorResource(), (int)80));
        MTUiUtils.buildResources(MTThemeResources.getSelectionForegroundResources(), this.getSelectionForegroundColorResource());
        MTUiUtils.buildResources(MTThemeResources.getButtonColorResources(), this.getButtonColorResource());
        MTUiUtils.buildResources(MTThemeResources.getSecondaryBackgroundResources(), this.getSecondaryBackgroundColorResource());
        MTUiUtils.buildResources(MTThemeResources.getDisabledResources(), this.getDisabledColorResource());
        MTUiUtils.buildResources(MTThemeResources.getContrastResources(), MTColorUtils.contrastifyBackground(this.dark, this.getContrastColorResource(), this.isNotHighContrast));
        MTUiUtils.buildResources(MTThemeResources.getTableSelectedResources(), this.getTableSelectedColorResource());
        MTUiUtils.buildResources(MTThemeResources.getSecondBorderResources(), this.getSecondBorderColorResource());
        MTUiUtils.buildResources(MTThemeResources.getHighlightResources(), this.getHighlightColorResource());
        MTUiUtils.buildResources(MTThemeResources.getTreeSelectionResources(), this.getTreeSelectionColorResource());
        MTUiUtils.buildResources(MTThemeResources.getNotificationsResources(), this.getNotificationsColorResource());
        MTUiUtils.buildResources(MTThemeResources.getExcludedResources(), this.getExcludedColorResource());
        MTAbstractTheme.buildNotificationsColors();
        MTAbstractTheme.buildFlameChartColors();
        MTAbstractTheme.buildFileColors();
        MTAbstractTheme.buildTransparentColors();
        MTAbstractTheme.buildTreeSelectionInactiveColors();
        this.buildTabsTransparentColors();
        this.buildOutlineButtons();
        UIManager.getDefaults().put("Component.grayForeground", ColorUtil.darker((Color)this.getTextColorResource(), (int)2));
        UIManager.getDefaults().put("EditorGroupsTabs.underlineHeight", (Object)MTConfig.getInstance().getHighlightThickness());
    }

    @Override
    @NotNull
    public final String getName() {
        String string = this.name;
        if (string == null) {
            MTAbstractTheme.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public final MTAbstractTheme setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public final String getEditorColorsScheme() {
        return this.editorColorsScheme;
    }

    @Override
    public final MTAbstractTheme setEditorColorScheme(String editorColorsScheme) {
        this.editorColorsScheme = editorColorsScheme;
        return this;
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.id;
        if (string == null) {
            MTAbstractTheme.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public final MTAbstractTheme setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public final boolean isDark() {
        return this.dark;
    }

    @Override
    public final MTAbstractTheme setIsDark(boolean dark) {
        this.dark = dark;
        return this;
    }

    @Override
    @NotNull
    public final Icon getIcon() {
        Icon icon = this.icon != null ? IconLoader.getIcon((String)this.icon) : IconUtil.getEmptyIcon((boolean)true);
        if (icon == null) {
            MTAbstractTheme.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @Override
    public final MTAbstractTheme setIcon(String icon) {
        this.icon = icon;
        return this;
    }

    @Override
    public boolean isCustom() {
        return false;
    }

    @Override
    @NotNull
    public final Color getBackgroundColor() {
        Color color = MTColorUtils.contrastifyBackground(this.dark, this.getBackgroundColorResource(), this.isNotHighContrast);
        if (color == null) {
            MTAbstractTheme.$$$reportNull$$$0(3);
        }
        return color;
    }

    @Override
    @NotNull
    public final Color getContrastColor() {
        Color color = MTColorUtils.contrastifyBackground(this.dark, this.getContrastColorResource(), this.isNotHighContrast);
        if (color == null) {
            MTAbstractTheme.$$$reportNull$$$0(4);
        }
        return color;
    }

    @Override
    @NotNull
    public final Color getForegroundColor() {
        Color color = MTColorUtils.contrastifyForeground(this.dark, this.getForegroundColorResource(), this.isNotHighContrast);
        if (color == null) {
            MTAbstractTheme.$$$reportNull$$$0(5);
        }
        return color;
    }

    @Override
    @NotNull
    public final Color getPrimaryColor() {
        Color color = MTColorUtils.contrastifyForeground(this.dark, this.getTextColorResource(), this.isNotHighContrast);
        if (color == null) {
            MTAbstractTheme.$$$reportNull$$$0(6);
        }
        return color;
    }

    @Override
    @NotNull
    public final Color getSelectionBackgroundColor() {
        ColorUIResource colorUIResource = this.getSelectionBackgroundColorResource();
        if (colorUIResource == null) {
            MTAbstractTheme.$$$reportNull$$$0(7);
        }
        return colorUIResource;
    }

    @Override
    @NotNull
    public final Color getSelectionForegroundColor() {
        ColorUIResource colorUIResource = this.getSelectionForegroundColorResource();
        if (colorUIResource == null) {
            MTAbstractTheme.$$$reportNull$$$0(8);
        }
        return colorUIResource;
    }

    @Override
    @NotNull
    public final Color getExcludedColor() {
        Color color = MTColorUtils.contrastifyBackground(this.dark, this.getExcludedColorResource(), this.isNotHighContrast);
        if (color == null) {
            MTAbstractTheme.$$$reportNull$$$0(9);
        }
        return color;
    }

    @Override
    @NotNull
    public final Color getNotificationsColor() {
        ColorUIResource colorUIResource = this.getNotificationsColorResource();
        if (colorUIResource == null) {
            MTAbstractTheme.$$$reportNull$$$0(10);
        }
        return colorUIResource;
    }

    @Override
    @NotNull
    public final Color getSecondBorderColor() {
        ColorUIResource colorUIResource = this.getSecondBorderColorResource();
        if (colorUIResource == null) {
            MTAbstractTheme.$$$reportNull$$$0(11);
        }
        return colorUIResource;
    }

    @Override
    @NotNull
    public final Color getDisabledColor() {
        ColorUIResource colorUIResource = this.getDisabledColorResource();
        if (colorUIResource == null) {
            MTAbstractTheme.$$$reportNull$$$0(12);
        }
        return colorUIResource;
    }

    @Override
    @NotNull
    public final Color getSecondaryBackgroundColor() {
        ColorUIResource colorUIResource = this.getSecondaryBackgroundColorResource();
        if (colorUIResource == null) {
            MTAbstractTheme.$$$reportNull$$$0(13);
        }
        return colorUIResource;
    }

    @Override
    @NotNull
    public final Color getButtonColor() {
        ColorUIResource colorUIResource = this.getButtonColorResource();
        if (colorUIResource == null) {
            MTAbstractTheme.$$$reportNull$$$0(14);
        }
        return colorUIResource;
    }

    @Override
    @NotNull
    public final Color getTableSelectedColor() {
        ColorUIResource colorUIResource = this.getTableSelectedColorResource();
        if (colorUIResource == null) {
            MTAbstractTheme.$$$reportNull$$$0(15);
        }
        return colorUIResource;
    }

    @Override
    @NotNull
    public final Color getTextColor() {
        ColorUIResource colorUIResource = this.getTextColorResource();
        if (colorUIResource == null) {
            MTAbstractTheme.$$$reportNull$$$0(16);
        }
        return colorUIResource;
    }

    @Override
    @NotNull
    public final Color getTreeSelectionColor() {
        ColorUIResource colorUIResource = this.getTreeSelectionColorResource();
        if (colorUIResource == null) {
            MTAbstractTheme.$$$reportNull$$$0(17);
        }
        return colorUIResource;
    }

    @Override
    @NotNull
    public final Color getHighlightColor() {
        ColorUIResource colorUIResource = this.getHighlightColorResource();
        if (colorUIResource == null) {
            MTAbstractTheme.$$$reportNull$$$0(18);
        }
        return colorUIResource;
    }

    @Override
    @NotNull
    public final Color getAccentColor() {
        ColorUIResource colorUIResource = this.getAccentColorResource();
        if (colorUIResource == null) {
            MTAbstractTheme.$$$reportNull$$$0(19);
        }
        return colorUIResource;
    }

    @Override
    public final void setPristine() {
        this.isNotHighContrast = true;
    }

    private static void buildNotificationsColors() {
        JBColor errorColor = new JBColor((Color)new ColorUIResource(15684432), (Color)new ColorUIResource(12000284));
        UIManager.put("Notification.ToolWindowError.background", errorColor);
        UIManager.put("Notification.ToolWindow.errorBackground", errorColor);
        UIManager.put("Notification.ToolWindowError.borderColor", errorColor);
        UIManager.put("Notification.ToolWindow.errorBorderColor", errorColor);
        JBColor warnColor = new JBColor((Color)new ColorUIResource(16766287), (Color)new ColorUIResource(6111287));
        UIManager.put("Notification.ToolWindowWarning.background", warnColor);
        UIManager.put("Notification.ToolWindow.warningBackground", warnColor);
        UIManager.put("Notification.ToolWindowWarning.borderColor", warnColor);
        UIManager.put("Notification.ToolWindow.warningBorderColor", warnColor);
        JBColor infoColor = new JBColor((Color)new ColorUIResource(0x66BB6A), (Color)new ColorUIResource(1793568));
        UIManager.put("Notification.ToolWindowInfo.borderColor", infoColor);
        UIManager.put("Notification.ToolWindow.infoBorderColor", infoColor);
        UIManager.put("Notification.ToolWindow.informativeBorderColor", infoColor);
        UIManager.put("Notification.ToolWindowInfo.background", infoColor);
        UIManager.put("Notification.ToolWindow.infoBackground", infoColor);
        UIManager.put("Notification.ToolWindow.informativeBackground", infoColor);
    }

    private static void buildFlameChartColors() {
        UIManager.put("FlameGraph.JVMBackground", MTUI.MTColor.CYAN);
        UIManager.put("FlameGraph.JVMFocusBackground", MTUI.MTColor.BLUE);
        UIManager.put("FlameGraph.JVMSearchNotMatchedBackground", MTUI.MTColor.RED);
        UIManager.put("FlameGraph.JVMFocusSearchNotMatchedBackground", MTUI.MTColor.BROWN);
        UIManager.put("FlameGraph.nativeBackground", MTUI.MTColor.YELLOW);
        UIManager.put("FlameGraph.nativeFocusBackground", MTUI.MTColor.ORANGE);
        UIManager.put("FlameGraph.nativeSearchNotMatchedBackground", MTUI.MTColor.PURPLE);
        UIManager.put("FlameGraph.nativeFocusSearchNotMatchedBackground", MTUI.MTColor.PINK);
    }

    private static void buildFileColors() {
        UIManager.put("FileColor.Green", new JBColor(MTUI.MTColor.GREEN, MTUI.MTColor.DARK_GREEN));
        UIManager.put("FileColor.Blue", new JBColor(MTUI.MTColor.BLUE, MTUI.MTColor.DARK_BLUE));
        UIManager.put("FileColor.Yellow", new JBColor(MTUI.MTColor.YELLOW, MTUI.MTColor.DARK_YELLOW));
        UIManager.put("FileColor.Orange", new JBColor(MTUI.MTColor.ORANGE, MTUI.MTColor.DARK_ORANGE));
        UIManager.put("FileColor.Violet", new JBColor(MTUI.MTColor.PURPLE, MTUI.MTColor.DARK_PURPLE));
        UIManager.put("FileColor.Rose", new JBColor(MTUI.MTColor.RED, MTUI.MTColor.DARK_RED));
    }

    private static void buildTransparentColors() {
        Set<String> colors = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"ScrollBar.hoverTrackColor", "ScrollBar.trackColor", "ScrollBar.Mac.hoverTrackColor", "ScrollBar.Mac.trackColor", "ScrollBar.Transparent.hoverTrackColor", "ScrollBar.Transparent.trackColor", "ScrollBar.Mac.Transparent.hoverTrackColor", "ScrollBar.Mac.Transparent.trackColor"}));
        Color transparentBackground = MTUI.Panel.getTransparentBackground();
        MTUiUtils.buildResources(colors, transparentBackground);
    }

    private static void buildTreeSelectionInactiveColors() {
        Set<String> colors = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"CompletionPopup.nonFocusedState"}));
        Color transparentBackground = MTUI.Tree.getSelectionInactiveBackground();
        MTUiUtils.buildResources(colors, transparentBackground);
    }

    private void buildTabsTransparentColors() {
        Set<String> colors = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"EditorTabs.inactiveColoredFileBackground"}));
        Color transparentBackground = ColorUtil.withAlpha((Color)this.getSecondaryBackgroundColorResource(), (double)0.5);
        MTUiUtils.buildResources(colors, transparentBackground);
    }

    private void buildOutlineButtons() {
        Set<String> colors = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"Button.background", "Button.endBackground", "Button.startBackground"}));
        Color buttonColor = this.getButtonColor();
        Color transparentBackground = MTConfig.getInstance().isBorderedButtons() ? ColorUtil.withAlpha((Color)buttonColor, (double)0.0) : buttonColor;
        MTUiUtils.buildResources(colors, transparentBackground);
    }

    @Override
    public void applyContrast(boolean apply) {
        Color contrastedColor = apply ? this.getContrastColor() : this.getBackgroundColor();
        for (String resource : ContrastResources.CONTRASTED_RESOURCES) {
            UIManager.put(resource, contrastedColor);
        }
    }

    @Override
    public final void setThemeName(String name) {
        this.setName(name);
    }

    @Override
    public boolean isNative() {
        return false;
    }

    private void installBackgroundImage() {
        block17: {
            String currentSpec = PropertiesComponent.getInstance().getValue("idea.background.frame");
            String oldCurrentSpec = PropertiesComponent.getInstance().getValue("old.mt.idea.background.frame");
            if (!MTConfig.getInstance().isUseMaterialWallpapers()) {
                MTAbstractTheme.removeBackgroundImage(null);
                return;
            }
            try {
                String path = this.getBackgroundImage();
                if (path != null) {
                    File tmpImage = FileUtil.createTempFile((String)"mtBackgroundImage", (String)path.toString().substring(path.lastIndexOf(46)), (boolean)true);
                    URL resource = this.getClass().getClassLoader().getResource(path);
                    if (resource != null) {
                        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream(path);
                             FileOutputStream output = new FileOutputStream(tmpImage);){
                            FileUtil.copy((InputStream)Objects.requireNonNull(input), (OutputStream)output);
                        }
                        String image = tmpImage.getPath();
                        String alpha = String.valueOf(85);
                        String fill = MTUiUtils.parseEnumValue("fill", IdeBackgroundUtil.Fill.PLAIN);
                        String anchor = MTUiUtils.parseEnumValue("center", IdeBackgroundUtil.Anchor.CENTER);
                        String spec = StringUtil.join((String[])new String[]{image, alpha, fill, anchor}, (String)",");
                        PropertiesComponent.getInstance().setValue("old.mt.idea.background.frame", currentSpec);
                        PropertiesComponent.getInstance().setValue("idea.background.frame", spec);
                        ApplicationManager.getApplication().invokeLater(IdeBackgroundUtil::repaintAllWindows);
                        break block17;
                    }
                    throw new IllegalArgumentException("Can't load background: " + path);
                }
                MTAbstractTheme.removeBackgroundImage(oldCurrentSpec);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void removeBackgroundImage(String oldCurrentSpec) {
        PropertiesComponent.getInstance().setValue("idea.background.frame", oldCurrentSpec);
        PropertiesComponent.getInstance().setValue("old.mt.idea.background.frame", null);
        ApplicationManager.getApplication().invokeLater(IdeBackgroundUtil::repaintAllWindows);
    }

    @NonNls
    protected abstract String getBackgroundImage();

    @Override
    public void applyAccentMode() {
        MTConfig mtConfig = MTConfig.getInstance();
        Color accentColor = ColorUtil.fromHex((String)mtConfig.getAccentColor());
        Color darkerAccentColor = ColorUtil.darker((Color)accentColor, (int)2);
        Color accentColorTransparent = ColorUtil.withAlpha((Color)accentColor, (double)0.5);
        Color secondAccentColor = ColorUtil.fromHex((String)mtConfig.getSecondAccentColor());
        boolean accentMode = mtConfig.isAccentMode();
        if (accentMode) {
            MTUiUtils.buildResources(MTAccentMode.ACCENT_EXTRA_RESOURCES, accentColor);
            MTUiUtils.buildResources(MTAccentMode.DARKER_ACCENT_RESOURCES, darkerAccentColor);
            MTUiUtils.buildResources(MTAccentMode.ACCENT_TRANSPARENT_EXTRA_RESOURCES, accentColorTransparent);
            MTUiUtils.buildResources(MTAccentMode.SELECTION_RESOURCES, MTAccentMode.getSelectionColor());
            MTUiUtils.buildResources(MTAccentMode.SECOND_ACCENT_RESOURCES, secondAccentColor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/mallowigi/idea/themes/themes/MTAbstractTheme";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundColor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContrastColor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getForegroundColor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryColor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionBackgroundColor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionForegroundColor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedColor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationsColor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondBorderColor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledColor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondaryBackgroundColor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getButtonColor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableSelectedColor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextColor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeSelectionColor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightColor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccentColor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

