/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.themes.models.parsers;

import com.intellij.ui.ColorUtil;
import com.mallowigi.idea.themes.models.MTBundledTheme;
import com.mallowigi.idea.themes.models.MTThemeColor;
import com.mallowigi.idea.utils.MTColorUtils;
import java.awt.Color;
import java.util.Collection;
import javax.swing.plaf.ColorUIResource;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MTBundledThemeParser {
    @NonNls
    private static final String EXCLUDED_TAG = "excluded";
    @NonNls
    private static final String ACCENT_TAG = "accent";
    @NonNls
    private static final String NOTIFICATIONS_TAG = "notifications";
    @NonNls
    private static final String TREE_SELECTION_TAG = "treeSelection";
    @NonNls
    private static final String HIGHLIGHT_TAG = "highlight";
    @NonNls
    private static final String SECOND_BORDER_TAG = "secondBorder";
    @NonNls
    private static final String TABLE_SELECTED_TAG = "tableSelected";
    @NonNls
    private static final String CONTRAST_TAG = "contrast";
    @NonNls
    private static final String DISABLED_TAG = "disabled";
    @NonNls
    private static final String SECONDARY_BACKGROUND_TAG = "secondaryBackground";
    @NonNls
    private static final String BUTTON_TAG = "button";
    @NonNls
    private static final String SELECTION_FOREGROUND_TAG = "selectionForeground";
    @NonNls
    private static final String SELECTION_BACKGROUND_TAG = "selectionBackground";
    @NonNls
    private static final String TEXT_TAG = "text";
    @NonNls
    private static final String FOREGROUND_TAG = "foreground";
    @NonNls
    private static final String BACKGROUND_TAG = "background";
    private final MTBundledTheme mtBundledTheme;

    MTBundledThemeParser(MTBundledTheme mtBundledTheme) {
        this.mtBundledTheme = mtBundledTheme;
    }

    protected abstract ColorUIResource getDefaultExcludedColor();

    protected abstract ColorUIResource getDefaultAccentColor();

    protected abstract ColorUIResource getDefaultNotificationsColor();

    protected abstract ColorUIResource getDefaultTreeSelectionColor();

    protected abstract ColorUIResource getDefaultHighlightColor();

    protected abstract ColorUIResource getDefaultSecondBorderColor();

    protected abstract ColorUIResource getDefaultTableSelectedColor();

    protected abstract ColorUIResource getDefaultContrastColor();

    protected abstract ColorUIResource getDefaultDisabledColor();

    protected abstract ColorUIResource getDefaultSecondaryBackgroundColor();

    protected abstract ColorUIResource getDefaultButtonColor();

    protected abstract ColorUIResource getDefaultSelectionForegroundColor();

    protected abstract ColorUIResource getDefaultSelectionBackgroundColor();

    protected abstract ColorUIResource getDefaultTextColor();

    protected abstract ColorUIResource getDefaultForegroundColor();

    protected abstract ColorUIResource getDefaultBackgroundColor();

    public final ColorUIResource getExcludedColorString() {
        return this.getColor(EXCLUDED_TAG, this.getDefaultExcludedColor());
    }

    public final ColorUIResource getAccentColorString() {
        return this.getColor(ACCENT_TAG, this.getDefaultAccentColor());
    }

    public final ColorUIResource getNotificationsColorString() {
        return this.getColor(NOTIFICATIONS_TAG, this.getDefaultNotificationsColor());
    }

    public final ColorUIResource getTreeSelectionColorString() {
        return this.getColor(TREE_SELECTION_TAG, this.getDefaultTreeSelectionColor());
    }

    public final ColorUIResource getHighlightColorString() {
        return this.getColor(HIGHLIGHT_TAG, this.getDefaultHighlightColor());
    }

    public final ColorUIResource getSecondBorderColorString() {
        return this.getColor(SECOND_BORDER_TAG, this.getDefaultSecondBorderColor());
    }

    public final ColorUIResource getTableSelectedColorString() {
        return this.getColor(TABLE_SELECTED_TAG, this.getDefaultTableSelectedColor());
    }

    public final ColorUIResource getContrastColorString() {
        return this.getColor(CONTRAST_TAG, this.getDefaultContrastColor());
    }

    public final ColorUIResource getDisabledColorString() {
        return this.getColor(DISABLED_TAG, this.getDefaultDisabledColor());
    }

    public final ColorUIResource getSecondaryBackgroundColorString() {
        return this.getColor(SECONDARY_BACKGROUND_TAG, this.getDefaultSecondaryBackgroundColor());
    }

    public final ColorUIResource getButtonColorString() {
        return this.getColor(BUTTON_TAG, this.getDefaultButtonColor());
    }

    public final ColorUIResource getSelectionForegroundColorString() {
        return this.getColor(SELECTION_FOREGROUND_TAG, this.getDefaultSelectionForegroundColor());
    }

    public final ColorUIResource getSelectionBackgroundColorString() {
        return this.getColor(SELECTION_BACKGROUND_TAG, this.getDefaultSelectionBackgroundColor());
    }

    public final ColorUIResource getTextColorString() {
        return this.getColor(TEXT_TAG, this.getDefaultTextColor());
    }

    public final ColorUIResource getForegroundColorString() {
        return this.getColor(FOREGROUND_TAG, this.getDefaultForegroundColor());
    }

    public final ColorUIResource getBackgroundColorString() {
        return this.getColor(BACKGROUND_TAG, this.getDefaultBackgroundColor());
    }

    public final void setExcludedColor(ColorUIResource excludedColor) {
        this.setColor(EXCLUDED_TAG, excludedColor);
    }

    public final void setAccentColor(ColorUIResource accentColor) {
        this.setColor(ACCENT_TAG, accentColor);
    }

    public final void setNotificationsColor(ColorUIResource notificationsColor) {
        this.setColor(NOTIFICATIONS_TAG, notificationsColor);
    }

    public final void setHighlightColor(ColorUIResource highlightColor) {
        this.setColor(HIGHLIGHT_TAG, highlightColor);
    }

    public final void setTreeSelectionColor(ColorUIResource treeSelectionColor) {
        this.setColor(TREE_SELECTION_TAG, treeSelectionColor);
    }

    public final void setSecondBorderColor(ColorUIResource secondBorderColor) {
        this.setColor(SECOND_BORDER_TAG, secondBorderColor);
    }

    public final void setTableSelectedColor(ColorUIResource tableSelectedColor) {
        this.setColor(TABLE_SELECTED_TAG, tableSelectedColor);
    }

    public final void setContrastColor(ColorUIResource contrastColor) {
        this.setColor(CONTRAST_TAG, contrastColor);
    }

    public final void setDisabledColor(ColorUIResource disabledColor) {
        this.setColor(DISABLED_TAG, disabledColor);
    }

    public final void setSecondaryBackgroundColor(ColorUIResource secondaryBackgroundColor) {
        this.setColor(SECONDARY_BACKGROUND_TAG, secondaryBackgroundColor);
    }

    public final void setButtonColor(ColorUIResource buttonColor) {
        this.setColor(BUTTON_TAG, buttonColor);
    }

    public final void setSelectionForegroundColor(ColorUIResource selectionForegroundColor) {
        this.setColor(SELECTION_FOREGROUND_TAG, selectionForegroundColor);
    }

    public final void setSelectionBackgroundColor(ColorUIResource selectionBackgroundColor) {
        this.setColor(SELECTION_BACKGROUND_TAG, selectionBackgroundColor);
    }

    public final void setTextColor(ColorUIResource textColor) {
        this.setColor(TEXT_TAG, textColor);
    }

    public final void setForegroundColor(ColorUIResource foregroundColor) {
        this.setColor(FOREGROUND_TAG, foregroundColor);
    }

    public final void setBackgroundColor(ColorUIResource backgroundColor) {
        this.setColor(BACKGROUND_TAG, backgroundColor);
    }

    @NotNull
    private ColorUIResource getColor(String tag, ColorUIResource defaultColor) {
        MTThemeColor color = this.findColor(tag);
        if (color == null) {
            ColorUIResource colorUIResource = defaultColor;
            if (colorUIResource == null) {
                MTBundledThemeParser.$$$reportNull$$$0(0);
            }
            return colorUIResource;
        }
        return new ColorUIResource(MTColorUtils.parseColor(color.getValue()));
    }

    private Collection<MTThemeColor> getColors() {
        return this.mtBundledTheme.getColors();
    }

    private void setColor(String tag, ColorUIResource newColor) {
        MTThemeColor color = this.findColor(tag);
        if (color == null) {
            color = new MTThemeColor();
            color.setId(tag);
            this.getColors().add(color);
        }
        color.setValue(ColorUtil.toHex((Color)newColor, (boolean)true));
    }

    @Nullable
    private MTThemeColor findColor(@NonNls String id) {
        MTThemeColor result = null;
        for (MTThemeColor color : this.getColors()) {
            if (!color.getId().equals(id)) continue;
            result = color;
            break;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/mallowigi/idea/themes/models/parsers/MTBundledThemeParser", "getColor"));
    }
}

