/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.themes.models;

import com.mallowigi.idea.messages.ThemesBundle;
import java.awt.Color;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MTThemeable {
    @NonNls
    public String getThemeId();

    public boolean isCustom();

    public void activate();

    @NotNull
    public String getName();

    public MTThemeable setName(String var1);

    public String getEditorColorsScheme();

    public MTThemeable setEditorColorScheme(String var1);

    @NotNull
    public String getId();

    public MTThemeable setId(String var1);

    public boolean isDark();

    public MTThemeable setIsDark(boolean var1);

    public Icon getIcon();

    public MTThemeable setIcon(String var1);

    @NotNull
    public Color getBackgroundColor();

    @NotNull
    public Color getForegroundColor();

    @NotNull
    public Color getPrimaryColor();

    @NotNull
    public Color getTextColor();

    @NotNull
    public Color getSelectionBackgroundColor();

    @NotNull
    public Color getSelectionForegroundColor();

    @NotNull
    public Color getButtonColor();

    @NotNull
    public Color getSecondaryBackgroundColor();

    @NotNull
    public Color getDisabledColor();

    @NotNull
    public Color getContrastColor();

    @NotNull
    public Color getTableSelectedColor();

    @NotNull
    public Color getSecondBorderColor();

    @NotNull
    public Color getHighlightColor();

    @NotNull
    public Color getTreeSelectionColor();

    @NotNull
    public Color getNotificationsColor();

    @Nullable
    public Color getAccentColor();

    @Nullable
    public Color getExcludedColor();

    @NonNls
    default public String getThemeName() {
        return ThemesBundle.messageWithPrefix("name", this.getThemeId());
    }

    @NonNls
    default public String getThemeIcon() {
        return "/icons/actions/themes/" + ThemesBundle.messageWithPrefix("icon", this.getThemeId()) + ".svg";
    }

    @NonNls
    default public String getThemeColorScheme() {
        return ThemesBundle.messageWithPrefix("scheme", this.getThemeId());
    }

    @NonNls
    default public boolean isThemeDark() {
        return Boolean.parseBoolean(ThemesBundle.messageWithPrefix("dark", this.getThemeId()));
    }

    @NonNls
    default public int getOrder() {
        return Integer.parseInt(ThemesBundle.messageWithPrefix("order", this.getThemeId()));
    }

    public void setPristine();

    public void applyContrast(boolean var1);

    public void setThemeName(String var1);

    public boolean isNative();

    public void applyAccentMode();
}

