/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.themes;

import com.mallowigi.idea.MTLicenseChecker;
import com.mallowigi.idea.themes.MTThemeFacade;
import com.mallowigi.idea.themes.models.MTThemeable;
import com.mallowigi.idea.themes.themes.ArcDarkTheme;
import com.mallowigi.idea.themes.themes.DraculaTheme;
import com.mallowigi.idea.themes.themes.GithubDarkTheme;
import com.mallowigi.idea.themes.themes.GithubTheme;
import com.mallowigi.idea.themes.themes.LightOwlTheme;
import com.mallowigi.idea.themes.themes.MTCustomTheme;
import com.mallowigi.idea.themes.themes.MTDarkerTheme;
import com.mallowigi.idea.themes.themes.MTDeepOceanTheme;
import com.mallowigi.idea.themes.themes.MTLightCustomTheme;
import com.mallowigi.idea.themes.themes.MTLighterTheme;
import com.mallowigi.idea.themes.themes.MTNativeTheme;
import com.mallowigi.idea.themes.themes.MTOceanicTheme;
import com.mallowigi.idea.themes.themes.MTPalenightTheme;
import com.mallowigi.idea.themes.themes.MonokaiTheme;
import com.mallowigi.idea.themes.themes.MoonlightTheme;
import com.mallowigi.idea.themes.themes.NightOwlTheme;
import com.mallowigi.idea.themes.themes.OneDarkTheme;
import com.mallowigi.idea.themes.themes.OneLightTheme;
import com.mallowigi.idea.themes.themes.SolarizedDarkTheme;
import com.mallowigi.idea.themes.themes.SolarizedLightTheme;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public enum MTThemes implements MTThemeFacade
{
    OCEANIC("OCEANIC", new MTOceanicTheme(), false),
    DARKER("DARKER", new MTDarkerTheme(), false),
    LIGHTER("LIGHTER", new MTLighterTheme(), false),
    PALENIGHT("PALENIGHT", new MTPalenightTheme(), false),
    DEEPOCEAN("DEEPOCEAN", new MTDeepOceanTheme(), false),
    CUSTOM("CUSTOM", new MTCustomTheme(), true),
    LIGHT_CUSTOM("LIGHT_CUSTOM", new MTLightCustomTheme(), true),
    MONOKAI("MONOKAI", new MonokaiTheme(), false),
    ARC_DARK("ARC_DARK", new ArcDarkTheme(), false),
    ONE_DARK("ONE_DARK", new OneDarkTheme(), false),
    ONE_LIGHT("ONE_LIGHT", new OneLightTheme(), false),
    SOLARIZED_DARK("SOLARIZED_DARK", new SolarizedDarkTheme(), false),
    SOLARIZED_LIGHT("SOLARIZED_LIGHT", new SolarizedLightTheme(), false),
    DRACULA("DRACULA", new DraculaTheme(), false),
    GITHUB("GITHUB", new GithubTheme(), false),
    GITHUB_DARK("GITHUB_DARK", new GithubDarkTheme(), false),
    NIGHTOWL("NIGHT_OWL", new NightOwlTheme(), false),
    LIGHTOWL("LIGHT_OWL", new LightOwlTheme(), false),
    MOONLIGHT("MOONLIGHT", new MoonlightTheme(), false),
    NATIVE("NATIVE", new MTNativeTheme(), false);

    private static final Map<String, MTThemeFacade> THEMES_MAP;
    private final String name;
    private final transient MTThemeable mtTheme;
    private final boolean isPremium;

    private MTThemes(String name, MTThemeable mtTheme, boolean isPremium) {
        this.name = name;
        this.mtTheme = mtTheme;
        this.isPremium = isPremium;
    }

    @Override
    @NotNull
    public String getThemeColorScheme() {
        String string = this.mtTheme.getEditorColorsScheme();
        if (string == null) {
            MTThemes.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public MTThemeable getTheme() {
        MTThemeable mTThemeable = this.mtTheme;
        if (mTThemeable == null) {
            MTThemes.$$$reportNull$$$0(1);
        }
        return mTThemeable;
    }

    @Override
    public boolean isDark() {
        return this.mtTheme.isDark();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            MTThemes.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public String getThemeName() {
        return this.mtTheme.getName();
    }

    @Override
    @NotNull
    public String getThemeId() {
        String string = this.name;
        if (string == null) {
            MTThemes.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public Icon getIcon() {
        return this.mtTheme.getIcon();
    }

    @Override
    public int getOrder() {
        return this.mtTheme.getOrder();
    }

    @Override
    public boolean isPremium() {
        return this.isPremium;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean isCustom() {
        return this.mtTheme.isCustom();
    }

    @Override
    public void setThemeName(String name) {
        this.mtTheme.setThemeName(name);
    }

    @Override
    public void setIsDark(boolean isDark) {
        this.mtTheme.setIsDark(isDark);
    }

    @Override
    public boolean isNative() {
        return this.mtTheme.isNative();
    }

    @Override
    public void applyAccentMode() {
        this.mtTheme.applyAccentMode();
    }

    public static MTThemeFacade getThemeFor(String themeID) {
        return THEMES_MAP.get(themeID);
    }

    public static MTThemeFacade installTheme(MTThemeable theme) {
        if (MTThemes.getThemeFor(theme.getId()) == null) {
            MTThemes.addTheme(MTThemes.fromTheme(theme));
        }
        return MTThemes.getThemeFor(theme.getThemeId());
    }

    private static void addTheme(MTThemeFacade themesInterface) {
        if (!THEMES_MAP.containsKey(themesInterface.getThemeId())) {
            THEMES_MAP.put(themesInterface.getThemeId(), themesInterface);
        }
    }

    public static Vector<MTThemeFacade> getAllThemes() {
        boolean isPremium = MTLicenseChecker.isLicensed();
        return THEMES_MAP.values().stream().filter(mtThemeFacade -> isPremium || !mtThemeFacade.isPremium()).sorted(Comparator.comparingInt(MTThemeFacade::getOrder)).collect(Collectors.toCollection(Vector::new));
    }

    private static MTThemeFacade fromTheme(final MTThemeable theme) {
        return new MTThemeFacade(){

            @Override
            @NotNull
            public String getThemeColorScheme() {
                String string = theme.getEditorColorsScheme();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public MTThemeable getTheme() {
                MTThemeable mTThemeable = theme;
                if (mTThemeable == null) {
                    1.$$$reportNull$$$0(1);
                }
                return mTThemeable;
            }

            @Override
            public boolean isDark() {
                return theme.isDark();
            }

            @Override
            @NotNull
            public String getName() {
                String string = theme.getId();
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            @Override
            public String getThemeName() {
                return theme.getName();
            }

            @Override
            @NotNull
            public String getThemeId() {
                String string = theme.getThemeId();
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            @Override
            public Icon getIcon() {
                return theme.getIcon();
            }

            @Override
            public int getOrder() {
                return 100;
            }

            @Override
            public boolean isPremium() {
                return false;
            }

            @Override
            public boolean isCustom() {
                return false;
            }

            @Override
            public void setThemeName(String name) {
                theme.setName(name);
            }

            @Override
            public void setIsDark(boolean isDark) {
                theme.setIsDark(isDark);
            }

            @Override
            public void applyAccentMode() {
                theme.applyAccentMode();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/mallowigi/idea/themes/MTThemes$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getThemeColorScheme";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTheme";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getThemeId";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    static {
        THEMES_MAP = new TreeMap<String, MTThemeFacade>();
        for (MTThemes theme : MTThemes.values()) {
            THEMES_MAP.put(theme.getName(), theme);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/mallowigi/idea/themes/MTThemes";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getThemeColorScheme";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTheme";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getThemeId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

