/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.tabs.highlightTabPainters;

import com.intellij.ide.ui.UISettings;
import com.mallowigi.idea.config.enums.TabHighlightPositions;
import com.mallowigi.idea.tabs.highlightTabPainters.BottomHighlightTabPainter;
import com.mallowigi.idea.tabs.highlightTabPainters.BottomlessHighlightTabPainter;
import com.mallowigi.idea.tabs.highlightTabPainters.DefaultHighlightTabPainter;
import com.mallowigi.idea.tabs.highlightTabPainters.FullHighlightTabPainter;
import com.mallowigi.idea.tabs.highlightTabPainters.LeftHighlightTabPainter;
import com.mallowigi.idea.tabs.highlightTabPainters.LeftRightHighlightTabPainter;
import com.mallowigi.idea.tabs.highlightTabPainters.NoneHighlightTabPainter;
import com.mallowigi.idea.tabs.highlightTabPainters.RightHighlightTabPainter;
import com.mallowigi.idea.tabs.highlightTabPainters.TopBottomHighlightTabPainter;
import com.mallowigi.idea.tabs.highlightTabPainters.TopHighlightTabPainter;
import com.mallowigi.idea.tabs.highlightTabPainters.ToplessHighlightTabPainter;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public abstract class HighlightTabPainter {
    public static HighlightTabPainter getHighlightTabPainter(TabHighlightPositions tabHighlightPosition) {
        switch (tabHighlightPosition) {
            case TOP: {
                return new TopHighlightTabPainter();
            }
            case FULL: {
                return new FullHighlightTabPainter();
            }
            case LEFT: {
                return new LeftHighlightTabPainter();
            }
            case NONE: {
                return new NoneHighlightTabPainter();
            }
            case RIGHT: {
                return new RightHighlightTabPainter();
            }
            case BOTTOM: {
                return new BottomHighlightTabPainter();
            }
            case TOPLESS: {
                return new ToplessHighlightTabPainter();
            }
            case BOTTOMLESS: {
                return new BottomlessHighlightTabPainter();
            }
            case LEFT_RIGHT: {
                return new LeftRightHighlightTabPainter();
            }
            case TOP_BOTTOM: {
                return new TopBottomHighlightTabPainter();
            }
        }
        return new DefaultHighlightTabPainter();
    }

    static int getEditorTabPlacement() {
        return UISettings.getInstance().getEditorTabPlacement();
    }

    public abstract void paintBottom(int var1, Graphics2D var2, Rectangle var3, int var4);

    public abstract void paintTop(int var1, Graphics2D var2, Rectangle var3, int var4);

    public abstract void paintLeft(int var1, Graphics2D var2, Rectangle var3, int var4);

    public abstract void paintRight(int var1, Graphics2D var2, Rectangle var3, int var4);

    static void paintOnRight(int borderThickness, Graphics2D g2d, Rectangle rect) {
        g2d.fillRect(rect.x + rect.width - borderThickness + 1, rect.y, borderThickness, rect.height);
    }

    static void paintOnLeft(int borderThickness, Graphics2D g2d, Rectangle rect) {
        g2d.fillRect(rect.x, rect.y, borderThickness, rect.height);
    }

    static void paintOnBottom(int borderThickness, Graphics2D g2d, Rectangle rect, int w) {
        g2d.fillRect(rect.x, rect.y + rect.height - borderThickness + 1, w, borderThickness);
    }

    static void paintOnTop(int borderThickness, Graphics2D g2d, Rectangle rect) {
        g2d.fillRect(rect.x, rect.y - 1, rect.width, borderThickness);
    }
}

