/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.tabs;

import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.tabs.MTTabsPainter;
import java.awt.Container;
import java.awt.Font;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.jetbrains.annotations.NotNull;

public final class MTTabsPainterPatcherComponent
implements StartupActivity {
    private MTConfig config = null;

    public void initComponent(JBEditorTabs editorTabs) {
        this.config = MTConfig.getInstance();
        if (editorTabs != null) {
            this.patchPainter(editorTabs);
        }
        MessageBus bus = ApplicationManagerEx.getApplicationEx().getMessageBus();
        MessageBusConnection connect = bus.connect();
        connect.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                FileEditor editor;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((editor = event.getNewEditor()) != null) {
                    for (Container component = editor.getComponent(); component != null; component = component.getParent()) {
                        if (!(component instanceof JBEditorTabs)) continue;
                        MTTabsPainterPatcherComponent.this.patchPainter((JBEditorTabs)component);
                        return;
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/mallowigi/idea/tabs/MTTabsPainterPatcherComponent$1", "selectionChanged"));
            }
        });
    }

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            MTTabsPainterPatcherComponent.$$$reportNull$$$0(0);
        }
        JBEditorTabs editorTabs = (JBEditorTabs)UIUtil.findComponentOfType((JComponent)Objects.requireNonNull(WindowManager.getInstance().getIdeFrame(project)).getComponent(), JBEditorTabs.class);
        this.initComponent(editorTabs);
    }

    void patchPainter(JBEditorTabs component) {
        MTTabsPainter tabsPainter = new MTTabsPainter(component);
        JBTabPainter proxy = (JBTabPainter)Enhancer.create(MTTabsPainter.class, (Callback)new TabPainterInterceptor(tabsPainter));
        this.applyCustomFontSize(component);
        ReflectionUtil.setField(JBEditorTabs.class, (Object)component, JBTabPainter.class, (String)"myTabPainter", (Object)proxy);
    }

    private void applyCustomFontSize(JBEditorTabs component) {
        if (this.config.isTabFontSizeEnabled()) {
            float tabFontSize = this.config.getTabFontSize();
            Map myInfo2Label = component.myInfo2Label;
            for (TabLabel value : myInfo2Label.values()) {
                Font font = value.getLabelComponent().getFont().deriveFont(tabFontSize);
                value.getLabelComponent().setFont(font);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/mallowigi/idea/tabs/MTTabsPainterPatcherComponent", "runActivity"));
    }

    private static class TabPainterInterceptor
    implements MethodInterceptor {
        private final MTTabsPainter tabsPainter;

        TabPainterInterceptor(MTTabsPainter tabsPainter) {
            this.tabsPainter = tabsPainter;
        }

        public final Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws IllegalAccessException, InvocationTargetException {
            return method.invoke((Object)this.tabsPainter, objects);
        }
    }
}

