/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.tabs;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.impl.JBDefaultTabPainter;
import com.intellij.ui.tabs.impl.JBEditorTabs;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.tabs.MTTabsHighlightPainter;
import com.mallowigi.idea.tabs.shadowPainters.BottomShadowPainter;
import com.mallowigi.idea.tabs.shadowPainters.LeftShadowPainter;
import com.mallowigi.idea.tabs.shadowPainters.NoneShadowPainter;
import com.mallowigi.idea.tabs.shadowPainters.RightShadowPainter;
import com.mallowigi.idea.tabs.shadowPainters.ShadowPainter;
import com.mallowigi.idea.tabs.shadowPainters.TopShadowPainter;
import com.mallowigi.idea.utils.MTUI;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MTTabsPainter
extends JBDefaultTabPainter {
    private final MTConfig mtConfig = MTConfig.getInstance();
    private JBEditorTabs tabs = null;

    public MTTabsPainter() {
    }

    public MTTabsPainter(JBEditorTabs component) {
        this.tabs = component;
    }

    private Color getBorderColor() {
        return ColorUtil.withAlpha((Color)Color.BLACK, (double)0.0);
    }

    public void paintSelectedTab(@NotNull JBTabsPosition position, @NotNull Graphics2D g, @NotNull Rectangle rect, int borderThickness, @Nullable Color tabColor, boolean active, boolean hovered) {
        if (position == null) {
            MTTabsPainter.$$$reportNull$$$0(0);
        }
        if (g == null) {
            MTTabsPainter.$$$reportNull$$$0(1);
        }
        if (rect == null) {
            MTTabsPainter.$$$reportNull$$$0(2);
        }
        g.setColor(hovered ? MTUI.TabbedPane.getHoveredBackground() : MTUI.TabbedPane.getBackground());
        if (tabColor != null) {
            g.setColor(tabColor);
        }
        RectanglePainter2D.FILL.paint(g, (double)rect.x, (double)rect.y, (double)rect.width, (double)rect.height);
        int configThickness = this.mtConfig.getHighlightThickness() + 1;
        Color underlineColor = this.getIndicatorColor(active);
        g.setColor(underlineColor);
        MTTabsHighlightPainter.paintHighlight(configThickness, g, rect);
    }

    @NotNull
    private Color getIndicatorColor(boolean active) {
        Color color = this.getTabUnderlineColor(active);
        if (color == null) {
            MTTabsPainter.$$$reportNull$$$0(3);
        }
        return color;
    }

    public void paintUnderline(@NotNull JBTabsPosition position, @NotNull Rectangle rect, int borderThickness, @NotNull Graphics2D g, boolean active) {
        if (position == null) {
            MTTabsPainter.$$$reportNull$$$0(4);
        }
        if (rect == null) {
            MTTabsPainter.$$$reportNull$$$0(5);
        }
        if (g == null) {
            MTTabsPainter.$$$reportNull$$$0(6);
        }
        int thickness = this.mtConfig.getHighlightThickness();
        Color underlineColor = this.getIndicatorColor(active);
        g.setColor(underlineColor);
        MTTabsHighlightPainter.paintHighlight(thickness, g, rect);
    }

    public static ShadowPainter getShadowPainter(JBTabsPosition position) {
        switch (position) {
            case top: {
                return new BottomShadowPainter();
            }
            case bottom: {
                return new TopShadowPainter();
            }
            case left: {
                return new RightShadowPainter();
            }
            case right: {
                return new LeftShadowPainter();
            }
        }
        return new NoneShadowPainter();
    }

    public void paintBorderLine(@NotNull Graphics2D g, int thickness, @NotNull Point from, @NotNull Point to) {
        if (g == null) {
            MTTabsPainter.$$$reportNull$$$0(7);
        }
        if (from == null) {
            MTTabsPainter.$$$reportNull$$$0(8);
        }
        if (to == null) {
            MTTabsPainter.$$$reportNull$$$0(9);
        }
        if (MTConfig.getInstance().isTabsShadow()) {
            ShadowPainter shadowPainter = MTTabsPainter.getShadowPainter(this.tabs != null ? this.tabs.getTabsPosition() : JBTabsPosition.bottom);
            shadowPainter.drawShadow(g, from, to);
        }
        g.setColor(this.getBorderColor());
        LinePainter2D.paint((Graphics2D)g, (double)from.getX(), (double)from.getY(), (double)to.getX(), (double)to.getY(), (LinePainter2D.StrokeType)LinePainter2D.StrokeType.INSIDE, (double)thickness);
    }

    public Color getTabUnderlineColor(boolean active) {
        Color accentColor = MTUI.Panel.getLinkForeground();
        Color highlightColor = this.mtConfig.getHighlightColor();
        if (this.mtConfig.isHighlightColorEnabled()) {
            return highlightColor;
        }
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        EditorColorsScheme currentScheme = editorColorsManager.getGlobalScheme();
        Color tabUnderline = currentScheme.getColor(ColorKey.find((String)"TAB_UNDERLINE"));
        Color tabUnderlineInactive = currentScheme.getColor(ColorKey.find((String)"TAB_UNDERLINE_INACTIVE"));
        if (active && tabUnderline != null) {
            return tabUnderline;
        }
        if (!active && tabUnderlineInactive != null) {
            return tabUnderlineInactive;
        }
        return accentColor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/mallowigi/idea/tabs/MTTabsPainter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/mallowigi/idea/tabs/MTTabsPainter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndicatorColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "paintSelectedTab";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "paintUnderline";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "paintBorderLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

