/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.tabs;

import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.mallowigi.idea.MTConfig;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MTEditorUpperTabs
implements EditorTabTitleProvider {
    private static final char SPACE = ' ';

    @NotNull
    private static String[] nameToWords(@NotNull String name) {
        if (name == null) {
            MTEditorUpperTabs.$$$reportNull$$$0(0);
        }
        boolean index = false;
        int length = name.length();
        Collection<String> array = MTEditorUpperTabs.extractedMethod(0, length, name);
        String[] stringArray = ArrayUtil.toStringArray(array);
        if (stringArray == null) {
            MTEditorUpperTabs.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    private static Collection<String> extractedMethod(int index, int length, String name) {
        ArrayList<String> array = new ArrayList<String>(10);
        while (index < length) {
            String word;
            int wordStart = index;
            int upperCaseCount = 0;
            int lowerCaseCount = 0;
            int digitCount = 0;
            int specialCount = 0;
            while (index < length) {
                char c = name.charAt(index);
                if (Character.isDigit(c)) {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || specialCount > 0) break;
                    ++digitCount;
                } else if (Character.isUpperCase(c)) {
                    if (lowerCaseCount > 0 || digitCount > 0 || specialCount > 0) break;
                    ++upperCaseCount;
                } else if (Character.isLowerCase(c)) {
                    if (digitCount > 0 || specialCount > 0) break;
                    if (upperCaseCount > 1) {
                        --index;
                        break;
                    }
                    ++lowerCaseCount;
                } else {
                    if (upperCaseCount > 0 || lowerCaseCount > 0 || digitCount > 0) break;
                    ++specialCount;
                }
                ++index;
            }
            if (StringUtil.isEmptyOrSpaces((String)(word = name.substring(wordStart, index)))) continue;
            array.add(word);
        }
        return array;
    }

    @NotNull
    private static String splitWords(@NotNull String text, @NotNull Function<? super String, String> transformWord) {
        if (text == null) {
            MTEditorUpperTabs.$$$reportNull$$$0(2);
        }
        if (transformWord == null) {
            MTEditorUpperTabs.$$$reportNull$$$0(3);
        }
        String[] words = MTEditorUpperTabs.nameToWords(text);
        boolean insertSeparator = false;
        StringBuilder buf = new StringBuilder(10);
        for (String word : words) {
            boolean isSpecialChar = "[(.)/]".contains(word.substring(0, 1));
            if (!Character.isLetterOrDigit(word.charAt(0)) && !isSpecialChar) {
                buf.append(' ');
                insertSeparator = false;
                continue;
            }
            if (insertSeparator && word.length() > 1) {
                buf.append(' ');
            } else {
                insertSeparator = !isSpecialChar && word.length() > 1;
            }
            buf.append((String)transformWord.fun((Object)word.replace("_", "")));
        }
        String string = buf.toString();
        if (string == null) {
            MTEditorUpperTabs.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public String getEditorTabTitle(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            MTEditorUpperTabs.$$$reportNull$$$0(5);
        }
        if (file == null) {
            MTEditorUpperTabs.$$$reportNull$$$0(6);
        }
        String uniqueVirtualFilePath = UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file);
        if (MTConfig.getInstance().isUpperCaseTabs()) {
            return MTEditorUpperTabs.splitWords(uniqueVirtualFilePath, (Function<? super String, String>)((Function)String::toUpperCase));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/mallowigi/idea/tabs/MTEditorUpperTabs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformWord";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/mallowigi/idea/tabs/MTEditorUpperTabs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "nameToWords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "splitWords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nameToWords";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "splitWords";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTabTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

