/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.status;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.ui.ColorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.listeners.AccentsListener;
import com.mallowigi.idea.listeners.ConfigNotifier;
import com.mallowigi.idea.listeners.MTTopics;
import com.mallowigi.idea.listeners.ThemeListener;
import com.mallowigi.idea.messages.MaterialThemeBundle;
import com.mallowigi.idea.themes.MTThemeFacade;
import com.mallowigi.idea.utils.MTUiUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Objects;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class MTStatusWidget
implements CustomStatusBarWidget {
    private static final String MT_SETTINGS_PAGE = MaterialThemeBundle.message("mt.settings.titles.mtHome", new Object[0]);
    private final MTWidget mtWidget;
    @Nullable
    private static Image myBufferedImage = null;
    private final MessageBusConnection connect = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);

    MTStatusWidget() {
        this.mtWidget = new MTWidget();
    }

    @NonNls
    @NotNull
    public String ID() {
        return "MTStatusBarWidget";
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            MTStatusWidget.$$$reportNull$$$0(0);
        }
        this.connect.subscribe(MTTopics.THEMES, (Object)new ThemeListener(){

            @Override
            public void themeChanged(@NotNull MTThemeFacade theme) {
                if (theme == null) {
                    1.$$$reportNull$$$0(0);
                }
                MTStatusWidget.this.refresh();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "theme", "com/mallowigi/idea/status/MTStatusWidget$1", "themeChanged"));
            }
        });
        this.connect.subscribe(MTTopics.ACCENTS, (Object)new AccentsListener(){

            @Override
            public void accentChanged(@NotNull Color accentColor) {
                if (accentColor == null) {
                    2.$$$reportNull$$$0(0);
                }
                MTStatusWidget.this.refresh();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accentColor", "com/mallowigi/idea/status/MTStatusWidget$2", "accentChanged"));
            }
        });
        this.connect.subscribe(ConfigNotifier.CONFIG_TOPIC, (Object)new ConfigNotifier(){

            @Override
            public void configChanged(MTConfig mtConfig) {
                MTStatusWidget.this.refresh();
            }
        });
    }

    public void dispose() {
        Disposer.dispose((Disposable)this);
        myBufferedImage = null;
        this.connect.disconnect();
    }

    private void refresh() {
        myBufferedImage = null;
        this.mtWidget.setVisible(true);
        this.mtWidget.repaint();
        this.mtWidget.updateUI();
        this.mtWidget.setToolTipText(MTConfig.getInstance().getTooltip());
    }

    public JComponent getComponent() {
        return this.mtWidget;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statusBar", "com/mallowigi/idea/status/MTStatusWidget", "install"));
    }

    static final class MTWidget
    extends JButton {
        private static final int DEFAULT_FONT_SIZE = JBUI.scale((int)11);
        private static final int STATUS_PADDING = 4;
        private static final int STATUS_HEIGHT = 16;
        private final MTConfig mtConfig;
        private final Font widgetFont = MTWidget.getWidgetFont();

        MTWidget() {
            this.mtConfig = MTConfig.getInstance();
            new BaseButtonBehavior(this, TimedDeadzone.NULL){

                protected void execute(MouseEvent e) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(null, MT_SETTINGS_PAGE);
                }
            }.setActionTrigger(501);
            this.setFont(this.widgetFont);
            this.putClientProperty("MTButton.noBorder", Boolean.TRUE);
        }

        private static Font getWidgetFont() {
            Font[] fonts;
            GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (Font font : fonts = e.getAllFonts()) {
                if (!Objects.equals(font.getFontName(), "Roboto")) continue;
                HashMap<TextAttribute, Number> attributes = new HashMap<TextAttribute, Number>(10);
                attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                attributes.put(TextAttribute.SIZE, JBUI.scale((int)DEFAULT_FONT_SIZE));
                return font.deriveFont(attributes);
            }
            return JBUI.Fonts.create((String)"Dialog", (int)12);
        }

        @Override
        public void paintComponent(Graphics g) {
            String themeName = this.mtConfig.getSelectedTheme().getTheme().getName();
            if (themeName.isEmpty()) {
                return;
            }
            Color accentColor = ColorUtil.fromHex((String)this.mtConfig.getAccentColor());
            int accentDiameter = JBUI.scale((int)14);
            if (myBufferedImage == null) {
                Dimension size = this.getSize();
                Dimension arcs = new Dimension(8, 8);
                myBufferedImage = ImageUtil.createImage((int)size.width, (int)size.height, (int)2);
                Graphics2D g2 = (Graphics2D)myBufferedImage.getGraphics().create();
                FontMetrics fontMetrics = g.getFontMetrics();
                g2.setRenderingHints(MTUiUtils.getHints());
                int nameWidth = fontMetrics.charsWidth(themeName.toCharArray(), 0, themeName.length());
                int nameHeight = fontMetrics.getAscent();
                AttributedString as = new AttributedString(themeName);
                as.addAttribute(TextAttribute.FAMILY, this.getFont().getFamily());
                as.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                as.addAttribute(TextAttribute.SIZE, DEFAULT_FONT_SIZE);
                g2.setColor(this.mtConfig.getSelectedTheme().getTheme().getContrastColor());
                g2.fillRoundRect(0, 0, size.width + accentDiameter - JBUI.scale((int)arcs.width), JBUI.scale((int)16), arcs.width, arcs.height);
                g2.setColor(UIUtil.getLabelForeground());
                g2.setFont(this.getFont());
                g2.drawString(as.getIterator(), (size.width - accentDiameter - nameWidth) / 2, nameHeight + (size.height - nameHeight) / 2 - JBUI.scale((int)1));
                g2.setColor(accentColor);
                g2.fillOval(size.width - JBUI.scale((int)16), JBUI.scale((int)1), accentDiameter, accentDiameter);
                g2.dispose();
            }
            StartupUiUtil.drawImage((Graphics)g, (Image)myBufferedImage, (int)0, (int)0, null);
        }

        @Override
        public Dimension getPreferredSize() {
            String themeName = this.mtConfig.getSelectedTheme().getThemeName();
            assert (themeName != null);
            int width = this.getFontMetrics(this.widgetFont).charsWidth(themeName.toCharArray(), 0, themeName.length()) + 8;
            int accentDiameter = JBUI.scale((int)16);
            return new Dimension(width + accentDiameter, accentDiameter);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }
    }
}

