/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.schemes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusFactory;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.ui.ColorUtil;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.config.MTFileColorsPage;
import com.mallowigi.idea.messages.MaterialThemeBundle;
import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public enum MTFileColors {
    DEFAULT;

    @NonNls
    private static final String MT_PREFIX = "FILESTATUS_";
    private static final HashMap<FileStatus, ColorKey> COLOR_KEYS;

    private static void apply() {
        MTFileColors.applyStyleDirectories();
    }

    @NotNull
    private static EditorColorsScheme getCurrentSchemeForCurrentUITheme() {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
        if (editorColorsScheme == null) {
            MTFileColors.$$$reportNull$$$0(0);
        }
        return editorColorsScheme;
    }

    private static void applyFileStatuses() {
        FileStatus[] allFileStatuses;
        if (!MTConfig.getInstance().isFileStatusColorsEnabled()) {
            return;
        }
        EditorColorsScheme defaultScheme = MTFileColors.getCurrentSchemeForCurrentUITheme();
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        for (FileStatus fileStatus : allFileStatuses = FileStatusFactory.getInstance().getAllFileStatuses()) {
            defaultScheme.setColor(fileStatus.getColorKey(), globalScheme.getColor(fileStatus.getColorKey()));
        }
        ((AbstractColorsScheme)defaultScheme).setSaveNeeded(true);
        for (FileStatus fileStatus : ProjectManager.getInstance().getOpenProjects()) {
            FileStatusManager.getInstance((Project)fileStatus).fileStatusesChanged();
        }
    }

    private static void applyStyleDirectories() {
        if (!MTConfig.getInstance().isStyledDirectories()) {
            return;
        }
        EditorColorsScheme defaultScheme = MTFileColors.getCurrentSchemeForCurrentUITheme();
        EditorColorsScheme globalScheme = EditorColorsManager.getInstance().getGlobalScheme();
        defaultScheme.setAttributes(MTFileColorsPage.DIRECTORIES, globalScheme.getAttributes(MTFileColorsPage.DIRECTORIES));
        ((AbstractColorsScheme)defaultScheme).setSaveNeeded(true);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            FileStatusManager.getInstance((Project)project).fileStatusesChanged();
        }
    }

    public static void initFileColors() {
        FileStatus[] allFileStatuses;
        for (FileStatus allFileStatus : allFileStatuses = FileStatusFactory.getInstance().getAllFileStatuses()) {
            Color originalColor = allFileStatus.getColor();
            if (originalColor != null) {
                String originalColorString = ColorUtil.toHex((Color)originalColor);
                String property = MaterialThemeBundle.INSTANCE.messageOrDefault("material.file." + allFileStatus.getId().toLowerCase(Locale.ENGLISH), originalColorString, new Object[0]);
                Color color = ColorUtil.fromHex((String)(property == null ? originalColorString : property));
                COLOR_KEYS.put(allFileStatus, ColorKey.createColorKey((String)(MT_PREFIX + allFileStatus.getId()), (Color)color));
                continue;
            }
            String property = MaterialThemeBundle.INSTANCE.messageOrDefault("material.file." + allFileStatus.getId().toLowerCase(Locale.ENGLISH), "-1", new Object[0]);
            if (Objects.equals(property, "-1")) {
                COLOR_KEYS.put(allFileStatus, ColorKey.createColorKey((String)(MT_PREFIX + allFileStatus.getId())));
                continue;
            }
            Color color = ColorUtil.fromHex((String)property);
            COLOR_KEYS.put(allFileStatus, ColorKey.createColorKey((String)(MT_PREFIX + allFileStatus.getId()), (Color)color));
        }
    }

    public static ColorKey getColorKey(FileStatus status) {
        return COLOR_KEYS.get(status);
    }

    static {
        COLOR_KEYS = new HashMap(18);
        MTFileColors.initFileColors();
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(EditorColorsManager.TOPIC, scheme -> MTFileColors.apply());
        MTFileColors.apply();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/mallowigi/idea/schemes/MTFileColors", "getCurrentSchemeForCurrentUITheme"));
    }
}

