/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.notifications;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.awt.RelativePoint;
import com.mallowigi.idea.MTThemeManager;
import com.mallowigi.idea.messages.MaterialThemeBundle;
import com.mallowigi.idea.utils.MTUiUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Notify {
    DEFAULT;

    @NonNls
    public static final String CHANNEL = "Material Theme Notifications";

    public static void showUpdate(@NotNull Project project, NotificationListener listener) {
        if (project == null) {
            Notify.$$$reportNull$$$0(0);
        }
        Notification notification = Notify.createNotification(MaterialThemeBundle.message("notification.update.title", MTUiUtils.getVersion()), MaterialThemeBundle.message("notification.update.content", new Object[0]), "Material Theme Notifications_UPDATE", NotificationType.INFORMATION, listener);
        Notify.showFullNotification(project, notification);
    }

    public static void show(@NotNull Project project, @NotNull String title, @NotNull String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        if (project == null) {
            Notify.$$$reportNull$$$0(1);
        }
        if (title == null) {
            Notify.$$$reportNull$$$0(2);
        }
        if (content == null) {
            Notify.$$$reportNull$$$0(3);
        }
        if (type == null) {
            Notify.$$$reportNull$$$0(4);
        }
        Notify.show(project, title, content, CHANNEL, type, listener);
    }

    private static void show(@NotNull Project project, @NotNull String title, @NotNull String content, @NotNull String displayId, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        if (project == null) {
            Notify.$$$reportNull$$$0(5);
        }
        if (title == null) {
            Notify.$$$reportNull$$$0(6);
        }
        if (content == null) {
            Notify.$$$reportNull$$$0(7);
        }
        if (displayId == null) {
            Notify.$$$reportNull$$$0(8);
        }
        if (type == null) {
            Notify.$$$reportNull$$$0(9);
        }
        Notification notification = Notify.createNotification(title, content, displayId, type, listener);
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    @NotNull
    private static Notification createNotification(@NotNull String title, @NotNull String content, @NonNls @NotNull String displayId, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        if (title == null) {
            Notify.$$$reportNull$$$0(10);
        }
        if (content == null) {
            Notify.$$$reportNull$$$0(11);
        }
        if (displayId == null) {
            Notify.$$$reportNull$$$0(12);
        }
        if (type == null) {
            Notify.$$$reportNull$$$0(13);
        }
        NotificationGroup group = new NotificationGroup(displayId, NotificationDisplayType.STICKY_BALLOON, true);
        Notification notification = group.createNotification(title, content, type, listener);
        if (notification == null) {
            Notify.$$$reportNull$$$0(14);
        }
        return notification;
    }

    private static void showFullNotification(Project project, Notification notification) {
        IdeFrame frame = WindowManager.getInstance().getIdeFrame(project);
        Rectangle bounds = Objects.requireNonNull(frame).getComponent().getBounds();
        RelativePoint target = new RelativePoint((Component)frame.getComponent(), new Point(bounds.x + bounds.width, 20));
        try {
            Balloon balloon = NotificationsManagerImpl.createBalloon((IdeFrame)frame, (Notification)notification, (boolean)true, (boolean)true, (Ref)BalloonLayoutData.fullContent(), (Disposable)MTThemeManager.getInstance());
            balloon.show(target, Balloon.Position.atLeft);
        }
        catch (NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError e) {
            notification.notify(project);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayId";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/mallowigi/idea/notifications/Notify";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/mallowigi/idea/notifications/Notify";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showUpdate";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

