/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.lafs;

import com.intellij.ide.ui.laf.darcula.ui.DarculaMenuBarBorder;
import com.intellij.ide.ui.laf.darcula.ui.DarculaMenuItemBorder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.tree.ui.Control;
import com.intellij.util.ui.JBUI;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.themes.models.MTThemeable;
import com.mallowigi.idea.ui.MTButtonPainter;
import com.mallowigi.idea.ui.MTButtonUI;
import com.mallowigi.idea.ui.MTCheckBoxBorder;
import com.mallowigi.idea.ui.MTCheckBoxMenuItemUI;
import com.mallowigi.idea.ui.MTCheckBoxUI;
import com.mallowigi.idea.ui.MTComboBoxUI;
import com.mallowigi.idea.ui.MTDarculaButtonUI;
import com.mallowigi.idea.ui.MTEditorTextFieldBorder;
import com.mallowigi.idea.ui.MTLabelUI;
import com.mallowigi.idea.ui.MTMenuItemBorder;
import com.mallowigi.idea.ui.MTOnOffButtonUI;
import com.mallowigi.idea.ui.MTOptionButtonUI;
import com.mallowigi.idea.ui.MTPasswordFieldUI;
import com.mallowigi.idea.ui.MTPopupMenuBorder;
import com.mallowigi.idea.ui.MTPopupMenuUI;
import com.mallowigi.idea.ui.MTProgressBarBorder;
import com.mallowigi.idea.ui.MTProgressBarUI;
import com.mallowigi.idea.ui.MTRadioButtonMenuItemUI;
import com.mallowigi.idea.ui.MTRadioButtonUI;
import com.mallowigi.idea.ui.MTRootPaneUI;
import com.mallowigi.idea.ui.MTRowPainter;
import com.mallowigi.idea.ui.MTSeparatorUI;
import com.mallowigi.idea.ui.MTSliderUI;
import com.mallowigi.idea.ui.MTSpinnerBorder;
import com.mallowigi.idea.ui.MTSpinnerUI;
import com.mallowigi.idea.ui.MTStatusBarBorder;
import com.mallowigi.idea.ui.MTStatusBarUI;
import com.mallowigi.idea.ui.MTTabbedPaneUI;
import com.mallowigi.idea.ui.MTTableCellNoFocusBorder;
import com.mallowigi.idea.ui.MTTableHeaderBorder;
import com.mallowigi.idea.ui.MTTableHeaderUI;
import com.mallowigi.idea.ui.MTTableSelectedCellHighlightBorder;
import com.mallowigi.idea.ui.MTTextAreaUI;
import com.mallowigi.idea.ui.MTTextBorder;
import com.mallowigi.idea.ui.MTTextFieldUI;
import com.mallowigi.idea.ui.indicators.MTSelectedTreePainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class MTLafInstaller {
    @Nullable
    private final MTThemeable theme;

    MTLafInstaller(@Nullable MTThemeable theme) {
        this.theme = theme;
    }

    static void installMTDefaults(UIDefaults defaults) {
        MTLafInstaller.replaceStatusBar(defaults);
        MTLafInstaller.replaceTree(defaults);
        MTLafInstaller.replaceSelectedIndicator(defaults);
        MTLafInstaller.replaceDropdowns(defaults);
        MTLafInstaller.replaceTableHeaders(defaults);
        MTLafInstaller.replaceRootPane(defaults);
        MTLafInstaller.replaceMenus(defaults);
        MTLafInstaller.replaceTabbedPanes(defaults);
        MTLafInstaller.replaceLabels(defaults);
        MTLafInstaller.replaceDefaultButtons(defaults);
        MTLafInstaller.replaceButtons(defaults);
        MTLafInstaller.replaceTextFields(defaults);
        MTLafInstaller.replaceProgressBar(defaults);
        MTLafInstaller.replaceTables(defaults);
        MTLafInstaller.replaceSpinners(defaults);
        MTLafInstaller.replaceCheckboxes(defaults);
        MTLafInstaller.replaceRadioButtons(defaults);
        MTLafInstaller.replaceSliders(defaults);
        MTLafInstaller.replaceTextAreas(defaults);
        MTLafInstaller.modifyRegistry();
    }

    public static void installDefaults(@NonNls UIDefaults defaults) {
        defaults.put("Caret.width", (Object)2);
        defaults.put("Border.width", (Object)2);
        defaults.put("Component.focusWidth", (Object)2);
        defaults.put("CompletionPopup.nonFocusedState", (Object)false);
        defaults.put("CellEditor.border.width", (Object)2);
        defaults.put("Window.border", "1,1,1,1,000000");
        defaults.put("Tree.border", "1,1,1,1");
        defaults.put("ListUI", "com.intellij.ui.components.WideSelectionListUI");
        defaults.put("Button.arc", (Object)6);
        defaults.put("Component.arc", (Object)0);
        defaults.put("Menu.maxGutterIconWidth", (Object)18);
        defaults.put("MenuItem.maxGutterIconWidth", (Object)18);
        defaults.put("MenuItem.acceleratorDelimiter", "-");
        defaults.put("MenuItem.border", new DarculaMenuItemBorder());
        defaults.put("Menu.border", new DarculaMenuItemBorder());
        defaults.put("MenuBar.border", new DarculaMenuBarBorder());
        defaults.put("TextArea.caretBlinkRate", (Object)500);
        defaults.put("Tree.paintLines", (Object)false);
        defaults.put("Table.cellNoFocusBorder", JBUI.insets((int)4, (int)4, (int)4, (int)4));
        defaults.put("CheckBoxMenuItem.borderPainted", (Object)false);
        defaults.put("RadioButtonMenuItem.borderPainted", (Object)false);
        defaults.put("ComboBox.squareButton", (Object)true);
        defaults.put("ComboBox.padding", JBUI.insets((int)1, (int)5, (int)1, (int)5));
        defaults.put("CheckBox.border.width", (Object)3);
        defaults.put("RadioButton.border.width", (Object)3);
        defaults.put("List.rowHeight", (Object)20);
        defaults.put("Table.rowHeight", (Object)20);
        defaults.put("HelpTooltip.verticalGap", (Object)4);
        defaults.put("HelpTooltip.horizontalGap", (Object)10);
        defaults.put("HelpTooltip.maxWidth", (Object)250);
        defaults.put("HelpTooltip.xOffset", (Object)1);
        defaults.put("HelpTooltip.yOffset", (Object)1);
        defaults.put("HelpTooltip.defaultTextBorderInsets", JBUI.insets((int)10, (int)10, (int)10, (int)16));
        defaults.put("HelpTooltip.fontSizeDelta", (Object)0);
        defaults.put("HelpTooltip.smallTextBorderInsets", JBUI.insets((int)4, (int)8, (int)5, (int)8));
        defaults.put("ValidationTooltip.maxWidth", (Object)384);
        defaults.put("Spinner.arrowButtonInsets", JBUI.insets((int)1, (int)1, (int)1, (int)1));
        defaults.put("Spinner.editorBorderPainted", (Object)false);
        defaults.put("ScrollBarUI", JBScrollBar.class.getName());
        defaults.put(JBScrollBar.class.getName(), JBScrollBar.class);
        defaults.put("Focus.activeErrorBorderColor", new ColorUIResource(15022389));
        defaults.put("Component.focusErrorColor", new ColorUIResource(15022389));
        defaults.put("Component.errorFocusColor", new ColorUIResource(15022389));
        defaults.put("Focus.inactiveErrorBorderColor", new ColorUIResource(7617082));
        defaults.put("Component.inactiveFocusErrorColor", new ColorUIResource(7617082));
        defaults.put("Component.inactiveErrorFocusColor", new ColorUIResource(7617082));
        defaults.put("Focus.activeWarningBorderColor", new ColorUIResource(16758316));
        defaults.put("Component.focusWarningColor", new ColorUIResource(16758316));
        defaults.put("Component.warningFocusColor", new ColorUIResource(16758316));
        defaults.put("Focus.inactiveWarningBorderColor", new ColorUIResource(8350720));
        defaults.put("Component.inactiveFocusWarningColor", new ColorUIResource(8350720));
        defaults.put("Component.inactiveWarningFocusColor", new ColorUIResource(8350720));
        defaults.put("TabbedPane.tabAreaInsets", JBUI.insets((int)0));
        defaults.put("TabbedPane.selectedLabelShift", (Object)0);
        defaults.put("TabbedPane.labelShift", (Object)0);
        defaults.put("TabbedPane.tabsOverlapBorder", (Object)true);
        defaults.put("TabbedPane.tabHeight", (Object)32);
        defaults.put("TabbedPane.tabSelectionHeight", (Object)2);
        defaults.put("TabbedPane.tabFillStyle", "underline");
        defaults.put("TabbedPane.fontSizeOffset", (Object)0);
        defaults.put("TableHeader.height", (Object)25);
        defaults.put("NewClass.separatorWidth", (Object)10);
        defaults.put("List.selectedItemAlpha", (Object)100);
        defaults.put("EditorTabs.underlineHeight", (Object)0);
    }

    private static void replaceDefaultButtons(UIDefaults defaults) {
        defaults.put("ButtonUI", MTDarculaButtonUI.class.getName());
        defaults.put(MTDarculaButtonUI.class.getName(), MTDarculaButtonUI.class);
    }

    private static void replaceButtons(UIDefaults defaults) {
        defaults.put("ButtonUI", MTButtonUI.class.getName());
        defaults.put(MTButtonUI.class.getName(), MTButtonUI.class);
        defaults.put("Button.border", (Object)new MTButtonPainter());
        defaults.put("OptionButtonUI", MTOptionButtonUI.class.getName());
        defaults.put(MTOptionButtonUI.class.getName(), MTOptionButtonUI.class);
        defaults.put("OnOffButtonUI", MTOnOffButtonUI.class.getName());
        defaults.put(MTOnOffButtonUI.class.getName(), MTOnOffButtonUI.class);
        defaults.put("ActionButton.backgroundIcon", new Icon(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g.create();
                try {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                    g2.translate(x, y);
                    g2.setColor(JBUI.CurrentTheme.ActionButton.pressedBackground());
                    if (this.getIconWidth() > 28) {
                        g2.fill3DRect(0, 0, this.getIconWidth(), this.getIconHeight(), true);
                    } else {
                        g2.fillOval(0, 0, this.getIconWidth(), this.getIconHeight());
                    }
                }
                finally {
                    g2.dispose();
                }
            }

            @Override
            public int getIconWidth() {
                return JBUI.scale((int)18);
            }

            @Override
            public int getIconHeight() {
                return JBUI.scale((int)18);
            }
        });
    }

    private static void replaceTextFields(UIDefaults defaults) {
        defaults.put("TextFieldUI", MTTextFieldUI.class.getName());
        defaults.put(MTTextFieldUI.class.getName(), MTTextFieldUI.class);
        defaults.put("PasswordFieldUI", MTPasswordFieldUI.class.getName());
        defaults.put(MTPasswordFieldUI.class.getName(), MTPasswordFieldUI.class);
        defaults.put("TextField.border", (Object)new MTTextBorder());
        defaults.put("PasswordField.border", (Object)new MTTextBorder());
        defaults.put("EditorTextField.border", (Object)new MTEditorTextFieldBorder());
    }

    private static void replaceDropdowns(UIDefaults defaults) {
        defaults.put("ComboBoxUI", MTComboBoxUI.class.getName());
        defaults.put(MTComboBoxUI.class.getName(), MTComboBoxUI.class);
    }

    private static void replaceProgressBar(UIDefaults defaults) {
        defaults.put("ProgressBarUI", MTProgressBarUI.class.getName());
        defaults.put(MTProgressBarUI.class.getName(), MTProgressBarUI.class);
        defaults.put("ProgressBar.border", (Object)new MTProgressBarBorder());
    }

    public static void replaceTree(UIDefaults defaults) {
        ApplicationManager.getApplication().putUserData(Control.Painter.KEY, (Object)new MTRowPainter());
    }

    private static void replaceSelectedIndicator(@NonNls UIDefaults defaults) {
        MTSelectedTreePainter painter = new MTSelectedTreePainter();
        defaults.put("List.sourceListSelectionBackgroundPainter", painter);
        defaults.put("List.sourceListFocusedSelectionBackgroundPainter", painter);
    }

    private static void replaceTableHeaders(@NonNls UIDefaults defaults) {
        defaults.put("TableHeaderUI", MTTableHeaderUI.class.getName());
        defaults.put(MTTableHeaderUI.class.getName(), MTTableHeaderUI.class);
        defaults.put("TableHeader.border", new MTTableHeaderBorder());
        defaults.put("Table.focusSelectedCellHighlightBorder", (Object)new MTTableSelectedCellHighlightBorder());
    }

    private static void replaceTables(@NonNls UIDefaults defaults) {
        defaults.put("TableHeader.cellBorder", new MTTableHeaderBorder());
        defaults.put("Table.cellNoFocusBorder", new MTTableCellNoFocusBorder());
        defaults.put("Table.focusCellHighlightBorder", (Object)new MTTableSelectedCellHighlightBorder());
    }

    private static void replaceStatusBar(@NonNls UIDefaults defaults) {
        defaults.put("IdeStatusBarUI", MTStatusBarUI.class.getName());
        defaults.put(MTStatusBarUI.class.getName(), MTStatusBarUI.class);
        defaults.put("IdeStatusBar.border", new MTStatusBarBorder());
        defaults.put("SeparatorUI", MTSeparatorUI.class.getName());
        defaults.put(MTSeparatorUI.class.getName(), MTSeparatorUI.class);
    }

    private static void replaceSpinners(UIDefaults defaults) {
        defaults.put("SpinnerUI", MTSpinnerUI.class.getName());
        defaults.put(MTSpinnerUI.class.getName(), MTSpinnerUI.class);
        defaults.put("Spinner.border", (Object)new MTSpinnerBorder());
    }

    private static void replaceCheckboxes(UIDefaults defaults) {
        defaults.put("CheckBoxUI", MTCheckBoxUI.class.getName());
        defaults.put(MTCheckBoxUI.class.getName(), MTCheckBoxUI.class);
        defaults.put("CheckBoxMenuItemUI", MTCheckBoxMenuItemUI.class.getName());
        defaults.put(MTCheckBoxMenuItemUI.class.getName(), MTCheckBoxMenuItemUI.class);
        defaults.put("CheckBox.border", new MTCheckBoxBorder());
    }

    private static void replaceRadioButtons(UIDefaults defaults) {
        defaults.put("RadioButtonUI", MTRadioButtonUI.class.getName());
        defaults.put(MTRadioButtonUI.class.getName(), MTRadioButtonUI.class);
        defaults.put("RadioButtonMenuItemUI", MTRadioButtonMenuItemUI.class.getName());
        defaults.put(MTRadioButtonMenuItemUI.class.getName(), MTRadioButtonMenuItemUI.class);
    }

    private static void replaceSliders(UIDefaults defaults) {
        defaults.put("SliderUI", MTSliderUI.class.getName());
        defaults.put(MTSliderUI.class.getName(), MTSliderUI.class);
    }

    private static void replaceRootPane(UIDefaults defaults) {
        defaults.put("RootPaneUI", MTRootPaneUI.class.getName());
        defaults.put(MTRootPaneUI.class.getName(), MTRootPaneUI.class);
    }

    private static void replaceTextAreas(UIDefaults defaults) {
        defaults.put("TextAreaUI", MTTextAreaUI.class.getName());
        defaults.put(MTTextAreaUI.class.getName(), MTTextAreaUI.class);
    }

    private static void replaceTabbedPanes(UIDefaults defaults) {
        defaults.put("TabbedPane.tabInsets", JBUI.insets((int)5, (int)10, (int)5, (int)10));
        defaults.put("TabbedPane.selectedTabPadInsets", JBUI.insets((int)0));
        defaults.put("TabbedPane.contentBorderInsets", JBUI.insets((int)3, (int)1, (int)1, (int)1));
        defaults.put("TabbedPaneUI", MTTabbedPaneUI.class.getName());
        defaults.put(MTTabbedPaneUI.class.getName(), MTTabbedPaneUI.class);
    }

    private static void replaceLabels(@NonNls UIDefaults defaults) {
        defaults.put("LabelUI", MTLabelUI.class.getName());
        defaults.put(MTLabelUI.class.getName(), MTLabelUI.class);
    }

    private static void replaceMenus(@NonNls UIDefaults defaults) {
        defaults.put("PopupMenuUI", MTPopupMenuUI.class.getName());
        defaults.put(MTPopupMenuUI.class.getName(), MTPopupMenuUI.class);
        defaults.put("PopupMenu.border", (Object)new MTPopupMenuBorder());
        defaults.put("MenuItem.border", (Object)new MTMenuItemBorder());
        defaults.put("Menu.border", (Object)new MTMenuItemBorder());
    }

    private static void modifyRegistry() {
        Registry.get((String)"ide.balloon.shadow.size").setValue(0);
    }

    static void loadDefaults(UIDefaults defaults) {
        HashMap<String, ColorUIResource> globalProps = new HashMap<String, ColorUIResource>(100);
        MTThemeable selectedTheme = MTConfig.getInstance().getSelectedTheme().getTheme();
        Color backgroundColorString = selectedTheme.getBackgroundColor();
        ColorUIResource backgroundColor = new ColorUIResource(backgroundColorString);
        globalProps.put("background", backgroundColor);
        globalProps.put("textBackground", backgroundColor);
        globalProps.put("inactiveBackground", backgroundColor);
        Color foregroundColorString = selectedTheme.getForegroundColor();
        ColorUIResource foregroundColor = new ColorUIResource(foregroundColorString);
        globalProps.put("foreground", foregroundColor);
        globalProps.put("textForeground", foregroundColor);
        globalProps.put("inactiveForeground", foregroundColor);
        globalProps.put("selectionForegroundInactive", foregroundColor);
        globalProps.put("selectionInactiveForeground", foregroundColor);
        Color selectionBackgroundColorString = selectedTheme.getSelectionBackgroundColor();
        ColorUIResource selectionBgColor = new ColorUIResource(selectionBackgroundColorString);
        globalProps.put("selectionBackgroundInactive", selectionBgColor);
        globalProps.put("selectionInactiveBackground", selectionBgColor);
        Color selectionForegroundColorString = selectedTheme.getSelectionForegroundColor();
        ColorUIResource selectionFgColor = new ColorUIResource(selectionForegroundColorString);
        globalProps.put("selectionForeground", selectionFgColor);
        for (Object key : defaults.keySet()) {
            String s;
            String property;
            if (!(key instanceof String) || !((String)key).contains(".") || !globalProps.containsKey(property = (s = (String)key).substring(s.lastIndexOf(46) + 1))) continue;
            defaults.put(key, globalProps.get(property));
        }
    }

    final String getPrefix() {
        return Objects.requireNonNull(this.theme).getId();
    }
}

