/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.config.ui.load;

import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.mallowigi.idea.MTBundledThemesManager;
import com.mallowigi.idea.MTCustomThemeConfig;
import com.mallowigi.idea.config.ui.MTCustomThemeForm;
import com.mallowigi.idea.messages.MaterialThemeBundle;
import com.mallowigi.idea.themes.models.MTBundledTheme;
import com.twelvemonkeys.lang.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.Nullable;

public final class MTSaveCustomThemeDialog
extends DialogWrapper {
    private final MTCustomThemeForm form;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel pleaseFillLabel;
    private JPanel namePanel;
    private JLabel nameLabel;
    private JTextField nameField;
    private JPanel idPanel;
    private JLabel idLabel;
    private JTextField idField;
    private JPanel colorSchemePanel;
    private JLabel colorLabel;
    private JTextField colorField;
    private JPanel darkCheckBoxPanel;
    private JLabel darkLabel;
    private JCheckBox darkThemeCheckbox;

    MTSaveCustomThemeDialog(MTCustomThemeForm mtCustomThemeForm) {
        super(null, true, DialogWrapper.IdeModalityType.IDE);
        this.form = mtCustomThemeForm;
        this.init();
        this.getOKAction().setEnabled(false);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.initComponents();
        return this.dialogPane;
    }

    protected void doOKAction() {
        MTBundledTheme customTheme = MTCustomThemeConfig.export(this.form);
        customTheme.setName(this.nameField.getText());
        customTheme.setThemeId(this.idField.getText());
        customTheme.setId(this.idField.getText());
        customTheme.setEditorColorScheme(this.colorField.getText());
        customTheme.setIsDark(this.darkThemeCheckbox.isSelected());
        MTBundledThemesManager.saveTheme(customTheme);
        this.close(0, true);
    }

    private void checkFields() {
        this.getOKAction().setEnabled(!Objects.equals(this.nameField.getText(), "") && !Objects.equals(this.idField.getText(), ""));
    }

    private void checkFields(FocusEvent e) {
        this.checkFields();
    }

    private void checkFields(KeyEvent e) {
        this.checkFields();
    }

    private void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("messages.MaterialThemeBundle");
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.pleaseFillLabel = new JLabel();
        this.namePanel = new JPanel();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.idPanel = new JPanel();
        this.idLabel = new JLabel();
        this.idField = new JTextField();
        this.colorSchemePanel = new JPanel();
        this.colorLabel = new JLabel();
        this.colorField = new JTextField();
        this.darkCheckBoxPanel = new JPanel();
        this.darkLabel = new JLabel();
        this.darkThemeCheckbox = new JCheckBox();
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout((LayoutManager)new MigLayout("fillx,insets dialog,hidemode 3,align center top", "[fill]", "[][][][][]"));
        this.pleaseFillLabel.setText(bundle.getString("MTSaveDialog.pleaseFillLabel.text"));
        this.contentPanel.add((Component)this.pleaseFillLabel, "cell 0 0");
        this.namePanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.nameLabel.setText(bundle.getString("MTSaveDialog.nameLabel.text"));
        this.nameLabel.setHorizontalAlignment(2);
        this.nameLabel.setVerticalTextPosition(1);
        this.nameLabel.setVerticalAlignment(1);
        this.nameLabel.setFont(UIManager.getFont("TableHeader.font"));
        this.nameLabel.setForeground(UIManager.getColor("controlText"));
        this.namePanel.add((Component)this.nameLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.nameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                MTSaveCustomThemeDialog.this.checkFields(e);
            }
        });
        this.nameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                MTSaveCustomThemeDialog.this.checkFields(e);
            }
        });
        this.namePanel.add((Component)this.nameField, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.contentPanel.add((Component)this.namePanel, "cell 0 1,aligny top,grow 100 0");
        this.idPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.idLabel.setText(bundle.getString("MTSaveDialog.idLabel.text"));
        this.idLabel.setHorizontalAlignment(2);
        this.idLabel.setVerticalTextPosition(1);
        this.idLabel.setVerticalAlignment(1);
        this.idLabel.setFont(UIManager.getFont("TableHeader.font"));
        this.idLabel.setForeground(UIManager.getColor("controlText"));
        this.idPanel.add((Component)this.idLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.idField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                MTSaveCustomThemeDialog.this.checkFields(e);
            }
        });
        this.idField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                MTSaveCustomThemeDialog.this.checkFields(e);
            }
        });
        this.idPanel.add((Component)this.idField, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.contentPanel.add((Component)this.idPanel, "cell 0 2,aligny top,grow 100 0");
        this.colorSchemePanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.colorLabel.setText(bundle.getString("MTSaveDialog.colorLabel.text"));
        this.colorLabel.setHorizontalAlignment(2);
        this.colorLabel.setVerticalTextPosition(1);
        this.colorLabel.setVerticalAlignment(1);
        this.colorLabel.setFont(UIManager.getFont("TableHeader.font"));
        this.colorLabel.setForeground(UIManager.getColor("controlText"));
        this.colorSchemePanel.add((Component)this.colorLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.colorSchemePanel.add((Component)this.colorField, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.contentPanel.add((Component)this.colorSchemePanel, "cell 0 3,aligny top,grow 100 0");
        this.darkCheckBoxPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.darkLabel.setText(bundle.getString("MTSaveDialog.darkLabel.text"));
        this.darkLabel.setHorizontalAlignment(2);
        this.darkLabel.setVerticalTextPosition(1);
        this.darkLabel.setVerticalAlignment(1);
        this.darkLabel.setFont(UIManager.getFont("TableHeader.font"));
        this.darkLabel.setForeground(UIManager.getColor("controlText"));
        this.darkCheckBoxPanel.add((Component)this.darkLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.darkThemeCheckbox.setText(bundle.getString("MTSaveDialog.darkThemeCheckbox.text"));
        this.darkThemeCheckbox.setSelected(true);
        this.darkCheckBoxPanel.add((Component)this.darkThemeCheckbox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.contentPanel.add((Component)this.darkCheckBoxPanel, "cell 0 4,aligny top,grow 100 0");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.addValidators();
    }

    private void addValidators() {
        new ComponentValidator(this.getDisposable()).withValidator(() -> {
            String tt = this.nameField.getText();
            if (StringUtil.isEmpty((String)tt)) {
                return new ValidationInfo(MaterialThemeBundle.message("MTSaveDialog.nameMissing", new Object[0]), (JComponent)this.nameField).asWarning();
            }
            return null;
        }).andRegisterOnDocumentListener((JTextComponent)this.nameField).installOn((JComponent)this.nameField);
        new ComponentValidator(this.getDisposable()).withValidator(() -> {
            String tt = this.idField.getText();
            if (StringUtil.isEmpty((String)tt)) {
                return new ValidationInfo(MaterialThemeBundle.message("MTSaveDialog.themeIdMissing", new Object[0]), (JComponent)this.idField).asWarning();
            }
            return null;
        }).andRegisterOnDocumentListener((JTextComponent)this.idField).installOn((JComponent)this.idField);
    }
}

