/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.config.ui.load;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import com.mallowigi.idea.MTBundledThemesManager;
import com.mallowigi.idea.MTCustomThemeConfig;
import com.mallowigi.idea.config.ui.MTCustomThemeForm;
import com.mallowigi.idea.config.ui.load.MTSaveCustomThemeDialog;
import com.mallowigi.idea.messages.MaterialThemeBundle;
import com.mallowigi.idea.themes.MTThemeFacade;
import com.mallowigi.idea.themes.MTThemes;
import com.mallowigi.idea.themes.models.MTBundledTheme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public final class MTLoadCustomThemeComboBoxAction
extends ComboBoxAction {
    private final MTCustomThemeForm mtCustomThemeForm;
    private final MTCustomThemeConfig customThemeConfig;

    public MTLoadCustomThemeComboBoxAction(MTCustomThemeForm mtCustomThemeForm) {
        this.mtCustomThemeForm = mtCustomThemeForm;
        this.customThemeConfig = MTCustomThemeConfig.getInstance().clone();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MTLoadCustomThemeComboBoxAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        e.getPresentation().setIcon(AllIcons.General.GearPlain);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation) {
        if (presentation == null) {
            MTLoadCustomThemeComboBoxAction.$$$reportNull$$$0(1);
        }
        JComponent jComponent = this.createCustomComponent(presentation, "StatusBarPlace");
        if (jComponent == null) {
            MTLoadCustomThemeComboBoxAction.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            MTLoadCustomThemeComboBoxAction.$$$reportNull$$$0(3);
        }
        if (place == null) {
            MTLoadCustomThemeComboBoxAction.$$$reportNull$$$0(4);
        }
        ComboBoxAction.ComboBoxButton comboBoxButton = new ComboBoxAction.ComboBoxButton((ComboBoxAction)this, presentation);
        NonOpaquePanel panel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        Border border = JBUI.Borders.empty((int)0);
        panel.setBorder(border);
        panel.add((Component)comboBoxButton);
        NonOpaquePanel nonOpaquePanel = panel;
        if (nonOpaquePanel == null) {
            MTLoadCustomThemeComboBoxAction.$$$reportNull$$$0(5);
        }
        return nonOpaquePanel;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup(null, true);
        group.addSeparator(MaterialThemeBundle.message("MTCustomThemeForm.loadFromButton.loadFrom", new Object[0]));
        for (final MTThemeFacade theme : MTThemes.getAllThemes()) {
            if (theme.isCustom()) continue;
            group.add(new AnAction(theme.getThemeName(), theme.getThemeName(), theme.getIcon()){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    MTLoadCustomThemeComboBoxAction.this.customThemeConfig.importFrom(theme.getTheme());
                    MTLoadCustomThemeComboBoxAction.this.mtCustomThemeForm.setFormState(MTLoadCustomThemeComboBoxAction.this.customThemeConfig);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/mallowigi/idea/config/ui/load/MTLoadCustomThemeComboBoxAction$1", "actionPerformed"));
                }
            });
        }
        group.addSeparator(MaterialThemeBundle.message("MTCustomThemeForm.loadFromButton.loadFromDisk", new Object[0]));
        group.add(new AnAction(MaterialThemeBundle.message("MTCustomThemeForm.loadFromButton.fromDisk", new Object[0]), MaterialThemeBundle.message("load.an.external.theme.into.your.custom.theme.colors", new Object[0]), AllIcons.Actions.Install){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                MyFileChooserDescriptor descriptor = new MyFileChooserDescriptor();
                descriptor.setTitle(MaterialThemeBundle.message("MTCustomThemeForm.importButton.selectFile", new Object[0]));
                String oldPath = PropertiesComponent.getInstance().getValue("plugins.preselection.path");
                VirtualFile toSelect = oldPath == null ? null : VfsUtil.findFileByIoFile((File)new File(FileUtil.toSystemDependentName((String)oldPath)), (boolean)false);
                FileChooser.chooseFile((FileChooserDescriptor)descriptor, null, null, (VirtualFile)toSelect, this::loadTheme);
            }

            private void loadTheme(VirtualFile virtualFile) {
                MTBundledTheme theme = MTBundledThemesManager.loadBundledTheme(virtualFile);
                if (theme == null) {
                    Messages.showErrorDialog((String)MaterialThemeBundle.message("error.parsing.xml.file.make.sure.that.this.is.a.valid.external.theme.file", new Object[0]), (String)MaterialThemeBundle.message("error", new Object[0]));
                    return;
                }
                MTLoadCustomThemeComboBoxAction.this.customThemeConfig.importFrom(theme);
                MTLoadCustomThemeComboBoxAction.this.mtCustomThemeForm.setFormState(MTLoadCustomThemeComboBoxAction.this.customThemeConfig);
                Messages.showDialog((Project)null, (String)String.format(MaterialThemeBundle.message("MTCustomThemeForm.loadFromButton.success", new Object[0]), virtualFile.getName()), (String)MaterialThemeBundle.message("MTCustomThemeForm.loadFromButton.importSuccess", new Object[0]), (String[])new String[]{MaterialThemeBundle.message("common.ok", new Object[0])}, (int)0, (Icon)Messages.getInformationIcon());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/mallowigi/idea/config/ui/load/MTLoadCustomThemeComboBoxAction$2", "actionPerformed"));
            }
        });
        group.addSeparator(MaterialThemeBundle.message("MTCustomThemeForm.loadFromButton.save", new Object[0]));
        group.add(new AnAction(MaterialThemeBundle.message("MTCustomThemeForm.loadFromButton.saveAs", new Object[0]), MaterialThemeBundle.message("save.your.custom.theme.as.an.external.theme", new Object[0]), AllIcons.Actions.Menu_saveall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                new MTSaveCustomThemeDialog(MTLoadCustomThemeComboBoxAction.this.mtCustomThemeForm).show();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/mallowigi/idea/config/ui/load/MTLoadCustomThemeComboBoxAction$3", "actionPerformed"));
            }
        });
        DefaultActionGroup defaultActionGroup = group;
        if (defaultActionGroup == null) {
            MTLoadCustomThemeComboBoxAction.$$$reportNull$$$0(6);
        }
        return defaultActionGroup;
    }

    protected int getMinHeight() {
        return 40;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/mallowigi/idea/config/ui/load/MTLoadCustomThemeComboBoxAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/mallowigi/idea/config/ui/load/MTLoadCustomThemeComboBoxAction";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyFileChooserDescriptor
    extends FileChooserDescriptor {
        MyFileChooserDescriptor() {
            super(true, false, false, false, false, false);
        }

        public boolean isFileSelectable(VirtualFile file) {
            return Objects.equals(file.getExtension(), "xml");
        }
    }
}

