/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.config.ui;

import com.intellij.ui.components.labels.LinkLabel;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.MTLicenseChecker;
import com.mallowigi.idea.config.MTBaseConfig;
import com.mallowigi.idea.config.ui.MTFormUI;
import com.mallowigi.idea.messages.MaterialThemeBundle;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;

public final class MTHomeForm
implements MTFormUI {
    private JPanel content;
    private JLabel logo;
    private JLabel licensedLabel;
    private JButton buyLicenseButton;
    private JButton activateLicenseButton;
    private JSeparator separator1;
    private JPanel vSpacer1;
    private JLabel pluginName;
    private JLabel pluginVersionLabel;
    private JLabel pluginVersion;
    private JLabel copyrightLabel;
    private LinkLabel websiteLink;
    private JLabel activateLicenseLabel;

    public MTHomeForm() {
        this.init();
    }

    @Override
    public void init() {
        MTLicenseChecker.extractLicenseInformation();
        this.initComponents();
        this.setupComponents();
    }

    @Override
    public JComponent getContent() {
        return this.content;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setupComponents() {
        boolean isPremium = MTLicenseChecker.isLicensed();
        if (isPremium) {
            this.licensedLabel.setText(MTLicenseChecker.getLicensedInfo());
            this.content.remove(this.buyLicenseButton);
            this.content.remove(this.activateLicenseButton);
            this.content.remove(this.activateLicenseLabel);
        }
        this.pluginVersion.setText(MTConfig.getInstance().getVersion());
    }

    private static void buyLicenseButtonActionPerformed(ActionEvent e) {
        MTHomeForm.openWebsite("plugin.buyLink");
    }

    private void activateLicenseButtonActionPerformed(ActionEvent e) {
        MTLicenseChecker.requestLicense("Activate License");
        this.activateLicenseButton.setText(MaterialThemeBundle.message("activateLicense.afterSaveButton", new Object[0]));
        this.activateLicenseButton.setEnabled(false);
        this.activateLicenseLabel.setVisible(true);
    }

    private static void logoMouseClicked(MouseEvent e) {
        MTHomeForm.openWebsite("plugin.website");
    }

    private static void websiteLinkMouseClicked(MouseEvent e) {
        MTHomeForm.openWebsite("plugin.website");
    }

    private static void openWebsite(String s) {
        try {
            Desktop.getDesktop().browse(new URI(MaterialThemeBundle.message(s, new Object[0])));
        }
        catch (IOException | URISyntaxException ioException) {
            ioException.printStackTrace();
        }
    }

    @Override
    public void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("messages.MaterialThemeBundle");
        this.content = new JPanel();
        this.logo = new JLabel();
        this.licensedLabel = new JLabel();
        this.buyLicenseButton = new JButton();
        this.activateLicenseButton = new JButton();
        this.separator1 = new JSeparator();
        this.vSpacer1 = new JPanel(null);
        this.pluginName = new JLabel();
        this.pluginVersionLabel = new JLabel();
        this.pluginVersion = new JLabel();
        this.copyrightLabel = new JLabel();
        this.websiteLink = new LinkLabel();
        this.activateLicenseLabel = new JLabel();
        this.content.setLayout((LayoutManager)new MigLayout("hidemode 3", "[357,left]", "[304][23][][][][][]"));
        this.logo.setIcon(new ImageIcon(this.getClass().getResource("/wizard/logo.png")));
        this.logo.setMinimumSize(new Dimension(768, 480));
        this.logo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MTHomeForm.logoMouseClicked(e);
            }
        });
        this.content.add((Component)this.logo, "cell 0 0");
        this.licensedLabel.setText(bundle.getString("MTHomeForm.licensedLabel.text"));
        this.content.add((Component)this.licensedLabel, "cell 0 1");
        this.buyLicenseButton.setText(bundle.getString("MTHomeForm.buyLicenseButton.text"));
        this.buyLicenseButton.addActionListener(e -> MTHomeForm.buyLicenseButtonActionPerformed(e));
        this.content.add((Component)this.buyLicenseButton, "cell 0 2");
        this.activateLicenseButton.setText(bundle.getString("MTHomeForm.activateLicenseButton.text"));
        this.activateLicenseButton.addActionListener(e -> this.activateLicenseButtonActionPerformed(e));
        this.content.add((Component)this.activateLicenseButton, "cell 0 2");
        this.content.add((Component)this.separator1, "cell 0 3");
        this.content.add((Component)this.vSpacer1, "cell 0 4");
        this.pluginName.setText(bundle.getString("plugin.name"));
        this.pluginName.setIconTextGap(0);
        this.pluginName.setFont(new Font("Roboto", 1, 13));
        this.pluginName.setForeground(UIManager.getColor("Tree.foreground"));
        this.content.add((Component)this.pluginName, "cell 0 5");
        this.pluginVersionLabel.setText(bundle.getString("MTHomeForm.pluginVersionLabel.text"));
        this.pluginVersionLabel.setFont(new Font("Roboto", 1, 13));
        this.pluginVersionLabel.setForeground(UIManager.getColor("Tree.foreground"));
        this.content.add((Component)this.pluginVersionLabel, "cell 0 5,gapx 2");
        this.pluginVersion.setText(bundle.getString("plugin.version"));
        this.pluginVersion.setFont(new Font("Roboto", 1, 13));
        this.pluginVersion.setForeground(UIManager.getColor("Tree.foreground"));
        this.content.add((Component)this.pluginVersion, "cell 0 5,gapx 2");
        this.copyrightLabel.setText(bundle.getString("MTHomeForm.copyrightLabel.text"));
        this.copyrightLabel.setForeground(UIManager.getColor("Tree.foreground"));
        this.content.add((Component)this.copyrightLabel, "cell 0 5,gapx 2");
        this.websiteLink.setText(bundle.getString("plugin.website"));
        this.websiteLink.setIcon(null);
        this.websiteLink.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MTHomeForm.websiteLinkMouseClicked(e);
            }
        });
        this.content.add((Component)this.websiteLink, "cell 0 6");
        this.activateLicenseLabel.setText(bundle.getString("MTHomeForm.activateLicenseLabel.text"));
        this.activateLicenseLabel.setEnabled(false);
        this.activateLicenseLabel.setVisible(false);
        this.content.add((Component)this.activateLicenseLabel, "cell 0 2");
    }

    public void setFormState(MTConfig config) {
    }

    public static boolean isModified(MTBaseConfig<MTHomeForm, MTConfig> config) {
        return false;
    }
}

