/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.config.ui;

import com.intellij.CommonBundle;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.ide.DataManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColorPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.lang.JavaVersion;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.MTLicenseChecker;
import com.mallowigi.idea.config.MTBaseConfig;
import com.mallowigi.idea.config.MTCustomThemeConfigurable;
import com.mallowigi.idea.config.MTFileColorsPage;
import com.mallowigi.idea.config.enums.IndicatorStyles;
import com.mallowigi.idea.config.enums.TabHighlightPositions;
import com.mallowigi.idea.config.ui.MTFormUI;
import com.mallowigi.idea.messages.MaterialThemeBundle;
import com.mallowigi.idea.themes.MTThemeFacade;
import com.mallowigi.idea.themes.MTThemes;
import com.mallowigi.idea.utils.MTUiUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

public class MTForm
implements MTFormUI {
    private SpinnerModel highlightSpinnerModel;
    private SpinnerModel tabsHeightSpinnerModel;
    private SpinnerModel leftTreeIndentModel;
    private SpinnerModel rightTreeIndentModel;
    private SpinnerModel customSidebarHeightModel;
    private SpinnerModel treeFontSizeModel;
    private SpinnerModel tabFontSizeModel;
    private SpinnerModel indicatorThicknessSpinnerModel;
    private JPanel content;
    private JComponent settingsSep;
    private JPanel mainSettingsPanel;
    private JLabel selectedThemeLabel;
    private ComboBox<MTThemeFacade> themeComboBox;
    private JCheckBox isContrastModeCheckbox;
    private JCheckBox highContrastCheckbox;
    private JLabel customAccentColorLabel;
    private ColorPanel customAccentColorChooser;
    private JCheckBox overrideAccentCheckbox;
    private LinkLabel fileColorsLink;
    private JComponent advSettingsSep;
    private JTabbedPane tabbedPane1;
    private JPanel tabPanel;
    private JLabel tabsDesc;
    private JCheckBox activeTabHighlightCheckbox;
    private ColorPanel activeTabHighlightColor;
    private JLabel thicknessLabel;
    private JSpinner highlightSpinner;
    private JCheckBox isUpperCaseTabsCheckbox;
    private JLabel tabHeightLabel;
    private JSpinner tabHeightSpinner;
    private JLabel positionLabel;
    private ComboBox<TabHighlightPositions> tabHighlightPositionComboBox;
    private JCheckBox tabFontSizeCheckbox;
    private JSpinner tabFontSizeSpinner;
    private JLabel panelDesc;
    private JCheckBox isCompactStatusbarCheckbox;
    private JCheckBox isCompactTablesCheckbox;
    private JCheckBox compactDropdownsCheckbox;
    private JCheckBox isCompactMenusCheckbox;
    private JPanel projectViewPanel;
    private JLabel projectViewDesc;
    private JCheckBox isCompactSidebarCheckbox;
    private JSpinner customSidebarSpinner;
    private JCheckBox customTreeIndentCheckbox;
    private JLabel leftLabel;
    private JSpinner leftIndentSpinner;
    private JLabel rightLabel;
    private JSpinner rightSpinner;
    private JLabel selectedIndicatorLabel;
    private ComboBox<IndicatorStyles> indicatorStyleComboBox;
    private JLabel indicatorThicknessLabel;
    private JSpinner indicatorThicknessSpinner;
    private JCheckBox styledDirectoriesCheckbox;
    private LinkLabel directoriesColorLink;
    private JCheckBox fontSizeCheckbox;
    private JSpinner fontSizeSpinner;
    private JPanel componentsPanel;
    private JLabel componentDesc;
    private JCheckBox upperCaseButtonsCheckbox;
    private JCheckBox borderedButtonsCheckbox;
    private JCheckBox accentScrollbarsCheckbox;
    private LinkLabel scrollbarsLink;
    private JCheckBox themedScrollbarsCheckbox;
    private JCheckBox accentModeCheckbox;
    private JLabel secondAccentLabel;
    private ColorPanel secondAccentColorChooser;
    private JCheckBox tabShadowCheckbox;
    private JPanel featuresPanel;
    private JLabel featuresDesc;
    private JCheckBox useMaterialFontCheckbox;
    private JCheckBox fileColorsCheckbox;
    private LinkLabel fileStatusColorsLink;
    private JCheckBox useMaterialWallpapersCheckbox;
    private JCheckBox useProjectFrameCheckbox;
    private JPanel otherTweaksPanel;
    private JLabel tweaksDesc;
    private JCheckBox darkTitleBarCheckbox;
    private JCheckBox codeAdditionsCheckBox;
    private JCheckBox isColoredOpenedDirsCheckbox;
    private JButton resetDefaultsButton;

    private void disablePremiumFeatures() {
        boolean isFreeLicense;
        boolean bl = isFreeLicense = !MTLicenseChecker.isLicensed();
        if (isFreeLicense) {
            MTUiUtils.disablePremium(this.highContrastCheckbox);
            MTUiUtils.disablePremium(this.customAccentColorLabel);
            MTUiUtils.disablePremium((JComponent)this.customAccentColorChooser);
            MTUiUtils.disablePremium(this.overrideAccentCheckbox);
            MTUiUtils.disablePremium((JComponent)this.directoriesColorLink);
            MTUiUtils.disablePremium((JComponent)this.fileColorsLink);
            MTUiUtils.disablePremium((JComponent)this.fileStatusColorsLink);
            MTUiUtils.disablePremium((JComponent)this.scrollbarsLink);
            MTUiUtils.disablePremium(this.activeTabHighlightCheckbox);
            MTUiUtils.disablePremium((JComponent)this.activeTabHighlightColor);
            MTUiUtils.disablePremium(this.thicknessLabel);
            MTUiUtils.disablePremium(this.highlightSpinner);
            MTUiUtils.disablePremium(this.isUpperCaseTabsCheckbox);
            MTUiUtils.disablePremium(this.positionLabel);
            MTUiUtils.disablePremium(this.tabHighlightPositionComboBox);
            MTUiUtils.disablePremium(this.tabFontSizeCheckbox);
            MTUiUtils.disablePremium(this.tabFontSizeSpinner);
            MTUiUtils.disablePremium(this.selectedIndicatorLabel);
            MTUiUtils.disablePremium(this.indicatorStyleComboBox);
            MTUiUtils.disablePremium(this.indicatorThicknessLabel);
            MTUiUtils.disablePremium(this.indicatorThicknessSpinner);
            MTUiUtils.disablePremium(this.secondAccentLabel);
            MTUiUtils.disablePremium(this.styledDirectoriesCheckbox);
            MTUiUtils.disablePremium(this.fontSizeCheckbox);
            MTUiUtils.disablePremium(this.fontSizeSpinner);
            MTUiUtils.disablePremium(this.accentModeCheckbox);
            MTUiUtils.disablePremium((JComponent)this.secondAccentColorChooser);
            MTUiUtils.disablePremium(this.tabShadowCheckbox);
            MTUiUtils.disablePremium(this.useMaterialFontCheckbox);
            MTUiUtils.disablePremium(this.fileColorsCheckbox);
            MTUiUtils.disablePremium(this.useMaterialWallpapersCheckbox);
            MTUiUtils.disablePremium(this.useProjectFrameCheckbox);
            MTUiUtils.disablePremium(this.darkTitleBarCheckbox);
            MTUiUtils.disablePremium(this.codeAdditionsCheckBox);
            MTUiUtils.disablePremium(this.isColoredOpenedDirsCheckbox);
            MTUiUtils.disablePremium(this.borderedButtonsCheckbox);
        }
    }

    @Override
    public final void init() {
        this.initComponents();
        this.setupComponents();
    }

    @Override
    public final JComponent getContent() {
        return this.content;
    }

    private void afterStateSet() {
    }

    @Override
    public void dispose() {
    }

    public final void setFormState(MTBaseConfig config) {
        MTConfig mtConfig = (MTConfig)config;
        mtConfig.setPremium(true);
        this.setHighlightPosition(mtConfig.getTabHighlightPosition());
        this.setCodeAdditionsEnabled(mtConfig.isCodeAdditionsEnabled());
        this.setCustomAccentColor(ColorUtil.fromHex((String)mtConfig.getAccentColor()));
        this.setSecondAccentColor(ColorUtil.fromHex((String)mtConfig.getSecondAccentColor()));
        this.setCustomSidebarHeight(mtConfig.getCustomSidebarHeight());
        this.setHighlightColor(mtConfig.getHighlightColor());
        this.setHighlightColorEnabled(mtConfig.isHighlightColorEnabled());
        this.setHighlightThickness(mtConfig.getHighlightThickness());
        this.setIndicatorStyle(mtConfig.getIndicatorStyle());
        this.setIndicatorThickness(mtConfig.getIndicatorThickness());
        this.setIsAccentMode(mtConfig.isAccentMode());
        this.setIsAccentScrollbars(mtConfig.isAccentScrollbars());
        this.setIsCompactDropdowns(mtConfig.isCompactDropdowns());
        this.setIsCompactMenus(mtConfig.isCompactMenus());
        this.setIsCompactSidebar(mtConfig.isCompactSidebar());
        this.setIsCompactStatusBar(mtConfig.isCompactStatusBar());
        this.setIsCompactTables(mtConfig.isCompactTables());
        this.setIsContrastMode(mtConfig.isContrastMode());
        this.setIsCustomTreeIndent(mtConfig.isCustomTreeIndentEnabled());
        this.setIsDarkTitleBar(mtConfig.isDarkTitleBar());
        this.setIsFileStatusColors(mtConfig.isFileStatusColorsEnabled());
        this.setIsHighContrast(mtConfig.isHighContrast());
        this.setIsOverrideAccents(mtConfig.isOverrideAccentColor());
        this.setIsStyledDirectories(mtConfig.isStyledDirectories());
        this.setIsTabsShadow(mtConfig.isTabsShadow());
        this.setIsThemedScrollbars(mtConfig.isThemedScrollbars());
        this.setIsTabFontSizeEnabled(mtConfig.isTabFontSizeEnabled());
        this.setIsTreeFontSizeEnabled(mtConfig.isTreeFontSizeEnabled());
        this.setIsUppercaseButtons(mtConfig.isUpperCaseButtons());
        this.setIsBorderedButtons(mtConfig.isBorderedButtons());
        this.setIsUpperCaseTabs(mtConfig.isUpperCaseTabs());
        this.setLeftTreeIndent(mtConfig.getLeftTreeIndent());
        this.setRightTreeIndent(mtConfig.getRightTreeIndent());
        this.setSelectedTabIndex(mtConfig.getSettingsSelectedTab());
        this.setTabsHeight(mtConfig.getTabsHeight());
        this.setTheme(mtConfig.getSelectedTheme());
        this.setTabFontSize(mtConfig.getTabFontSize());
        this.setTreeFontSize(mtConfig.getTreeFontSize());
        this.setUseMaterialFont(mtConfig.isUseMaterialFont2());
        this.setUseMaterialWallpapers(mtConfig.isUseMaterialWallpapers());
        this.setUseColoredDirectories(mtConfig.isUseColoredDirectories());
        this.setUseProjectFrame(mtConfig.isUseProjectFrame());
        mtConfig.setPremium(MTLicenseChecker.isLicensed());
        this.afterStateSet();
    }

    public final boolean isModified(MTBaseConfig config) {
        MTConfig mtConfig = (MTConfig)config;
        boolean modified = mtConfig.isReset();
        modified = modified || mtConfig.isHighlightColorChanged(this.getHighlightColor());
        modified = modified || mtConfig.isSelectedThemeChanged(this.getTheme());
        modified = modified || mtConfig.isHighlightColorEnabledChanged(this.isHighlightColorEnabled());
        modified = modified || mtConfig.isHighlightThicknessChanged(this.getHighlightThickness());
        modified = modified || mtConfig.isContrastModeChanged(this.isContrastMode());
        modified = modified || mtConfig.isStyledDirectoriesChanged(this.isStyledDirectories());
        modified = modified || mtConfig.isTabsHeightChanged(this.getTabsHeight());
        modified = modified || mtConfig.isTabHighlightPositionChanged(this.getTabHighlightPosition());
        modified = modified || mtConfig.isAccentModeChanged(this.isAccentMode());
        modified = modified || mtConfig.isCustomTreeIndentChanged(this.isCustomTreeIndent());
        modified = modified || mtConfig.isRightTreeIndentChanged(this.getRightTreeIndent());
        modified = modified || mtConfig.isLeftTreeIndentChanged(this.getLeftTreeIndent());
        modified = modified || mtConfig.isTabFontSizeChanged(this.getTabFontSize());
        modified = modified || mtConfig.isTabFontSizeEnabledChanged(this.isTabFontSizeEnabled());
        modified = modified || mtConfig.isTreeFontSizeChanged(this.getTreeFontSize());
        modified = modified || mtConfig.isTreeFontSizeEnabledChanged(this.isTreeFontSizeEnabled());
        modified = modified || mtConfig.isUpperCaseTabsChanged(this.isUpperCaseTabs());
        modified = modified || mtConfig.isCompactSidebarChanged(this.isCompactSidebar());
        modified = modified || mtConfig.isCompactStatusBarChanged(this.isCompactStatusBar());
        modified = modified || mtConfig.isCompactTablesChanged(this.isCompactTables());
        modified = modified || mtConfig.isCompactMenusChanged(this.isCompactMenus());
        modified = modified || mtConfig.isCustomSidebarHeightChanged(this.getCustomSidebarHeight());
        modified = modified || mtConfig.isThemedScrollbarsChanged(this.isThemedScrollbars());
        modified = modified || mtConfig.isAccentScrollbarsChanged(this.isAccentScrollbars());
        modified = modified || mtConfig.isFileStatusColorsEnabledChanged(this.isFileStatusColors());
        modified = modified || mtConfig.isDarkTitleBarChanged(this.isDarkTitleBar());
        modified = modified || mtConfig.isAccentColorChanged(this.getCustomAccentColor());
        modified = modified || mtConfig.isSecondAccentColorChanged(this.getSecondAccentColor());
        modified = modified || mtConfig.isIndicatorStyleChanged(this.getIndicatorStyle());
        modified = modified || mtConfig.isIndicatorThicknessChanged(this.getIndicatorThickness());
        modified = modified || mtConfig.isUseMaterialFontChanged(this.isUseMaterialFonts());
        modified = modified || mtConfig.isUseMaterialWallpapersChanged(this.isUseMaterialWallpapers());
        modified = modified || mtConfig.isUseProjectFrameChanged(this.isUseProjectFrame());
        modified = modified || mtConfig.isCompactDropdownsChanged(this.isCompactDropdowns());
        modified = modified || mtConfig.isUpperCaseButtonsChanged(this.isUpperCaseButtons());
        modified = modified || mtConfig.isBorderedButtonsChanged(this.isBorderedButtons());
        modified = modified || mtConfig.isHighContrastChanged(this.isHighContrast());
        modified = modified || mtConfig.isOverrideAccentColorChanged(this.isOverrideAccents());
        modified = modified || mtConfig.isTabsShadowChanged(this.isTabsShadow());
        modified = modified || mtConfig.isCodeAdditionsEnabledChanged(this.isCodeAdditionsEnabled());
        modified = modified || mtConfig.isUseColoredDirectoriesChanged(this.isUseColoredDirectories());
        return modified;
    }

    public final MTThemeFacade getTheme() {
        return (MTThemeFacade)this.themeComboBox.getSelectedItem();
    }

    private void setTheme(MTThemeFacade selectedTheme) {
        this.themeComboBox.setSelectedItem((Object)selectedTheme);
    }

    public final boolean isContrastMode() {
        return this.isContrastModeCheckbox.isSelected();
    }

    private void setIsContrastMode(boolean isContrastMode) {
        this.isContrastModeCheckbox.setSelected(isContrastMode);
    }

    public final boolean isHighContrast() {
        return this.highContrastCheckbox.isSelected();
    }

    private void setIsHighContrast(boolean isHighContrast) {
        this.highContrastCheckbox.setSelected(isHighContrast);
    }

    public final Color getCustomAccentColor() {
        return this.customAccentColorChooser.getSelectedColor();
    }

    private void setCustomAccentColor(Color customAccentColor) {
        this.customAccentColorChooser.setSelectedColor(customAccentColor);
    }

    public final boolean isOverrideAccents() {
        return this.overrideAccentCheckbox.isSelected();
    }

    private void setIsOverrideAccents(boolean isOverrideAccents) {
        this.overrideAccentCheckbox.setSelected(isOverrideAccents);
        this.enableDisableAccentColor(isOverrideAccents);
    }

    public final Color getHighlightColor() {
        return this.activeTabHighlightColor.getSelectedColor();
    }

    private void setHighlightColor(@NotNull Color highlightColor) {
        if (highlightColor == null) {
            MTForm.$$$reportNull$$$0(0);
        }
        this.activeTabHighlightColor.setSelectedColor(highlightColor);
    }

    public final boolean isHighlightColorEnabled() {
        return this.activeTabHighlightCheckbox.isSelected();
    }

    private void setHighlightColorEnabled(boolean enabled) {
        this.activeTabHighlightCheckbox.setSelected(enabled);
        this.enableDisableActiveTabColor(enabled);
    }

    public final Integer getHighlightThickness() {
        return (Integer)this.highlightSpinnerModel.getValue();
    }

    private void setHighlightThickness(Integer highlightThickness) {
        this.highlightSpinnerModel.setValue(highlightThickness);
    }

    public final boolean isUpperCaseTabs() {
        return this.isUpperCaseTabsCheckbox.isSelected();
    }

    private void setIsUpperCaseTabs(boolean upperCaseTabs) {
        this.isUpperCaseTabsCheckbox.setSelected(upperCaseTabs);
    }

    public final Integer getTabsHeight() {
        return (Integer)this.tabsHeightSpinnerModel.getValue();
    }

    private void setTabsHeight(int tabsHeight) {
        this.tabsHeightSpinnerModel.setValue(tabsHeight);
    }

    public final TabHighlightPositions getTabHighlightPosition() {
        return (TabHighlightPositions)((Object)this.tabHighlightPositionComboBox.getSelectedItem());
    }

    private void setHighlightPosition(TabHighlightPositions position) {
        this.tabHighlightPositionComboBox.setSelectedItem((Object)position);
    }

    public final Integer getTabFontSize() {
        return (Integer)this.tabFontSizeModel.getValue();
    }

    private void setTabFontSize(int tabFontSize) {
        this.tabFontSizeModel.setValue(tabFontSize);
    }

    public final boolean isTabFontSizeEnabled() {
        return this.tabFontSizeCheckbox.isSelected();
    }

    private void setIsTabFontSizeEnabled(boolean isTabFontSizeEnabled) {
        this.tabFontSizeCheckbox.setSelected(isTabFontSizeEnabled);
        this.enableDisableTabFontSize(isTabFontSizeEnabled);
    }

    public final boolean isCompactStatusBar() {
        return this.isCompactStatusbarCheckbox.isSelected();
    }

    private void setIsCompactStatusBar(boolean compactStatusBar) {
        this.isCompactStatusbarCheckbox.setSelected(compactStatusBar);
    }

    public final boolean isCompactTables() {
        return this.isCompactTablesCheckbox.isSelected();
    }

    private void setIsCompactTables(boolean compactTables) {
        this.isCompactTablesCheckbox.setSelected(compactTables);
    }

    public final boolean isCompactDropdowns() {
        return this.compactDropdownsCheckbox.isSelected();
    }

    private void setIsCompactDropdowns(boolean compactDropdowns) {
        this.compactDropdownsCheckbox.setSelected(compactDropdowns);
    }

    public final boolean isCompactMenus() {
        return this.isCompactMenusCheckbox.isSelected();
    }

    private void setIsCompactMenus(boolean compactMenus) {
        this.isCompactMenusCheckbox.setSelected(compactMenus);
    }

    public final boolean isCompactSidebar() {
        return this.isCompactSidebarCheckbox.isSelected();
    }

    private void setIsCompactSidebar(boolean compactSidebar) {
        this.isCompactSidebarCheckbox.setSelected(compactSidebar);
        this.enableDisableCustomSidebarHeight(compactSidebar);
    }

    public final Integer getCustomSidebarHeight() {
        return (Integer)this.customSidebarHeightModel.getValue();
    }

    private void setCustomSidebarHeight(Integer customSidebarHeight) {
        this.customSidebarHeightModel.setValue(customSidebarHeight);
    }

    public final boolean isCustomTreeIndent() {
        return this.customTreeIndentCheckbox.isSelected();
    }

    private void setIsCustomTreeIndent(boolean isCustomTreeIndent) {
        this.customTreeIndentCheckbox.setSelected(isCustomTreeIndent);
        this.enableDisableCustomTreeIndent(isCustomTreeIndent);
    }

    public final Integer getRightTreeIndent() {
        return (Integer)this.rightTreeIndentModel.getValue();
    }

    private void setRightTreeIndent(Integer rightTreeIndent) {
        this.rightTreeIndentModel.setValue(rightTreeIndent);
    }

    public final Integer getLeftTreeIndent() {
        return (Integer)this.leftTreeIndentModel.getValue();
    }

    private void setLeftTreeIndent(Integer leftTreeIndent) {
        this.leftTreeIndentModel.setValue(leftTreeIndent);
    }

    public final IndicatorStyles getIndicatorStyle() {
        return (IndicatorStyles)((Object)this.indicatorStyleComboBox.getSelectedItem());
    }

    private void setIndicatorStyle(IndicatorStyles arrowsStyle) {
        this.indicatorStyleComboBox.setSelectedItem((Object)arrowsStyle);
    }

    public final Integer getIndicatorThickness() {
        return (Integer)this.indicatorThicknessSpinnerModel.getValue();
    }

    private void setIndicatorThickness(Integer indicatorThickness) {
        this.indicatorThicknessSpinnerModel.setValue(indicatorThickness);
    }

    public final boolean isStyledDirectories() {
        return this.styledDirectoriesCheckbox.isSelected();
    }

    private void setIsStyledDirectories(boolean isStyled) {
        this.styledDirectoriesCheckbox.setSelected(isStyled);
    }

    public final Integer getTreeFontSize() {
        return (Integer)this.treeFontSizeModel.getValue();
    }

    private void setTreeFontSize(int treeFontSize) {
        this.treeFontSizeModel.setValue(treeFontSize);
    }

    public final boolean isTreeFontSizeEnabled() {
        return this.fontSizeCheckbox.isSelected();
    }

    private void setIsTreeFontSizeEnabled(boolean isTreeFontSizeEnabled) {
        this.fontSizeCheckbox.setSelected(isTreeFontSizeEnabled);
        this.enableDisableTreeFontSize(isTreeFontSizeEnabled);
    }

    public final boolean isUpperCaseButtons() {
        return this.upperCaseButtonsCheckbox.isSelected();
    }

    private void setIsUppercaseButtons(boolean upperCaseButtons) {
        this.upperCaseButtonsCheckbox.setSelected(upperCaseButtons);
    }

    public final boolean isBorderedButtons() {
        return this.borderedButtonsCheckbox.isSelected();
    }

    private void setIsBorderedButtons(boolean borderedButtons) {
        this.borderedButtonsCheckbox.setSelected(borderedButtons);
    }

    public final boolean isThemedScrollbars() {
        return this.themedScrollbarsCheckbox.isSelected();
    }

    private void setIsThemedScrollbars(boolean isThemedScrollbars) {
        this.themedScrollbarsCheckbox.setSelected(isThemedScrollbars);
    }

    public final boolean isAccentScrollbars() {
        return this.accentScrollbarsCheckbox.isSelected();
    }

    private void setIsAccentScrollbars(boolean isAccentScrollbars) {
        this.accentScrollbarsCheckbox.setSelected(isAccentScrollbars);
    }

    public final boolean isTabsShadow() {
        return this.tabShadowCheckbox.isSelected();
    }

    private void setIsTabsShadow(boolean tabsShadow) {
        this.tabShadowCheckbox.setSelected(tabsShadow);
    }

    public final boolean isAccentMode() {
        return this.accentModeCheckbox.isSelected();
    }

    private void setIsAccentMode(boolean isAccentMode) {
        this.accentModeCheckbox.setSelected(isAccentMode);
        this.enableDisableSecondAccentColor(isAccentMode);
    }

    public final Color getSecondAccentColor() {
        return this.secondAccentColorChooser.getSelectedColor();
    }

    private void setSecondAccentColor(Color secondAccentColor) {
        this.secondAccentColorChooser.setSelectedColor(secondAccentColor);
    }

    public final boolean isUseMaterialFonts() {
        return this.useMaterialFontCheckbox.isSelected();
    }

    private void setUseMaterialFont(boolean isUseMaterialFont) {
        this.useMaterialFontCheckbox.setSelected(isUseMaterialFont);
    }

    public final boolean isFileStatusColors() {
        return this.fileColorsCheckbox.isSelected();
    }

    private void setIsFileStatusColors(boolean fileStatusColorsEnabled) {
        this.fileColorsCheckbox.setSelected(fileStatusColorsEnabled);
    }

    public final boolean isUseMaterialWallpapers() {
        return this.useMaterialWallpapersCheckbox.isSelected();
    }

    private void setUseMaterialWallpapers(boolean useMaterialWallpapers) {
        this.useMaterialWallpapersCheckbox.setSelected(useMaterialWallpapers);
    }

    public final boolean isUseProjectFrame() {
        return this.useProjectFrameCheckbox.isSelected();
    }

    private void setUseProjectFrame(boolean useProjectFrame) {
        this.useProjectFrameCheckbox.setSelected(useProjectFrame);
    }

    public final boolean isDarkTitleBar() {
        return this.darkTitleBarCheckbox.isSelected();
    }

    private void setIsDarkTitleBar(boolean darkTitleBar) {
        this.darkTitleBarCheckbox.setSelected(darkTitleBar);
    }

    public final boolean isCodeAdditionsEnabled() {
        return this.codeAdditionsCheckBox.isSelected();
    }

    private void setCodeAdditionsEnabled(boolean enabled) {
        this.codeAdditionsCheckBox.setSelected(enabled);
    }

    public final boolean isUseColoredDirectories() {
        return this.isColoredOpenedDirsCheckbox.isSelected();
    }

    private void setUseColoredDirectories(boolean useColoredDirectories) {
        this.isColoredOpenedDirsCheckbox.setSelected(useColoredDirectories);
    }

    public final Integer getSelectedTabIndex() {
        return this.tabbedPane1.getSelectedIndex();
    }

    private void setSelectedTabIndex(Integer settingsSelectedTab) {
        this.tabbedPane1.setSelectedIndex(settingsSelectedTab);
    }

    private void enableDisableCustomTreeIndent(boolean isCustomTreeIndent) {
        this.leftIndentSpinner.setEnabled(isCustomTreeIndent);
        this.rightSpinner.setEnabled(isCustomTreeIndent);
    }

    private void enableDisableActiveTabColor(boolean isCustomTreeIndent) {
        this.activeTabHighlightColor.setEnabled(isCustomTreeIndent);
    }

    private void enableDisableAccentColor(boolean overrideAccentColor) {
        this.customAccentColorChooser.setEnabled(!overrideAccentColor);
    }

    private void enableDisableSecondAccentColor(boolean accentMode) {
        this.secondAccentColorChooser.setEnabled(accentMode);
    }

    private void enableDisableCustomSidebarHeight(boolean isCustomSidebarHeight) {
        this.customSidebarSpinner.setEnabled(isCustomSidebarHeight);
    }

    private void enableDisableTreeFontSize(boolean isTreeFontSize) {
        this.fontSizeSpinner.setEnabled(isTreeFontSize);
    }

    private void enableDisableTabFontSize(boolean isTabFontSize) {
        this.tabFontSizeSpinner.setEnabled(isTabFontSize);
    }

    private void enableDisableCompactStatusBar(boolean isMaterialDesign) {
        this.isCompactStatusbarCheckbox.setEnabled(isMaterialDesign);
    }

    private void enableDisableCompactTableCells(boolean isMaterialDesign) {
        this.isCompactTablesCheckbox.setEnabled(isMaterialDesign);
    }

    private void enableDisableDropdownLists(boolean isMaterialDesign) {
        this.compactDropdownsCheckbox.setEnabled(isMaterialDesign);
    }

    private void customTreeIndentCheckboxActionPerformed(ActionEvent e) {
        this.enableDisableCustomTreeIndent(this.customTreeIndentCheckbox.isSelected());
    }

    private void activeTabHighlightCheckboxActionPerformed(ActionEvent e) {
        this.enableDisableActiveTabColor(this.activeTabHighlightCheckbox.isSelected());
    }

    private void isCompactSidebarCheckboxActionPerformed(ActionEvent e) {
        this.enableDisableCustomSidebarHeight(this.isCompactSidebarCheckbox.isSelected());
    }

    private void fontSizeCheckboxActionPerformed(ActionEvent e) {
        this.enableDisableTreeFontSize(this.fontSizeCheckbox.isSelected());
    }

    private void isDarkTitleBarActionPerformed(ActionEvent e) {
        int dialog;
        if (SystemInfo.isWin10OrNewer && this.darkTitleBarCheckbox.isSelected()) {
            int dialog2 = Messages.showOkCancelDialog((String)MaterialThemeBundle.message("MTForm.windowsTitleBar.warning.message", new Object[0]), (String)MaterialThemeBundle.message("MTForm.windowsTitleBar.warning.title", new Object[0]), (String)CommonBundle.getOkButtonText(), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon());
            if (dialog2 == 2) {
                this.darkTitleBarCheckbox.setSelected(false);
            }
        } else if (SystemInfo.isMac && JavaVersion.current().isAtLeast(11) && this.darkTitleBarCheckbox.isSelected() && (dialog = Messages.showOkCancelDialog((String)MaterialThemeBundle.message("MTForm.themedTitleBar.warning.message", new Object[0]), (String)MaterialThemeBundle.message("MTForm.themedTitleBar.warning.title", new Object[0]), (String)CommonBundle.getOkButtonText(), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon())) == 2) {
            this.darkTitleBarCheckbox.setSelected(false);
        }
    }

    private void resetDefaultsButtonActionPerformed(ActionEvent e) {
        ResourceBundle bundle = ResourceBundle.getBundle("messages.MaterialThemeBundle");
        int answer = Messages.showYesNoDialog((String)bundle.getString("MTForm.dialog.resetDefaults.consent"), (String)bundle.getString("MTForm.resetDefaultsButton.text"), (Icon)Messages.getWarningIcon());
        if (answer == 0) {
            MTConfig config = MTConfig.getInstance();
            config.resetSettings();
            this.setFormState(config);
        }
    }

    private void useMaterialFontCheckboxActionPerformed(ActionEvent e) {
        if (this.useMaterialFontCheckbox.isSelected()) {
            MTForm.showFontWarningDialog();
        }
    }

    private void overrideAccentCheckboxActionPerformed(ActionEvent e) {
        this.enableDisableAccentColor(this.isOverrideAccents());
    }

    private void tabFontSizeCheckboxActionPerformed(ActionEvent e) {
        this.enableDisableTabFontSize(this.tabFontSizeCheckbox.isSelected());
    }

    private void darkTitleBarCheckboxActionPerformed(ActionEvent e) {
        if (this.darkTitleBarCheckbox.isSelected() && SystemInfo.isMac && JavaVersion.current().isAtLeast(11)) {
            MTForm.showTitleBarDialog();
        }
    }

    private void accentModeCheckboxActionPerformed(ActionEvent e) {
        this.enableDisableSecondAccentColor(this.isAccentMode());
    }

    private void useMaterialWallpapersCheckboxActionPerformed(ActionEvent e) {
        int dialog;
        if (this.useMaterialWallpapersCheckbox.isSelected() && (dialog = Messages.showOkCancelDialog((String)MaterialThemeBundle.message("MTForm.materialWallPapers.warning.message", new Object[0]), (String)MaterialThemeBundle.message("MTForm.materialWallPapers.warning.title", new Object[0]), (String)CommonBundle.getOkButtonText(), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon())) == 2) {
            this.useMaterialWallpapersCheckbox.setSelected(false);
        }
    }

    @Override
    public final void initComponents() {
        ResourceBundle bundle = ResourceBundle.getBundle("messages.MaterialThemeBundle");
        DefaultComponentFactory compFactory = DefaultComponentFactory.getInstance();
        this.content = new JPanel();
        this.settingsSep = compFactory.createSeparator(bundle.getString("MTForm.settingsSep.text"));
        this.mainSettingsPanel = new JPanel();
        this.selectedThemeLabel = new JLabel();
        this.themeComboBox = new ComboBox();
        this.isContrastModeCheckbox = new JCheckBox();
        this.highContrastCheckbox = new JCheckBox();
        this.customAccentColorLabel = new JLabel();
        this.customAccentColorChooser = new ColorPanel();
        this.overrideAccentCheckbox = new JCheckBox();
        this.fileColorsLink = new LinkLabel();
        this.advSettingsSep = compFactory.createSeparator(bundle.getString("MTForm.advancedSettingsSep.text"));
        this.tabbedPane1 = new JTabbedPane();
        this.tabPanel = new JPanel();
        this.tabsDesc = compFactory.createLabel(bundle.getString("MTForm.tabsDesc.textWithMnemonic"));
        this.activeTabHighlightCheckbox = new JCheckBox();
        this.activeTabHighlightColor = new ColorPanel();
        this.thicknessLabel = new JLabel();
        this.highlightSpinner = new JSpinner();
        this.isUpperCaseTabsCheckbox = new JCheckBox();
        this.tabHeightLabel = new JLabel();
        this.tabHeightSpinner = new JSpinner();
        this.positionLabel = new JLabel();
        this.tabHighlightPositionComboBox = new ComboBox();
        this.tabFontSizeCheckbox = new JCheckBox();
        this.tabFontSizeSpinner = new JSpinner();
        JPanel compactPanel = new JPanel();
        this.panelDesc = compFactory.createLabel(bundle.getString("MTForm.panelDesc.textWithMnemonic"));
        this.isCompactStatusbarCheckbox = new JCheckBox();
        this.isCompactTablesCheckbox = new JCheckBox();
        this.compactDropdownsCheckbox = new JCheckBox();
        this.isCompactMenusCheckbox = new JCheckBox();
        this.projectViewPanel = new JPanel();
        this.projectViewDesc = compFactory.createLabel(bundle.getString("MTForm.projectViewDesc.textWithMnemonic"));
        this.isCompactSidebarCheckbox = new JCheckBox();
        this.customSidebarSpinner = new JSpinner();
        this.customTreeIndentCheckbox = new JCheckBox();
        this.leftLabel = new JLabel();
        this.leftIndentSpinner = new JSpinner();
        this.rightLabel = new JLabel();
        this.rightSpinner = new JSpinner();
        this.selectedIndicatorLabel = new JLabel();
        this.indicatorStyleComboBox = new ComboBox();
        this.indicatorThicknessLabel = new JLabel();
        this.indicatorThicknessSpinner = new JSpinner();
        this.styledDirectoriesCheckbox = new JCheckBox();
        this.directoriesColorLink = new LinkLabel();
        this.fontSizeCheckbox = new JCheckBox();
        this.fontSizeSpinner = new JSpinner();
        this.componentsPanel = new JPanel();
        this.componentDesc = compFactory.createLabel(bundle.getString("MTForm.componentDesc.textWithMnemonic"));
        this.upperCaseButtonsCheckbox = new JCheckBox();
        this.borderedButtonsCheckbox = new JCheckBox();
        this.accentScrollbarsCheckbox = new JCheckBox();
        this.scrollbarsLink = new LinkLabel();
        this.themedScrollbarsCheckbox = new JCheckBox();
        this.accentModeCheckbox = new JCheckBox();
        this.secondAccentLabel = new JLabel();
        this.secondAccentColorChooser = new ColorPanel();
        this.tabShadowCheckbox = new JCheckBox();
        this.featuresPanel = new JPanel();
        this.featuresDesc = compFactory.createLabel(bundle.getString("MTForm.featuresDesc.textWithMnemonic"));
        this.useMaterialFontCheckbox = new JCheckBox();
        this.fileColorsCheckbox = new JCheckBox();
        this.fileStatusColorsLink = new LinkLabel();
        this.useMaterialWallpapersCheckbox = new JCheckBox();
        this.useProjectFrameCheckbox = new JCheckBox();
        this.otherTweaksPanel = new JPanel();
        this.tweaksDesc = compFactory.createLabel(bundle.getString("MTForm.tweaksDesc.textWithMnemonic"));
        this.darkTitleBarCheckbox = new JCheckBox();
        this.codeAdditionsCheckBox = new JCheckBox();
        this.isColoredOpenedDirsCheckbox = new JCheckBox();
        this.resetDefaultsButton = new JButton();
        this.content.setAutoscrolls(true);
        this.content.setRequestFocusEnabled(false);
        this.content.setVerifyInputWhenFocusTarget(false);
        this.content.setBorder(null);
        this.content.setPreferredSize(null);
        this.content.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.content.setMinimumSize(null);
        this.content.setLayout((LayoutManager)new MigLayout("insets 0,hidemode 1,aligny top,gap 0 0", "[fill]", "[][fill][fill][259,fill][]"));
        this.content.add((Component)this.settingsSep, "cell 0 0,gapx 16,gapy 10 10");
        this.mainSettingsPanel.setBorder(null);
        this.mainSettingsPanel.setLayout((LayoutManager)new MigLayout("fillx,align left center", "[grow 1,shrink 0,fill]", "[][][][grow]0[][]"));
        this.selectedThemeLabel.setText(bundle.getString("MTForm.selectedThemeLabel.text"));
        this.selectedThemeLabel.setIcon(new ImageIcon(this.getClass().getResource("/icons/mt/themeSwitch.png")));
        this.selectedThemeLabel.setFont(UIManager.getFont("ComboBox.font"));
        this.selectedThemeLabel.setIconTextGap(8);
        this.selectedThemeLabel.setToolTipText(bundle.getString("MTForm.selectedThemeLabel.toolTipText"));
        this.mainSettingsPanel.add((Component)this.selectedThemeLabel, "pad 0 2 0 0,cell 0 0,growx");
        this.themeComboBox.setToolTipText(bundle.getString("MTForm.themeComboBox.toolTipText"));
        this.mainSettingsPanel.add((Component)this.themeComboBox, "cell 1 0");
        this.isContrastModeCheckbox.setText(bundle.getString("MTForm.contrastCheckBox.text"));
        this.isContrastModeCheckbox.setToolTipText(bundle.getString("MTForm.contrastCheckBox.toolTipText"));
        this.mainSettingsPanel.add((Component)this.isContrastModeCheckbox, "cell 0 1");
        this.highContrastCheckbox.setText(bundle.getString("MTForm.highContrastCheckbox.text"));
        this.highContrastCheckbox.setToolTipText(bundle.getString("MTForm.highContrastCheckbox.toolTipText"));
        this.mainSettingsPanel.add((Component)this.highContrastCheckbox, "cell 0 2");
        this.customAccentColorLabel.setText(bundle.getString("MTForm.customAccentColorLabel.text"));
        this.customAccentColorLabel.setToolTipText(bundle.getString("MTForm.customAccentColorLabel.toolTipText"));
        this.customAccentColorLabel.setHorizontalAlignment(2);
        this.customAccentColorLabel.setIcon(new ImageIcon(this.getClass().getResource("/icons/mt/customAccent.png")));
        this.customAccentColorLabel.setIconTextGap(8);
        this.mainSettingsPanel.add((Component)this.customAccentColorLabel, "pad 0 2 0 0,cell 0 3,growx");
        this.customAccentColorChooser.setMinimumSize(new Dimension(10, 18));
        this.customAccentColorChooser.setPreferredSize(new Dimension(61, 26));
        this.mainSettingsPanel.add((Component)this.customAccentColorChooser, "cell 1 3,alignx right,growx 0");
        this.overrideAccentCheckbox.setText(bundle.getString("MTForm.overrideAccentCheckbox.text"));
        this.overrideAccentCheckbox.setFont(this.overrideAccentCheckbox.getFont().deriveFont((float)this.overrideAccentCheckbox.getFont().getSize() - 1.0f));
        this.overrideAccentCheckbox.setToolTipText(bundle.getString("MTForm.overrideAccentCheckbox.toolTipText"));
        this.overrideAccentCheckbox.addActionListener(e -> this.overrideAccentCheckboxActionPerformed(e));
        this.mainSettingsPanel.add((Component)this.overrideAccentCheckbox, "cell 0 4,gapx 20");
        this.fileColorsLink.setText(bundle.getString("MTForm.fileColorsLink.text"));
        this.fileColorsLink.setForeground(UIManager.getColor("Link.activeForeground"));
        this.fileColorsLink.setToolTipText(bundle.getString("MTForm.fileColorsLink.toolTipText"));
        this.fileColorsLink.setLabelFor(null);
        this.mainSettingsPanel.add((Component)this.fileColorsLink, "cell 0 5 2 1");
        this.content.add((Component)this.mainSettingsPanel, "cell 0 1");
        this.content.add((Component)this.advSettingsSep, "cell 0 2,aligny center,growy 0,gapx 16,gapy 10 10");
        this.tabbedPane1.setMinimumSize(null);
        this.tabbedPane1.setPreferredSize(null);
        this.tabPanel.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3,align left top", "[fill][grow1, fill]", "[][][][][][][]"));
        this.tabsDesc.setForeground(UIManager.getColor("Label.disabledForeground"));
        this.tabPanel.add((Component)this.tabsDesc, "cell 0 0 2 1");
        this.activeTabHighlightCheckbox.setText(bundle.getString("MTForm.activeTabHighlightCheckbox.text"));
        this.activeTabHighlightCheckbox.setToolTipText(bundle.getString("MTForm.activeTabHighlightCheckbox.toolTipText"));
        this.activeTabHighlightCheckbox.addActionListener(e -> this.activeTabHighlightCheckboxActionPerformed(e));
        this.tabPanel.add((Component)this.activeTabHighlightCheckbox, "cell 0 1,align left center,grow 0 0");
        this.tabPanel.add((Component)this.activeTabHighlightColor, "cell 1 1,align right center,grow 0 0");
        this.thicknessLabel.setHorizontalTextPosition(10);
        this.thicknessLabel.setLabelFor(this.highlightSpinner);
        this.thicknessLabel.setText(bundle.getString("MTForm.thicknessLabel.text"));
        this.thicknessLabel.setToolTipText(bundle.getString("MTForm.thicknessLabel.toolTipText"));
        this.tabPanel.add((Component)this.thicknessLabel, "pad 0,cell 0 2,aligny center,grow 100 0");
        this.highlightSpinner.setToolTipText(bundle.getString("MTForm.highlightSpinner.toolTipText"));
        this.tabPanel.add((Component)this.highlightSpinner, "cell 1 2,align right center,grow 0 0,width 80:80:80");
        this.isUpperCaseTabsCheckbox.setText(bundle.getString("MTForm.isUpperCaseTabsCheckbox.text"));
        this.isUpperCaseTabsCheckbox.setToolTipText(bundle.getString("MTForm.isUpperCaseTabsCheckbox.toolTipText"));
        this.tabPanel.add((Component)this.isUpperCaseTabsCheckbox, "cell 0 3,align left center,grow 0 0");
        this.tabHeightLabel.setHorizontalTextPosition(10);
        this.tabHeightLabel.setLabelFor(this.highlightSpinner);
        this.tabHeightLabel.setText(bundle.getString("MTForm.tabHeightLabel.text"));
        this.tabHeightLabel.setToolTipText(bundle.getString("MTForm.tabHeightLabel.toolTipText"));
        this.tabPanel.add((Component)this.tabHeightLabel, "pad 0,cell 0 4,aligny center,grow 100 0");
        this.tabHeightSpinner.setToolTipText(bundle.getString("MTForm.tabHeightSpinner.toolTipText"));
        this.tabPanel.add((Component)this.tabHeightSpinner, "cell 1 4,align right center,grow 0 0,width 80:80:80");
        this.positionLabel.setText(bundle.getString("MTForm.positionLabel.text"));
        this.positionLabel.setToolTipText(bundle.getString("MTForm.positionLabel.toolTipText"));
        this.tabPanel.add((Component)this.positionLabel, "cell 0 5,aligny center,growy 0");
        this.tabHighlightPositionComboBox.setToolTipText(bundle.getString("MTForm.tabHighlightPositionComboBox.toolTipText"));
        this.tabPanel.add((Component)this.tabHighlightPositionComboBox, "cell 1 5,align right center,grow 0 0,width 120:120:120");
        this.tabFontSizeCheckbox.setText(bundle.getString("MTForm.tabFontSizeCheckbox.text"));
        this.tabFontSizeCheckbox.setToolTipText(bundle.getString("MTForm.tabFontSizeCheckbox.toolTipText"));
        this.tabFontSizeCheckbox.addActionListener(e -> {
            this.fontSizeCheckboxActionPerformed(e);
            this.tabFontSizeCheckboxActionPerformed(e);
        });
        this.tabPanel.add((Component)this.tabFontSizeCheckbox, "cell 0 6");
        this.tabFontSizeSpinner.setToolTipText(bundle.getString("MTForm.tabFontSizeSpinner.toolTipText"));
        this.tabPanel.add((Component)this.tabFontSizeSpinner, "cell 1 6,align right center,grow 0 0,width 80:80:80");
        this.tabbedPane1.addTab(bundle.getString("MTForm.tabPanel.tab.title"), null, this.tabPanel, bundle.getString("MTForm.tabPanel.tab.toolTipText"));
        compactPanel.setBorder(null);
        compactPanel.setMinimumSize(null);
        compactPanel.setPreferredSize(null);
        compactPanel.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3,gap 10 5", "[grow, fill]", "[fill][][][][]"));
        this.panelDesc.setForeground(UIManager.getColor("Label.disabledForeground"));
        compactPanel.add((Component)this.panelDesc, "cell 0 0");
        this.isCompactStatusbarCheckbox.setText(bundle.getString("MTForm.isCompactStatusbarCheckbox.text"));
        this.isCompactStatusbarCheckbox.setToolTipText(bundle.getString("MTForm.isCompactStatusbarCheckbox.toolTipText"));
        compactPanel.add((Component)this.isCompactStatusbarCheckbox, "cell 0 1,align left center,grow 0 0");
        this.isCompactTablesCheckbox.setText(bundle.getString("MTForm.isCompactTablesCheckbox.text"));
        this.isCompactTablesCheckbox.setToolTipText(bundle.getString("MTForm.isCompactTablesCheckbox.toolTipText"));
        compactPanel.add((Component)this.isCompactTablesCheckbox, "cell 0 2,align left center,grow 0 0");
        this.compactDropdownsCheckbox.setText(bundle.getString("MTForm.compactDropdownsCheckbox.text"));
        this.compactDropdownsCheckbox.setToolTipText(bundle.getString("MTForm.compactDropdownsCheckbox.toolTipText"));
        compactPanel.add((Component)this.compactDropdownsCheckbox, "cell 0 3");
        this.isCompactMenusCheckbox.setText(bundle.getString("MTForm.isCompactMenusCheckbox.text"));
        this.isCompactMenusCheckbox.setToolTipText(bundle.getString("MTForm.isCompactMenusCheckbox.toolTipText"));
        compactPanel.add((Component)this.isCompactMenusCheckbox, "cell 0 4");
        this.tabbedPane1.addTab(bundle.getString("MTForm.compactPanel.tab.title"), null, compactPanel, bundle.getString("MTForm.compactPanel.tab.toolTipText"));
        this.projectViewPanel.setBorder(null);
        this.projectViewPanel.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3,align left top", "[322,fill][fill]", "[][][][][][][][]"));
        this.projectViewDesc.setForeground(UIManager.getColor("Label.disabledForeground"));
        this.projectViewPanel.add((Component)this.projectViewDesc, "cell 0 0 2 1");
        this.isCompactSidebarCheckbox.setText(bundle.getString("MTForm.isCompactSidebarCheckbox.text"));
        this.isCompactSidebarCheckbox.setToolTipText(bundle.getString("MTForm.isCompactSidebarCheckbox.toolTipText"));
        this.isCompactSidebarCheckbox.addActionListener(e -> this.isCompactSidebarCheckboxActionPerformed(e));
        this.projectViewPanel.add((Component)this.isCompactSidebarCheckbox, "cell 0 1,align left center,grow 0 0");
        this.customSidebarSpinner.setToolTipText(bundle.getString("MTForm.customSidebarSpinner.toolTipText"));
        this.projectViewPanel.add((Component)this.customSidebarSpinner, "cell 1 1,align right center,grow 0 0,width 80:80:80");
        this.customTreeIndentCheckbox.setText(bundle.getString("MTForm.customTreeIndentCheckbox.text"));
        this.customTreeIndentCheckbox.setToolTipText(bundle.getString("MTForm.customTreeIndentCheckbox.toolTipText"));
        this.customTreeIndentCheckbox.addActionListener(e -> this.customTreeIndentCheckboxActionPerformed(e));
        this.projectViewPanel.add((Component)this.customTreeIndentCheckbox, "cell 0 2,align left center,grow 0 0");
        this.leftLabel.setText(bundle.getString("MTForm.leftLabel.text"));
        this.leftLabel.setFont(this.leftLabel.getFont().deriveFont((float)this.leftLabel.getFont().getSize() - 2.0f));
        this.projectViewPanel.add((Component)this.leftLabel, "cell 1 2");
        this.leftIndentSpinner.setToolTipText(bundle.getString("MTForm.leftIndentSpinner.toolTipText"));
        this.leftIndentSpinner.setPreferredSize(new Dimension(80, 30));
        this.leftIndentSpinner.setMinimumSize(new Dimension(80, 30));
        this.projectViewPanel.add((Component)this.leftIndentSpinner, "cell 1 2");
        this.rightLabel.setText(bundle.getString("MTForm.rightLabel.text"));
        this.rightLabel.setFont(this.rightLabel.getFont().deriveFont((float)this.rightLabel.getFont().getSize() - 2.0f));
        this.projectViewPanel.add((Component)this.rightLabel, "cell 1 2");
        this.rightSpinner.setToolTipText(bundle.getString("MTForm.rightSpinner.toolTipText"));
        this.projectViewPanel.add((Component)this.rightSpinner, "cell 1 2,align right center,grow 0 0,width 80:80:80");
        this.selectedIndicatorLabel.setText(bundle.getString("MTForm.selectedIndicatorLabel.text"));
        this.selectedIndicatorLabel.setToolTipText(bundle.getString("MTForm.selectedIndicatorLabel.toolTipText"));
        this.projectViewPanel.add((Component)this.selectedIndicatorLabel, "cell 0 3");
        this.indicatorStyleComboBox.setToolTipText(bundle.getString("MTForm.indicatorStyleComboBox.toolTipText"));
        this.projectViewPanel.add((Component)this.indicatorStyleComboBox, "cell 1 3,align right center,grow 0 0,width 120:120:120");
        this.indicatorThicknessLabel.setHorizontalTextPosition(10);
        this.indicatorThicknessLabel.setLabelFor(this.highlightSpinner);
        this.indicatorThicknessLabel.setText(bundle.getString("MTForm.indicatorThicknessLabel.text"));
        this.indicatorThicknessLabel.setToolTipText(bundle.getString("MTForm.indicatorThicknessLabel.toolTipText"));
        this.projectViewPanel.add((Component)this.indicatorThicknessLabel, "pad 0 16 0 0,cell 0 4");
        this.indicatorThicknessSpinner.setToolTipText(bundle.getString("MTForm.indicatorThicknessSpinner.toolTipText"));
        this.projectViewPanel.add((Component)this.indicatorThicknessSpinner, "cell 1 4,alignx right,growx 0");
        this.styledDirectoriesCheckbox.setText(bundle.getString("MTForm.styledDirectoriesCheckbox.text"));
        this.styledDirectoriesCheckbox.setToolTipText(bundle.getString("MTForm.styledDirectoriesCheckbox.tooltipText"));
        this.projectViewPanel.add((Component)this.styledDirectoriesCheckbox, "cell 0 5");
        this.directoriesColorLink.setText(bundle.getString("MTForm.directoriesColorLink.text"));
        this.directoriesColorLink.setForeground(UIManager.getColor("Link.activeForeground"));
        this.directoriesColorLink.setHorizontalAlignment(4);
        this.directoriesColorLink.setToolTipText(bundle.getString("MTForm.directoriesColorLink.toolTipText"));
        this.projectViewPanel.add((Component)this.directoriesColorLink, "cell 1 5");
        this.fontSizeCheckbox.setText(bundle.getString("MTForm.fontSizeCheckbox.text"));
        this.fontSizeCheckbox.setToolTipText(bundle.getString("MTForm.fontSizeCheckbox.toolTipText"));
        this.fontSizeCheckbox.addActionListener(e -> this.fontSizeCheckboxActionPerformed(e));
        this.projectViewPanel.add((Component)this.fontSizeCheckbox, "cell 0 6");
        this.fontSizeSpinner.setToolTipText(bundle.getString("MTForm.fontSizeSpinner.toolTipText"));
        this.projectViewPanel.add((Component)this.fontSizeSpinner, "cell 1 6,align right center,grow 0 0,width 80:80:80");
        this.tabbedPane1.addTab(bundle.getString("MTForm.projectViewPanel.tab.title"), null, this.projectViewPanel, bundle.getString("MTForm.projectViewPanel.tab.toolTipText"));
        this.componentsPanel.setBorder(null);
        this.componentsPanel.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3,align left top", "[fill]", "[][][][][][]"));
        this.componentDesc.setForeground(UIManager.getColor("Label.disabledForeground"));
        this.componentsPanel.add((Component)this.componentDesc, "cell 0 0");
        this.upperCaseButtonsCheckbox.setText(bundle.getString("MTForm.upperCaseButtonsCheckbox.text"));
        this.upperCaseButtonsCheckbox.setToolTipText(bundle.getString("MTForm.upperCaseButtonsCheckbox.toolTipText"));
        this.componentsPanel.add((Component)this.upperCaseButtonsCheckbox, "cell 0 1");
        this.borderedButtonsCheckbox.setText(bundle.getString("MTForm.borderedButtonsCheckbox.text"));
        this.borderedButtonsCheckbox.setToolTipText(bundle.getString("MTForm.borderedButtonsCheckbox.toolTipText"));
        this.componentsPanel.add((Component)this.borderedButtonsCheckbox, "cell 0 2");
        this.accentScrollbarsCheckbox.setText(bundle.getString("MTForm.accentScrollbarsCheckbox.text"));
        this.accentScrollbarsCheckbox.setToolTipText(bundle.getString("MTForm.accentScrollbarsCheckbox.toolTipText"));
        this.componentsPanel.add((Component)this.accentScrollbarsCheckbox, "cell 0 3,align left center,grow 0 0");
        this.scrollbarsLink.setText(bundle.getString("MTForm.scrollbarsLink.text"));
        this.scrollbarsLink.setForeground(UIManager.getColor("Link.activeForeground"));
        this.scrollbarsLink.setHorizontalAlignment(4);
        this.scrollbarsLink.setToolTipText(bundle.getString("MTForm.scrollbarsLink.toolTipText"));
        this.componentsPanel.add((Component)this.scrollbarsLink, "cell 0 3");
        this.themedScrollbarsCheckbox.setText(bundle.getString("MTForm.themedScrollbarsCheckbox.text"));
        this.themedScrollbarsCheckbox.setToolTipText(bundle.getString("MTForm.themedScrollbarsCheckbox.toolTipText"));
        this.componentsPanel.add((Component)this.themedScrollbarsCheckbox, "cell 0 4");
        this.accentModeCheckbox.setText(bundle.getString("MTForm.accentModeCheckbox.text"));
        this.accentModeCheckbox.setToolTipText(bundle.getString("MTForm.accentModeCheckbox.toolTipText"));
        this.accentModeCheckbox.addActionListener(e -> this.accentModeCheckboxActionPerformed(e));
        this.componentsPanel.add((Component)this.accentModeCheckbox, "cell 0 6");
        this.secondAccentLabel.setText(bundle.getString("MTForm.secondAccentLabel.text"));
        this.secondAccentLabel.setToolTipText(bundle.getString("MTForm.secondAccentLabel.toolTipText"));
        this.componentsPanel.add((Component)this.secondAccentLabel, "cell 0 6");
        this.secondAccentColorChooser.setMinimumSize(new Dimension(10, 18));
        this.secondAccentColorChooser.setPreferredSize(new Dimension(61, 26));
        this.componentsPanel.add((Component)this.secondAccentColorChooser, "cell 0 6,alignx right,growx 0");
        this.tabShadowCheckbox.setText(bundle.getString("MTForm.tabShadowCheckbox.text"));
        this.tabShadowCheckbox.setToolTipText(bundle.getString("MTForm.tabShadowCheckbox.toolTipText"));
        this.componentsPanel.add((Component)this.tabShadowCheckbox, "cell 0 5");
        this.tabbedPane1.addTab(bundle.getString("MTForm.componentsPanel.tab.title"), null, this.componentsPanel, bundle.getString("MTForm.componentsPanel.tab.toolTipText"));
        this.featuresPanel.setBorder(null);
        this.featuresPanel.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3,align left top", "[fill][fill]", "[][][][][]"));
        this.featuresDesc.setForeground(UIManager.getColor("Label.disabledForeground"));
        this.featuresPanel.add((Component)this.featuresDesc, "cell 0 0");
        this.useMaterialFontCheckbox.setText(bundle.getString("MTForm.useMaterialFontCheckbox.text"));
        this.useMaterialFontCheckbox.setToolTipText(bundle.getString("MTForm.useMaterialFontCheckbox.tooltipText"));
        this.useMaterialFontCheckbox.addActionListener(e -> this.useMaterialFontCheckboxActionPerformed(e));
        this.featuresPanel.add((Component)this.useMaterialFontCheckbox, "cell 0 1,align left center,grow 0 0");
        this.fileColorsCheckbox.setText(bundle.getString("MTForm.fileColorsCheckbox.text"));
        this.fileColorsCheckbox.setToolTipText(bundle.getString("MTForm.fileColorsCheckbox.toolTipText"));
        this.featuresPanel.add((Component)this.fileColorsCheckbox, "cell 0 2");
        this.fileStatusColorsLink.setText(bundle.getString("MTForm.fileStatusColorsLink.text"));
        this.fileStatusColorsLink.setForeground(UIManager.getColor("Link.activeForeground"));
        this.fileStatusColorsLink.setToolTipText(bundle.getString("MTForm.fileStatusColorsLink.toolTipText"));
        this.featuresPanel.add((Component)this.fileStatusColorsLink, "cell 1 2");
        this.useMaterialWallpapersCheckbox.setText(bundle.getString("MTForm.useMaterialWallpapersCheckbox.text"));
        this.useMaterialWallpapersCheckbox.setToolTipText(bundle.getString("MTForm.useMaterialWallpapersCheckbox.toolTipText"));
        this.useMaterialWallpapersCheckbox.addActionListener(e -> this.useMaterialWallpapersCheckboxActionPerformed(e));
        this.featuresPanel.add((Component)this.useMaterialWallpapersCheckbox, "cell 0 3,align left center,grow 0 0");
        this.useProjectFrameCheckbox.setText(bundle.getString("MTForm.useProjectFrameCheckbox.text"));
        this.useProjectFrameCheckbox.setToolTipText(bundle.getString("MTForm.useProjectFrameCheckbox.toolTipText"));
        this.featuresPanel.add((Component)this.useProjectFrameCheckbox, "cell 0 4,align left center,grow 0 0");
        this.tabbedPane1.addTab(bundle.getString("MTForm.featuresPanel.tab.title"), null, this.featuresPanel, bundle.getString("MTForm.featuresPanel.tab.toolTipText"));
        this.otherTweaksPanel.setBorder(null);
        this.otherTweaksPanel.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3,align left top", "[fill]", "[][][][]"));
        this.tweaksDesc.setForeground(UIManager.getColor("Label.disabledForeground"));
        this.otherTweaksPanel.add((Component)this.tweaksDesc, "cell 0 0");
        this.darkTitleBarCheckbox.setText(bundle.getString("MTForm.themedTitleBarCheckbox.text"));
        this.darkTitleBarCheckbox.setToolTipText(bundle.getString("MTForm.themedTitleBarCheckbox.toolTipText"));
        this.otherTweaksPanel.add((Component)this.darkTitleBarCheckbox, "cell 0 1,align left center,grow 0 0");
        this.codeAdditionsCheckBox.setText(bundle.getString("MTForm.codeAdditionsCheckBox.text"));
        this.codeAdditionsCheckBox.setToolTipText(bundle.getString("MTForm.codeAdditionsCheckBox.toolTipText"));
        this.otherTweaksPanel.add((Component)this.codeAdditionsCheckBox, "cell 0 2,align left center,grow 0 0");
        this.isColoredOpenedDirsCheckbox.setText(bundle.getString("MTForm.isColoredOpenedDirsCheckbox.text"));
        this.isColoredOpenedDirsCheckbox.setToolTipText(bundle.getString("MTForm.isColoredOpenedDirsCheckbox.toolTipText"));
        this.otherTweaksPanel.add((Component)this.isColoredOpenedDirsCheckbox, "cell 0 3,align left center,grow 0 0");
        this.tabbedPane1.addTab(bundle.getString("MTForm.otherTweaksPanel.tab.title"), null, this.otherTweaksPanel, bundle.getString("MTForm.otherTweaksPanel.tab.toolTipText"));
        this.content.add((Component)this.tabbedPane1, "pad 0,cell 0 3,growx,gapx 10 10,gapy 10 10");
        this.resetDefaultsButton.setText(bundle.getString("MTForm.resetDefaultsButton.text"));
        this.resetDefaultsButton.setToolTipText(bundle.getString("MTForm.resetDefaultsButton.toolTipText"));
        this.resetDefaultsButton.addActionListener(e -> this.resetDefaultsButtonActionPerformed(e));
        this.content.add((Component)this.resetDefaultsButton, "pad 0,cell 0 4,align trailing center,grow 0 0,wmin 200");
    }

    @Override
    public final void setupComponents() {
        MTConfig config = MTConfig.getInstance();
        int highlightThickness = MTUiUtils.valueInRange(config.getHighlightThickness(), 1, 5);
        int tabsHeight = MTUiUtils.valueInRange(config.getTabsHeight(), 10, 60);
        int rightTreeIndent = MTUiUtils.valueInRange(config.getRightTreeIndent(), 0, 40);
        int leftTreeIndent = MTUiUtils.valueInRange(config.getLeftTreeIndent(), 0, 40);
        int customSidebarHeight = MTUiUtils.valueInRange(config.getCustomSidebarHeight(), 18, 36);
        int treeFontSize = MTUiUtils.valueInRange(config.getTreeFontSize(), 6, 24);
        int tabFontSize = MTUiUtils.valueInRange(config.getTabFontSize(), 6, 24);
        int selectedTabIndex = MTUiUtils.valueInRange(config.getSettingsSelectedTab(), 0, 6);
        this.highlightSpinnerModel = new SpinnerNumberModel(highlightThickness, 1, 5, 1);
        this.highlightSpinner.setModel(this.highlightSpinnerModel);
        this.tabsHeightSpinnerModel = new SpinnerNumberModel(tabsHeight, 10, 60, 1);
        this.tabHeightSpinner.setModel(this.tabsHeightSpinnerModel);
        this.leftTreeIndentModel = new SpinnerNumberModel(leftTreeIndent, 0, 40, 2);
        this.leftIndentSpinner.setModel(this.leftTreeIndentModel);
        this.rightTreeIndentModel = new SpinnerNumberModel(rightTreeIndent, 0, 40, 2);
        this.rightSpinner.setModel(this.rightTreeIndentModel);
        this.customSidebarHeightModel = new SpinnerNumberModel(customSidebarHeight, 18, 36, 2);
        this.customSidebarSpinner.setModel(this.customSidebarHeightModel);
        this.tabFontSizeModel = new SpinnerNumberModel(tabFontSize, 6, 24, 1);
        this.tabFontSizeSpinner.setModel(this.tabFontSizeModel);
        this.treeFontSizeModel = new SpinnerNumberModel(treeFontSize, 6, 24, 1);
        this.fontSizeSpinner.setModel(this.treeFontSizeModel);
        this.indicatorThicknessSpinnerModel = new SpinnerNumberModel(highlightThickness, 1, 5, 1);
        this.indicatorThicknessSpinner.setModel(this.indicatorThicknessSpinnerModel);
        this.fileColorsLink.setIcon(IconLoader.findIcon((String)"icons/mt/link2.svg"));
        this.directoriesColorLink.setIcon(IconLoader.findIcon((String)"icons/mt/link2.svg"));
        this.fileStatusColorsLink.setIcon(IconLoader.findIcon((String)"icons/mt/link2.svg"));
        this.scrollbarsLink.setIcon(IconLoader.findIcon((String)"icons/mt/link2.svg"));
        this.darkTitleBarCheckbox.addActionListener(this::isDarkTitleBarActionPerformed);
        this.darkTitleBarCheckbox.setEnabled(SystemInfo.isWin10OrNewer || SystemInfo.isMac);
        this.themeComboBox.setModel(new DefaultComboBoxModel<MTThemeFacade>(MTThemes.getAllThemes()));
        this.themeComboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<MTThemeFacade>(){

            public void customize(JList list, MTThemeFacade value, int index, boolean selected, boolean hasFocus) {
                if (value == null) {
                    return;
                }
                Icon baseIcon = value.getIcon();
                this.setIcon(baseIcon);
                this.setText(value.getThemeName());
            }
        });
        this.indicatorStyleComboBox.setModel(new DefaultComboBoxModel<IndicatorStyles>(IndicatorStyles.values()));
        this.tabHighlightPositionComboBox.setModel(new DefaultComboBoxModel<TabHighlightPositions>(TabHighlightPositions.values()));
        this.fileColorsLink.setListener((aSource, aLinkData) -> {
            Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)this.content));
            if (settings != null) {
                settings.select(settings.find(MTCustomThemeConfigurable.class));
            }
        }, null);
        this.fileStatusColorsLink.setListener((aSource, aLinkData) -> {
            SearchableConfigurable subConfigurable;
            Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)this.content));
            if (settings != null && (subConfigurable = Objects.requireNonNull((ColorAndFontOptions)settings.find(ColorAndFontOptions.class)).findSubConfigurable(MTFileColorsPage.class)) != null) {
                settings.select((Configurable)subConfigurable);
            }
        }, null);
        this.directoriesColorLink.setListener((aSource, aLinkData) -> {
            SearchableConfigurable subConfigurable;
            Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)this.content));
            if (settings != null && (subConfigurable = Objects.requireNonNull((ColorAndFontOptions)settings.find(ColorAndFontOptions.class)).findSubConfigurable(MTFileColorsPage.class)) != null) {
                settings.select((Configurable)subConfigurable, "Directories");
            }
        }, null);
        this.disablePremiumFeatures();
    }

    private static int valueInRange(int value, int min, int max) {
        return Integer.min(max, Integer.max(value, min));
    }

    public static void showFontWarningDialog() {
        Messages.showWarningDialog((String)MaterialThemeBundle.message("MTForm.useMaterialFonts.warning.message", new Object[0]), (String)MaterialThemeBundle.message("MTForm.useMaterialFonts.warning.title", new Object[0]));
    }

    private static void showTitleBarDialog() {
        Messages.showWarningDialog((String)MaterialThemeBundle.message("MTForm.themedTitleBar.warning.message", new Object[0]), (String)MaterialThemeBundle.message("MTForm.themedTitleBar.warning.title", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightColor", "com/mallowigi/idea/config/ui/MTForm", "setHighlightColor"));
    }
}

