/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.config;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.util.ui.UIUtil;
import com.mallowigi.idea.config.ui.MTFormUI;
import java.util.Objects;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class MTConfigurableBase<FORM extends MTFormUI, CONFIG extends PersistentStateComponent>
extends BaseConfigurable {
    @Nullable
    private volatile FORM form;

    MTConfigurableBase() {
    }

    protected abstract void setFormState(FORM var1, @NotNull CONFIG var2);

    @NotNull
    protected abstract CONFIG getConfig();

    @NotNull
    protected abstract FORM createForm();

    protected abstract void doApply(FORM var1, @Nullable CONFIG var2) throws ConfigurationException;

    protected abstract boolean checkModified(FORM var1, @Nullable CONFIG var2);

    public final boolean isModified() {
        this.setModified(this.checkModified(this.form, this.getConfig()));
        return super.isModified();
    }

    @Nullable
    public final JComponent createComponent() {
        this.initComponent();
        this.setFormState(this.form, this.getConfig());
        return ((MTFormUI)Objects.requireNonNull(this.form)).getContent();
    }

    public final void apply() throws ConfigurationException {
        this.initComponent();
        this.doApply(this.form, this.getConfig());
    }

    public final void reset() {
        this.initComponent();
        this.setFormState(this.form, this.getConfig());
    }

    public final synchronized void disposeUIResources() {
        this.dispose();
        if (this.form != null) {
            ((MTFormUI)Objects.requireNonNull(this.form)).dispose();
        }
        this.form = null;
    }

    private void dispose() {
    }

    @Nullable
    final FORM getForm() {
        return this.form;
    }

    private synchronized void initComponent() {
        if (this.form == null) {
            this.form = (MTFormUI)UIUtil.invokeAndWaitIfNeeded(() -> {
                FORM myForm = this.createForm();
                myForm.init();
                return myForm;
            });
        }
    }
}

