/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.annotators.settings;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.mallowigi.idea.annotators.PHPAnnotator;
import com.mallowigi.idea.annotators.settings.BaseColorSettings;
import com.mallowigi.idea.messages.MaterialThemeBundle;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PHPColorSettings
extends BaseColorSettings {
    @NonNls
    private static final AttributesDescriptor[] PHP_ATTRIBUTES;
    @NonNls
    private static final Map<String, TextAttributesKey> PHP_DESCRIPTORS;
    private static final TextAttributesKey PHPKEYWORD;
    private static final TextAttributesKey VARIABLE;
    private static final TextAttributesKey CLASS;
    private static final TextAttributesKey NUMBER;
    private static final TextAttributesKey CONSTANT;
    private static final TextAttributesKey FN;
    private static final TextAttributesKey FUNCTION;
    private static final TextAttributesKey THIS_SELF;
    private static final TextAttributesKey MODIFIER;
    private static final TextAttributesKey STATIC_FINAL;
    private static final TextAttributesKey USE_NAMESPACE;
    private static final TextAttributesKey NULL;
    private static final TextAttributesKey PRIMITIVE;
    private static final TextAttributesKey EXIT;
    private static final TextAttributesKey ECHO;

    private static Map<String, TextAttributesKey> createAdditionalHlAttrs() {
        THashMap descriptors = new THashMap();
        descriptors.put("string", DefaultLanguageHighlighterColors.STRING);
        descriptors.put("keyword", PHPKEYWORD);
        descriptors.put("function", FUNCTION);
        descriptors.put("class", CLASS);
        descriptors.put("const", CONSTANT);
        descriptors.put("num", NUMBER);
        descriptors.put("var", VARIABLE);
        descriptors.put("fn", FN);
        descriptors.put("use", USE_NAMESPACE);
        descriptors.put("static", STATIC_FINAL);
        descriptors.put("modifier", MODIFIER);
        descriptors.put("self", THIS_SELF);
        descriptors.put("primitive", PRIMITIVE);
        descriptors.put("null", NULL);
        descriptors.put("echo", ECHO);
        descriptors.put("exit", EXIT);
        return descriptors;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.FileTypes.JavaScript;
        if (icon == null) {
            PHPColorSettings.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        Language lang = (Language)ObjectUtils.notNull((Object)Language.findLanguageByID((String)"PHP"), (Object)Language.ANY);
        SyntaxHighlighter syntaxHighlighter = PHPColorSettings.getSyntaxHighlighterWithFallback(lang);
        if (syntaxHighlighter == null) {
            PHPColorSettings.$$$reportNull$$$0(1);
        }
        return syntaxHighlighter;
    }

    @NonNls
    @NotNull
    public String getDemoText() {
        return "<use>namespace</use> <class>Foo\\Bar\\Baz</class>;\n\n<use>use</use> <class>SomeClass</class>;\n\n<static>final</static> <keyword>class</keyword> <class>MyClass</class> <keyword>extends</keyword> <class>MyOtherClass</class> {\n    <modifier>public</modifier> <keyword>const</keyword> <var>SINGLE</var> = <num>1</num>;\n    <modifier>private</modifier> <var>$variable</var> = <primitive>true</primitive>;\n    <modifier>protected</modifier> <var>$arguments</var> = <fn>array</fn>(<primitive>null</primitive>, <primitive>false</primitive>);\n}\n\n<modifier>public</modifier> <function>function</function> <fn>getVar</fn>() {\n    <echo>echo</echo> <string>\"Returning myself\"</string>;\n    <keyword>return</keyword> <self>self</self>::<var>variable</var>;\n}\n\n<exit>die</exit>(<num>1</num>);";
    }

    @NotNull
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        Map<String, TextAttributesKey> map = Collections.unmodifiableMap(PHP_DESCRIPTORS);
        if (map == null) {
            PHPColorSettings.$$$reportNull$$$0(2);
        }
        return map;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        if (PHP_ATTRIBUTES == null) {
            PHPColorSettings.$$$reportNull$$$0(3);
        }
        return PHP_ATTRIBUTES;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            PHPColorSettings.$$$reportNull$$$0(4);
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public String getDisplayName() {
        String string = MaterialThemeBundle.message("PHPColorPage.php.additions", new Object[0]);
        if (string == null) {
            PHPColorSettings.$$$reportNull$$$0(5);
        }
        return string;
    }

    public DisplayPriority getPriority() {
        return PlatformUtils.isPhpStorm() ? DisplayPriority.KEY_LANGUAGE_SETTINGS : DisplayPriority.LANGUAGE_SETTINGS;
    }

    static {
        PHP_DESCRIPTORS = new THashMap();
        PHPKEYWORD = (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"PHP_KEYWORD"), (Object)DefaultLanguageHighlighterColors.KEYWORD);
        VARIABLE = (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"PHP_VAR"), (Object)DefaultLanguageHighlighterColors.LOCAL_VARIABLE);
        CLASS = (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"PHP_CLASS"), (Object)DefaultLanguageHighlighterColors.CLASS_NAME);
        NUMBER = (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"PHP_NUMBER"), (Object)DefaultLanguageHighlighterColors.NUMBER);
        CONSTANT = (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"PHP_CONSTANT"), (Object)DefaultLanguageHighlighterColors.CONSTANT);
        FN = (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"PHP_FUNCTION_CALL"), (Object)DefaultLanguageHighlighterColors.FUNCTION_CALL);
        FUNCTION = PHPAnnotator.FUNCTION;
        THIS_SELF = PHPAnnotator.THIS_SELF;
        MODIFIER = PHPAnnotator.MODIFIER;
        STATIC_FINAL = PHPAnnotator.STATIC_FINAL;
        USE_NAMESPACE = PHPAnnotator.USE_NAMESPACE;
        NULL = PHPAnnotator.NULL;
        PRIMITIVE = PHPAnnotator.PRIMITIVE;
        EXIT = PHPAnnotator.EXIT;
        ECHO = PHPAnnotator.ECHO;
        PHP_ATTRIBUTES = new AttributesDescriptor[]{new AttributesDescriptor(MaterialThemeBundle.message("php.keywords.function", new Object[0]), FUNCTION), new AttributesDescriptor(MaterialThemeBundle.message("php.keywords.self", new Object[0]), THIS_SELF), new AttributesDescriptor(MaterialThemeBundle.message("php.keywords.private.public.protected", new Object[0]), MODIFIER), new AttributesDescriptor(MaterialThemeBundle.message("php.keywords.static.final", new Object[0]), STATIC_FINAL), new AttributesDescriptor(MaterialThemeBundle.message("php.keywords.use.namespace", new Object[0]), USE_NAMESPACE), new AttributesDescriptor(MaterialThemeBundle.message("php.keywords.true.false", new Object[0]), PRIMITIVE), new AttributesDescriptor(MaterialThemeBundle.message("php.keywords.null", new Object[0]), NULL), new AttributesDescriptor(MaterialThemeBundle.message("php.keywords.exit.die", new Object[0]), EXIT), new AttributesDescriptor(MaterialThemeBundle.message("php.keywords.echo", new Object[0]), ECHO)};
        PHP_DESCRIPTORS.putAll(PHPColorSettings.createAdditionalHlAttrs());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/mallowigi/idea/annotators/settings/PHPColorSettings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalHighlightingTagToDescriptorMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

