/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.annotators.settings;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.util.ObjectUtils;
import com.mallowigi.idea.annotators.KotlinAnnotator;
import com.mallowigi.idea.annotators.settings.BaseColorSettings;
import com.mallowigi.idea.messages.MaterialThemeBundle;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class KotlinColorSettings
extends BaseColorSettings {
    @NotNull
    @NonNls
    private static final AttributesDescriptor[] KOTLIN_ATTRIBUTES;
    @NonNls
    private static final Map<String, TextAttributesKey> KOTLIN_DESCRIPTORS;
    public static final TextAttributesKey THIS_SUPER;
    private static final TextAttributesKey MODIFIER;
    private static final TextAttributesKey COMPANION;
    private static final TextAttributesKey DATA;
    private static final TextAttributesKey OP_INFIX;
    private static final TextAttributesKey NULL_UNIT;
    public static final TextAttributesKey IMPORT_PACKAGE;
    private static final TextAttributesKey SEALED_OVERRIDE;
    private static final TextAttributesKey PRIMITIVE;

    @NotNull
    private static Map<String, TextAttributesKey> createAdditionalHlAttrs() {
        THashMap descriptors = new THashMap();
        descriptors.put("field", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"INSTANCE_FIELD_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.INSTANCE_FIELD));
        descriptors.put("unusedField", CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES);
        descriptors.put("error", CodeInsightColors.ERRORS_ATTRIBUTES);
        descriptors.put("warning", CodeInsightColors.WARNINGS_ATTRIBUTES);
        descriptors.put("weak_warning", CodeInsightColors.WEAK_WARNING_ATTRIBUTES);
        descriptors.put("server_problems", CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING);
        descriptors.put("server_duplicate", CodeInsightColors.DUPLICATE_FROM_SERVER);
        descriptors.put("unknownType", CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES);
        descriptors.put("localVar", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"LOCAL_VARIABLE_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.LOCAL_VARIABLE));
        descriptors.put("reassignedLocalVar", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"REASSIGNED_LOCAL_VARIABLE_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.REASSIGNED_LOCAL_VARIABLE));
        descriptors.put("reassignedParameter", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"REASSIGNED_PARAMETER_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.REASSIGNED_PARAMETER));
        descriptors.put("implicitAnonymousParameter", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"IMPLICIT_ANONYMOUS_CLASS_PARAMETER_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.CLASS_NAME));
        descriptors.put("static", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"STATIC_FIELD_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.STATIC_FIELD));
        descriptors.put("static_final", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"STATIC_FINAL_FIELD_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.STATIC_FIELD));
        descriptors.put("deprecated", CodeInsightColors.DEPRECATED_ATTRIBUTES);
        descriptors.put("for_removal", CodeInsightColors.MARKED_FOR_REMOVAL_ATTRIBUTES);
        descriptors.put("constructorCall", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"CONSTRUCTOR_CALL_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.FUNCTION_CALL));
        descriptors.put("constructorDeclaration", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"CONSTRUCTOR_DECLARATION_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.FUNCTION_DECLARATION));
        descriptors.put("methodCall", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"METHOD_CALL_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.FUNCTION_CALL));
        descriptors.put("methodDeclaration", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"METHOD_DECLARATION_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.FUNCTION_DECLARATION));
        descriptors.put("static_method", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"STATIC_METHOD_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.STATIC_METHOD));
        descriptors.put("abstract_method", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"ABSTRACT_METHOD_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.FUNCTION_CALL));
        descriptors.put("inherited_method", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"INHERITED_METHOD_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.FUNCTION_CALL));
        descriptors.put("param", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"PARAMETER_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.PARAMETER));
        descriptors.put("lambda_param", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"LAMBDA_PARAMETER_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.PARAMETER));
        descriptors.put("class", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"CLASS_NAME_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.CLASS_NAME));
        descriptors.put("anonymousClass", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"ANONYMOUS_CLASS_NAME_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.CLASS_NAME));
        descriptors.put("typeParameter", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"TYPE_PARAMETER_NAME_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.PARAMETER));
        descriptors.put("abstractClass", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"ABSTRACT_CLASS_NAME_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.CLASS_NAME));
        descriptors.put("interface", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"INTERFACE_NAME_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.INTERFACE_NAME));
        descriptors.put("enum", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"ENUM_NAME_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.CLASS_NAME));
        descriptors.put("annotationName", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"ANNOTATION_NAME_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.METADATA));
        descriptors.put("annotationAttributeName", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"ANNOTATION_ATTRIBUTE_NAME_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.METADATA));
        descriptors.put("javadocTagValue", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"DOC_COMMENT_TAG_VALUE"), (Object)DefaultLanguageHighlighterColors.DOC_COMMENT_TAG_VALUE));
        descriptors.put("instanceFinalField", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"INSTANCE_FINAL_FIELD_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.INSTANCE_FIELD));
        descriptors.put("staticallyConstImported", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"STATIC_FINAL_FIELD_IMPORTED_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.STATIC_FIELD));
        descriptors.put("staticallyImported", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"STATIC_FIELD_IMPORTED_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.STATIC_FIELD));
        descriptors.put("static_imported_method", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"STATIC_METHOD_CALL_IMPORTED_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.STATIC_METHOD));
        descriptors.put("string", DefaultLanguageHighlighterColors.STRING);
        descriptors.put("number", DefaultLanguageHighlighterColors.NUMBER);
        descriptors.put("val", DefaultLanguageHighlighterColors.KEYWORD);
        descriptors.put("keyword", DefaultLanguageHighlighterColors.KEYWORD);
        descriptors.put("this", THIS_SUPER);
        descriptors.put("modifier", MODIFIER);
        descriptors.put("companion", COMPANION);
        descriptors.put("data", DATA);
        descriptors.put("infix", OP_INFIX);
        descriptors.put("null", NULL_UNIT);
        descriptors.put("import", IMPORT_PACKAGE);
        descriptors.put("sealed", SEALED_OVERRIDE);
        descriptors.put("primitive", PRIMITIVE);
        THashMap tHashMap = descriptors;
        if (tHashMap == null) {
            KotlinColorSettings.$$$reportNull$$$0(0);
        }
        return tHashMap;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Javaee.Home;
        if (icon == null) {
            KotlinColorSettings.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        Language lang = (Language)ObjectUtils.notNull((Object)Language.findLanguageByID((String)"kotlin"), (Object)Language.ANY);
        SyntaxHighlighter syntaxHighlighter = KotlinColorSettings.getSyntaxHighlighterWithFallback(lang);
        if (syntaxHighlighter == null) {
            KotlinColorSettings.$$$reportNull$$$0(2);
        }
        return syntaxHighlighter;
    }

    @NonNls
    @NotNull
    public String getDemoText() {
        return "<import>import</import> java.util.*\n\n<import>package</import> myPackage.hello\n\n<sealed>open</sealed> <keyword>class</keyword> <class>MyClass</class> {\n    <modifier>private</modifier> <val>val</val> <instanceFinalField>fooBar</instanceFinalField> = \"\";\n\n    <modifier>protected</modifier> <sealed>open</sealed> <keyword>fun</keyword> <methodDeclaration>foo</methodDeclaration>(): <null>Unit</null>? {\n        <val>val</val> values = <methodCall>listOf</methodCall>(<primitive>true</primitive>, <null>null</null>, <primitive>false</primitive>)\n        <methodCall>println</methodCall>(<localVar>values</localVar>)\n        <keyword>return</keyword> <null>null</null>\n    }\n\n    <modifier>internal</modifier> <keyword>fun</keyword> <methodDeclaration>bar</methodDeclaration>() {\n        <keyword>return</keyword> <null>Unit</null>\n    }\n}\n\n<sealed>sealed</sealed> <keyword>class</keyword> <class>MySealedClass</class> : <constructorCall>MyClass</constructorCall>() {\n    <sealed>override</sealed> <keyword>fun</keyword> <methodDeclaration>foo</methodDeclaration>(): <null>Unit</null>? {\n        <methodCall>println</methodCall>(<string>\"overriden\"</string>)\n        <keyword>return</keyword> <null>null</null>\n    }\n\n    <companion>companion</companion> <companion>object</companion> {\n        <keyword>fun</keyword> <methodDeclaration>create</methodDeclaration>(): <class>MyClass</class> {\n            <keyword>return</keyword> <constructorCall>MyClass</constructorCall>()\n        }\n    }\n}\n\n<data>data</data> <keyword>class</keyword> <class>MyDataClass</class>(<val>val</val> <param>num</param>: <class>Int</class>) {\n    <modifier>public</modifier> <infix>operator</infix> <infix>infix</infix> <keyword>fun</keyword> <methodDeclaration>plus</methodDeclaration>(<param>to</param>: <class>Int</class>) {\n        <keyword>return</keyword> <this>this</this> + <param>to</param>\n    }\n}\n";
    }

    @NotNull
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        Map<String, TextAttributesKey> map = Collections.unmodifiableMap(KOTLIN_DESCRIPTORS);
        if (map == null) {
            KotlinColorSettings.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        if (KOTLIN_ATTRIBUTES == null) {
            KotlinColorSettings.$$$reportNull$$$0(4);
        }
        return KOTLIN_ATTRIBUTES;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            KotlinColorSettings.$$$reportNull$$$0(5);
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public String getDisplayName() {
        String string = MaterialThemeBundle.message("KotlinColorPage.kotlin.additions", new Object[0]);
        if (string == null) {
            KotlinColorSettings.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public DisplayPriority getPriority() {
        DisplayPriority displayPriority = DisplayPriority.LANGUAGE_SETTINGS;
        if (displayPriority == null) {
            KotlinColorSettings.$$$reportNull$$$0(7);
        }
        return displayPriority;
    }

    static {
        KOTLIN_DESCRIPTORS = new THashMap();
        THIS_SUPER = KotlinAnnotator.THIS_SUPER;
        MODIFIER = KotlinAnnotator.MODIFIER;
        COMPANION = KotlinAnnotator.COMPANION;
        DATA = KotlinAnnotator.DATA;
        OP_INFIX = KotlinAnnotator.OP_INFIX;
        NULL_UNIT = KotlinAnnotator.NULL_UNIT;
        IMPORT_PACKAGE = KotlinAnnotator.IMPORT_PACKAGE;
        SEALED_OVERRIDE = KotlinAnnotator.SEALED_OVERRIDE;
        PRIMITIVE = KotlinAnnotator.PRIMITIVE;
        KOTLIN_ATTRIBUTES = new AttributesDescriptor[]{new AttributesDescriptor(MaterialThemeBundle.message("keywords.this.super", new Object[0]), THIS_SUPER), new AttributesDescriptor(MaterialThemeBundle.message("keywords.private.public.internal", new Object[0]), MODIFIER), new AttributesDescriptor(MaterialThemeBundle.message("keywords.companion", new Object[0]), COMPANION), new AttributesDescriptor(MaterialThemeBundle.message("keywords.null.unit", new Object[0]), NULL_UNIT), new AttributesDescriptor(MaterialThemeBundle.message("keywords.import.package", new Object[0]), IMPORT_PACKAGE), new AttributesDescriptor(MaterialThemeBundle.message("keywords.true.false", new Object[0]), PRIMITIVE), new AttributesDescriptor(MaterialThemeBundle.message("keywords.data", new Object[0]), DATA), new AttributesDescriptor(MaterialThemeBundle.message("keywords.sealed.override.open", new Object[0]), SEALED_OVERRIDE), new AttributesDescriptor(MaterialThemeBundle.message("keywords.operator.infix", new Object[0]), OP_INFIX)};
        KOTLIN_DESCRIPTORS.putAll(KotlinColorSettings.createAdditionalHlAttrs());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/mallowigi/idea/annotators/settings/KotlinColorSettings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalHlAttrs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalHighlightingTagToDescriptorMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

