/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.annotators.settings;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.mallowigi.idea.annotators.JavaAnnotator;
import com.mallowigi.idea.annotators.settings.BaseColorSettings;
import com.mallowigi.idea.messages.MaterialThemeBundle;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaColorSettings
extends BaseColorSettings {
    @NotNull
    @NonNls
    private static final AttributesDescriptor[] JAVA_ATTRIBUTES;
    @NonNls
    private static final Map<String, TextAttributesKey> JAVA_DESCRIPTORS;
    private static final TextAttributesKey JAVA_KEYWORD;
    private static final TextAttributesKey THIS_SUPER;
    private static final TextAttributesKey MODIFIER;
    private static final TextAttributesKey STATIC_FINAL;
    private static final TextAttributesKey IMPORT_PACKAGE;
    private static final TextAttributesKey PRIMITIVE;

    @NotNull
    private static Map<String, TextAttributesKey> createAdditionalHlAttrs() {
        THashMap descriptors = new THashMap();
        descriptors.put("field", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"INSTANCE_FIELD_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.INSTANCE_FIELD));
        descriptors.put("unusedField", CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES);
        descriptors.put("error", CodeInsightColors.ERRORS_ATTRIBUTES);
        descriptors.put("warning", CodeInsightColors.WARNINGS_ATTRIBUTES);
        descriptors.put("weak_warning", CodeInsightColors.WEAK_WARNING_ATTRIBUTES);
        descriptors.put("server_problems", CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING);
        descriptors.put("server_duplicate", CodeInsightColors.DUPLICATE_FROM_SERVER);
        descriptors.put("unknownType", CodeInsightColors.WRONG_REFERENCES_ATTRIBUTES);
        descriptors.put("localVar", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"LOCAL_VARIABLE_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.LOCAL_VARIABLE));
        descriptors.put("reassignedLocalVar", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"REASSIGNED_LOCAL_VARIABLE_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.REASSIGNED_LOCAL_VARIABLE));
        descriptors.put("reassignedParameter", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"REASSIGNED_PARAMETER_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.REASSIGNED_PARAMETER));
        descriptors.put("implicitAnonymousParameter", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"IMPLICIT_ANONYMOUS_CLASS_PARAMETER_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.CLASS_NAME));
        descriptors.put("static", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"STATIC_FIELD_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.STATIC_FIELD));
        descriptors.put("static_final", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"STATIC_FINAL_FIELD_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.STATIC_FIELD));
        descriptors.put("deprecated", CodeInsightColors.DEPRECATED_ATTRIBUTES);
        descriptors.put("for_removal", CodeInsightColors.MARKED_FOR_REMOVAL_ATTRIBUTES);
        descriptors.put("constructorCall", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"CONSTRUCTOR_CALL_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.FUNCTION_CALL));
        descriptors.put("constructorDeclaration", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"CONSTRUCTOR_DECLARATION_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.FUNCTION_DECLARATION));
        descriptors.put("methodCall", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"METHOD_CALL_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.FUNCTION_CALL));
        descriptors.put("methodDeclaration", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"METHOD_DECLARATION_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.FUNCTION_DECLARATION));
        descriptors.put("static_method", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"STATIC_METHOD_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.STATIC_METHOD));
        descriptors.put("abstract_method", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"ABSTRACT_METHOD_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.FUNCTION_CALL));
        descriptors.put("inherited_method", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"INHERITED_METHOD_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.FUNCTION_CALL));
        descriptors.put("param", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"PARAMETER_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.PARAMETER));
        descriptors.put("lambda_param", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"LAMBDA_PARAMETER_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.PARAMETER));
        descriptors.put("class", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"CLASS_NAME_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.CLASS_NAME));
        descriptors.put("anonymousClass", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"ANONYMOUS_CLASS_NAME_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.CLASS_NAME));
        descriptors.put("typeParameter", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"TYPE_PARAMETER_NAME_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.PARAMETER));
        descriptors.put("abstractClass", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"ABSTRACT_CLASS_NAME_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.CLASS_NAME));
        descriptors.put("interface", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"INTERFACE_NAME_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.INTERFACE_NAME));
        descriptors.put("enum", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"ENUM_NAME_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.CLASS_NAME));
        descriptors.put("annotationName", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"ANNOTATION_NAME_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.METADATA));
        descriptors.put("annotationAttributeName", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"ANNOTATION_ATTRIBUTE_NAME_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.METADATA));
        descriptors.put("javadocTagValue", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"DOC_COMMENT_TAG_VALUE"), (Object)DefaultLanguageHighlighterColors.DOC_COMMENT_TAG_VALUE));
        descriptors.put("instanceFinalField", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"INSTANCE_FINAL_FIELD_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.INSTANCE_FIELD));
        descriptors.put("staticallyConstImported", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"STATIC_FINAL_FIELD_IMPORTED_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.STATIC_FIELD));
        descriptors.put("staticallyImported", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"STATIC_FIELD_IMPORTED_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.STATIC_FIELD));
        descriptors.put("static_imported_method", (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"STATIC_METHOD_CALL_IMPORTED_ATTRIBUTES"), (Object)DefaultLanguageHighlighterColors.STATIC_METHOD));
        descriptors.put("keyword", JAVA_KEYWORD);
        descriptors.put("this", THIS_SUPER);
        descriptors.put("sf", STATIC_FINAL);
        descriptors.put("modifier", MODIFIER);
        descriptors.put("import", IMPORT_PACKAGE);
        descriptors.put("null", PRIMITIVE);
        THashMap tHashMap = descriptors;
        if (tHashMap == null) {
            JavaColorSettings.$$$reportNull$$$0(0);
        }
        return tHashMap;
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.FileTypes.Java;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        Language lang = (Language)ObjectUtils.notNull((Object)Language.findLanguageByID((String)"JAVA"), (Object)Language.ANY);
        SyntaxHighlighter syntaxHighlighter = JavaColorSettings.getSyntaxHighlighterWithFallback(lang);
        if (syntaxHighlighter == null) {
            JavaColorSettings.$$$reportNull$$$0(1);
        }
        return syntaxHighlighter;
    }

    @NonNls
    @NotNull
    public String getDemoText() {
        return "<import>package</import> com.info.package;\n\n<import>import</import> java.awt.*;\n\npublic class <class>SomeClass</class> extends <class>BaseClass</class> {\n  <modifier>private</modifier> <sf>static final</sf> <field>field</field> = null;\n  <modifier>protected</modifier> <sf>final</sf> <field>otherField</field>;\n\n  <modifier>public</modifier> <constructorDeclaration>SomeClass</constructorDeclaration>(<interface>AnInterface</interface> <param>param1</param>, int[] <reassignedParameter>reassignedParam</reassignedParameter>,\n                  int <param>param2</param>\n                  int <param>param3</param>) {\n    <this>super</this>(<param>param1</param>);\n    <this>this</this>.<warning>field</warning> = <param>param1</param>;\n    <this>this</this>.<warning>unused</warning> = <null>null</null>;\n    <keyword>return</keyword> <null>true</null> || <null>false</null>;\n  }\n }\n";
    }

    @NotNull
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        Map<String, TextAttributesKey> map = Collections.unmodifiableMap(JAVA_DESCRIPTORS);
        if (map == null) {
            JavaColorSettings.$$$reportNull$$$0(2);
        }
        return map;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        if (JAVA_ATTRIBUTES == null) {
            JavaColorSettings.$$$reportNull$$$0(3);
        }
        return JAVA_ATTRIBUTES;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            JavaColorSettings.$$$reportNull$$$0(4);
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public String getDisplayName() {
        String string = MaterialThemeBundle.message("JavaColorPage.java.additions", new Object[0]);
        if (string == null) {
            JavaColorSettings.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public DisplayPriority getPriority() {
        DisplayPriority displayPriority = PlatformUtils.isIntelliJ() ? DisplayPriority.KEY_LANGUAGE_SETTINGS : DisplayPriority.LANGUAGE_SETTINGS;
        if (displayPriority == null) {
            JavaColorSettings.$$$reportNull$$$0(6);
        }
        return displayPriority;
    }

    static {
        JAVA_DESCRIPTORS = new THashMap();
        JAVA_KEYWORD = JavaAnnotator.JAVA_KEYWORD;
        THIS_SUPER = JavaAnnotator.THIS_SUPER;
        MODIFIER = JavaAnnotator.MODIFIER;
        STATIC_FINAL = JavaAnnotator.STATIC_FINAL;
        IMPORT_PACKAGE = JavaAnnotator.IMPORT_PACKAGE;
        PRIMITIVE = JavaAnnotator.PRIMITIVE;
        JAVA_ATTRIBUTES = new AttributesDescriptor[]{new AttributesDescriptor(MaterialThemeBundle.message("keywords.this.super", new Object[0]), THIS_SUPER), new AttributesDescriptor(MaterialThemeBundle.message("keywords.private.public.protected", new Object[0]), MODIFIER), new AttributesDescriptor(MaterialThemeBundle.message("keywords.static.final", new Object[0]), STATIC_FINAL), new AttributesDescriptor(MaterialThemeBundle.message("keywords.import.package", new Object[0]), IMPORT_PACKAGE), new AttributesDescriptor(MaterialThemeBundle.message("keywords.primitives", new Object[0]), PRIMITIVE)};
        JAVA_DESCRIPTORS.putAll(JavaColorSettings.createAdditionalHlAttrs());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/mallowigi/idea/annotators/settings/JavaColorSettings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalHlAttrs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalHighlightingTagToDescriptorMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

