/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.annotators.settings;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.mallowigi.idea.annotators.JSAnnotator;
import com.mallowigi.idea.annotators.settings.BaseColorSettings;
import com.mallowigi.idea.messages.MaterialThemeBundle;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class JSColorSettings
extends BaseColorSettings {
    @NotNull
    @NonNls
    private static final AttributesDescriptor[] JS_ATTRIBUTES;
    @NonNls
    static final Map<String, TextAttributesKey> JS_DESCRIPTORS;
    private static final TextAttributesKey JS_KEYWORD;
    private static final TextAttributesKey JS_NUMBER;
    private static final TextAttributesKey VARIABLE;
    private static final TextAttributesKey FUNCTION;
    private static final TextAttributesKey THIS_SUPER;
    private static final TextAttributesKey MODULE;
    private static final TextAttributesKey CONSOLE;
    private static final TextAttributesKey DEBUGGER;
    private static final TextAttributesKey NULL;
    private static final TextAttributesKey PRIMITIVE;
    private static final TextAttributesKey VAL;
    private static final TextAttributesKey FUNCTION_NAME;

    @NotNull
    private static Map<String, TextAttributesKey> createAdditionalHlAttrs() {
        THashMap descriptors = new THashMap();
        descriptors.put("string", DefaultLanguageHighlighterColors.STRING);
        descriptors.put("keyword", JS_KEYWORD);
        descriptors.put("function", FUNCTION);
        descriptors.put("function_name", FUNCTION_NAME);
        descriptors.put("val", VAL);
        descriptors.put("local_variable", VARIABLE);
        descriptors.put("this", THIS_SUPER);
        descriptors.put("null", NULL);
        descriptors.put("primitive", PRIMITIVE);
        descriptors.put("debugger", DEBUGGER);
        descriptors.put("import", MODULE);
        descriptors.put("console", CONSOLE);
        descriptors.put("number", JS_NUMBER);
        descriptors.put("inst_field", DefaultLanguageHighlighterColors.INSTANCE_FIELD);
        THashMap tHashMap = descriptors;
        if (tHashMap == null) {
            JSColorSettings.$$$reportNull$$$0(0);
        }
        return tHashMap;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.FileTypes.JavaScript;
        if (icon == null) {
            JSColorSettings.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        Language lang = (Language)ObjectUtils.notNull((Object)Language.findLanguageByID((String)"JavaScript"), (Object)Language.ANY);
        SyntaxHighlighter syntaxHighlighter = JSColorSettings.getSyntaxHighlighterWithFallback(lang);
        if (syntaxHighlighter == null) {
            JSColorSettings.$$$reportNull$$$0(2);
        }
        return syntaxHighlighter;
    }

    @NonNls
    @NotNull
    public String getDemoText() {
        return "<import>import</import> <local_variable>_</local_variable> <import>from</import> <string>'lodash'</string>;\n\n<function>function</function> <function_name>foo</function_name>() {\n  <val>var</val> <local_variable>x</local_variable> = <number>10</number>;\n  <this>this</this>.<inst_field>x</inst_field> = <null>null</null>;\n  <keyword>if</keyword> (<local_variable>x</local_variable> === <null>undefined</null>) {\n    <console>console</console>.<function>log</function>(<string>'foo'</string>);\n    <debugger>debugger</debugger>;\n    <keyword>return</keyword> <primitive>false</primitive>;\n  }\n  <keyword>return</keyword> <primitive>true</primitive>;\n}\n";
    }

    @NotNull
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        Map<String, TextAttributesKey> map = Collections.unmodifiableMap(JS_DESCRIPTORS);
        if (map == null) {
            JSColorSettings.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        if (JS_ATTRIBUTES == null) {
            JSColorSettings.$$$reportNull$$$0(4);
        }
        return JS_ATTRIBUTES;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        if (ColorDescriptor.EMPTY_ARRAY == null) {
            JSColorSettings.$$$reportNull$$$0(5);
        }
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public String getDisplayName() {
        String string = MaterialThemeBundle.message("JSColorPage.java.additions", new Object[0]);
        if (string == null) {
            JSColorSettings.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public DisplayPriority getPriority() {
        DisplayPriority displayPriority = PlatformUtils.isWebStorm() ? DisplayPriority.KEY_LANGUAGE_SETTINGS : DisplayPriority.LANGUAGE_SETTINGS;
        if (displayPriority == null) {
            JSColorSettings.$$$reportNull$$$0(7);
        }
        return displayPriority;
    }

    static {
        JS_DESCRIPTORS = new THashMap();
        JS_KEYWORD = JSAnnotator.JS_KEYWORD;
        JS_NUMBER = JSAnnotator.JS_NUMBER;
        VARIABLE = (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"JS.LOCAL_VARIABLE"), (Object)DefaultLanguageHighlighterColors.LOCAL_VARIABLE);
        FUNCTION = JSAnnotator.FUNCTION;
        THIS_SUPER = JSAnnotator.THIS_SUPER;
        MODULE = JSAnnotator.MODULE;
        CONSOLE = JSAnnotator.CONSOLE;
        DEBUGGER = JSAnnotator.DEBUGGER;
        NULL = JSAnnotator.NULL;
        PRIMITIVE = JSAnnotator.PRIMITIVE;
        VAL = JSAnnotator.VAL;
        FUNCTION_NAME = JSAnnotator.FUNCTION;
        JS_ATTRIBUTES = new AttributesDescriptor[]{new AttributesDescriptor(MaterialThemeBundle.message("keywords.this.super", new Object[0]), THIS_SUPER), new AttributesDescriptor(MaterialThemeBundle.message("keywords.module.import.export.from", new Object[0]), MODULE), new AttributesDescriptor(MaterialThemeBundle.message("keywords.debugger", new Object[0]), DEBUGGER), new AttributesDescriptor(MaterialThemeBundle.message("keywords.null.undefined", new Object[0]), NULL), new AttributesDescriptor(MaterialThemeBundle.message("keywords.true.false", new Object[0]), PRIMITIVE), new AttributesDescriptor(MaterialThemeBundle.message("keywords.var.let.const", new Object[0]), VAL), new AttributesDescriptor(MaterialThemeBundle.message("keywords.var.console", new Object[0]), CONSOLE), new AttributesDescriptor(MaterialThemeBundle.message("keywords.function", new Object[0]), FUNCTION)};
        JS_DESCRIPTORS.putAll(JSColorSettings.createAdditionalHlAttrs());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/mallowigi/idea/annotators/settings/JSColorSettings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalHlAttrs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalHighlightingTagToDescriptorMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

