/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.annotators;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.mallowigi.idea.annotators.BaseAnnotator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TSAnnotator
extends BaseAnnotator {
    public static final TextAttributesKey KEYWORD = (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"TS.KEYWORD"), (Object)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey NUMBER = (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"TS.NUMBER"), (Object)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey THIS_SUPER = TextAttributesKey.createTextAttributesKey((String)"TS.THIS_SUPER", (TextAttributesKey)KEYWORD);
    public static final TextAttributesKey MODULE = TextAttributesKey.createTextAttributesKey((String)"TS.MODULE_KEYWORD", (TextAttributesKey)KEYWORD);
    public static final TextAttributesKey DEBUGGER = TextAttributesKey.createTextAttributesKey((String)"TS.DEBUGGER_STMT", (TextAttributesKey)KEYWORD);
    public static final TextAttributesKey CONSOLE = TextAttributesKey.createTextAttributesKey((String)"TS.CONSOLE", (TextAttributesKey)KEYWORD);
    public static final TextAttributesKey NULL = TextAttributesKey.createTextAttributesKey((String)"TS.NULL_UNDEFINED", (TextAttributesKey)NUMBER);
    public static final TextAttributesKey VAL = TextAttributesKey.createTextAttributesKey((String)"TS.VAR_DEF", (TextAttributesKey)KEYWORD);
    public static final TextAttributesKey FUNCTION = TextAttributesKey.createTextAttributesKey((String)"TS.FUNCTION", (TextAttributesKey)KEYWORD);
    public static final TextAttributesKey PRIVATE = TextAttributesKey.createTextAttributesKey((String)"TS.PRIVATE_PUBLIC", (TextAttributesKey)KEYWORD);
    public static final TextAttributesKey DECLARE = TextAttributesKey.createTextAttributesKey((String)"TS.DECLARE", (TextAttributesKey)KEYWORD);
    public static final TextAttributesKey TYPE_ALIAS = TextAttributesKey.createTextAttributesKey((String)"TS.TYPE_ALIAS", (TextAttributesKey)KEYWORD);
    public static final TextAttributesKey PRIMITIVE = TextAttributesKey.createTextAttributesKey((String)"TS.PRIMITIVE", (TextAttributesKey)NUMBER);

    @Override
    @Nullable
    public TextAttributesKey getKeywordKind(@NotNull PsiElement element) {
        if (element == null) {
            TSAnnotator.$$$reportNull$$$0(0);
        }
        TextAttributesKey kind = null;
        switch (element.getText()) {
            case "this": 
            case "super": {
                kind = THIS_SUPER;
                break;
            }
            case "export": 
            case "import": 
            case "require": 
            case "from": 
            case "default": 
            case "module": {
                kind = MODULE;
                break;
            }
            case "debugger": {
                kind = DEBUGGER;
                break;
            }
            case "null": 
            case "undefined": {
                kind = NULL;
                break;
            }
            case "true": 
            case "false": {
                kind = PRIMITIVE;
                break;
            }
            case "var": 
            case "let": 
            case "const": {
                kind = VAL;
                break;
            }
            case "function": {
                kind = FUNCTION;
                break;
            }
            case "console": {
                kind = CONSOLE;
                break;
            }
            case "public": 
            case "protected": 
            case "private": {
                kind = PRIVATE;
                break;
            }
            case "declare": {
                kind = DECLARE;
                break;
            }
            case "type": 
            case "alias": {
                kind = TYPE_ALIAS;
                break;
            }
        }
        return kind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/mallowigi/idea/annotators/TSAnnotator", "getKeywordKind"));
    }
}

