/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.annotators;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.mallowigi.idea.annotators.BaseAnnotator;
import org.jetbrains.annotations.NotNull;

public final class PHPAnnotator
extends BaseAnnotator {
    public static final TextAttributesKey PHP_KEYWORD = (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"PHP_KEYWORD"), (Object)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey PHP_FUNCTION = (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"PHP_FUNCTION_CALL"), (Object)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey PHP_NUMBER = (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"PHP_NUMBER"), (Object)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey MODIFIER = TextAttributesKey.createTextAttributesKey((String)"PHP.MODIFIER", (TextAttributesKey)PHP_KEYWORD);
    public static final TextAttributesKey STATIC_FINAL = TextAttributesKey.createTextAttributesKey((String)"PHP.STATIC_FINAL", (TextAttributesKey)PHP_KEYWORD);
    public static final TextAttributesKey THIS_SELF = TextAttributesKey.createTextAttributesKey((String)"PHP.THIS_SELF", (TextAttributesKey)PHP_KEYWORD);
    public static final TextAttributesKey USE_NAMESPACE = TextAttributesKey.createTextAttributesKey((String)"PHP.USE_NAMESPACE", (TextAttributesKey)PHP_KEYWORD);
    public static final TextAttributesKey FUNCTION = TextAttributesKey.createTextAttributesKey((String)"PHP.FUNCTION", (TextAttributesKey)PHP_KEYWORD);
    public static final TextAttributesKey PRIMITIVE = TextAttributesKey.createTextAttributesKey((String)"PHP.PRIMITIVE", (TextAttributesKey)PHP_NUMBER);
    public static final TextAttributesKey NULL = TextAttributesKey.createTextAttributesKey((String)"PHP.NULL", (TextAttributesKey)PHP_NUMBER);
    public static final TextAttributesKey EXIT = TextAttributesKey.createTextAttributesKey((String)"PHP.EXIT", (TextAttributesKey)PHP_FUNCTION);
    public static final TextAttributesKey ECHO = TextAttributesKey.createTextAttributesKey((String)"PHP.ECHO", (TextAttributesKey)PHP_FUNCTION);

    @Override
    protected TextAttributesKey getKeywordKind(@NotNull PsiElement element) {
        if (element == null) {
            PHPAnnotator.$$$reportNull$$$0(0);
        }
        TextAttributesKey kind = null;
        switch (element.getText()) {
            case "private": 
            case "public": 
            case "protected": {
                kind = MODIFIER;
                break;
            }
            case "static": 
            case "final": {
                kind = STATIC_FINAL;
                break;
            }
            case "self": {
                kind = THIS_SELF;
                break;
            }
            case "use": 
            case "namespace": {
                kind = USE_NAMESPACE;
                break;
            }
            case "true": 
            case "false": {
                kind = PRIMITIVE;
                break;
            }
            case "null": {
                kind = NULL;
                break;
            }
            case "exit": 
            case "die": {
                kind = EXIT;
                break;
            }
            case "function": {
                kind = FUNCTION;
                break;
            }
            case "echo": {
                kind = ECHO;
                break;
            }
        }
        return kind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/mallowigi/idea/annotators/PHPAnnotator", "getKeywordKind"));
    }
}

