/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.annotators;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.mallowigi.idea.annotators.BaseAnnotator;
import com.mallowigi.idea.annotators.JavaAnnotator;
import org.jetbrains.annotations.NotNull;

public final class KotlinAnnotator
extends BaseAnnotator {
    private static final TextAttributesKey KOTLIN_KEYWORD = (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"KOTLIN_KEYWORD"), (Object)DefaultLanguageHighlighterColors.KEYWORD);
    private static final TextAttributesKey KOTLIN_NUMBER = (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"KOTLIN_NUMBER"), (Object)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey MODIFIER = TextAttributesKey.createTextAttributesKey((String)"KOTLIN.MODIFIER", (TextAttributesKey)JavaAnnotator.MODIFIER);
    public static final TextAttributesKey COMPANION = TextAttributesKey.createTextAttributesKey((String)"KOTLIN.COMPANION", (TextAttributesKey)JavaAnnotator.STATIC_FINAL);
    public static final TextAttributesKey DATA = TextAttributesKey.createTextAttributesKey((String)"KOTLIN.DATA", (TextAttributesKey)JavaAnnotator.STATIC_FINAL);
    public static final TextAttributesKey OP_INFIX = TextAttributesKey.createTextAttributesKey((String)"KOTLIN.OP_INFIX", (TextAttributesKey)JavaAnnotator.STATIC_FINAL);
    public static final TextAttributesKey THIS_SUPER = TextAttributesKey.createTextAttributesKey((String)"KOTLIN.THIS_SUPER", (TextAttributesKey)JavaAnnotator.THIS_SUPER);
    public static final TextAttributesKey NULL_UNIT = TextAttributesKey.createTextAttributesKey((String)"KOTLIN.NULL_UNIT", (TextAttributesKey)JavaAnnotator.PRIMITIVE);
    public static final TextAttributesKey IMPORT_PACKAGE = TextAttributesKey.createTextAttributesKey((String)"KOTLIN.IMPORT_PACKAGE", (TextAttributesKey)JavaAnnotator.IMPORT_PACKAGE);
    public static final TextAttributesKey SEALED_OVERRIDE = TextAttributesKey.createTextAttributesKey((String)"KOTLIN.SEALED_OVERRIDE", (TextAttributesKey)JavaAnnotator.STATIC_FINAL);
    public static final TextAttributesKey PRIMITIVE = TextAttributesKey.createTextAttributesKey((String)"KOTLIN.PRIMITIVE", (TextAttributesKey)JavaAnnotator.PRIMITIVE);

    @Override
    protected TextAttributesKey getKeywordKind(@NotNull PsiElement element) {
        if (element == null) {
            KotlinAnnotator.$$$reportNull$$$0(0);
        }
        TextAttributesKey kind = null;
        switch (element.getText()) {
            case "private": 
            case "public": 
            case "protected": 
            case "internal": {
                kind = MODIFIER;
                break;
            }
            case "sealed": 
            case "open": 
            case "override": {
                kind = SEALED_OVERRIDE;
                break;
            }
            case "object": 
            case "companion": {
                kind = COMPANION;
                break;
            }
            case "data": {
                kind = DATA;
                break;
            }
            case "operator": 
            case "infix": {
                kind = OP_INFIX;
                break;
            }
            case "this": 
            case "super": {
                kind = THIS_SUPER;
                break;
            }
            case "null": 
            case "Unit": {
                kind = NULL_UNIT;
                break;
            }
            case "import": 
            case "package": {
                kind = IMPORT_PACKAGE;
                break;
            }
            case "true": 
            case "false": {
                kind = PRIMITIVE;
                break;
            }
        }
        return kind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/mallowigi/idea/annotators/KotlinAnnotator", "getKeywordKind"));
    }
}

