/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.annotators;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.mallowigi.idea.annotators.BaseAnnotator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaAnnotator
extends BaseAnnotator {
    public static final TextAttributesKey JAVA_KEYWORD = (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"JAVA_KEYWORD"), (Object)DefaultLanguageHighlighterColors.KEYWORD);
    private static final TextAttributesKey JAVA_NUMBER = (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"JAVA_NUMBER"), (Object)DefaultLanguageHighlighterColors.NUMBER);
    public static final TextAttributesKey MODIFIER = TextAttributesKey.createTextAttributesKey((String)"JAVA.MODIFIER", (TextAttributesKey)JAVA_KEYWORD);
    public static final TextAttributesKey STATIC_FINAL = TextAttributesKey.createTextAttributesKey((String)"JAVA.STATIC_FINAL", (TextAttributesKey)JAVA_KEYWORD);
    public static final TextAttributesKey THIS_SUPER = TextAttributesKey.createTextAttributesKey((String)"JAVA.THIS_SUPER", (TextAttributesKey)JAVA_KEYWORD);
    public static final TextAttributesKey IMPORT_PACKAGE = TextAttributesKey.createTextAttributesKey((String)"JAVA.IMPORT_PACKAGE", (TextAttributesKey)JAVA_KEYWORD);
    public static final TextAttributesKey PRIMITIVE = TextAttributesKey.createTextAttributesKey((String)"JAVA.PRIMITIVE", (TextAttributesKey)JAVA_NUMBER);

    @Override
    @Nullable
    protected TextAttributesKey getKeywordKind(@NotNull PsiElement element) {
        if (element == null) {
            JavaAnnotator.$$$reportNull$$$0(0);
        }
        TextAttributesKey kind = null;
        switch (element.getText()) {
            case "private": 
            case "public": 
            case "protected": {
                kind = MODIFIER;
                break;
            }
            case "static": 
            case "final": {
                kind = STATIC_FINAL;
                break;
            }
            case "this": 
            case "super": {
                kind = THIS_SUPER;
                break;
            }
            case "import": 
            case "package": {
                kind = IMPORT_PACKAGE;
                break;
            }
            case "null": 
            case "true": 
            case "false": {
                kind = PRIMITIVE;
                break;
            }
        }
        return kind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/mallowigi/idea/annotators/JavaAnnotator", "getKeywordKind"));
    }
}

