/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.annotators;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.mallowigi.idea.annotators.BaseAnnotator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSAnnotator
extends BaseAnnotator {
    public static final TextAttributesKey JS_KEYWORD = (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"JS.KEYWORD"), (Object)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey JS_NUMBER = (TextAttributesKey)ObjectUtils.notNull((Object)TextAttributesKey.find((String)"JS.NUMBER"), (Object)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey THIS_SUPER = TextAttributesKey.createTextAttributesKey((String)"JS.THIS_SUPER", (TextAttributesKey)JS_KEYWORD);
    public static final TextAttributesKey MODULE = TextAttributesKey.createTextAttributesKey((String)"JS.MODULE_KEYWORD", (TextAttributesKey)JS_KEYWORD);
    public static final TextAttributesKey DEBUGGER = TextAttributesKey.createTextAttributesKey((String)"JS.DEBUGGER_STMT", (TextAttributesKey)JS_KEYWORD);
    public static final TextAttributesKey CONSOLE = TextAttributesKey.createTextAttributesKey((String)"JS.CONSOLE", (TextAttributesKey)JS_KEYWORD);
    public static final TextAttributesKey NULL = TextAttributesKey.createTextAttributesKey((String)"JS.NULL_UNDEFINED", (TextAttributesKey)JS_NUMBER);
    public static final TextAttributesKey VAL = TextAttributesKey.createTextAttributesKey((String)"JS.VAR_DEF", (TextAttributesKey)JS_KEYWORD);
    public static final TextAttributesKey FUNCTION = TextAttributesKey.createTextAttributesKey((String)"JS.FUNCTION", (TextAttributesKey)JS_KEYWORD);
    public static final TextAttributesKey PRIMITIVE = TextAttributesKey.createTextAttributesKey((String)"JS.PRIMITIVE", (TextAttributesKey)JS_NUMBER);

    @Override
    @Nullable
    protected TextAttributesKey getKeywordKind(@NotNull PsiElement element) {
        if (element == null) {
            JSAnnotator.$$$reportNull$$$0(0);
        }
        TextAttributesKey kind = null;
        switch (element.getText()) {
            case "this": 
            case "super": {
                kind = THIS_SUPER;
                break;
            }
            case "export": 
            case "import": 
            case "require": 
            case "from": 
            case "default": 
            case "module": {
                kind = MODULE;
                break;
            }
            case "debugger": {
                kind = DEBUGGER;
                break;
            }
            case "null": 
            case "undefined": {
                kind = NULL;
                break;
            }
            case "true": 
            case "false": {
                kind = PRIMITIVE;
                break;
            }
            case "var": 
            case "let": 
            case "const": {
                kind = VAL;
                break;
            }
            case "function": {
                kind = FUNCTION;
                break;
            }
            case "console": {
                kind = CONSOLE;
                break;
            }
        }
        return kind;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/mallowigi/idea/annotators/JSAnnotator", "getKeywordKind"));
    }
}

