/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea.annotators;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.mallowigi.idea.MTConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseAnnotator
implements Annotator {
    BaseAnnotator() {
    }

    public final void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            BaseAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            BaseAnnotator.$$$reportNull$$$0(1);
        }
        if (!MTConfig.getInstance().isCodeAdditionsEnabled()) {
            return;
        }
        if (element instanceof LeafPsiElement) {
            if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class) != null) {
                return;
            }
            TextAttributesKey kind = this.getKeywordKind(element);
            if (kind == null) {
                return;
            }
            TextRange textRange = element.getTextRange();
            TextRange range = new TextRange(textRange.getStartOffset(), textRange.getEndOffset());
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(range).textAttributes(kind).highlightType(ProblemHighlightType.LIKE_UNUSED_SYMBOL).create();
        }
    }

    @Nullable
    protected abstract TextAttributesKey getKeywordKind(@NotNull PsiElement var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/mallowigi/idea/annotators/BaseAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

