/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea;

import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.history.integration.ui.views.RevisionsList;
import com.intellij.ide.actions.Switcher;
import com.intellij.ide.bookmarks.actions.MnemonicChooser;
import com.intellij.ide.navigationToolbar.ui.NavBarUIManager;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.keymap.impl.ui.MouseShortcutPanel;
import com.intellij.openapi.roots.ui.configuration.JavaModuleSourceRootEditHandler;
import com.intellij.openapi.roots.ui.configuration.JavaTestSourceRootEditHandler;
import com.intellij.ui.DarculaColors;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.ui.tabs.impl.SingleHeightTabs;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.ui.MTActionButtonLook;
import com.mallowigi.idea.ui.MTNavBarUI;
import com.mallowigi.idea.utils.MTUI;
import com.mallowigi.idea.utils.MTUiUtils;
import com.mallowigi.idea.utils.StaticPatcher;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import javax.swing.UIManager;

public enum UIReplacer {
    DEFAULT;


    public static void patchUI() {
        try {
            UIReplacer.patchCompletionPopup();
            UIReplacer.patchTabs();
            UIReplacer.patchGrays();
            UIReplacer.patchNavBar();
            UIReplacer.patchIdeaActionButton();
            UIReplacer.patchOnMouseOver();
            UIReplacer.patchAndroid();
            UIReplacer.patchKotlin();
            UIReplacer.patchAttributes();
            UIReplacer.patchKeymap();
            UIReplacer.patchBookmarks();
            UIReplacer.patchJavaModules();
            UIReplacer.patchColors();
            UIReplacer.patchScopes();
            if (!PlatformUtils.isCodeWithMeGuest()) {
                UIReplacer.patchLocalHistory();
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private static void patchBookmarks() throws NoSuchFieldException, IllegalAccessException {
        StaticPatcher.setFinalStatic(MnemonicChooser.class, "OCCUPIED_CELL_COLOR", MTUI.Button.getSelectedBackgroundColor());
        StaticPatcher.setFinalStatic(MnemonicChooser.class, "FREE_CELL_COLOR", MTUI.Button.getBackgroundColor());
    }

    private static void patchJavaModules() throws NoSuchFieldException, IllegalAccessException {
        StaticPatcher.setFinalStatic(JavaModuleSourceRootEditHandler.class, "SOURCES_COLOR", MTUI.MTColor.BLUE);
        StaticPatcher.setFinalStatic(JavaTestSourceRootEditHandler.class, "TESTS_COLOR", MTUI.MTColor.GREEN);
    }

    private static void patchColors() throws NoSuchFieldException, IllegalAccessException {
        StaticPatcher.setFinalStatic(JBColor.class, "blue", MTUI.Panel.getAccentColor());
        StaticPatcher.setFinalStatic(JBColor.class, "BLUE", MTUI.Panel.getAccentColor());
        StaticPatcher.setFinalStatic(JBColor.class, "orange", new JBColor(MTUI.MTColor.ORANGE, MTUI.MTColor.DARK_ORANGE));
        StaticPatcher.setFinalStatic(JBColor.class, "ORANGE", new JBColor(MTUI.MTColor.ORANGE, MTUI.MTColor.DARK_ORANGE));
        StaticPatcher.setFinalStatic(JBColor.class, "pink", new JBColor(MTUI.MTColor.PINK, MTUI.MTColor.DARK_PINK));
        StaticPatcher.setFinalStatic(JBColor.class, "PINK", new JBColor(MTUI.MTColor.PINK, MTUI.MTColor.DARK_PINK));
        StaticPatcher.setFinalStatic(JBColor.class, "yellow", new JBColor(MTUI.MTColor.YELLOW, MTUI.MTColor.DARK_YELLOW));
        StaticPatcher.setFinalStatic(JBColor.class, "YELLOW", new JBColor(MTUI.MTColor.YELLOW, MTUI.MTColor.DARK_YELLOW));
        StaticPatcher.setFinalStatic(JBColor.class, "green", new JBColor(MTUI.MTColor.GREEN, MTUI.MTColor.DARK_GREEN));
        StaticPatcher.setFinalStatic(JBColor.class, "GREEN", new JBColor(MTUI.MTColor.GREEN, MTUI.MTColor.DARK_GREEN));
        StaticPatcher.setFinalStatic(JBColor.class, "magenta", new JBColor(MTUI.MTColor.PURPLE, MTUI.MTColor.DARK_PURPLE));
        StaticPatcher.setFinalStatic(JBColor.class, "MAGENTA", new JBColor(MTUI.MTColor.PURPLE, MTUI.MTColor.DARK_PURPLE));
        StaticPatcher.setFinalStatic(JBColor.class, "cyan", new JBColor(MTUI.MTColor.CYAN, MTUI.MTColor.DARK_CYAN));
        StaticPatcher.setFinalStatic(JBColor.class, "CYAN", new JBColor(MTUI.MTColor.CYAN, MTUI.MTColor.DARK_CYAN));
        StaticPatcher.setFinalStatic(JBColor.class, "white", MTUI.Panel.getBackground());
        StaticPatcher.setFinalStatic(JBColor.class, "WHITE", MTUI.Panel.getBackground());
        StaticPatcher.setFinalStatic(JBColor.class, "black", MTUI.Panel.getForeground());
        StaticPatcher.setFinalStatic(JBColor.class, "BLACK", MTUI.Panel.getForeground());
        StaticPatcher.setFinalStatic(JBColor.class, "gray", MTUI.Panel.getPrimaryForeground());
        StaticPatcher.setFinalStatic(JBColor.class, "GRAY", MTUI.Panel.getPrimaryForeground());
        StaticPatcher.setFinalStatic(JBColor.class, "lightGray", MTUiUtils.toJBColor(MTUiUtils.brighter(MTUI.Panel.getPrimaryForeground(), 4)));
        StaticPatcher.setFinalStatic(JBColor.class, "LIGHT_GRAY", MTUiUtils.toJBColor(MTUiUtils.brighter(MTUI.Panel.getPrimaryForeground(), 4)));
        StaticPatcher.setFinalStatic(JBColor.class, "darkGray", MTUiUtils.toJBColor(MTUiUtils.darker(MTUI.Panel.getPrimaryForeground(), 4)));
        StaticPatcher.setFinalStatic(JBColor.class, "DARK_GRAY", MTUiUtils.toJBColor(MTUiUtils.darker(MTUI.Panel.getPrimaryForeground(), 4)));
        StaticPatcher.setFinalStatic(DarculaColors.class, "BLUE", MTUI.Panel.getAccentColor());
        StaticPatcher.setFinalStatic(DarculaColors.class, "RED", MTUI.Panel.getAccentColor());
        StaticPatcher.setFinalStatic(PlatformColors.class, "BLUE", MTUI.Panel.getAccentColor());
        StaticPatcher.setFinalStatic(LightColors.class, "BLUE", new JBColor(MTUI.MTColor.BLUE, MTUI.MTColor.DARK_BLUE));
        StaticPatcher.setFinalStatic(LightColors.class, "RED", new JBColor(MTUI.MTColor.RED, MTUI.MTColor.DARK_RED));
        StaticPatcher.setFinalStatic(LightColors.class, "YELLOW", new JBColor(MTUI.MTColor.YELLOW, MTUI.MTColor.DARK_YELLOW));
        StaticPatcher.setFinalStatic(LightColors.class, "GREEN", new JBColor(MTUI.MTColor.GREEN, MTUI.MTColor.DARK_GREEN));
        StaticPatcher.setFinalStatic(LightColors.class, "CYAN", new JBColor(MTUI.MTColor.CYAN, MTUI.MTColor.DARK_CYAN));
    }

    private static void patchOnMouseOver() throws NoSuchFieldException, IllegalAccessException {
        StaticPatcher.setFinalStatic(Switcher.class, "ON_MOUSE_OVER_BG_COLOR", UIUtil.getListSelectionBackground((boolean)true));
    }

    private static void patchLocalHistory() throws NoSuchFieldException, IllegalAccessException {
        StaticPatcher.setFinalStatic(RevisionsList.MyCellRenderer.class, "USER_LABEL_COLOR", MTUI.Panel.getAccentColor());
    }

    private static void patchKeymap() throws NoSuchFieldException, IllegalAccessException {
        StaticPatcher.setFinalStatic(MouseShortcutPanel.class, "BACKGROUND", MTUI.Panel.getSecondaryBackground());
        StaticPatcher.setFinalStatic(MouseShortcutPanel.class, "BORDER", MTUI.Panel.getSecondaryBackground());
        StaticPatcher.setFinalStatic(MouseShortcutPanel.class, "FOREGROUND", MTUI.Panel.getForeground());
    }

    private static void patchGrays() throws NoSuchFieldException, IllegalAccessException {
        Gray gray = Gray._85;
        Color alphaGray = gray.withAlpha(1);
        StaticPatcher.setFinalStatic(Gray.class, "_85", alphaGray);
        StaticPatcher.setFinalStatic(Gray.class, "_40", alphaGray);
        StaticPatcher.setFinalStatic(Gray.class, "_145", alphaGray);
        StaticPatcher.setFinalStatic(Gray.class, "_201", alphaGray);
        StaticPatcher.setFinalStatic(Gray.class, "_90", gray.withAlpha(25));
        boolean dark = MTConfig.getInstance().getSelectedTheme().isDark();
        StaticPatcher.setFinalStatic(Gray.class, "_15", dark ? Gray._15.withAlpha(255) : Gray._200.withAlpha(15));
    }

    private static void patchAndroid() throws NoSuchFieldException, IllegalAccessException {
        Color panelBackground = MTUI.Panel.getBackground();
        Color contrastBackground = MTUI.Panel.getContrastBackground();
        Color secondaryBackground = MTUI.Panel.getSecondaryBackground();
        Color highlightBackground = MTUI.Panel.getHighlightBackground();
        try {
            Class<?> uiUtils = Class.forName("com.android.tools.idea.assistant.view.UIUtils");
            StaticPatcher.setFinalStatic(uiUtils, "AS_STANDARD_BACKGROUND_COLOR", panelBackground);
            StaticPatcher.setFinalStatic(uiUtils, "BACKGROUND_COLOR", panelBackground);
            StaticPatcher.setFinalStatic(uiUtils, "SECONDARY_COLOR", secondaryBackground);
            Class<?> wizardConstants = Class.forName("com.android.tools.idea.wizard.WizardConstants");
            StaticPatcher.setFinalStatic(wizardConstants, "ANDROID_NPW_HEADER_COLOR", panelBackground);
            Class<?> navColorSet = Class.forName("com.android.tools.idea.naveditor.scene.NavColorSet");
            StaticPatcher.setFinalStatic(navColorSet, "BACKGROUND_COLOR", contrastBackground);
            StaticPatcher.setFinalStatic(navColorSet, "FRAME_COLOR", contrastBackground);
            StaticPatcher.setFinalStatic(navColorSet, "HIGHLIGHTED_FRAME_COLOR", highlightBackground);
            StaticPatcher.setFinalStatic(navColorSet, "SUBDUED_FRAME_COLOR", highlightBackground);
            StaticPatcher.setFinalStatic(navColorSet, "SUBDUED_BACKGROUND_COLOR", panelBackground);
            StaticPatcher.setFinalStatic(navColorSet, "COMPONENT_BACKGROUND_COLOR", secondaryBackground);
            StaticPatcher.setFinalStatic(navColorSet, "LIST_MOUSEOVER_COLOR", secondaryBackground);
            StaticPatcher.setFinalStatic(navColorSet, "PLACEHOLDER_BACKGROUND_COLOR", secondaryBackground);
            Class<?> studioColors = Class.forName("com.android.tools.adtui.common.StudioColorsKt");
            StaticPatcher.setFinalStatic(studioColors, "primaryPanelBackground", new JBColor(contrastBackground, contrastBackground));
            StaticPatcher.setFinalStatic(studioColors, "secondaryPanelBackground", panelBackground);
            StaticPatcher.setFinalStatic(studioColors, "border", panelBackground);
            StaticPatcher.setFinalStatic(studioColors, "borderLight", secondaryBackground);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static void patchKotlin() throws NoSuchFieldException, IllegalAccessException {
        JBColor highlightBackground = JBColor.namedColor((String)"ParameterInfo.currentOverloadBackground", (Color)UIUtil.getListSelectionBackground((boolean)false));
        try {
            Class<?> kotlinParamInfo = Class.forName("org.jetbrains.kotlin.idea.parameterInfo.KotlinParameterInfoWithCallHandlerBase");
            JBColor color = new JBColor((Color)highlightBackground, (Color)highlightBackground);
            Field[] fields = kotlinParamInfo.getDeclaredFields();
            Object[] objects = Arrays.stream(fields).filter(field -> field.getType().equals(Color.class)).toArray();
            StaticPatcher.setFinalStatic((Field)objects[0], color);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static void patchScopes() throws NoSuchFieldException, IllegalAccessException, ClassNotFoundException {
        Color excludedColor = MTConfig.getInstance().getSelectedTheme().getTheme().getExcludedColor();
        if (MTConfig.getInstance().getSelectedTheme().isNative()) {
            return;
        }
        StaticPatcher.setFinalStatic(Class.forName("com.intellij.ide.util.scopeChooser.ScopeEditorPanel$MyTreeCellRenderer"), "WHOLE_INCLUDED", MTUI.MTColor.BLUE);
        StaticPatcher.setFinalStatic(Class.forName("com.intellij.ide.util.scopeChooser.ScopeEditorPanel$MyTreeCellRenderer"), "PARTIAL_INCLUDED", MTUI.MTColor.ORANGE);
        Map ourDefaultColors = ContainerUtil.immutableMapBuilder().put((Object)"Sea", (Object)UIManager.getColor("FileColor.Blue")).put((Object)"Forest", (Object)UIManager.getColor("FileColor.Green")).put((Object)"Spice", (Object)UIManager.getColor("FileColor.Orange")).put((Object)"Crimson", (Object)UIManager.getColor("FileColor.Rose")).put((Object)"DeepPurple", (Object)UIManager.getColor("FileColor.Violet")).put((Object)"Amber", (Object)UIManager.getColor("FileColor.Yellow")).put((Object)"Theme Excluded Color", (Object)excludedColor).build();
        Field[] fields = FileColorManagerImpl.class.getDeclaredFields();
        Object[] objects = Arrays.stream(fields).filter(field -> field.getType().equals(Map.class)).toArray();
        StaticPatcher.setFinalStatic((Field)objects[0], ourDefaultColors);
    }

    private static void patchNavBar() throws NoSuchFieldException, IllegalAccessException {
        StaticPatcher.setFinalStatic(NavBarUIManager.class, "DARCULA", (Object)new MTNavBarUI());
        StaticPatcher.setFinalStatic(NavBarUIManager.class, "COMMON", (Object)new MTNavBarUI());
    }

    private static void patchIdeaActionButton() throws NoSuchFieldException, IllegalAccessException {
        StaticPatcher.setFinalStatic(ActionButtonLook.class, "SYSTEM_LOOK", (Object)new MTActionButtonLook());
    }

    private static void patchTabs() throws NoSuchFieldException, IllegalAccessException {
        int tabsHeight = MTConfig.getInstance().getTabsHeight() + 10;
        StaticPatcher.setFinalStatic(SingleHeightTabs.class, "UNSCALED_PREF_HEIGHT", tabsHeight);
        UIManager.put("TabbedPane.tabHeight", tabsHeight);
    }

    static void patchCompletionPopup() {
        Color autoCompleteBackground = MTUI.Panel.getSecondaryBackground();
        try {
            Field backgroundColorField = LookupCellRenderer.class.getDeclaredField("BACKGROUND_COLOR");
            StaticPatcher.setFinalStatic(backgroundColorField, autoCompleteBackground);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            System.err.println("Unable to patch completion popup: " + e.getLocalizedMessage());
        }
    }

    static void patchAttributes() {
        try {
            StaticPatcher.setFinalStatic(JBColor.class, "GRAY", MTUI.Label.getLabelInfoForeground());
            StaticPatcher.setFinalStatic(JBColor.class, "LIGHT_GRAY", MTUI.Label.getSelectedForeground());
            StaticPatcher.setFinalStatic(JBColor.class, "DARK_GRAY", MTUI.Label.getLabelDisabledForeground());
            StaticPatcher.setFinalStatic(SimpleTextAttributes.class, "DARK_TEXT", new SimpleTextAttributes(0, MTUI.Label.getLabelDisabledForeground()));
            StaticPatcher.setFinalStatic(SimpleTextAttributes.class, "SIMPLE_CELL_ATTRIBUTES", new SimpleTextAttributes(0, MTUI.Label.getLabelInfoForeground()));
            StaticPatcher.setFinalStatic(SimpleTextAttributes.class, "EXCLUDED_ATTRIBUTES", new SimpleTextAttributes(0, MTUI.Label.getLabelDisabledForeground()));
            StaticPatcher.setFinalStatic(SimpleTextAttributes.class, "GRAY_ATTRIBUTES", new SimpleTextAttributes(0, MTUI.Label.getLabelInfoForeground()));
            StaticPatcher.setFinalStatic(SimpleTextAttributes.class, "GRAY_SMALL_ATTRIBUTES", new SimpleTextAttributes(128, MTUI.Label.getLabelInfoForeground()));
            StaticPatcher.setFinalStatic(SimpleTextAttributes.class, "GRAY_ITALIC_ATTRIBUTES", new SimpleTextAttributes(2, MTUI.Label.getLabelInfoForeground()));
            StaticPatcher.setFinalStatic(SimpleTextAttributes.class, "SYNTHETIC_ATTRIBUTES", new SimpleTextAttributes(0, MTUI.Panel.getLinkForeground()));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

