/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.Notifications;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.mallowigi.idea.MTAnalytics;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.messages.MaterialThemeBundle;
import com.mallowigi.idea.notifications.MTInstallAtomNotification;
import com.mallowigi.idea.notifications.MTStatisticsNotification;
import com.mallowigi.idea.notifications.Notify;
import com.mallowigi.idea.utils.MTUiUtils;
import java.net.URL;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

public final class MTUpdatesComponent
implements StartupActivity {
    private MTConfig config = null;
    private Project myProject = null;

    private static void onPaypalClick(Notification notification, HyperlinkEvent event) {
        URL url = event.getURL();
        try {
            JSONObject props = new JSONObject();
            props.put("Url", (Object)url);
            MTAnalytics.getInstance().trackWithData("Notification", props);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        if (url == null) {
            BrowserUtil.browse((String)event.getDescription());
        } else {
            BrowserUtil.browse((URL)url);
        }
        notification.expire();
    }

    private static void onAtomPlugin(Notification notification, HyperlinkEvent event) {
        URL url = event.getURL();
        if (url == null) {
            BrowserUtil.browse((String)event.getDescription());
        } else {
            BrowserUtil.browse((URL)url);
        }
        notification.expire();
    }

    private static Notification createStatsNotification() {
        NotificationGroup group = new NotificationGroup("Material Theme Notifications", NotificationDisplayType.STICKY_BALLOON, true);
        MTStatisticsNotification notif = new MTStatisticsNotification();
        return group.createNotification(notif.getTitle(), notif.getSubtitle(), notif.getContent(), notif.getType(), notif.getListener());
    }

    private static Notification createInstallAtomNotification() {
        NotificationGroup group = new NotificationGroup("Material Theme Notifications", NotificationDisplayType.STICKY_BALLOON, true);
        MTInstallAtomNotification notif = new MTInstallAtomNotification();
        return group.createNotification(notif.getTitle(), notif.getSubtitle(), notif.getContent(), notif.getType(), notif.getListener());
    }

    private static boolean isAgreementShown() {
        return PropertiesComponent.getInstance().isValueSet("mt.showStatisticsAgreement");
    }

    private static boolean isInstallAtomShown() {
        return PropertiesComponent.getInstance().isValueSet("mt.showInstallAtom");
    }

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            MTUpdatesComponent.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.config = MTConfig.getInstance();
        this.projectOpened();
    }

    private void projectOpened() {
        Notification notification;
        boolean updated;
        String pluginVersion = MTUiUtils.getVersion();
        boolean bl = updated = !pluginVersion.equals(this.config.getVersion());
        if (updated) {
            this.config.setVersion(pluginVersion);
            Notify.showUpdate(this.myProject, MTUpdatesComponent::onPaypalClick);
        }
        if (!MTUpdatesComponent.isAgreementShown()) {
            notification = MTUpdatesComponent.createStatsNotification();
            Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
        }
        if (updated && !MTUpdatesComponent.isInstallAtomShown() && !PluginManager.isPluginInstalled((PluginId)PluginId.getId((String)MaterialThemeBundle.message("atom.pluginid", new Object[0])))) {
            notification = MTUpdatesComponent.createInstallAtomNotification();
            Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/mallowigi/idea/MTUpdatesComponent", "runActivity"));
    }
}

