/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.ide.ui.laf.darcula.DarculaLaf;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SVGLoader;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.mallowigi.idea.MTAccentColorPatcher;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.UIReplacer;
import com.mallowigi.idea.listeners.AccentsListener;
import com.mallowigi.idea.listeners.MTTopics;
import com.mallowigi.idea.listeners.ThemeListener;
import com.mallowigi.idea.themes.MTThemeFacade;
import com.mallowigi.idea.themes.MTThemes;
import com.mallowigi.idea.themes.lists.AccentResources;
import com.mallowigi.idea.themes.lists.FontResources;
import com.mallowigi.idea.themes.models.MTThemeable;
import com.mallowigi.idea.utils.MTChangeLAFAnimator;
import com.mallowigi.idea.utils.MTUI;
import java.awt.Color;
import java.awt.Font;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Locale;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import sun.awt.AppContext;

public final class MTThemeManager
implements Disposable {
    @NonNls
    public static final String DEFAULT_FONT = "Roboto";
    private static final int DEFAULT_SIDEBAR_HEIGHT = 28;
    private static final int DEFAULT_INDENT = 6;
    private static final int DEFAULT_FONT_SIZE = JBUI.scale((int)13);
    @NonNls
    private static final String DEFAULT_MONO_FONT = "Fira Code";
    @NonNls
    private static final String RETINA = "@2x.css";
    @NonNls
    private static final String NON_RETINA = ".css";
    @NonNls
    private static final String DARCULA = "darcula";
    private static final MTConfig CONFIG = MTConfig.getInstance();

    private MTThemeManager() {
    }

    public static MTThemeManager getInstance() {
        return (MTThemeManager)ServiceManager.getService(MTThemeManager.class);
    }

    public static void toggleColoredDirs() {
        CONFIG.setUseColoredDirectories(!CONFIG.isUseColoredDirectories());
        MTThemeManager.updateFileIcons();
    }

    public static void toggleContrast() {
        CONFIG.setContrastMode(!CONFIG.isContrastMode());
        MTThemeManager.applyContrast(true);
    }

    public static void toggleHighContrast() {
        CONFIG.setHighContrast(!CONFIG.isHighContrast());
        MTThemeManager.activate();
    }

    public static void toggleCompactStatusBar() {
        boolean compactStatusBar = CONFIG.isCompactStatusBar();
        CONFIG.setCompactStatusBar(!compactStatusBar);
        MTThemeManager.applyCompactToolWindowHeaders();
    }

    private static void applyCompactToolWindowHeaders() {
        if (CONFIG.isCompactStatusBar()) {
            UIManager.put("ToolWindow.tab.verticalPadding", JBUI.scale((int)0));
        } else {
            UIManager.put("ToolWindow.tab.verticalPadding", JBUI.scale((int)5));
        }
    }

    public static void toggleCompactSidebar() {
        boolean isCompactSidebar = CONFIG.isCompactSidebar();
        CONFIG.setCompactSidebar(!isCompactSidebar);
        MTThemeManager.applyCompactSidebar(true);
    }

    public static void toggleCompactDropdowns() {
        boolean isCompactDropdowns = CONFIG.isCompactDropdowns();
        CONFIG.setCompactDropdowns(!isCompactDropdowns);
        UIReplacer.patchUI();
    }

    public static void toggleCompactMenus() {
        boolean isCompact = CONFIG.isCompactMenus();
        CONFIG.setCompactMenus(!isCompact);
        MTThemeManager.applyMenusHeight();
        UIReplacer.patchUI();
    }

    public static void toggleCompactTableCells() {
        boolean isCompact = CONFIG.isCompactTables();
        CONFIG.setCompactTables(!isCompact);
        MTThemeManager.reloadUI();
    }

    public static void toggleMaterialFonts() {
        boolean useMaterialFonts = CONFIG.isUseMaterialFont2();
        CONFIG.setUseMaterialFont2(!useMaterialFonts);
        MTThemeManager.applyFonts();
    }

    public static void toggleMaterialWallpapers() {
        CONFIG.setUseMaterialWallpapers(!CONFIG.isUseMaterialWallpapers());
        CONFIG.fireChanged();
    }

    public static void toggleUpperCaseTabs() {
        CONFIG.setUpperCaseTabs(!CONFIG.isUpperCaseTabs());
        CONFIG.fireChanged();
    }

    public static void toggleOverrideAccent() {
        CONFIG.setOverrideAccentColor(!CONFIG.isOverrideAccentColor());
        CONFIG.fireChanged();
    }

    public static void toggleProjectFrame() {
        CONFIG.setUseProjectFrame(!CONFIG.isUseProjectFrame());
        CONFIG.fireChanged();
    }

    private static void updateFileIcons() {
        GuiUtils.invokeLaterIfNeeded(() -> {
            Application app = ApplicationManager.getApplication();
            app.runWriteAction(() -> FileTypeManagerEx.getInstanceEx().fireFileTypesChanged());
        }, (ModalityState)ModalityState.NON_MODAL);
    }

    public static void activate() {
        MTThemeFacade mtTheme = CONFIG.getSelectedTheme();
        MTThemeManager.activate(mtTheme);
    }

    static void activateWithColorScheme() {
        MTThemeFacade mtTheme = CONFIG.getSelectedTheme();
        MTThemeManager.activate(mtTheme);
    }

    static void activateLAF(@NonNls String themeId, boolean isDark, @NonNls String name) {
        MTThemeFacade themeFor = MTThemes.getThemeFor(themeId);
        if (themeFor != null) {
            MTThemeManager.activate(themeFor);
        } else {
            MTThemes mtTheme = MTThemes.NATIVE;
            mtTheme.setIsDark(isDark);
            mtTheme.setThemeName(name);
            MTThemeManager.activate(mtTheme);
        }
    }

    static void activateLAF(UITheme theme) {
        MTThemeManager.activateLAF(theme.getId(), theme.isDark(), theme.getName());
    }

    public static void activate(MTThemeFacade mtTheme) {
        MTThemeFacade newTheme = mtTheme;
        if (newTheme == null) {
            newTheme = MTThemes.OCEANIC;
        }
        CONFIG.setSelectedTheme(newTheme);
        newTheme.getTheme().activate();
        IconLoader.clearCache();
        MTThemeManager.applyContrast(false);
        MTThemeManager.applyCompactSidebar(false);
        MTThemeManager.applyCustomTreeIndent();
        MTThemeManager.applyMenusHeight();
        MTThemeManager.applyAccents(false);
        MTThemeManager.applyFonts();
        MTThemeManager.applyCompactToolWindowHeaders();
        MTThemeManager.patchStyledEditorKit();
        LafManager.getInstance().updateUI();
        UIReplacer.patchUI();
        MTThemeManager.fireThemeChanged(newTheme);
    }

    public static void setLookAndFeel(MTThemeFacade selectedTheme) {
        LafManager lafManager = LafManager.getInstance();
        UIManager.LookAndFeelInfo lafInfo = (UIManager.LookAndFeelInfo)ContainerUtil.find((Object[])lafManager.getInstalledLookAndFeels(), lookAndFeelInfo -> lookAndFeelInfo.getName().equals(selectedTheme.getThemeName()));
        MTChangeLAFAnimator.showSnapshot();
        if (lafInfo != null) {
            lafManager.setCurrentLookAndFeel(lafInfo);
        } else {
            MTThemeManager.activate(selectedTheme);
        }
        SwingUtilities.invokeLater(MTChangeLAFAnimator::hideSnapshotWithAnimation);
    }

    private static void switchScheme(MTThemeFacade mtTheme, boolean switchColorScheme) {
        EditorColorsScheme themeScheme;
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        if (switchColorScheme && (themeScheme = editorColorsManager.getScheme(mtTheme.getThemeColorScheme())) != null) {
            editorColorsManager.setGlobalScheme(themeScheme);
        }
        EditorColorsScheme globalScheme = editorColorsManager.getGlobalScheme();
        editorColorsManager.setGlobalScheme(editorColorsManager.getScheme("Darcula"));
        editorColorsManager.setGlobalScheme(globalScheme);
    }

    public static void applyAccents(boolean fireEvent) {
        Color accentColor = ColorUtil.fromHex((String)CONFIG.getAccentColor());
        Color transparentAccentColor = ColorUtil.toAlpha((Color)accentColor, (int)70);
        for (String resource : AccentResources.ACCENT_RESOURCES) {
            UIManager.put(resource, accentColor);
        }
        for (String resource : AccentResources.ACCENT_TRANSPARENT_RESOURCES) {
            UIManager.put(resource, transparentAccentColor);
        }
        CONFIG.getSelectedTheme().applyAccentMode();
        MTThemeManager.applyScrollbars(accentColor);
        MTThemeManager.patchStyledEditorKit();
        MTThemeManager.addAccentColorTint();
        if (fireEvent) {
            MTThemeManager.fireAccentChanged(accentColor);
        }
    }

    private static void applyScrollbars(Color accentColor) {
        Color hoverColor;
        Color transColor = ColorUtil.toAlpha((Color)accentColor, (int)50);
        Couple<Color> scrollbarColors = MTThemeManager.getScrollbarColors(accentColor, transColor, hoverColor = ColorUtil.toAlpha((Color)accentColor, (int)75));
        if (scrollbarColors != null) {
            Color scrollbarColor = (Color)scrollbarColors.getFirst();
            Color scrollbarHoverColor = (Color)scrollbarColors.getSecond();
            for (String resource : AccentResources.SCROLLBAR_RESOURCES) {
                UIManager.put(resource, scrollbarColor);
            }
            for (String resource : AccentResources.SCROLLBAR_HOVER_RESOURCES) {
                UIManager.put(resource, scrollbarHoverColor);
            }
        }
    }

    @Nullable
    private static Couple<Color> getScrollbarColors(Color accentColor, Color transColor, Color hoverColor) {
        if (CONFIG.isAccentScrollbars()) {
            return CONFIG.isThemedScrollbars() ? new Couple((Object)transColor, (Object)hoverColor) : new Couple((Object)hoverColor, (Object)accentColor);
        }
        return null;
    }

    private static void fireThemeChanged(MTThemeFacade newTheme) {
        ((ThemeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(MTTopics.THEMES)).themeChanged(newTheme);
    }

    private static void fireAccentChanged(Color accentColorColor) {
        ((AccentsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(MTTopics.ACCENTS)).accentChanged(accentColorColor);
    }

    private static void applySettingsFont(@NonNls UIDefaults uiDefaults, String fontFace, int fontSize) {
        uiDefaults.put("Tree.ancestorInputMap", (Object)null);
        FontUIResource font = UIUtil.getFontWithFallback((String)fontFace, (int)0, (int)fontSize);
        String editorFontName = AppEditorFontOptions.getInstance().getFontPreferences().getFontFamily();
        String monospaceFont = (String)ObjectUtils.notNull((Object)editorFontName, (Object)DEFAULT_MONO_FONT);
        FontUIResource monoFont = new FontUIResource(monospaceFont, 0, fontSize);
        for (String fontResource : FontResources.FONT_RESOURCES) {
            Font curFont = (Font)ObjectUtils.notNull((Object)uiDefaults.getFont(fontResource), (Object)font);
            uiDefaults.put(fontResource, font.deriveFont(curFont.getStyle(), curFont.getSize()));
        }
        uiDefaults.put("PasswordField.font", monoFont);
        uiDefaults.put("TextArea.font", monoFont);
        uiDefaults.put("TextPane.font", font);
        uiDefaults.put("EditorPane.font", font);
    }

    private static void applyMaterialFonts(@NonNls UIDefaults uiDefaults) {
        uiDefaults.put("Tree.ancestorInputMap", (Object)null);
        String language = Locale.getDefault().getLanguage();
        boolean cjkLocale = Locale.CHINESE.getLanguage().equals(language) || Locale.JAPANESE.getLanguage().equals(language) || Locale.KOREAN.getLanguage().equals(language);
        FontUIResource font = UIUtil.getFontWithFallback((String)DEFAULT_FONT, (int)0, (int)DEFAULT_FONT_SIZE);
        if (cjkLocale) {
            font = UIUtil.getFontWithFallback((String)"Noto Sans", (int)0, (int)DEFAULT_FONT_SIZE);
        }
        FontUIResource uiFont = font;
        FontUIResource textFont = font;
        String editorFontName = AppEditorFontOptions.getInstance().getFontPreferences().getFontFamily();
        String monospaceFont = (String)ObjectUtils.notNull((Object)editorFontName, (Object)DEFAULT_MONO_FONT);
        FontUIResource monoFont = new FontUIResource(monospaceFont, 0, DEFAULT_FONT_SIZE);
        for (String fontResource : FontResources.FONT_RESOURCES) {
            Font curFont = (Font)ObjectUtils.notNull((Object)uiDefaults.getFont(fontResource), (Object)uiFont);
            uiDefaults.put(fontResource, uiFont.deriveFont(curFont.getStyle(), curFont.getSize()));
        }
        uiDefaults.put("PasswordField.font", monoFont);
        uiDefaults.put("TextArea.font", monoFont);
        uiDefaults.put("TextPane.font", textFont);
        uiDefaults.put("EditorPane.font", textFont);
    }

    private static void applyFonts() {
        UISettings uiSettings = UISettings.getInstance();
        UIDefaults lookAndFeelDefaults = UIManager.getLookAndFeelDefaults();
        int treeFontSize = JBUI.scale((int)CONFIG.getTreeFontSize());
        boolean useMaterialFont = CONFIG.isUseMaterialFont2();
        if (uiSettings.getOverrideLafFonts()) {
            MTThemeManager.applySettingsFont(lookAndFeelDefaults, uiSettings.getFontFace(), uiSettings.getFontSize());
        } else if (useMaterialFont) {
            MTThemeManager.applyMaterialFonts(lookAndFeelDefaults);
        } else if (SystemInfo.isMacOSYosemite) {
            LafManagerImpl.installMacOSXFonts((UIDefaults)lookAndFeelDefaults);
        }
        if (CONFIG.isTreeFontSizeEnabled()) {
            Font font = lookAndFeelDefaults.getFont("Tree.font");
            lookAndFeelDefaults.put("Tree.font", font.deriveFont((float)treeFontSize));
            LafManager.getInstance().updateUI();
        }
    }

    private static void applyContrast(boolean reloadUI) {
        boolean apply = CONFIG.isContrastMode();
        MTThemeable mtTheme = CONFIG.getSelectedTheme().getTheme();
        mtTheme.applyContrast(apply);
        if (reloadUI) {
            MTThemeManager.reloadUI();
        }
    }

    private static void applyCustomTreeIndent() {
        if (CONFIG.isCustomTreeIndentEnabled()) {
            UIManager.put("Tree.leftChildIndent", CONFIG.getLeftTreeIndent());
            UIManager.put("Tree.rightChildIndent", CONFIG.getRightTreeIndent());
        } else {
            UIManager.put("Tree.leftChildIndent", 3 + JBUI.scale((int)7));
            UIManager.put("Tree.rightChildIndent", 3 + JBUI.scale((int)4));
        }
    }

    private static void applyMenusHeight() {
        if (CONFIG.isCompactMenus()) {
            UIManager.put("PopupMenuSeparator.height", 3);
            UIManager.put("PopupMenuSeparator.stripeIndent", 1);
        } else {
            UIManager.put("PopupMenuSeparator.height", 10);
            UIManager.put("PopupMenuSeparator.stripeIndent", 5);
        }
    }

    private static void applyCompactSidebar(boolean reloadUI) {
        boolean isCustomSidebarHeight = CONFIG.isCompactSidebar();
        int customSidebarHeight = CONFIG.getCustomSidebarHeight();
        int rowHeight = isCustomSidebarHeight ? JBUI.scale((int)customSidebarHeight) : JBUI.scale((int)28);
        UIManager.put("Tree.rowHeight", rowHeight);
        if (reloadUI) {
            MTThemeManager.reloadUI();
        }
    }

    private static void patchStyledEditorKit() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        MTThemeable selectedTheme = CONFIG.getSelectedTheme().getTheme();
        URL url = selectedTheme.getClass().getResource(selectedTheme.getId() + (JBUIScale.isUsrHiDPI() ? RETINA : NON_RETINA));
        StyleSheet styleSheet = UIUtil.loadStyleSheet((URL)url);
        if (styleSheet == null) {
            URL fallbackUrl = DarculaLaf.class.getResource(DARCULA + (JBUIScale.isUsrHiDPI() ? RETINA : NON_RETINA));
            styleSheet = UIUtil.loadStyleSheet((URL)fallbackUrl);
        }
        assert (styleSheet != null);
        String accentColor = ColorUtil.toHex((Color)MTUI.Panel.getLinkForeground());
        String css = "a, address, b { color: #%s; }";
        styleSheet.addRule(String.format("a, address, b { color: #%s; }", accentColor));
        UIManager.put("StyledEditorKit.JBDefaultStyle", styleSheet);
        defaults.put("StyledEditorKit.JBDefaultStyle", styleSheet);
        try {
            Field keyField = HTMLEditorKit.class.getDeclaredField("DEFAULT_STYLES_KEY");
            keyField.setAccessible(true);
            AppContext.getAppContext().put(keyField.get(null), styleSheet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addAccentColorTint() {
        SVGLoader.setColorPatcherProvider((SVGLoader.SvgElementColorPatcherProvider)new MTAccentColorPatcher());
    }

    public static void toggleAccentMode() {
        CONFIG.setAccentMode(!CONFIG.isAccentMode());
        CONFIG.fireChanged();
    }

    public static void setTabsHeight(int newTabsHeight) {
        CONFIG.setTabsHeight(newTabsHeight);
    }

    private static void reloadUI() {
        MTThemeManager.applyFonts();
        DarculaInstaller.uninstall();
        if (UIUtil.isUnderDarcula()) {
            DarculaInstaller.install();
        }
        LafManager.getInstance().updateUI();
    }

    public void dispose() {
    }
}

