/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea;

import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.ui.ColorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.listeners.ConfigNotifier;
import com.mallowigi.idea.utils.MTUI;
import com.mallowigi.idea.utils.MTUiUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MTProjectFrame
extends IdeRootPaneNorthExtension
implements Disposable {
    private final Project myProject;
    private final MessageBusConnection connect;
    @Nullable
    private JComponent myWrapperPanel;
    @Nullable
    private JPanel myProjectFramePanel;

    private MTProjectFrame(@NotNull Project project) {
        if (project == null) {
            MTProjectFrame.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.connect = this.myProject.getMessageBus().connect();
        this.connect.subscribe(ConfigNotifier.CONFIG_TOPIC, (Object)new ConfigNotifier(){

            @Override
            public void configChanged(MTConfig mtConfig) {
                MTProjectFrame.this.addFrame(MTProjectFrame.shouldShowProjectFrame());
            }
        });
    }

    private static boolean shouldShowProjectFrame() {
        UISettings uiSettings = UISettings.getInstance();
        return !uiSettings.getPresentationMode() && MTConfig.getInstance().isUseProjectFrame();
    }

    public void dispose() {
        this.connect.disconnect();
    }

    private void addFrame(boolean show) {
        if (this.myWrapperPanel == null) {
            return;
        }
        if (show && this.myProjectFramePanel == null) {
            this.myProjectFramePanel = this.buildPanel();
            this.myWrapperPanel.add((Component)this.myProjectFramePanel, "Center");
        } else if (!show && this.myProjectFramePanel != null) {
            this.myWrapperPanel.remove(this.myProjectFramePanel);
            this.myProjectFramePanel = null;
        }
    }

    @NonNls
    @NotNull
    public String getKey() {
        return "MTProjectFrame";
    }

    @NotNull
    public JComponent getComponent() {
        if (this.myWrapperPanel == null) {
            this.myWrapperPanel = new MTProjectFrameWrapperPanel((LayoutManager)new BorderLayout());
            this.addFrame(MTProjectFrame.shouldShowProjectFrame());
        }
        JComponent jComponent = this.myWrapperPanel;
        if (jComponent == null) {
            MTProjectFrame.$$$reportNull$$$0(1);
        }
        return jComponent;
    }

    private JPanel buildPanel() {
        final MTProjectTitlePanel mtProjectTitlePanel = new MTProjectTitlePanel(this.myProject);
        JPanel panel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                mtProjectTitlePanel.paintComponent(g);
            }

            @Override
            public Insets getInsets() {
                return JBInsets.create((int)JBUI.scale((int)12), (int)0);
            }
        };
        panel.add((Component)mtProjectTitlePanel, "Center");
        panel.updateUI();
        return panel;
    }

    public void uiSettingsChanged(UISettings settings) {
        this.addFrame(MTProjectFrame.shouldShowProjectFrame());
    }

    public IdeRootPaneNorthExtension copy() {
        return new MTProjectFrame(this.myProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/mallowigi/idea/MTProjectFrame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/mallowigi/idea/MTProjectFrame";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MTProjectFrameWrapperPanel
    extends JPanel {
        private MTProjectFrameWrapperPanel(LayoutManager layout) {
            super(layout);
            this.setName("mtRootPane");
        }

        @Override
        protected Graphics getComponentGraphics(Graphics g) {
            return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(g));
        }
    }

    private static final class MTProjectTitlePanel
    extends JPanel {
        private final Project myProject;

        private MTProjectTitlePanel(Project project) {
            super(new BorderLayout());
            this.myProject = project;
        }

        private void drawCenteredString(@NotNull Graphics2D g, @NotNull Rectangle rect, @NotNull String str) {
            if (g == null) {
                MTProjectTitlePanel.$$$reportNull$$$0(0);
            }
            if (rect == null) {
                MTProjectTitlePanel.$$$reportNull$$$0(1);
            }
            if (str == null) {
                MTProjectTitlePanel.$$$reportNull$$$0(2);
            }
            FontMetrics fm = g.getFontMetrics(g.getFont());
            int textWidth = fm.stringWidth(str) - 1;
            int x = Math.max(rect.x, rect.x + (rect.width - textWidth) / 2);
            int y = Math.max(rect.y, rect.y + rect.height / 2 + fm.getAscent() * 2 / 5);
            int padding = JBUI.scale((int)4);
            Shape oldClip = g.getClip();
            RecentProjectsManagerBase recentProjectsManage = RecentProjectsManagerBase.getInstanceEx();
            Icon recentIcon = recentProjectsManage.getProjectIcon(Objects.requireNonNull(this.myProject.getBasePath()), StartupUiUtil.isUnderDarcula());
            if (recentIcon == null) {
                recentIcon = EmptyIcon.ICON_16;
            }
            g.setColor(MTUI.Panel.getBackground());
            g.fillRoundRect(x - padding, padding, textWidth + padding * 2, rect.height - padding * 2, padding, padding);
            g.clip(rect);
            recentIcon.paintIcon(this, g, x, y);
            g.setColor(MTUI.Panel.getForeground());
            g.drawString(str, x, y);
            g.setClip(oldClip);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
            try {
                Rectangle headerRectangle = new Rectangle(0, 0, this.getWidth(), JBUI.insetsTop((int)24).top);
                graphics.setColor(this.getFrameColor());
                graphics.fill(headerRectangle);
                graphics.setFont(MTUI.Panel.getFont());
                String textToDraw = this.myProject.getName();
                this.drawCenteredString(graphics, headerRectangle, textToDraw);
            }
            finally {
                graphics.dispose();
            }
        }

        @NotNull
        private Color getFrameColor() {
            Color projectColor = new Color(MTUiUtils.stringToARGB(this.myProject.getName()));
            Color color = ColorUtil.withAlpha((Color)MTUiUtils.darker(projectColor, 2), (double)0.5);
            if (color == null) {
                MTProjectTitlePanel.$$$reportNull$$$0(3);
            }
            return color;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rect";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/mallowigi/idea/MTProjectFrame$MTProjectTitlePanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/mallowigi/idea/MTProjectFrame$MTProjectTitlePanel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFrameColor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "drawCenteredString";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

