/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.LicensingFacade;
import com.mallowigi.idea.messages.MaterialThemeBundle;
import com.mallowigi.idea.utils.MTUiUtils;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.security.Signature;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathValidator;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MTLicenseChecker {
    private static final String PRODUCT_CODE = "PMATERIALUI";
    private static final String KEY_PREFIX = "key:";
    private static final String STAMP_PREFIX = "stamp:";
    private static final String EVAL_PREFIX = "eval:";
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long TIMESTAMP_VALIDITY_PERIOD_MS = 3600000L;
    private static final String[] ROOT_CERTIFICATES = new String[]{"-----BEGIN CERTIFICATE-----\nMIIFOzCCAyOgAwIBAgIJANJssYOyg3nhMA0GCSqGSIb3DQEBCwUAMBgxFjAUBgNV\nBAMMDUpldFByb2ZpbGUgQ0EwHhcNMTUxMDAyMTEwMDU2WhcNNDUxMDI0MTEwMDU2\nWjAYMRYwFAYDVQQDDA1KZXRQcm9maWxlIENBMIICIjANBgkqhkiG9w0BAQEFAAOC\nAg8AMIICCgKCAgEA0tQuEA8784NabB1+T2XBhpB+2P1qjewHiSajAV8dfIeWJOYG\ny+ShXiuedj8rL8VCdU+yH7Ux/6IvTcT3nwM/E/3rjJIgLnbZNerFm15Eez+XpWBl\nm5fDBJhEGhPc89Y31GpTzW0vCLmhJ44XwvYPntWxYISUrqeR3zoUQrCEp1C6mXNX\nEpqIGIVbJ6JVa/YI+pwbfuP51o0ZtF2rzvgfPzKtkpYQ7m7KgA8g8ktRXyNrz8bo\niwg7RRPeqs4uL/RK8d2KLpgLqcAB9WDpcEQzPWegbDrFO1F3z4UVNH6hrMfOLGVA\nxoiQhNFhZj6RumBXlPS0rmCOCkUkWrDr3l6Z3spUVgoeea+QdX682j6t7JnakaOw\njzwY777SrZoi9mFFpLVhfb4haq4IWyKSHR3/0BlWXgcgI6w6LXm+V+ZgLVDON52F\nLcxnfftaBJz2yclEwBohq38rYEpb+28+JBvHJYqcZRaldHYLjjmb8XXvf2MyFeXr\nSopYkdzCvzmiEJAewrEbPUaTllogUQmnv7Rv9sZ9jfdJ/cEn8e7GSGjHIbnjV2ZM\nQ9vTpWjvsT/cqatbxzdBo/iEg5i9yohOC9aBfpIHPXFw+fEj7VLvktxZY6qThYXR\nRus1WErPgxDzVpNp+4gXovAYOxsZak5oTV74ynv1aQ93HSndGkKUE/qA/JECAwEA\nAaOBhzCBhDAdBgNVHQ4EFgQUo562SGdCEjZBvW3gubSgUouX8bMwSAYDVR0jBEEw\nP4AUo562SGdCEjZBvW3gubSgUouX8bOhHKQaMBgxFjAUBgNVBAMMDUpldFByb2Zp\nbGUgQ0GCCQDSbLGDsoN54TAMBgNVHRMEBTADAQH/MAsGA1UdDwQEAwIBBjANBgkq\nhkiG9w0BAQsFAAOCAgEAjrPAZ4xC7sNiSSqh69s3KJD3Ti4etaxcrSnD7r9rJYpK\nBMviCKZRKFbLv+iaF5JK5QWuWdlgA37ol7mLeoF7aIA9b60Ag2OpgRICRG79QY7o\nuLviF/yRMqm6yno7NYkGLd61e5Huu+BfT459MWG9RVkG/DY0sGfkyTHJS5xrjBV6\nhjLG0lf3orwqOlqSNRmhvn9sMzwAP3ILLM5VJC5jNF1zAk0jrqKz64vuA8PLJZlL\nS9TZJIYwdesCGfnN2AETvzf3qxLcGTF038zKOHUMnjZuFW1ba/12fDK5GJ4i5y+n\nfDWVZVUDYOPUixEZ1cwzmf9Tx3hR8tRjMWQmHixcNC8XEkVfztID5XeHtDeQ+uPk\nX+jTDXbRb+77BP6n41briXhm57AwUI3TqqJFvoiFyx5JvVWG3ZqlVaeU/U9e0gxn\n8qyR+ZA3BGbtUSDDs8LDnE67URzK+L+q0F2BC758lSPNB2qsJeQ63bYyzf0du3wB\n/gb2+xJijAvscU3KgNpkxfGklvJD/oDUIqZQAnNcHe7QEf8iG2WqaMJIyXZlW3me\n0rn+cgvxHPt6N4EBh5GgNZR4l0eaFEV+fxVsydOQYo1RIyFMXtafFBqQl6DDxujl\nFeU3FZ+Bcp12t7dlM4E0/sS1XdL47CfGVj4Bp+/VbF862HmkAbd7shs7sDQkHbU=\n-----END CERTIFICATE-----\n", "-----BEGIN CERTIFICATE-----\nMIIFTDCCAzSgAwIBAgIJAMCrW9HV+hjZMA0GCSqGSIb3DQEBCwUAMB0xGzAZBgNV\nBAMMEkxpY2Vuc2UgU2VydmVycyBDQTAgFw0xNjEwMTIxNDMwNTRaGA8yMTE2MTIy\nNzE0MzA1NFowHTEbMBkGA1UEAwwSTGljZW5zZSBTZXJ2ZXJzIENBMIICIjANBgkq\nhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAoT7LvHj3JKK2pgc5f02z+xEiJDcvlBi6\nfIwrg/504UaMx3xWXAE5CEPelFty+QPRJnTNnSxqKQQmg2s/5tMJpL9lzGwXaV7a\nrrcsEDbzV4el5mIXUnk77Bm/QVv48s63iQqUjVmvjQt9SWG2J7+h6X3ICRvF1sQB\nyeat/cO7tkpz1aXXbvbAws7/3dXLTgAZTAmBXWNEZHVUTcwSg2IziYxL8HRFOH0+\nGMBhHqa0ySmF1UTnTV4atIXrvjpABsoUvGxw+qOO2qnwe6ENEFWFz1a7pryVOHXg\nP+4JyPkI1hdAhAqT2kOKbTHvlXDMUaxAPlriOVw+vaIjIVlNHpBGhqTj1aqfJpLj\nqfDFcuqQSI4O1W5tVPRNFrjr74nDwLDZnOF+oSy4E1/WhL85FfP3IeQAIHdswNMJ\ny+RdkPZCfXzSUhBKRtiM+yjpIn5RBY+8z+9yeGocoxPf7l0or3YF4GUpud202zgy\nY3sJqEsZksB750M0hx+vMMC9GD5nkzm9BykJS25hZOSsRNhX9InPWYYIi6mFm8QA\n2Dnv8wxAwt2tDNgqa0v/N8OxHglPcK/VO9kXrUBtwCIfZigO//N3hqzfRNbTv/ZO\nk9lArqGtcu1hSa78U4fuu7lIHi+u5rgXbB6HMVT3g5GQ1L9xxT1xad76k2EGEi3F\n9B+tSrvru70CAwEAAaOBjDCBiTAdBgNVHQ4EFgQUpsRiEz+uvh6TsQqurtwXMd4J\n8VEwTQYDVR0jBEYwRIAUpsRiEz+uvh6TsQqurtwXMd4J8VGhIaQfMB0xGzAZBgNV\nBAMMEkxpY2Vuc2UgU2VydmVycyBDQYIJAMCrW9HV+hjZMAwGA1UdEwQFMAMBAf8w\nCwYDVR0PBAQDAgEGMA0GCSqGSIb3DQEBCwUAA4ICAQCJ9+GQWvBS3zsgPB+1PCVc\noG6FY87N6nb3ZgNTHrUMNYdo7FDeol2DSB4wh/6rsP9Z4FqVlpGkckB+QHCvqU+d\nrYPe6QWHIb1kE8ftTnwapj/ZaBtF80NWUfYBER/9c6To5moW63O7q6cmKgaGk6zv\nSt2IhwNdTX0Q5cib9ytE4XROeVwPUn6RdU/+AVqSOspSMc1WQxkPVGRF7HPCoGhd\nvqebbYhpahiMWfClEuv1I37gJaRtsoNpx3f/jleoC/vDvXjAznfO497YTf/GgSM2\nLCnVtpPQQ2vQbOfTjaBYO2MpibQlYpbkbjkd5ZcO5U5PGrQpPFrWcylz7eUC3c05\nUVeygGIthsA/0hMCioYz4UjWTgi9NQLbhVkfmVQ5lCVxTotyBzoubh3FBz+wq2Qt\niElsBrCMR7UwmIu79UYzmLGt3/gBdHxaImrT9SQ8uqzP5eit54LlGbvGekVdAL5l\nDFwPcSB1IKauXZvi1DwFGPeemcSAndy+Uoqw5XGRqE6jBxS7XVI7/4BSMDDRBz1u\na+JMGZXS8yyYT+7HdsybfsZLvkVmc9zVSDI7/MjVPdk6h0sLn+vuPC1bIi5edoNy\nPdiG2uPH5eDO6INcisyPpLS4yFKliaO4Jjap7yzLU9pbItoWgCAYa2NpxuxHJ0tB\n7tlDFnvaRnQukqSG+VqNWg==\n-----END CERTIFICATE-----"};
    private static final LicenseDetails licenseDetails = new LicenseDetails();

    private MTLicenseChecker() {
        MTLicenseChecker.extractLicenseInformation();
    }

    public static MTLicenseChecker getInstance() {
        return (MTLicenseChecker)ServiceManager.getService(MTLicenseChecker.class);
    }

    public static void extractLicenseInformation() {
        LicensingFacade facade = LicensingFacade.getInstance();
        if (facade == null) {
            return;
        }
        String cstamp = facade.getConfirmationStamp(PRODUCT_CODE);
        if (cstamp == null) {
            return;
        }
        if (cstamp.startsWith(KEY_PREFIX)) {
            MTLicenseChecker.extractFromKey(cstamp.substring(KEY_PREFIX.length()));
        }
        if (cstamp.startsWith(STAMP_PREFIX)) {
            MTLicenseChecker.extractFromStamp(cstamp.substring(STAMP_PREFIX.length()));
        }
        if (cstamp.startsWith(EVAL_PREFIX)) {
            MTLicenseChecker.extractFromEval(cstamp.substring(EVAL_PREFIX.length()));
        }
    }

    private static void extractFromKey(String key) {
        licenseDetails.setLicenseType(LicenseType.LICENSED);
        String[] licenseParts = key.split("-");
        if (licenseParts.length != 4) {
            licenseDetails.invalidate();
            return;
        }
        String licensePartBase64 = licenseParts[1];
        String signatureBase64 = licenseParts[2];
        String certBase64 = licenseParts[3];
        try {
            byte[] licenseBytes = MTLicenseChecker.verifySignature(licensePartBase64, signatureBase64, certBase64);
            if (licenseBytes == null) {
                licenseDetails.invalidate();
                return;
            }
            MTLicenseChecker.extractInfo(licenseBytes);
        }
        catch (Throwable e) {
            licenseDetails.invalidate();
        }
    }

    private static void extractFromStamp(String serverStamp) {
        licenseDetails.setLicenseType(LicenseType.FLOATING);
        try {
            String[] parts = serverStamp.split(":");
            Base64.Decoder base64 = Base64.getMimeDecoder();
            String machineId = MTLicenseChecker.verifyStampSignature(parts, base64);
            if (machineId != null) {
                licenseDetails.setMachineId(machineId);
            }
        }
        catch (Throwable ignored) {
            licenseDetails.invalidate();
        }
    }

    private static void extractFromEval(String expirationTime) {
        licenseDetails.setLicenseType(LicenseType.EVALUATION);
        try {
            Date now = new Date();
            Date expiration = new Date(Long.parseLong(expirationTime));
            licenseDetails.setPaidUpTo(expirationTime);
        }
        catch (NumberFormatException e) {
            licenseDetails.invalidate();
        }
    }

    public static boolean isLicensed() {
        return true;
    }

    public static void requestLicense(String message) {
        ApplicationManager.getApplication().invokeLater(() -> MTLicenseChecker.showRegisterDialog(message), ModalityState.NON_MODAL);
    }

    public static String getLicensedInfo() {
        LicensingFacade facade = LicensingFacade.getInstance();
        if (facade == null) {
            return "";
        }
        String licensedToMessage = licenseDetails.getName();
        Date licenseExpirationDate = facade.getExpirationDate(PRODUCT_CODE);
        Date now = new Date();
        if (licenseDetails.getLicenseType() == LicenseType.LICENSED || licenseDetails.getLicenseType() == LicenseType.FLOATING) {
            assert (licensedToMessage != null);
            assert (licenseExpirationDate != null);
            return MaterialThemeBundle.message("MTHomeForm.licensedLabel.licensedText", licensedToMessage, licenseExpirationDate);
        }
        if (licenseDetails.getLicenseType() == LicenseType.EVALUATION) {
            assert (licenseExpirationDate != null);
            long days = ChronoUnit.DAYS.between(now.toInstant(), licenseExpirationDate.toInstant());
            return MaterialThemeBundle.message("MTHomeForm.licensedLabel.evaluation", days);
        }
        return MaterialThemeBundle.message("MTHomeForm.licensedLabel.text", new Object[0]);
    }

    private static void showRegisterDialog(String message) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction registerAction = actionManager.getAction("RegisterPlugins");
        if (registerAction == null) {
            registerAction = actionManager.getAction("Register");
        }
        if (registerAction != null) {
            registerAction.actionPerformed(AnActionEvent.createFromDataContext((String)"", (Presentation)new Presentation(), (DataContext)MTLicenseChecker.asDataContext(message)));
            int answer = Messages.showYesNoDialog((String)MaterialThemeBundle.message("restartIde", new Object[0]), (String)MaterialThemeBundle.message("restartNow", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (answer == 0) {
                MTUiUtils.restartIde();
            }
        }
    }

    private static void extractInfo(byte ... licenseBytes) {
        String licenseString = new String(licenseBytes, StandardCharsets.UTF_8);
        LinkedTreeMap json = (LinkedTreeMap)new Gson().fromJson(licenseString, LinkedTreeMap.class);
        if (json == null) {
            return;
        }
        licenseDetails.setId((String)json.get((Object)"licenseId"));
        licenseDetails.setName((String)json.get((Object)"licenseeName"));
        Object productsJson = json.get((Object)"products");
        if (productsJson instanceof ArrayList) {
            Iterable products = (Iterable)productsJson;
            for (Object p : products) {
                LinkedTreeMap product;
                if (!(p instanceof LinkedTreeMap) || !(product = (LinkedTreeMap)p).get((Object)"code").equals(PRODUCT_CODE)) continue;
                licenseDetails.setPaidUpTo((String)product.get((Object)"paidUpTo"));
            }
        }
    }

    private static boolean isKeyValid(String key) {
        String[] licenseParts = key.split("-");
        if (licenseParts.length != 4) {
            return false;
        }
        String licenseId = licenseParts[0];
        String licensePartBase64 = licenseParts[1];
        String signatureBase64 = licenseParts[2];
        String certBase64 = licenseParts[3];
        try {
            byte[] licenseBytes = MTLicenseChecker.verifySignature(licensePartBase64, signatureBase64, certBase64);
            if (licenseBytes == null) {
                return false;
            }
            String licenseData = new String(licenseBytes, StandardCharsets.UTF_8);
            return licenseData.contains("\"licenseId\":\"" + licenseId + "\"");
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean isLicenseServerStampValid(String serverStamp) {
        try {
            String[] parts = serverStamp.split(":");
            Base64.Decoder base64 = Base64.getMimeDecoder();
            String expectedMachineId = parts[0];
            long timeStamp = Long.parseLong(parts[1]);
            String machineId = parts[2];
            String signatureType = parts[3];
            byte[] signatureBytes = base64.decode(parts[4].getBytes(StandardCharsets.UTF_8));
            byte[] certBytes = base64.decode(parts[5].getBytes(StandardCharsets.UTF_8));
            ArrayList<byte[]> intermediate = new ArrayList<byte[]>(10);
            for (int idx = 6; idx < parts.length; ++idx) {
                intermediate.add(base64.decode(parts[idx].getBytes(StandardCharsets.UTF_8)));
            }
            Signature sig = Signature.getInstance(signatureType);
            sig.initVerify(MTLicenseChecker.createCertificate(certBytes, intermediate, true));
            sig.update((timeStamp + ":" + machineId).getBytes(StandardCharsets.UTF_8));
            if (sig.verify(signatureBytes)) {
                return expectedMachineId.equals(machineId) && Math.abs(System.currentTimeMillis() - timeStamp) < 3600000L;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean isEvaluationValid(String expirationTime) {
        try {
            Date now = new Date();
            Date expiration = new Date(Long.parseLong(expirationTime));
            return now.before(expiration);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @NotNull
    private static DataContext asDataContext(@Nullable String message) {
        DataContext dataContext = dataId -> {
            switch (dataId) {
                case "register.product-descriptor.code": {
                    return PRODUCT_CODE;
                }
                case "register.message": {
                    return message;
                }
            }
            return null;
        };
        if (dataContext == null) {
            MTLicenseChecker.$$$reportNull$$$0(0);
        }
        return dataContext;
    }

    private static byte @Nullable [] verifySignature(String licensePartBase64, String signatureBase64, String certBase64) throws Exception {
        Signature sig = Signature.getInstance("SHA1withRSA");
        sig.initVerify(MTLicenseChecker.createCertificate(Base64.getMimeDecoder().decode(certBase64.getBytes(StandardCharsets.UTF_8)), Collections.emptySet(), false));
        byte[] licenseBytes = Base64.getMimeDecoder().decode(licensePartBase64.getBytes(StandardCharsets.UTF_8));
        sig.update(licenseBytes);
        if (!sig.verify(Base64.getMimeDecoder().decode(signatureBase64.getBytes(StandardCharsets.UTF_8)))) {
            return null;
        }
        return licenseBytes;
    }

    @Nullable
    private static String verifyStampSignature(String[] parts, Base64.Decoder base64) throws Exception {
        long timeStamp = Long.parseLong(parts[1]);
        String machineId = parts[2];
        String signatureType = parts[3];
        byte[] signatureBytes = base64.decode(parts[4].getBytes(StandardCharsets.UTF_8));
        byte[] certBytes = base64.decode(parts[5].getBytes(StandardCharsets.UTF_8));
        ArrayList<byte[]> intermediate = new ArrayList<byte[]>(10);
        for (int idx = 6; idx < parts.length; ++idx) {
            intermediate.add(base64.decode(parts[idx].getBytes(StandardCharsets.UTF_8)));
        }
        Signature sig = Signature.getInstance(signatureType);
        sig.initVerify(MTLicenseChecker.createCertificate(certBytes, intermediate, true));
        sig.update((timeStamp + ":" + machineId).getBytes(StandardCharsets.UTF_8));
        if (!sig.verify(signatureBytes)) {
            return null;
        }
        return machineId;
    }

    @NotNull
    private static X509Certificate createCertificate(byte[] certBytes, Collection<byte[]> intermediateCertsBytes, boolean checkValidityAtCurrentDate) throws Exception {
        block6: {
            X509Certificate x509Certificate;
            CertificateFactory x509factory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)x509factory.generateCertificate(new ByteArrayInputStream(certBytes));
            HashSet<Certificate> allCerts = new HashSet<Certificate>(10);
            allCerts.add(cert);
            for (byte[] bytes : intermediateCertsBytes) {
                allCerts.add(x509factory.generateCertificate(new ByteArrayInputStream(bytes)));
            }
            try {
                X509CertSelector selector = new X509CertSelector();
                selector.setCertificate(cert);
                HashSet<TrustAnchor> trustAchors = new HashSet<TrustAnchor>(10);
                for (String rc : ROOT_CERTIFICATES) {
                    trustAchors.add(new TrustAnchor((X509Certificate)x509factory.generateCertificate(new ByteArrayInputStream(rc.getBytes(StandardCharsets.UTF_8))), null));
                }
                PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustAchors, (CertSelector)selector);
                pkixParams.setRevocationEnabled(false);
                if (!checkValidityAtCurrentDate) {
                    pkixParams.setDate(cert.getNotBefore());
                }
                pkixParams.addCertStore(CertStore.getInstance("Collection", new CollectionCertStoreParameters(allCerts)));
                CertPath path = CertPathBuilder.getInstance("PKIX").build(pkixParams).getCertPath();
                if (path == null) break block6;
                CertPathValidator.getInstance("PKIX").validate(path, pkixParams);
                x509Certificate = cert;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (x509Certificate == null) {
                MTLicenseChecker.$$$reportNull$$$0(1);
            }
            return x509Certificate;
        }
        throw new Exception("Certificate used to sign the license is not signed by JetBrains root certificate");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/mallowigi/idea/MTLicenseChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "asDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCertificate";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static final class LicenseDetails {
        @NonNls
        static final String LICENSE_ID = "licenseId";
        @NonNls
        static final String LICENSEE_NAME = "licenseeName";
        @NonNls
        static final String PRODUCTS = "products";
        @NonNls
        static final String CODE = "code";
        @NonNls
        static final String PAID_UP_TO = "paidUpTo";
        private String id = null;
        private String name = null;
        private String paidUpTo = null;
        private String machineId = null;
        private LicenseType licenseType = LicenseType.FREE;
        private boolean isValid = true;

        LicenseDetails() {
        }

        void setId(String id) {
            this.id = id;
        }

        String getName() {
            return this.name;
        }

        void setName(String name) {
            this.name = name;
        }

        void setPaidUpTo(String paidUpTo) {
            this.paidUpTo = paidUpTo;
        }

        void invalidate() {
            this.isValid = false;
        }

        void setMachineId(String machineId) {
            this.machineId = machineId;
        }

        void setLicenseType(LicenseType licenseType) {
            this.licenseType = licenseType;
        }

        LicenseType getLicenseType() {
            return this.licenseType;
        }
    }

    static enum LicenseType {
        LICENSED,
        FLOATING,
        EVALUATION,
        FREE;

    }
}

