/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.ide.ui.laf.IntelliJLookAndFeelInfo;
import com.intellij.ide.ui.laf.UIThemeBasedLookAndFeelInfo;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.messages.MessageBusConnection;
import com.mallowigi.idea.MTBundledThemesManager;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.MTThemeManager;
import com.mallowigi.idea.UIReplacer;
import com.mallowigi.idea.config.MTBaseConfig;
import com.mallowigi.idea.config.ui.MTForm;
import com.mallowigi.idea.lafs.MTLafInstaller;
import com.mallowigi.idea.listeners.ConfigNotifier;
import com.mallowigi.idea.listeners.CustomConfigNotifier;
import com.mallowigi.idea.messages.MaterialThemeBundle;
import com.mallowigi.idea.themes.MTThemes;
import com.mallowigi.idea.ui.MTButtonUI;
import com.mallowigi.idea.ui.indicators.MTSelectedTreeIndicatorImpl;
import com.mallowigi.idea.utils.MTUiUtils;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public final class MTLafComponent
implements AppLifecycleListener {
    private UIManager.LookAndFeelInfo activeLookAndFeel = null;
    private boolean willRestartIde = false;

    public void appFrameCreated(@NotNull List<String> commandLineArgs) {
        if (commandLineArgs == null) {
            MTLafComponent.$$$reportNull$$$0(0);
        }
        this.initComponent();
    }

    private void lookAndFeelChanged(LafManager source) {
        UIManager.LookAndFeelInfo currentLookAndFeel = source.getCurrentLookAndFeel();
        MTLafComponent.patchTree();
        if (currentLookAndFeel == this.activeLookAndFeel) {
            return;
        }
        this.activeLookAndFeel = currentLookAndFeel;
        this.activateLaf(currentLookAndFeel);
    }

    private void activateLaf(UIManager.LookAndFeelInfo currentLookAndFeel) {
        UIManager.LookAndFeelInfo oldLaf = LafManager.getInstance().getCurrentLookAndFeel();
        if (oldLaf instanceof UIThemeBasedLookAndFeelInfo) {
            ((UIThemeBasedLookAndFeelInfo)oldLaf).dispose();
        }
        if (currentLookAndFeel instanceof UIThemeBasedLookAndFeelInfo) {
            UIThemeBasedLookAndFeelInfo lookAndFeel = (UIThemeBasedLookAndFeelInfo)currentLookAndFeel;
            MTThemeManager.activateLAF(lookAndFeel.getTheme());
        } else if (this.activeLookAndFeel instanceof DarculaLookAndFeelInfo) {
            MTThemeManager.activateLAF("darcula", true, "Darcula");
        } else if (this.activeLookAndFeel instanceof IntelliJLookAndFeelInfo) {
            MTThemeManager.activateLAF("default", false, "Light");
        }
    }

    private void initComponent() {
        try {
            MTBundledThemesManager.getInstance().loadBundledThemes();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.activeLookAndFeel = LafManager.getInstance().getCurrentLookAndFeel();
        ApplicationManager.getApplication().invokeAndWait(() -> this.activateLaf(this.activeLookAndFeel));
        MessageBusConnection connect = ApplicationManager.getApplication().getMessageBus().connect();
        connect.subscribe(ConfigNotifier.CONFIG_TOPIC, (Object)new ConfigNotifier(){

            @Override
            public void configChanged(MTConfig mtConfig) {
                MTLafComponent.this.onSettingsChanged();
            }

            @Override
            public void beforeConfigChanged(MTConfig mtConfig, MTForm form) {
                MTLafComponent.this.onBeforeSettingsChanged(mtConfig, form);
            }
        });
        connect.subscribe(CustomConfigNotifier.CONFIG_TOPIC, mtCustomThemeConfig -> MTLafComponent.activateCustomTheme());
        connect.subscribe(LafManagerListener.TOPIC, this::lookAndFeelChanged);
        MTLafComponent.patchTree();
    }

    private static void activateCustomTheme() {
        int okCancelDialog;
        boolean isNotCustom;
        MTConfig mtConfig = MTConfig.getInstance();
        boolean bl = isNotCustom = !mtConfig.getSelectedTheme().isCustom();
        if (isNotCustom && (okCancelDialog = Messages.showOkCancelDialog((String)MaterialThemeBundle.message("MTThemes.activate.custom.theme", new Object[0]), (String)MaterialThemeBundle.message("MTThemesComponent.activate.custom.theme", new Object[0]), (String)MaterialThemeBundle.message("common.ok", new Object[0]), (String)MaterialThemeBundle.message("common.cancel", new Object[0]), (Icon)Messages.getQuestionIcon())) == 0) {
            mtConfig.setSelectedTheme(MTThemes.CUSTOM);
        }
        MTLafComponent.activateTheme();
    }

    static void activateTheme() {
        MTThemeManager.activateWithColorScheme();
    }

    private static void patchTree() {
        ApplicationManager.getApplication().invokeLater(() -> MTLafInstaller.replaceTree(UIManager.getLookAndFeelDefaults()));
    }

    void onBeforeSettingsChanged(MTBaseConfig<MTForm, MTConfig> mtConfig, MTForm form) {
        this.restartIdeIfNecessary(mtConfig, form);
    }

    private void restartIdeIfNecessary(MTBaseConfig<MTForm, MTConfig> mtConfig, MTForm form) {
        if (mtConfig.needsRestart(form)) {
            String title = MaterialThemeBundle.message("MTForm.restartDialog.title", new Object[0]);
            String message = MaterialThemeBundle.message("MTForm.restartDialog.content", new Object[0]);
            int answer = Messages.showYesNoDialog((String)message, (String)title, (Icon)Messages.getQuestionIcon());
            if (answer == 0) {
                this.willRestartIde = true;
            }
        }
    }

    void onSettingsChanged() {
        MTSelectedTreeIndicatorImpl.resetCache();
        MTButtonUI.resetCache();
        UIManager.LookAndFeelInfo currentLookAndFeel = LafManager.getInstance().getCurrentLookAndFeel();
        MTThemeManager.setLookAndFeel(MTConfig.getInstance().getSelectedTheme());
        if (currentLookAndFeel == this.activeLookAndFeel) {
            MTLafComponent.activateTheme();
        }
        ApplicationManager.getApplication().invokeAndWait(UIReplacer::patchUI);
        if (this.willRestartIde) {
            MTUiUtils.restartIde();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineArgs", "com/mallowigi/idea/MTLafComponent", "appFrameCreated"));
    }
}

