/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.ui.ColorUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.mallowigi.idea.config.MTBaseConfig;
import com.mallowigi.idea.config.ui.MTCustomThemeForm;
import com.mallowigi.idea.config.ui.MTForm;
import com.mallowigi.idea.listeners.CustomConfigNotifier;
import com.mallowigi.idea.themes.models.MTBundledTheme;
import com.mallowigi.idea.themes.models.MTDarkBundledTheme;
import com.mallowigi.idea.themes.models.MTThemeable;
import com.mallowigi.idea.utils.MTColorUtils;
import com.mallowigi.idea.utils.MTUiUtils;
import java.awt.Color;
import java.util.Objects;
import javax.swing.plaf.ColorUIResource;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="MaterialCustomThemeConfig", storages={@Storage(value="material_custom_theme.xml")})
public final class MTCustomThemeConfig
implements PersistentStateComponent<MTCustomThemeConfig>,
MTBaseConfig<MTCustomThemeForm, MTCustomThemeConfig>,
Cloneable {
    @Property
    @NonNls
    String excludedColor = "2E3C43";
    @Property
    @NonNls
    String accentColor = "009688";
    @Property
    @NonNls
    String notificationsColor = "323232";
    @Property
    @NonNls
    String treeSelectionColor = "546E7A50";
    @Property
    @NonNls
    String highlightColor = "425B67";
    @Property
    @NonNls
    String secondBorderColor = "2A373E";
    @Property
    @NonNls
    String tableSelectedColor = "314549";
    @Property
    @NonNls
    String contrastColor = "1E272C";
    @Property
    @NonNls
    String disabledColor = "415967";
    @Property
    @NonNls
    String secondaryBackgroundColor = "32424A";
    @Property
    @NonNls
    String buttonColor = "2E3C43";
    @Property
    @NonNls
    String selectionForegroundColor = "FFFFFF";
    @Property
    @NonNls
    String selectionBackgroundColor = "546E7A";
    @Property
    @NonNls
    String textColor = "607D8B";
    @Property
    @NonNls
    String foregroundColor = "B0BEC5";
    @Property
    @NonNls
    String backgroundColor = "263238";

    @NotNull
    public static MTCustomThemeConfig getInstance() {
        MTCustomThemeConfig mTCustomThemeConfig = Objects.requireNonNull((MTCustomThemeConfig)ServiceManager.getService(MTCustomThemeConfig.class));
        if (mTCustomThemeConfig == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(0);
        }
        return mTCustomThemeConfig;
    }

    public static MTBundledTheme export(MTCustomThemeForm form) {
        MTDarkBundledTheme theme = new MTDarkBundledTheme();
        theme.setBackgroundColor(new ColorUIResource(form.getBackgroundColor()));
        theme.setForegroundColor(new ColorUIResource(form.getForegroundColor()));
        theme.setTextColor(new ColorUIResource(form.getTextColor()));
        theme.setHighlightColor(new ColorUIResource(form.getHighlightColor()));
        theme.setSelectionBackgroundColor(new ColorUIResource(form.getSelectionBackgroundColor()));
        theme.setSelectionForegroundColor(new ColorUIResource(form.getSelectionForegroundColor()));
        theme.setButtonColor(new ColorUIResource(form.getButtonColor()));
        theme.setSecondaryBackgroundColor(new ColorUIResource(form.getSecondaryBackgroundColor()));
        theme.setDisabledColor(new ColorUIResource(form.getDisabledColor()));
        theme.setContrastColor(new ColorUIResource(form.getContrastColor()));
        theme.setTableSelectedColor(new ColorUIResource(form.getTableSelectedColor()));
        theme.setSecondBorderColor(new ColorUIResource(form.getSecondBorderColor()));
        theme.setTreeSelectionColor(new ColorUIResource(form.getTreeSelectionColor()));
        theme.setNotificationsColor(new ColorUIResource(form.getNotificationsColor()));
        theme.setAccentColor(new ColorUIResource(form.getAccentColor()));
        theme.setExcludedColor(new ColorUIResource(form.getExcludedColor()));
        return theme;
    }

    public MTCustomThemeConfig clone() {
        return (MTCustomThemeConfig)XmlSerializerUtil.createCopy((Object)this);
    }

    @NotNull
    public MTCustomThemeConfig getState() {
        MTCustomThemeConfig mTCustomThemeConfig = this;
        if (mTCustomThemeConfig == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(1);
        }
        return mTCustomThemeConfig;
    }

    @Override
    public void loadState(@NotNull MTCustomThemeConfig state) {
        if (state == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(2);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    @Override
    public void fireBeforeChanged(MTCustomThemeForm form) {
    }

    @Override
    public void fireChanged() {
        ((CustomConfigNotifier)ApplicationManager.getApplication().getMessageBus().syncPublisher(CustomConfigNotifier.CONFIG_TOPIC)).customConfigChanged(this);
    }

    @Override
    public void applySettings(MTCustomThemeForm form) {
        this.setBackgroundColor(form.getBackgroundColor());
        this.setForegroundColor(form.getForegroundColor());
        this.setTextColor(form.getTextColor());
        this.setSelectionBackgroundColor(form.getSelectionBackgroundColor());
        this.setSelectionForegroundColor(form.getSelectionForegroundColor());
        this.setButtonColor(form.getButtonColor());
        this.setSecondaryBackgroundColor(form.getSecondaryBackgroundColor());
        this.setDisabledColor(form.getDisabledColor());
        this.setContrastColor(form.getContrastColor());
        this.setTableSelectedColor(form.getTableSelectedColor());
        this.setSecondBorderColor(form.getSecondBorderColor());
        this.setHighlightColor(form.getHighlightColor());
        this.setTreeSelectionColor(form.getTreeSelectionColor());
        this.setNotificationsColor(form.getNotificationsColor());
        this.setAccentColor(form.getAccentColor());
        this.setExcludedColor(form.getExcludedColor());
        this.fireChanged();
    }

    @Override
    public void resetSettings() {
        this.setExcludedColor(MTUiUtils.lightOrDark(MTCustomThemeForm.MTCustomDefaults.excludedColor, MTCustomThemeForm.MTLightCustomDefaults.excludedColor));
        this.setAccentColor(MTUiUtils.lightOrDark(MTCustomThemeForm.MTCustomDefaults.accentColor, MTCustomThemeForm.MTLightCustomDefaults.accentColor));
        this.setNotificationsColor(MTUiUtils.lightOrDark(MTCustomThemeForm.MTCustomDefaults.notificationsColor, MTCustomThemeForm.MTLightCustomDefaults.notificationsColor));
        this.setSecondBorderColor(MTUiUtils.lightOrDark(MTCustomThemeForm.MTCustomDefaults.secondBorderColor, MTCustomThemeForm.MTLightCustomDefaults.secondBorderColor));
        this.setContrastColor(MTUiUtils.lightOrDark(MTCustomThemeForm.MTCustomDefaults.contrastColor, MTCustomThemeForm.MTLightCustomDefaults.contrastColor));
        this.setDisabledColor(MTUiUtils.lightOrDark(MTCustomThemeForm.MTCustomDefaults.disabledColor, MTCustomThemeForm.MTLightCustomDefaults.disabledColor));
        this.setSecondaryBackgroundColor(MTUiUtils.lightOrDark(MTCustomThemeForm.MTCustomDefaults.secondaryBackgroundColor, MTCustomThemeForm.MTLightCustomDefaults.secondaryBackgroundColor));
        this.setButtonColor(MTUiUtils.lightOrDark(MTCustomThemeForm.MTCustomDefaults.buttonColor, MTCustomThemeForm.MTLightCustomDefaults.buttonColor));
        this.setSelectionBackgroundColor(MTUiUtils.lightOrDark(MTCustomThemeForm.MTCustomDefaults.selectionBackgroundColor, MTCustomThemeForm.MTLightCustomDefaults.selectionBackgroundColor));
        this.setSelectionForegroundColor(MTUiUtils.lightOrDark(MTCustomThemeForm.MTCustomDefaults.selectionForegroundColor, MTCustomThemeForm.MTLightCustomDefaults.selectionForegroundColor));
        this.setTableSelectedColor(MTUiUtils.lightOrDark(MTCustomThemeForm.MTCustomDefaults.tableSelectedColor, MTCustomThemeForm.MTLightCustomDefaults.tableSelectedColor));
        this.setTextColor(MTUiUtils.lightOrDark(MTCustomThemeForm.MTCustomDefaults.textColor, MTCustomThemeForm.MTLightCustomDefaults.textColor));
        this.setTreeSelectionColor(MTUiUtils.lightOrDark(MTCustomThemeForm.MTCustomDefaults.treeSelectionColor, MTCustomThemeForm.MTLightCustomDefaults.treeSelectionColor));
        this.setHighlightColor(MTUiUtils.lightOrDark(MTCustomThemeForm.MTCustomDefaults.highlightColor, MTCustomThemeForm.MTLightCustomDefaults.highlightColor));
        this.setForegroundColor(MTUiUtils.lightOrDark(MTCustomThemeForm.MTCustomDefaults.foregroundColor, MTCustomThemeForm.MTLightCustomDefaults.foregroundColor));
        this.setBackgroundColor(MTUiUtils.lightOrDark(MTCustomThemeForm.MTCustomDefaults.backgroundColor, MTCustomThemeForm.MTLightCustomDefaults.backgroundColor));
    }

    @Override
    public boolean needsRestart(MTForm form) {
        return false;
    }

    @NotNull
    public Color getExcludedColor() {
        ColorUIResource colorUIResource = MTColorUtils.parseColor(this.excludedColor);
        if (colorUIResource == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(3);
        }
        return colorUIResource;
    }

    public void setExcludedColor(Color excludedColor) {
        this.excludedColor = ColorUtil.toHex((Color)excludedColor, (boolean)true);
    }

    @NotNull
    public Color getAccentColor() {
        ColorUIResource colorUIResource = MTColorUtils.parseColor(this.accentColor);
        if (colorUIResource == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(4);
        }
        return colorUIResource;
    }

    public void setAccentColor(Color accentColor) {
        this.accentColor = ColorUtil.toHex((Color)accentColor, (boolean)true);
    }

    @NotNull
    public Color getNotificationsColor() {
        ColorUIResource colorUIResource = MTColorUtils.parseColor(this.notificationsColor);
        if (colorUIResource == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(5);
        }
        return colorUIResource;
    }

    public void setNotificationsColor(Color notificationsColor) {
        this.notificationsColor = ColorUtil.toHex((Color)notificationsColor, (boolean)true);
    }

    @NotNull
    public Color getTreeSelectionColor() {
        ColorUIResource colorUIResource = MTColorUtils.parseColor(this.treeSelectionColor);
        if (colorUIResource == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(6);
        }
        return colorUIResource;
    }

    public void setTreeSelectionColor(Color treeSelectionColor) {
        this.treeSelectionColor = ColorUtil.toHex((Color)treeSelectionColor, (boolean)true);
    }

    @NotNull
    public Color getHighlightColor() {
        ColorUIResource colorUIResource = MTColorUtils.parseColor(this.highlightColor);
        if (colorUIResource == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(7);
        }
        return colorUIResource;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = ColorUtil.toHex((Color)highlightColor, (boolean)true);
    }

    @NotNull
    public Color getSecondBorderColor() {
        ColorUIResource colorUIResource = MTColorUtils.parseColor(this.secondBorderColor);
        if (colorUIResource == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(8);
        }
        return colorUIResource;
    }

    public void setSecondBorderColor(Color secondBorderColor) {
        this.secondBorderColor = ColorUtil.toHex((Color)secondBorderColor, (boolean)true);
    }

    @NotNull
    public Color getTableSelectedColor() {
        ColorUIResource colorUIResource = MTColorUtils.parseColor(this.tableSelectedColor);
        if (colorUIResource == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(9);
        }
        return colorUIResource;
    }

    public void setTableSelectedColor(Color tableSelectedColor) {
        this.tableSelectedColor = ColorUtil.toHex((Color)tableSelectedColor, (boolean)true);
    }

    @NotNull
    public Color getContrastColor() {
        ColorUIResource colorUIResource = MTColorUtils.parseColor(this.contrastColor);
        if (colorUIResource == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(10);
        }
        return colorUIResource;
    }

    public void setContrastColor(Color contrastColor) {
        this.contrastColor = ColorUtil.toHex((Color)contrastColor, (boolean)true);
    }

    @NotNull
    public Color getDisabledColor() {
        ColorUIResource colorUIResource = MTColorUtils.parseColor(this.disabledColor);
        if (colorUIResource == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(11);
        }
        return colorUIResource;
    }

    public void setDisabledColor(Color disabledColor) {
        this.disabledColor = ColorUtil.toHex((Color)disabledColor, (boolean)true);
    }

    @NotNull
    public Color getSecondaryBackgroundColor() {
        ColorUIResource colorUIResource = MTColorUtils.parseColor(this.secondaryBackgroundColor);
        if (colorUIResource == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(12);
        }
        return colorUIResource;
    }

    public void setSecondaryBackgroundColor(Color secondaryBackgroundColor) {
        this.secondaryBackgroundColor = ColorUtil.toHex((Color)secondaryBackgroundColor, (boolean)true);
    }

    @NotNull
    public Color getButtonColor() {
        ColorUIResource colorUIResource = MTColorUtils.parseColor(this.buttonColor);
        if (colorUIResource == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(13);
        }
        return colorUIResource;
    }

    public void setButtonColor(Color buttonColor) {
        this.buttonColor = ColorUtil.toHex((Color)buttonColor, (boolean)true);
    }

    @NotNull
    public Color getSelectionForegroundColor() {
        ColorUIResource colorUIResource = MTColorUtils.parseColor(this.selectionForegroundColor);
        if (colorUIResource == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(14);
        }
        return colorUIResource;
    }

    public void setSelectionForegroundColor(Color selectionForegroundColor) {
        this.selectionForegroundColor = ColorUtil.toHex((Color)selectionForegroundColor, (boolean)true);
    }

    @NotNull
    public Color getSelectionBackgroundColor() {
        ColorUIResource colorUIResource = MTColorUtils.parseColor(this.selectionBackgroundColor);
        if (colorUIResource == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(15);
        }
        return colorUIResource;
    }

    public void setSelectionBackgroundColor(Color selectionBackgroundColor) {
        this.selectionBackgroundColor = ColorUtil.toHex((Color)selectionBackgroundColor, (boolean)true);
    }

    @NotNull
    public Color getTextColor() {
        ColorUIResource colorUIResource = MTColorUtils.parseColor(this.textColor);
        if (colorUIResource == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(16);
        }
        return colorUIResource;
    }

    public void setTextColor(Color textColor) {
        this.textColor = ColorUtil.toHex((Color)textColor, (boolean)true);
    }

    @NotNull
    public Color getForegroundColor() {
        ColorUIResource colorUIResource = MTColorUtils.parseColor(this.foregroundColor);
        if (colorUIResource == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(17);
        }
        return colorUIResource;
    }

    public void setForegroundColor(Color foregroundColor) {
        this.foregroundColor = ColorUtil.toHex((Color)foregroundColor, (boolean)true);
    }

    @NotNull
    public Color getBackgroundColor() {
        ColorUIResource colorUIResource = MTColorUtils.parseColor(this.backgroundColor);
        if (colorUIResource == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(18);
        }
        return colorUIResource;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = ColorUtil.toHex((Color)backgroundColor, (boolean)true);
    }

    @NotNull
    public ColorUIResource getExcludedColorString() {
        ColorUIResource colorUIResource = MTColorUtils.parseColor(this.excludedColor);
        if (colorUIResource == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(19);
        }
        return colorUIResource;
    }

    @NotNull
    public ColorUIResource getAccentColorString() {
        ColorUIResource colorUIResource = MTColorUtils.parseColor(this.accentColor);
        if (colorUIResource == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(20);
        }
        return colorUIResource;
    }

    @NotNull
    public ColorUIResource getNotificationsColorString() {
        ColorUIResource colorUIResource = MTColorUtils.parseColor(this.notificationsColor);
        if (colorUIResource == null) {
            MTCustomThemeConfig.$$$reportNull$$$0(21);
        }
        return colorUIResource;
    }

    public ColorUIResource getTreeSelectionColorString() {
        return MTColorUtils.parseColor(this.treeSelectionColor);
    }

    public ColorUIResource getHighlightColorString() {
        return MTColorUtils.parseColor(this.highlightColor);
    }

    public ColorUIResource getSecondBorderColorString() {
        return MTColorUtils.parseColor(this.secondBorderColor);
    }

    public ColorUIResource getTableSelectedColorString() {
        return MTColorUtils.parseColor(this.tableSelectedColor);
    }

    public ColorUIResource getContrastColorString() {
        return MTColorUtils.parseColor(this.contrastColor);
    }

    public ColorUIResource getDisabledColorString() {
        return MTColorUtils.parseColor(this.disabledColor);
    }

    public ColorUIResource getSecondaryBackgroundColorString() {
        return MTColorUtils.parseColor(this.secondaryBackgroundColor);
    }

    public ColorUIResource getButtonColorString() {
        return MTColorUtils.parseColor(this.buttonColor);
    }

    public ColorUIResource getSelectionForegroundColorString() {
        return MTColorUtils.parseColor(this.selectionForegroundColor);
    }

    public ColorUIResource getSelectionBackgroundColorString() {
        return MTColorUtils.parseColor(this.selectionBackgroundColor);
    }

    public ColorUIResource getTextColorString() {
        return MTColorUtils.parseColor(this.textColor);
    }

    public ColorUIResource getForegroundColorString() {
        return MTColorUtils.parseColor(this.foregroundColor);
    }

    public ColorUIResource getBackgroundColorString() {
        return MTColorUtils.parseColor(this.backgroundColor);
    }

    public boolean isBackgroundColorChanged(Color backgroundColor) {
        return !Objects.equals(MTColorUtils.parseColor(this.backgroundColor), backgroundColor);
    }

    public boolean isForegroundColorChanged(Color foregroundColor) {
        return !Objects.equals(MTColorUtils.parseColor(this.foregroundColor), foregroundColor);
    }

    public boolean isTextColorChanged(Color textColor) {
        return !Objects.equals(MTColorUtils.parseColor(this.textColor), textColor);
    }

    public boolean isSelectionBackgroundColorChanged(Color selectionBackgroundColor) {
        return !Objects.equals(MTColorUtils.parseColor(this.selectionBackgroundColor), selectionBackgroundColor);
    }

    public boolean isSelectionForegroundColorChanged(Color selectionForegroundColor) {
        return !Objects.equals(MTColorUtils.parseColor(this.selectionForegroundColor), selectionForegroundColor);
    }

    public boolean isButtonColorChanged(Color buttonColor) {
        return !Objects.equals(MTColorUtils.parseColor(this.buttonColor), buttonColor);
    }

    public boolean isSecondaryBackgroundColorChanged(Color secondaryBackgroundColor) {
        return !Objects.equals(MTColorUtils.parseColor(this.secondaryBackgroundColor), secondaryBackgroundColor);
    }

    public boolean isDisabledColorChanged(Color disabledColor) {
        return !Objects.equals(MTColorUtils.parseColor(this.disabledColor), disabledColor);
    }

    public boolean isContrastColorChanged(Color contrastColor) {
        return !Objects.equals(MTColorUtils.parseColor(this.contrastColor), contrastColor);
    }

    public boolean isTableSelectionColorChanged(Color tableSelectedColor) {
        return !Objects.equals(MTColorUtils.parseColor(this.tableSelectedColor), tableSelectedColor);
    }

    public boolean isSecondBorderColorChanged(Color secondBorderColor) {
        return !Objects.equals(MTColorUtils.parseColor(this.secondBorderColor), secondBorderColor);
    }

    public boolean isHighlightColorChanged(Color highlightColor) {
        return !Objects.equals(MTColorUtils.parseColor(this.highlightColor), highlightColor);
    }

    public boolean isTreeSelectionColorChanged(Color treeSelectionColor) {
        return !Objects.equals(MTColorUtils.parseColor(this.treeSelectionColor), treeSelectionColor);
    }

    public boolean isNotificationsColorChanged(Color notificationsColor) {
        return !Objects.equals(MTColorUtils.parseColor(this.notificationsColor), notificationsColor);
    }

    public boolean isAccentColorChanged(Color accentColor) {
        return !Objects.equals(MTColorUtils.parseColor(this.accentColor), accentColor);
    }

    public boolean isExcludedColorChanged(Color excludedColor) {
        return !Objects.equals(MTColorUtils.parseColor(this.excludedColor), excludedColor);
    }

    public void importFrom(MTThemeable theme) {
        theme.setPristine();
        this.setBackgroundColor(theme.getBackgroundColor());
        this.setForegroundColor(theme.getForegroundColor());
        this.setTextColor(theme.getTextColor());
        this.setSelectionBackgroundColor(theme.getSelectionBackgroundColor());
        this.setSelectionForegroundColor(theme.getSelectionForegroundColor());
        this.setButtonColor(theme.getButtonColor());
        this.setDisabledColor(theme.getDisabledColor());
        this.setContrastColor(theme.getContrastColor());
        this.setSecondaryBackgroundColor(theme.getSecondaryBackgroundColor());
        this.setSecondBorderColor(theme.getSecondBorderColor());
        this.setTableSelectedColor(theme.getTableSelectedColor());
        this.setHighlightColor(theme.getHighlightColor());
        this.setTreeSelectionColor(theme.getTreeSelectionColor());
        this.setNotificationsColor(theme.getNotificationsColor());
        if (theme.getAccentColor() != null) {
            this.setAccentColor(theme.getAccentColor());
        }
        if (theme.getExcludedColor() != null) {
            this.setExcludedColor(theme.getExcludedColor());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/mallowigi/idea/MTCustomThemeConfig";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/mallowigi/idea/MTCustomThemeConfig";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedColor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccentColor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationsColor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeSelectionColor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightColor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondBorderColor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableSelectedColor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getContrastColor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledColor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondaryBackgroundColor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getButtonColor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionForegroundColor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionBackgroundColor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextColor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getForegroundColor";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundColor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedColorString";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccentColorString";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationsColorString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

