/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import com.mallowigi.idea.MTLicenseChecker;
import com.mallowigi.idea.config.MTBaseConfig;
import com.mallowigi.idea.config.enums.IndicatorStyles;
import com.mallowigi.idea.config.enums.TabHighlightPositions;
import com.mallowigi.idea.config.ui.MTForm;
import com.mallowigi.idea.listeners.ConfigNotifier;
import com.mallowigi.idea.messages.MaterialThemeBundle;
import com.mallowigi.idea.themes.MTThemeFacade;
import com.mallowigi.idea.themes.MTThemes;
import com.mallowigi.idea.utils.MTAccents;
import com.mallowigi.idea.utils.MTUiUtils;
import java.awt.Color;
import java.rmi.server.UID;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@State(name="MaterialThemeConfig", storages={@Storage(value="material_theme.xml")})
public final class MTConfig
implements PersistentStateComponent<MTConfig>,
MTBaseConfig<MTForm, MTConfig>,
Cloneable {
    @NonNls
    public static final String DEFAULT_BG = "https://raw.githubusercontent.com/ChrisRM/material-theme-jetbrains/master/src/main/resources/themes/wall.jpg,60";
    public static final int MAX_HIGHLIGHT_THICKNESS = 5;
    public static final int MIN_HIGHLIGHT_THICKNESS = 1;
    public static final int MAX_INDICATOR_THICKNESS = 5;
    public static final int MIN_INDICATOR_THICKNESS = 1;
    public static final int MAX_TABS_HEIGHT = 60;
    public static final int DEFAULT_LINE_HEIGHT = 18;
    public static final int MIN_TABS_HEIGHT = 10;
    public static final int MAX_TREE_INDENT = 40;
    public static final int MIN_TREE_INDENT = 0;
    public static final int MAX_SIDEBAR_HEIGHT = 36;
    public static final int MIN_SIDEBAR_HEIGHT = 18;
    public static final int MIN_FONT_SIZE = 6;
    public static final int MAX_FONT_SIZE = 24;
    public static final int MAX_TAB_INDEX = 6;
    public static final int DEFAULT_TAB_OPACITY = 50;
    public static final int DEFAULT_TAB_FONT_SIZE = 12;
    public static final int DEFAULT_TREE_FONT_SIZE = 12;
    public static final int DEFAULT_THICKNESS = 2;
    public static final int DEFAULT_LEFT_INDENT = 6;
    public static final int DEFAULT_RIGHT_INDENT = 10;
    public static final int DEFAULT_TAB_HEIGHT = 32;
    public static final int NATIVE_TAB_HEIGHT = 18;
    static final String ACCENT_COLOR = MTAccents.FUCHSIA.getHexColor();
    static final String SECOND_ACCENT_COLOR = MTAccents.TURQUOISE.getHexColor();
    @Property
    boolean accentMode = false;
    @Property
    boolean accentScrollbars = true;
    @Property
    boolean allowDataCollection = false;
    @Property
    boolean borderedButtons = false;
    @Property
    boolean compactDropdowns = false;
    @Property
    boolean compactSidebar = false;
    @Property
    boolean darkTitleBar = false;
    @Property
    boolean fileStatusColorsEnabled = true;
    @Property
    boolean isHighlightColorEnabled = false;
    @Property
    boolean isCompactMenus = false;
    @Property
    boolean isCompactStatusBar = false;
    @Property
    boolean isCompactTables = false;
    @Property
    boolean isContrastMode = false;
    @Property
    boolean isCustomTreeIndentEnabled = false;
    @Property
    boolean isHighContrast = false;
    @Property
    boolean isMaterialDesign = true;
    @Property
    boolean isMaterialTheme = true;
    @Property
    boolean isStyledDirectories = false;
    @Property
    boolean isTabsShadow = true;
    @Property
    boolean isWizardShown = false;
    @Property
    boolean overrideAccentColor = true;
    @Property
    boolean pristineConfig = true;
    @Property
    boolean statusBarTheme = true;
    @Property
    boolean themedScrollbars = true;
    @Property
    boolean treeFontSizeEnabled = false;
    @Property
    boolean tabFontSizeEnabled = false;
    @Property
    boolean upperCaseButtons = true;
    @Property
    boolean upperCaseTabs = false;
    @Property
    @Deprecated
    boolean useMaterialFont = true;
    @Property
    boolean useMaterialFont2 = false;
    @Property
    boolean useMaterialWallpapers = false;
    @Property
    boolean useColoredDirectories = true;
    @Property
    boolean useProjectFrame = false;
    @Property
    IndicatorStyles indicatorStyle = IndicatorStyles.BORDER;
    @Property
    int customSidebarHeight = 18;
    @Property
    int tabOpacity = 50;
    @Property
    int treeFontSize = 12;
    @Property
    int tabFontSize = 12;
    @Property
    Integer highlightThickness = 2;
    @Property
    Integer indicatorThickness = 2;
    @Property
    Integer leftTreeIndent = 6;
    @Property
    Integer rightTreeIndent = 10;
    @Property
    Integer settingsSelectedTab = 0;
    @Property
    Integer tabsHeight = 32;
    @Property
    String accentColor = ACCENT_COLOR;
    @Property
    String secondAccentColor = SECOND_ACCENT_COLOR;
    @Property
    String highlightColor = ACCENT_COLOR;
    @Property
    @NonNls
    String selectedTheme = MTThemes.OCEANIC.getName();
    @Property
    String userId = new UID().toString();
    @Property
    String version = "6.2.2";
    @Property
    TabHighlightPositions tabHighlightPosition = TabHighlightPositions.DEFAULT;
    @Property
    private boolean codeAdditionsEnabled = true;
    @Transient
    private transient boolean isReset = false;
    @Transient
    private transient boolean isPremium = MTLicenseChecker.isLicensed();

    public static MTConfig getInstance() {
        return (MTConfig)ServiceManager.getService(MTConfig.class);
    }

    public MTConfig clone() {
        return (MTConfig)XmlSerializerUtil.createCopy((Object)this);
    }

    @NotNull
    public MTConfig getState() {
        this.isPremium = true;
        MTConfig clone = this.clone();
        this.isPremium = MTLicenseChecker.isLicensed();
        MTConfig mTConfig = clone;
        if (mTConfig == null) {
            MTConfig.$$$reportNull$$$0(0);
        }
        return mTConfig;
    }

    @Override
    public void loadState(@NotNull MTConfig state) {
        if (state == null) {
            MTConfig.$$$reportNull$$$0(1);
        }
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    @Override
    public void fireBeforeChanged(MTForm form) {
        ((ConfigNotifier)ApplicationManager.getApplication().getMessageBus().syncPublisher(ConfigNotifier.CONFIG_TOPIC)).beforeConfigChanged(this, form);
    }

    @Override
    public void fireChanged() {
        ((ConfigNotifier)ApplicationManager.getApplication().getMessageBus().syncPublisher(ConfigNotifier.CONFIG_TOPIC)).configChanged(this);
    }

    @Override
    public void applySettings(MTForm form) {
        this.fireBeforeChanged(form);
        this.isReset = false;
        this.setSettingsSelectedTab(form.getSelectedTabIndex());
        this.setAccentColor(ColorUtil.toHex((Color)form.getCustomAccentColor()));
        this.setAccentMode(form.isAccentMode());
        this.setAccentScrollbars(form.isAccentScrollbars());
        this.setBorderedButtons(form.isBorderedButtons());
        this.setCodeAdditionsEnabled(form.isCodeAdditionsEnabled());
        this.setCompactDropdowns(form.isCompactDropdowns());
        this.setCompactSidebar(form.isCompactSidebar());
        this.setCustomSidebarHeight(form.getCustomSidebarHeight());
        this.setDarkTitleBar(form.isDarkTitleBar());
        this.setFileStatusColorsEnabled(form.isFileStatusColors());
        this.setHighlightColor(form.getHighlightColor());
        this.setHighlightColorEnabled(form.isHighlightColorEnabled());
        this.setHighlightThickness(form.getHighlightThickness());
        this.setIndicatorStyle(form.getIndicatorStyle());
        this.setIndicatorThickness(form.getIndicatorThickness());
        this.setCompactMenus(form.isCompactMenus());
        this.setCompactStatusBar(form.isCompactStatusBar());
        this.setCompactTables(form.isCompactTables());
        this.setContrastMode(form.isContrastMode());
        this.setCustomTreeIndentEnabled(form.isCustomTreeIndent());
        this.setHighContrast(form.isHighContrast());
        this.setStyledDirectories(form.isStyledDirectories());
        this.setIsTabsShadow(form.isTabsShadow());
        this.setUpperCaseTabs(form.isUpperCaseTabs());
        this.setLeftTreeIndent(form.getLeftTreeIndent());
        this.setOverrideAccentColor(form.isOverrideAccents());
        this.pristineConfig = false;
        this.setRightTreeIndent(form.getRightTreeIndent());
        this.setSelectedTheme(form.getTheme());
        this.setSecondAccentColor(ColorUtil.toHex((Color)form.getSecondAccentColor()));
        this.setTabHighlightPosition(form.getTabHighlightPosition());
        this.setTabsHeight(form.getTabsHeight());
        this.setThemedScrollbars(form.isThemedScrollbars());
        this.setTabFontSize(form.getTabFontSize());
        this.setTabFontSizeEnabled(form.isTabFontSizeEnabled());
        this.setTreeFontSize(form.getTreeFontSize());
        this.setTreeFontSizeEnabled(form.isTreeFontSizeEnabled());
        this.setUpperCaseButtons(form.isUpperCaseButtons());
        this.setUseMaterialFont2(form.isUseMaterialFonts());
        this.setUseMaterialWallpapers(form.isUseMaterialWallpapers());
        this.setUseColoredDirectories(form.isUseColoredDirectories());
        this.setUseProjectFrame(form.isUseProjectFrame());
        this.fireChanged();
    }

    @Override
    public void resetSettings() {
        this.isReset = true;
        this.accentColor = ACCENT_COLOR;
        this.accentMode = false;
        this.accentScrollbars = true;
        this.borderedButtons = false;
        this.codeAdditionsEnabled = true;
        this.compactDropdowns = false;
        this.compactSidebar = false;
        this.customSidebarHeight = 18;
        this.darkTitleBar = false;
        this.fileStatusColorsEnabled = true;
        this.highlightColor = ACCENT_COLOR;
        this.isHighlightColorEnabled = false;
        this.highlightThickness = 2;
        this.indicatorStyle = IndicatorStyles.BORDER;
        this.indicatorThickness = 2;
        this.isCompactMenus = false;
        this.isCompactStatusBar = false;
        this.isCompactTables = false;
        this.isContrastMode = false;
        this.isCustomTreeIndentEnabled = false;
        this.isHighContrast = false;
        this.isMaterialDesign = true;
        this.isMaterialTheme = true;
        this.isStyledDirectories = false;
        this.isTabsShadow = true;
        this.leftTreeIndent = 6;
        this.overrideAccentColor = true;
        this.pristineConfig = true;
        this.rightTreeIndent = 6;
        this.secondAccentColor = SECOND_ACCENT_COLOR;
        this.selectedTheme = MTThemes.OCEANIC.getName();
        this.statusBarTheme = true;
        this.tabHighlightPosition = TabHighlightPositions.DEFAULT;
        this.tabOpacity = 50;
        this.tabsHeight = 32;
        this.themedScrollbars = true;
        this.tabFontSize = 12;
        this.tabFontSizeEnabled = false;
        this.treeFontSize = 12;
        this.treeFontSizeEnabled = false;
        this.upperCaseButtons = true;
        this.upperCaseTabs = false;
        this.useMaterialFont = true;
        this.useMaterialFont2 = false;
        this.useMaterialWallpapers = false;
        this.useColoredDirectories = true;
        this.useProjectFrame = false;
    }

    @Override
    public boolean needsRestart(MTForm form) {
        boolean modified = this.isTreeFontSizeEnabledChanged(form.isTreeFontSizeEnabled());
        modified = modified || this.isTreeFontSizeChanged(form.getTreeFontSize());
        modified = modified || this.isDarkTitleBarChanged(form.isDarkTitleBar());
        return modified;
    }

    public JSONObject asJson() throws JSONException {
        return this.getNativePropertiesAsJson();
    }

    public void setSelectedTheme(MTThemeFacade selectedTheme) {
        this.selectedTheme = selectedTheme.getThemeId();
    }

    public boolean isSelectedThemeChanged(MTThemeFacade theme) {
        return !this.selectedTheme.equals(theme.getName());
    }

    public MTThemeFacade getSelectedTheme() {
        MTThemeFacade themeFor = MTThemes.getThemeFor(this.selectedTheme);
        if (!this.isPremium && themeFor != null && themeFor.isPremium()) {
            return MTThemes.OCEANIC;
        }
        return (MTThemeFacade)ObjectUtils.notNull((Object)themeFor, (Object)MTThemes.OCEANIC);
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setHighlightColor(@NotNull Color color) {
        if (color == null) {
            MTConfig.$$$reportNull$$$0(2);
        }
        this.highlightColor = ColorUtil.toHex((Color)color);
    }

    public boolean isHighlightColorChanged(@NotNull Color color) {
        Color current;
        if (color == null) {
            MTConfig.$$$reportNull$$$0(3);
        }
        return !Objects.equals(current = this.getHighlightColor(), color);
    }

    public boolean isHighlightColorEnabled() {
        return this.isPremium && this.isHighlightColorEnabled;
    }

    public void setHighlightColorEnabled(boolean enabled) {
        this.isHighlightColorEnabled = enabled;
    }

    public boolean isHighlightColorEnabledChanged(boolean enabled) {
        return this.isHighlightColorEnabled != enabled;
    }

    public Color getHighlightColor() {
        return ColorUtil.fromHex((String)this.highlightColor);
    }

    public void setHighlightThickness(int thickness) {
        if (1 > thickness || thickness > 5) {
            return;
        }
        this.highlightThickness = thickness;
    }

    public boolean isHighlightThicknessChanged(int thickness) {
        return this.highlightThickness != thickness;
    }

    public int getHighlightThickness() {
        return this.isPremium ? this.highlightThickness : 2;
    }

    public TabHighlightPositions getTabHighlightPosition() {
        return this.isPremium ? this.tabHighlightPosition : TabHighlightPositions.BOTTOM;
    }

    public void setTabHighlightPosition(TabHighlightPositions tabHighlightPosition) {
        this.tabHighlightPosition = tabHighlightPosition;
    }

    public boolean isTabHighlightPositionChanged(TabHighlightPositions tabHighlightPosition) {
        return this.tabHighlightPosition != tabHighlightPosition;
    }

    public void setContrastMode(boolean isContrastMode) {
        this.isContrastMode = isContrastMode;
    }

    public boolean isContrastModeChanged(boolean isContrastMode) {
        return this.isContrastMode != isContrastMode;
    }

    public boolean isContrastMode() {
        return this.isContrastMode;
    }

    public void setStyledDirectories(boolean isStyledDirectories) {
        this.isStyledDirectories = isStyledDirectories;
    }

    public boolean isStyledDirectoriesChanged(boolean isStyledDirectories) {
        return this.isStyledDirectories != isStyledDirectories;
    }

    public boolean isStyledDirectories() {
        return this.isPremium && this.isStyledDirectories;
    }

    public void setAccentColor(String accentColor) {
        this.accentColor = accentColor;
    }

    public boolean isAccentColorChanged(Color customAccentColor) {
        return !Objects.equals(this.accentColor, ColorUtil.toHex((Color)customAccentColor));
    }

    public String getAccentColor() {
        return this.accentColor;
    }

    public void setOverrideAccentColor(boolean overrideAccentColor) {
        this.overrideAccentColor = overrideAccentColor;
    }

    public boolean isOverrideAccentColorChanged(boolean overrideAccents) {
        return this.overrideAccentColor != overrideAccents;
    }

    public boolean isOverrideAccentColor() {
        return !this.isPremium || this.overrideAccentColor;
    }

    public void setSecondAccentColor(String accentColor) {
        this.secondAccentColor = accentColor;
    }

    public boolean isSecondAccentColorChanged(Color color) {
        return !Objects.equals(this.secondAccentColor, ColorUtil.toHex((Color)color));
    }

    public String getSecondAccentColor() {
        return this.secondAccentColor;
    }

    public void setCompactSidebar(boolean compactSidebar) {
        this.compactSidebar = compactSidebar;
    }

    public boolean isCompactSidebarChanged(boolean compactSidebar) {
        return this.compactSidebar != compactSidebar;
    }

    public boolean isCompactSidebar() {
        return !this.isPremium || this.compactSidebar;
    }

    public void setCustomSidebarHeight(Integer customSidebarHeight) {
        if (18 > customSidebarHeight || customSidebarHeight > 36) {
            return;
        }
        this.customSidebarHeight = customSidebarHeight;
    }

    public boolean isCustomSidebarHeightChanged(Integer customSidebarHeight) {
        return this.customSidebarHeight != customSidebarHeight;
    }

    public int getCustomSidebarHeight() {
        return this.customSidebarHeight;
    }

    public void setTabsHeight(Integer tabsHeight) {
        this.tabsHeight = tabsHeight;
    }

    public boolean isTabsHeightChanged(Integer tabsHeight) {
        return !Objects.equals(this.tabsHeight, tabsHeight);
    }

    public int getTabsHeight() {
        return this.tabsHeight;
    }

    public void setRightTreeIndent(Integer rightTreeIndent) {
        this.rightTreeIndent = rightTreeIndent;
    }

    public int getLeftTreeIndent() {
        return this.leftTreeIndent;
    }

    public void setLeftTreeIndent(Integer leftTreeIndent) {
        this.leftTreeIndent = leftTreeIndent;
    }

    public boolean isCustomTreeIndentEnabled() {
        return this.isPremium && this.isCustomTreeIndentEnabled;
    }

    public void setCustomTreeIndentEnabled(boolean isCustomTreeIndent) {
        this.isCustomTreeIndentEnabled = isCustomTreeIndent;
    }

    public boolean isRightTreeIndentChanged(int rightTreeIndent) {
        return this.rightTreeIndent != rightTreeIndent;
    }

    public boolean isLeftTreeIndentChanged(int leftTreeIndent) {
        return this.leftTreeIndent != leftTreeIndent;
    }

    public boolean isCustomTreeIndentChanged(boolean customTreeIndentEnabled) {
        return this.isCustomTreeIndentEnabled != customTreeIndentEnabled;
    }

    public int getRightTreeIndent() {
        return this.rightTreeIndent;
    }

    public void setThemedScrollbars(boolean themedScrollbars) {
        this.themedScrollbars = themedScrollbars;
    }

    public boolean isThemedScrollbarsChanged(boolean themedScrollbars) {
        return this.themedScrollbars != themedScrollbars;
    }

    public boolean isAccentScrollbars() {
        return this.accentScrollbars;
    }

    public void setAccentScrollbars(boolean accentScrollbars) {
        this.accentScrollbars = accentScrollbars;
    }

    public boolean isAccentScrollbarsChanged(boolean accentScrollbars) {
        return this.accentScrollbars != accentScrollbars;
    }

    public boolean isThemedScrollbars() {
        return this.themedScrollbars;
    }

    public void setCompactStatusBar(boolean isCompactStatusBar) {
        this.isCompactStatusBar = isCompactStatusBar;
    }

    public boolean isCompactStatusBarChanged(boolean compactStatusBar) {
        return this.isCompactStatusBar != compactStatusBar;
    }

    public boolean isCompactStatusBar() {
        return this.isCompactStatusBar;
    }

    public void setCompactTables(boolean isCompactTables) {
        this.isCompactTables = isCompactTables;
    }

    public boolean isCompactTablesChanged(boolean compactTables) {
        return this.isCompactTables != compactTables;
    }

    public boolean isCompactTables() {
        return this.isCompactTables;
    }

    public void setCompactMenus(boolean compactMenus) {
        this.isCompactMenus = compactMenus;
    }

    public boolean isCompactMenusChanged(boolean compactMenus) {
        return this.isCompactMenus != compactMenus;
    }

    public boolean isCompactMenus() {
        return this.isCompactMenus;
    }

    public void setUpperCaseTabs(boolean isUpperCaseTabs) {
        this.upperCaseTabs = isUpperCaseTabs;
    }

    public boolean isUpperCaseTabsChanged(boolean upperCaseTabs) {
        return this.upperCaseTabs != upperCaseTabs;
    }

    public boolean isUpperCaseTabs() {
        return this.isPremium && this.upperCaseTabs;
    }

    public void setDarkTitleBar(boolean darkTitleBar) {
        this.darkTitleBar = darkTitleBar;
    }

    public boolean isDarkTitleBarChanged(boolean darkTitleBar) {
        return this.darkTitleBar != darkTitleBar;
    }

    public boolean isDarkTitleBar() {
        return this.isPremium && this.darkTitleBar;
    }

    public void setIndicatorStyle(IndicatorStyles indicatorStyle) {
        this.indicatorStyle = indicatorStyle;
    }

    public boolean isIndicatorStyleChanged(IndicatorStyles indicatorStyle) {
        return this.indicatorStyle != indicatorStyle;
    }

    public IndicatorStyles getIndicatorStyle() {
        return this.isPremium ? this.indicatorStyle : IndicatorStyles.NONE;
    }

    public void setIndicatorThickness(int indicatorThickness) {
        this.indicatorThickness = indicatorThickness;
    }

    public boolean isIndicatorThicknessChanged(int indicatorThickness) {
        return this.indicatorThickness != indicatorThickness;
    }

    public Integer getIndicatorThickness() {
        return this.indicatorThickness;
    }

    public void setUseMaterialFont2(boolean useMaterialFont) {
        this.useMaterialFont2 = useMaterialFont;
    }

    public boolean isUseMaterialFontChanged(boolean useMaterialFont) {
        return this.useMaterialFont2 != useMaterialFont;
    }

    public boolean isUseMaterialFont2() {
        return this.isPremium && this.useMaterialFont2;
    }

    public void setTabFontSize(int tabFontSize) {
        this.tabFontSize = tabFontSize;
    }

    public boolean isTabFontSizeChanged(Integer tabFontSize) {
        return this.tabFontSize != tabFontSize;
    }

    public boolean isTabFontSizeEnabled() {
        return this.isPremium && this.tabFontSizeEnabled;
    }

    public void setTabFontSizeEnabled(boolean tabFontSizeEnabled) {
        this.tabFontSizeEnabled = tabFontSizeEnabled;
    }

    public boolean isTabFontSizeEnabledChanged(boolean tabFontSizeEnabled) {
        return this.tabFontSizeEnabled != tabFontSizeEnabled;
    }

    public int getTabFontSize() {
        return this.tabFontSize;
    }

    public void setCompactDropdowns(boolean compactDropdowns) {
        this.compactDropdowns = compactDropdowns;
    }

    public boolean isCompactDropdownsChanged(boolean isCompactDropdowns) {
        return this.compactDropdowns != isCompactDropdowns;
    }

    public boolean isCompactDropdowns() {
        return this.compactDropdowns;
    }

    public void setUpperCaseButtons(boolean upperCaseButtons) {
        this.upperCaseButtons = upperCaseButtons;
    }

    public boolean isUpperCaseButtonsChanged(boolean isUppercaseButtons) {
        return this.upperCaseButtons != isUppercaseButtons;
    }

    public boolean isUpperCaseButtons() {
        return this.upperCaseButtons;
    }

    public void setBorderedButtons(boolean borderedButtons) {
        this.borderedButtons = borderedButtons;
    }

    public boolean isBorderedButtonsChanged(boolean isBorderedButtons) {
        return this.borderedButtons != isBorderedButtons;
    }

    public boolean isBorderedButtons() {
        return this.isPremium && this.borderedButtons;
    }

    public void setTreeFontSize(int treeFontSize) {
        this.treeFontSize = treeFontSize;
    }

    public boolean isTreeFontSizeChanged(Integer treeFontSize) {
        return this.treeFontSize != treeFontSize;
    }

    public boolean isTreeFontSizeEnabled() {
        return this.isPremium && this.treeFontSizeEnabled;
    }

    public void setTreeFontSizeEnabled(boolean treeFontSizeEnabled) {
        this.treeFontSizeEnabled = treeFontSizeEnabled;
    }

    public boolean isTreeFontSizeEnabledChanged(boolean treeFontSizeEnabled) {
        return this.treeFontSizeEnabled != treeFontSizeEnabled;
    }

    public int getTreeFontSize() {
        return this.treeFontSize;
    }

    public void setFileStatusColorsEnabled(boolean enabled) {
        this.fileStatusColorsEnabled = enabled;
    }

    public boolean isFileStatusColorsEnabledChanged(boolean fileStatusColors) {
        return this.fileStatusColorsEnabled != fileStatusColors;
    }

    public boolean isFileStatusColorsEnabled() {
        return this.isPremium && this.fileStatusColorsEnabled;
    }

    public void setHighContrast(boolean isHighContrast) {
        this.isHighContrast = isHighContrast;
    }

    public boolean isHighContrastChanged(boolean isHighContrast) {
        return this.isHighContrast != isHighContrast;
    }

    public boolean isHighContrast() {
        return this.isPremium && this.isHighContrast;
    }

    public boolean isTabsShadow() {
        return this.isPremium && this.isTabsShadow;
    }

    public boolean isTabsShadowChanged(boolean tabsShadow) {
        return this.isTabsShadow != tabsShadow;
    }

    public void setIsTabsShadow(boolean isTabsShadow) {
        this.isTabsShadow = isTabsShadow;
    }

    public boolean isCodeAdditionsEnabled() {
        return this.isPremium && this.codeAdditionsEnabled;
    }

    public void setCodeAdditionsEnabled(boolean codeAdditionsEnabled) {
        this.codeAdditionsEnabled = codeAdditionsEnabled;
    }

    public boolean isCodeAdditionsEnabledChanged(boolean codeAdditionsEnabled) {
        return this.codeAdditionsEnabled != codeAdditionsEnabled;
    }

    public boolean isUseColoredDirectories() {
        return this.isPremium && this.useColoredDirectories;
    }

    public void setUseColoredDirectories(boolean useColoredDirectories) {
        this.useColoredDirectories = useColoredDirectories;
    }

    public boolean isUseColoredDirectoriesChanged(boolean useColoredDirectories) {
        return this.useColoredDirectories != useColoredDirectories;
    }

    public boolean isAccentMode() {
        return this.isPremium && this.accentMode;
    }

    public void setAccentMode(boolean accentMode) {
        this.accentMode = accentMode;
    }

    public boolean isAccentModeChanged(boolean accentMode) {
        return this.accentMode != accentMode;
    }

    public boolean isUseMaterialWallpapers() {
        return this.isPremium && this.useMaterialWallpapers;
    }

    public void setUseMaterialWallpapers(boolean useMaterialWallpapers) {
        this.useMaterialWallpapers = useMaterialWallpapers;
    }

    public boolean isUseMaterialWallpapersChanged(boolean useMaterialWallpapers) {
        return this.useMaterialWallpapers != useMaterialWallpapers;
    }

    public boolean isUseProjectFrame() {
        return this.isPremium && this.useProjectFrame;
    }

    public void setUseProjectFrame(boolean useProjectFrame) {
        this.useProjectFrame = useProjectFrame;
    }

    public boolean isUseProjectFrameChanged(boolean useProjectFrame) {
        return this.useProjectFrame != useProjectFrame;
    }

    public boolean isReset() {
        return this.isReset;
    }

    public Integer getSettingsSelectedTab() {
        return MTUiUtils.valueInRange(this.settingsSelectedTab, 0, 6);
    }

    public void setSettingsSelectedTab(Integer settingsSelectedTab) {
        this.settingsSelectedTab = settingsSelectedTab;
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean isDisallowDataCollection() {
        return !this.allowDataCollection;
    }

    public void setAllowDataCollection(boolean allowDataCollection) {
        this.allowDataCollection = allowDataCollection;
    }

    public boolean isWizardShown() {
        return this.isWizardShown;
    }

    public void setIsWizardShown(boolean isWizardShown) {
        this.isWizardShown = isWizardShown;
    }

    public boolean isPremium() {
        return this.isPremium;
    }

    public void setPremium(boolean premium) {
        this.isPremium = premium;
    }

    private JSONObject getNativePropertiesAsJson() throws JSONException {
        JSONObject hashMap = new JSONObject();
        hashMap.put("accentColor", (Object)this.accentColor);
        hashMap.put("accentMode", this.accentMode);
        hashMap.put("accentScrollbars", this.accentScrollbars);
        hashMap.put("codeAdditions", this.codeAdditionsEnabled);
        hashMap.put("compactDropdowns", this.compactDropdowns);
        hashMap.put("compactSidebar", this.compactSidebar);
        hashMap.put("customSidebarHeight", this.customSidebarHeight);
        hashMap.put("darkTitleBar", this.darkTitleBar);
        hashMap.put("fileStatusColorsEnabled", this.fileStatusColorsEnabled);
        hashMap.put("highlightColor", (Object)this.highlightColor);
        hashMap.put("highlightThickness", (Object)this.highlightThickness);
        hashMap.put("IDE", (Object)ApplicationNamesInfo.getInstance().getFullProductName());
        hashMap.put("IDEVersion", ApplicationInfo.getInstance().getBuild().getBaselineVersion());
        hashMap.put("indicatorStyles", (Object)this.indicatorStyle);
        hashMap.put("indicatorThickness", (Object)this.indicatorThickness);
        hashMap.put("isCompactMenus", this.isCompactMenus);
        hashMap.put("isPremium", this.isPremium);
        hashMap.put("isCompactStatusBar", this.isCompactStatusBar);
        hashMap.put("isCompactTables", this.isCompactTables);
        hashMap.put("isContrastMode", this.isContrastMode);
        hashMap.put("isCustomTreeIndentEnabled", this.isCustomTreeIndentEnabled);
        hashMap.put("isHighContrast", this.isHighContrast);
        hashMap.put("isMaterialDesign", this.isMaterialDesign);
        hashMap.put("isMaterialTheme", this.isMaterialTheme);
        hashMap.put("isStyledDirectories", this.isStyledDirectories);
        hashMap.put("isTabsShadow", this.isTabsShadow);
        hashMap.put("leftTreeIndent", (Object)this.leftTreeIndent);
        hashMap.put("overrideAccentColor", this.overrideAccentColor);
        hashMap.put("pristineConfig", this.pristineConfig);
        hashMap.put("rightTreeIndent", (Object)this.rightTreeIndent);
        hashMap.put("secondAccentMode", (Object)this.secondAccentColor);
        hashMap.put("selectedTheme", (Object)this.selectedTheme);
        hashMap.put("statusBarTheme", this.statusBarTheme);
        hashMap.put("tabHighlightPosition", (Object)this.tabHighlightPosition);
        hashMap.put("tabOpacity", this.tabOpacity);
        hashMap.put("tabsHeight", (Object)this.tabsHeight);
        hashMap.put("themedScrollbars", this.themedScrollbars);
        hashMap.put("tabFontSize", this.tabFontSize);
        hashMap.put("tabFontSizeEnabled", this.tabFontSizeEnabled);
        hashMap.put("treeFontSize", this.treeFontSize);
        hashMap.put("treeFontSizeEnabled", this.treeFontSizeEnabled);
        hashMap.put("upperCaseButtons", this.upperCaseButtons);
        hashMap.put("upperCaseTabs", this.upperCaseTabs);
        hashMap.put("useMaterialFont", this.useMaterialFont2);
        hashMap.put("useMaterialWallpapers", this.useMaterialWallpapers);
        hashMap.put("useProjectFrame", this.useProjectFrame);
        hashMap.put("userId", (Object)this.userId);
        hashMap.put("version", (Object)this.version);
        return hashMap;
    }

    public String getTooltip() {
        return MaterialThemeBundle.message("MTConfig.about", Objects.requireNonNull(this.getSelectedTheme().getThemeName()), this.isContrastMode ? "Contrast" : "Normal");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/mallowigi/idea/MTConfig";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/mallowigi/idea/MTConfig";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightColor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isHighlightColorChanged";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

