/*
 * Decompiled with CFR 0.152.
 */
package com.mallowigi.idea;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.util.ThrowableRunnable;
import com.mallowigi.idea.MTAnalytics;
import com.mallowigi.idea.MTConfig;
import com.mallowigi.idea.MTThemeManager;
import com.mallowigi.idea.messages.MaterialThemeBundle;
import com.mallowigi.idea.themes.BundledThemeEP;
import com.mallowigi.idea.themes.MTThemeFacade;
import com.mallowigi.idea.themes.MTThemes;
import com.mallowigi.idea.themes.models.MTBundledTheme;
import com.mallowigi.idea.themes.models.MTDarkBundledTheme;
import com.mallowigi.idea.themes.models.MTLightBundledTheme;
import com.mallowigi.idea.themes.models.MTThemeColor;
import com.mallowigi.idea.themes.models.MTThemeable;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MTBundledThemesManager {
    private final Map<String, MTBundledTheme> bundledThemes = new HashMap<String, MTBundledTheme>(10);

    public static MTBundledThemesManager getInstance() {
        return (MTBundledThemesManager)ServiceManager.getService(MTBundledThemesManager.class);
    }

    public Map<String, MTBundledTheme> getBundledThemes() {
        return Collections.unmodifiableMap(this.bundledThemes);
    }

    void loadBundledThemes() throws IOException {
        for (BundledThemeEP ep : (BundledThemeEP[])BundledThemeEP.EP_NAME.getExtensions()) {
            MTBundledTheme mtBundledTheme = MTBundledThemesManager.loadBundledTheme(ep.path + ".xml", ep);
            Objects.requireNonNull(mtBundledTheme).setName(ep.name);
            this.bundledThemes.put(mtBundledTheme.getThemeId(), mtBundledTheme);
            MTThemes.installTheme(mtBundledTheme);
        }
    }

    private static MTThemeable getActiveTheme() {
        return MTConfig.getInstance().getSelectedTheme().getTheme();
    }

    public static MTBundledTheme loadBundledTheme(VirtualFile file) {
        File url = new File(file.getPath());
        return MTBundledThemesManager.loadFromXml(null, url);
    }

    private static MTBundledTheme loadBundledTheme(@NonNls String resource, BundledThemeEP ep) throws IOException {
        URL url = ep.getLoaderForClass().getResource(resource);
        if (url == null) {
            throw new IOException("Cannot read theme from " + resource);
        }
        return MTBundledThemesManager.loadFromXml(url, null);
    }

    @Nullable
    private static MTBundledTheme loadFromXml(@Nullable URL url, @Nullable File file) {
        XStream xStream = MTBundledThemesManager.configureXStream();
        try {
            if (url != null) {
                return (MTBundledTheme)xStream.fromXML(url);
            }
            if (file != null) {
                return (MTBundledTheme)xStream.fromXML(file);
            }
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public static void saveTheme(MTBundledTheme customTheme) {
        FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor(MaterialThemeBundle.message("SaveThemeDialog.placeholder", new Object[0]), MaterialThemeBundle.message("SaveThemeDialog.title", new Object[0]), new String[]{"xml"}), (Project)null);
        VirtualFileWrapper target = saveFileDialog.save(customTheme.getThemeId() + ".xml");
        if (target != null) {
            VirtualFile targetFile = target.getVirtualFile(true);
            String message = targetFile != null ? MTBundledThemesManager.generateMessage(customTheme, targetFile) : ApplicationBundle.message((String)"scheme.exporter.ui.cannot.write.message", (Object[])new Object[0]);
            Messages.showDialog((String)message, (String)MaterialThemeBundle.message("common.status", new Object[0]), (String[])new String[]{MaterialThemeBundle.message("common.ok", new Object[0])}, (int)0, null);
        }
    }

    private static String generateMessage(final MTBundledTheme customTheme, final VirtualFile targetFile) {
        String message;
        try {
            WriteAction.run((ThrowableRunnable)new ThrowableRunnable<Throwable>(){

                public void run() throws IOException {
                    OutputStream outputStream = targetFile.getOutputStream((Object)this);
                    MTBundledThemesManager.exportTheme(customTheme, outputStream);
                }
            });
            message = ApplicationBundle.message((String)"scheme.exporter.ui.scheme.exported.message", (Object[])new Object[]{customTheme.getName(), customTheme.getThemeName(), targetFile.getPresentableUrl()});
        }
        catch (Throwable e) {
            message = ApplicationBundle.message((String)"scheme.exporter.ui.export.failed", (Object[])new Object[]{e.getMessage()});
        }
        return message;
    }

    private static void exportTheme(MTBundledTheme customTheme, OutputStream outputStream) {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        XStream xStream = MTBundledThemesManager.configureXStream();
        String xml = xStream.toXML((Object)customTheme);
        try (PrintWriter printWriter = new PrintWriter(writer);){
            printWriter.write(xml);
        }
    }

    @NotNull
    private static XStream configureXStream() {
        XStream xStream = new XStream();
        XStream.setupDefaultSecurity((XStream)xStream);
        xStream.allowTypesByWildcard(new String[]{"com.mallowigi.idea.themes.models.*"});
        xStream.alias("mtTheme", MTBundledTheme.class);
        xStream.alias("color", MTThemeColor.class);
        xStream.useAttributeFor(MTThemeColor.class, "id");
        xStream.useAttributeFor(MTThemeColor.class, "value");
        xStream.registerConverter((Converter)new MTThemesConverter(xStream.getConverterLookup().lookupConverterForType(MTBundledTheme.class), xStream.getReflectionProvider()));
        xStream.addDefaultImplementation(MTDarkBundledTheme.class, MTBundledTheme.class);
        xStream.addDefaultImplementation(MTLightBundledTheme.class, MTBundledTheme.class);
        XStream xStream2 = xStream;
        if (xStream2 == null) {
            MTBundledThemesManager.$$$reportNull$$$0(0);
        }
        return xStream2;
    }

    public void addBundledThemes(@NotNull DefaultActionGroup group, Icon ourCurrentAction, Icon ourNotCurrentAction) {
        if (group == null) {
            MTBundledThemesManager.$$$reportNull$$$0(1);
        }
        Map<String, MTBundledTheme> themes = this.getBundledThemes();
        MTThemeable current = MTBundledThemesManager.getActiveTheme();
        for (MTBundledTheme bundledTheme : themes.values()) {
            MTBundledThemesManager.addBundledTheme(group, bundledTheme, current, ourCurrentAction, ourNotCurrentAction);
        }
    }

    private static void addBundledTheme(DefaultActionGroup group, final MTThemeable theme, MTThemeable current, Icon ourCurrentAction, Icon ourNotCurrentAction) {
        Icon themeIcon = theme.getIcon() != null ? theme.getIcon() : ourNotCurrentAction;
        group.add((AnAction)new DumbAwareAction(theme.getName(), theme.getEditorColorsScheme(), theme == current ? ourCurrentAction : themeIcon){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                MTThemeFacade externalTheme = MTThemes.installTheme(theme);
                MTThemeManager.activate(externalTheme);
                MTAnalytics.getInstance().trackValue("SelectTheme", externalTheme);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/mallowigi/idea/MTBundledThemesManager$2", "actionPerformed"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/mallowigi/idea/MTBundledThemesManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "configureXStream";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/mallowigi/idea/MTBundledThemesManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addBundledThemes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MTThemesConverter
    implements Converter {
        private final Converter defaultConverter;
        private final ReflectionProvider reflectionProvider;

        MTThemesConverter(Converter defaultConverter, ReflectionProvider reflectionProvider) {
            this.defaultConverter = defaultConverter;
            this.reflectionProvider = reflectionProvider;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            this.defaultConverter.marshal(source, writer, context);
        }

        public Object unmarshal(@NonNls HierarchicalStreamReader reader, UnmarshallingContext context) {
            boolean dark = Boolean.parseBoolean(reader.getAttribute("dark"));
            Class themeClass = dark ? MTLightBundledTheme.class : MTDarkBundledTheme.class;
            Object result = this.reflectionProvider.newInstance(themeClass);
            return context.convertAnother(result, themeClass, this.defaultConverter);
        }

        public boolean canConvert(Class type) {
            return MTBundledTheme.class.isAssignableFrom(type);
        }
    }
}

